/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\u001e\u0010\u0014\u001a\u00020\u0001*\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0001\u001a\u001c\u0010\u0014\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020 \u001a\f\u0010!\u001a\u0004\u0018\u00010 *\u00020\u000f\u001a\f\u0010\"\u001a\u0004\u0018\u00010 *\u00020\u000f\u001a\n\u0010#\u001a\u00020 *\u00020 \u001a\f\u0010$\u001a\u0004\u0018\u00010 *\u00020\u000f\u00a8\u0006%"}, d2={"isReturningContext", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isReturningLambdaResult", "isScopingFunction", "isScopingIt", "isScopingThis", "acceptMultiFileClass", "", "Lorg/jetbrains/uast/UFile;", "visitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "acceptSourceFile", "findSelector", "Lorg/jetbrains/uast/UElement;", "getReceiver", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiMember;", "getReceiverOrContainingClass", "isBelow", "Lcom/intellij/psi/PsiElement;", "parent", "strict", "isElvisIf", "Lorg/jetbrains/uast/UIfExpression;", "isReceiver", "Lcom/intellij/psi/PsiParameter;", "isSuperConstructorCall", "isThisConstructorCall", "isThisOrSuperConstructorCall", "isUnconditionalReturn", "Lorg/jetbrains/uast/UExpression;", "nextStatement", "previousStatement", "skipLabeledExpression", "statement", "lint-api"})
@SourceDebugExtension(value={"SMAP\nUastLintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,929:1\n18#2:930\n1747#3,3:931\n*S KotlinDebug\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n*L\n688#1:930\n826#1:931,3\n*E\n"})
public final class UastLintUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingThis(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingIt(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningContext(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    public static final boolean isScopingFunction(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return true;
        }
        PsiMethod called = psiMethod;
        PsiClass psiClass = called.getContainingClass();
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"kotlin.StandardKt__StandardKt");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningLambdaResult(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    public static final boolean isReceiver(@NotNull PsiParameter $this$isReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiver, (String)"<this>");
        String string = $this$isReceiver.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String name = string;
        return StringsKt.startsWith$default((String)name, (String)"$this", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"$self", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final UElement findSelector(@NotNull UElement $this$findSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$findSelector, (String)"<this>");
        UElement curr = $this$findSelector;
        while (true) {
            UElement uElement;
            UElement uElement2;
            if ((uElement2 = curr) instanceof UQualifiedReferenceExpression) {
                uElement = (UElement)((UQualifiedReferenceExpression)curr).getSelector();
            } else {
                if (!(uElement2 instanceof UParenthesizedExpression)) break;
                uElement = (UElement)((UParenthesizedExpression)curr).getExpression();
            }
            curr = uElement;
        }
        return curr;
    }

    @Nullable
    public static final UExpression nextStatement(@NotNull UElement $this$nextStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$nextStatement, (String)"<this>");
        UElement prev = $this$nextStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index != -1 && index < expressions.size() - 1 ? (UExpression)expressions.get(index + 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final UExpression statement(@NotNull UElement $this$statement) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$statement, (String)"<this>");
        UElement uElement = $this$statement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UExpression.class, (boolean)strict$iv);
        if (uExpression == null) {
            return null;
        }
        UExpression prev = uExpression;
        UElement curr = prev.getUastParent();
        while (curr != null) {
            if (curr instanceof UBlockExpression || !(curr instanceof UExpression)) {
                return prev instanceof UParenthesizedExpression ? ((UParenthesizedExpression)prev).getExpression() : prev;
            }
            prev = (UExpression)curr;
            curr = ((UExpression)curr).getUastParent();
        }
        return prev;
    }

    @Nullable
    public static final UExpression previousStatement(@NotNull UElement $this$previousStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$previousStatement, (String)"<this>");
        UElement prev = $this$previousStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index > 0 ? (UExpression)expressions.get(index - 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    public static final boolean isBelow(@NotNull UElement $this$isBelow, @NotNull UElement parent, boolean strict) {
        UElement curr;
        Intrinsics.checkNotNullParameter((Object)$this$isBelow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        UElement uElement = curr = strict ? $this$isBelow.getUastParent() : $this$isBelow;
        while (curr != null) {
            if (Intrinsics.areEqual((Object)curr, (Object)parent)) {
                return true;
            }
            curr = curr.getUastParent();
        }
        return false;
    }

    public static /* synthetic */ boolean isBelow$default(UElement uElement, UElement uElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(uElement, uElement2, bl);
    }

    public static final boolean isBelow(@Nullable PsiElement $this$isBelow, @NotNull PsiElement parent, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if ($this$isBelow == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)$this$isBelow, (boolean)strict);
    }

    public static /* synthetic */ boolean isBelow$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(psiElement, psiElement2, bl);
    }

    @Nullable
    public static final PsiClass getReceiverOrContainingClass(@NotNull PsiMember $this$getReceiverOrContainingClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverOrContainingClass, (String)"<this>");
        PsiClass psiClass = UastLintUtilsKt.getReceiver($this$getReceiverOrContainingClass);
        if (psiClass == null) {
            psiClass = $this$getReceiverOrContainingClass.getContainingClass();
        }
        return psiClass;
    }

    @Nullable
    public static final PsiClass getReceiver(@NotNull PsiMember $this$getReceiver) {
        UTypeReferenceExpression typeReference;
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        PsiElement unwrapped = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$getReceiver));
        if (unwrapped instanceof KtNamedFunction ? true : unwrapped instanceof KtProperty) {
            Intrinsics.checkNotNull((Object)unwrapped, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            ktCallableDeclaration = (KtCallableDeclaration)unwrapped;
        } else if (unwrapped instanceof KtPropertyAccessor) {
            ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)unwrapped, (Class[])new Class[0]);
        } else {
            return null;
        }
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration callable = ktCallableDeclaration;
        KtTypeReference ktTypeReference = callable.getReceiverTypeReference();
        UElement uElement = ktTypeReference != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktTypeReference)) : null;
        UTypeReferenceExpression uTypeReferenceExpression = typeReference = uElement instanceof UTypeReferenceExpression ? (UTypeReferenceExpression)uElement : null;
        PsiType psiType = uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null;
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    public static final boolean isElvisIf(@NotNull UIfExpression $this$isElvisIf) {
        Intrinsics.checkNotNullParameter((Object)$this$isElvisIf, (String)"<this>");
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)$this$isElvisIf.getUastParent());
        return parent instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)parent).getKind(), (Object)KotlinSpecialExpressionKinds.ELVIS);
    }

    public static final boolean isThisOrSuperConstructorCall(@NotNull UCallExpression $this$isThisOrSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisOrSuperConstructorCall, (String)"<this>");
        return UastLintUtilsKt.isSuperConstructorCall($this$isThisOrSuperConstructorCall) || UastLintUtilsKt.isThisConstructorCall($this$isThisOrSuperConstructorCall);
    }

    public static final boolean isSuperConstructorCall(@NotNull UCallExpression $this$isSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuperConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isSuperConstructorCall.getSourcePsi();
        return psiElement instanceof KtSuperTypeCallEntry ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isSuperConstructorCall.getMethodName(), (Object)"super") : false);
    }

    public static final boolean isThisConstructorCall(@NotNull UCallExpression $this$isThisConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isThisConstructorCall.getSourcePsi();
        return psiElement instanceof KtThisExpression ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isThisConstructorCall.getMethodName(), (Object)"this") : false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void acceptSourceFile(@NotNull UFile $this$acceptSourceFile, @NotNull UastVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiFile sourcePsi = $this$acceptSourceFile.getSourcePsi();
        if (sourcePsi instanceof KtFile) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = ((KtFile)sourcePsi).getAnnotationEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)String.valueOf(it.getShortName()), (Object)"JvmMultifileClass")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                UastLintUtilsKt.acceptMultiFileClass($this$acceptSourceFile, visitor);
                return;
            }
        }
        $this$acceptSourceFile.accept(visitor);
    }

    @NotNull
    public static final UExpression skipLabeledExpression(@NotNull UExpression $this$skipLabeledExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLabeledExpression, (String)"<this>");
        UExpression expression = $this$skipLabeledExpression;
        while (expression instanceof ULabeledExpression) {
            expression = ((ULabeledExpression)expression).getExpression();
        }
        return expression;
    }

    private static final void acceptMultiFileClass(UFile $this$acceptMultiFileClass, UastVisitor visitor) {
        VirtualFile targetFile = $this$acceptMultiFileClass.getSourcePsi().getVirtualFile();
        if (visitor.visitFile($this$acceptMultiFileClass)) {
            return;
        }
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getUAnnotations(), (UastVisitor)visitor);
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getImports(), (UastVisitor)visitor);
        for (UClass uClass : $this$acceptMultiFileClass.getClasses()) {
            if (visitor.visitClass(uClass)) {
                return;
            }
            ImplementationUtilsKt.acceptList((List)uClass.getUAnnotations(), (UastVisitor)visitor);
            for (UDeclaration declaration : uClass.getUastDeclarations()) {
                VirtualFile declarationFile;
                PsiElement psiElement = declaration.getSourcePsi();
                VirtualFile virtualFile = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : (declarationFile = null);
                if (declarationFile != null && !Intrinsics.areEqual((Object)declarationFile, (Object)targetFile)) continue;
                declaration.accept(visitor);
            }
            visitor.afterVisitClass(uClass);
        }
        visitor.afterVisitFile($this$acceptMultiFileClass);
    }

    public static final boolean isUnconditionalReturn(@NotNull UExpression $this$isUnconditionalReturn) {
        String methodName;
        UExpression uExpression;
        Intrinsics.checkNotNullParameter((Object)$this$isUnconditionalReturn, (String)"<this>");
        UExpression statement = $this$isUnconditionalReturn;
        if (statement instanceof UBlockExpression) {
            uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)statement).getExpressions());
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                return UastLintUtilsKt.isUnconditionalReturn(it);
            }
        } else if (statement instanceof UExpressionList) {
            uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UExpressionList)statement).getExpressions());
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                return UastLintUtilsKt.isUnconditionalReturn(it);
            }
        } else if (statement instanceof UYieldExpression) {
            UExpression yieldExpression = ((UYieldExpression)statement).getExpression();
            if (yieldExpression != null) {
                return UastLintUtilsKt.isUnconditionalReturn(yieldExpression);
            }
        } else {
            if (statement instanceof UParenthesizedExpression) {
                return UastLintUtilsKt.isUnconditionalReturn(((UParenthesizedExpression)statement).getExpression());
            }
            if (statement instanceof UIfExpression) {
                UExpression thenExpression = ((UIfExpression)statement).getThenExpression();
                UExpression elseExpression = ((UIfExpression)statement).getElseExpression();
                if (thenExpression != null && elseExpression != null) {
                    return UastLintUtilsKt.isUnconditionalReturn(thenExpression) && UastLintUtilsKt.isUnconditionalReturn(elseExpression);
                }
                return false;
            }
            if (statement instanceof USwitchExpression) {
                for (UExpression uExpression2 : ((USwitchExpression)statement).getBody().getExpressions()) {
                    if (!(uExpression2 instanceof USwitchClauseExpressionWithBody) || UastLintUtilsKt.isUnconditionalReturn((UExpression)((USwitchClauseExpressionWithBody)uExpression2).getBody())) continue;
                    return false;
                }
                return true;
            }
        }
        if (statement instanceof UReturnExpression || statement instanceof UThrowExpression) {
            return true;
        }
        return statement instanceof UCallExpression && (Intrinsics.areEqual((Object)"error", (Object)(methodName = Lint.getMethodName((UCallExpression)statement))) || Intrinsics.areEqual((Object)"TODO", (Object)methodName));
    }
}

