/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintJarApiMigration;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.helpers.ZipStreamsKt;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u0001:\u0003()*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000e0 H\u0002J(\u0010!\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\bH\u0002J(\u0010$\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\bH\u0002J(\u0010%\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010&\u001a\u00020\b*\u00020\u0010J\u000e\u0010'\u001a\u0004\u0018\u00010\u001e*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "(Lcom/android/tools/lint/client/api/LintClient;)V", "findClass", "Ljava/lang/Class;", "owner", "", "getMigratedJar", "Ljava/io/File;", "jar", "registryClass", "handleLintUtilRedirection", "", "method", "Lorg/objectweb/asm/tree/MethodNode;", "isRelevantMethod", "methodNode", "mapClass", "s", "migrateAnalyzeCall", "", "classBytes", "migrateClass", "bytes", "migrateClassNames", "jarBytes", "migrateJar", "find", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "condition", "Lkotlin/Function1;", "isCall", "name", "desc", "isStaticCall", "isVirtualCall", "prettyPrint", "prev", "Companion", "SwitchToInterfaceClassVisitor", "SwitchToInterfaceMethodVisitor", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintJarApiMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1416:1\n288#2,2:1417\n*S KotlinDebug\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n*L\n1028#1:1417,2\n*E\n"})
public final class LintJarApiMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    private static final boolean DEBUG = false;

    public LintJarApiMigration(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final File getMigratedJar(@NotNull File jar, @NotNull String registryClass) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
        File cacheDir = this.client.getCacheDir("migrated-jars", true);
        byte[] jarContents = FilesKt.readBytes((File)jar);
        HashFunction hashFunction = Hashing.farmHashFingerprint64();
        Hasher hasher = hashFunction.newHasher();
        hasher.putBytes(jarContents);
        HashCode hashCode = hasher.hash();
        String string = hashCode.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String hashCodeString = string;
        String fileName = (String)(!StringsKt.isBlank((CharSequence)registryClass) ? registryClass + "-" : "") + hashCodeString + "..jar";
        File cachedJar = new File(cacheDir, fileName);
        if (!cachedJar.isFile()) {
            byte[] bytes = this.migrateJar(jarContents);
            FilesKt.writeBytes((File)cachedJar, (byte[])bytes);
        }
        return cachedJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] migrateJar(byte[] jarBytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(jarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jis = (JarInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = output;
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream fos = (ByteArrayOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new JarOutputStream(fos);
                Throwable throwable3 = null;
                try {
                    JarOutputStream jos = (JarOutputStream)closeable3;
                    boolean bl3 = false;
                    JarEntry entry = jis.getNextJarEntry();
                    while (entry != null) {
                        jos.putNextEntry(new JarEntry(entry.getName()));
                        String name = entry.getName();
                        Intrinsics.checkNotNull((Object)name);
                        if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) && !entry.isDirectory()) {
                            byte[] bytes = ZipStreamsKt.readAllBytes(jis, (ZipEntry)entry);
                            byte[] migrated = this.migrateClass(bytes);
                            jos.write(migrated);
                        } else {
                            ByteStreamsKt.copyTo$default((InputStream)jis, (OutputStream)jos, (int)0, (int)2, null);
                        }
                        jos.closeEntry();
                        entry = jis.getNextJarEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public final byte[] migrateClass(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.migrateClassNames(this.migrateAnalyzeCall(bytes));
    }

    @Nullable
    public final String mapClass(@Nullable String s) {
        Object object;
        if (s == null || !Companion.isRelevantType(s)) {
            return null;
        }
        int innerClassIndex = StringsKt.indexOf$default((CharSequence)s, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (innerClassIndex != -1) {
            String string = s.substring(0, innerClassIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String mapped = this.mapClass(string);
            if (mapped != null) {
                String string2 = s.substring(innerClassIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return mapped + string2;
            }
        }
        switch (s) {
            case "org/jetbrains/kotlin/analysis/api/KaStarTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaSymbolBasedReference": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaTypeArgumentWithVariance": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisApiInternals": {
                object = "org/jetbrains/kotlin/analysis/api/KaAnalysisApiInternals";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisNonPublicApi": {
                object = "org/jetbrains/kotlin/analysis/api/KaAnalysisNonPublicApi";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisSession": {
                object = "org/jetbrains/kotlin/analysis/api/KaSession";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtStarTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtSymbolBasedReference": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtTypeArgumentWithVariance": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplication": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationValue": {
                object = "KaAnnotationValue$NestedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationWithArgumentsInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationsList": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaArrayAnnotationValue": {
                object = "KaAnnotationValue$ArrayValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue": {
                object = "KaAnnotationValue$ConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaEnumEntryAnnotationValue": {
                object = "KaAnnotationValue$EnumEntryValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaKClassAnnotationValue": {
                object = "KaAnnotationValue$ClassLiteralValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaUnsupportedAnnotationValue": {
                object = "KaAnnotationValue$UnsupportedValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotated": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplication": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue": {
                object = "KaAnnotationValue$NestedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue": {
                object = "KaAnnotationValue$ArrayValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue": {
                object = "KaAnnotationValue$ConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue": {
                object = "KaAnnotationValue$EnumEntryValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue": {
                object = "KaAnnotationValue$ClassLiteralValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtUnsupportedAnnotationValue": {
                object = "KaAnnotationValue$UnsupportedValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtConstantValue": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiver": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaContextReceiver";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiversOwner": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaAnnotationCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallableMemberCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundArrayAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaDelegatedConstructorCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaErrorCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaExplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaImplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaInapplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSmartCastedReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSuccessCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtAnnotationCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallableMemberCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundArrayAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtDelegatedConstructorCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtErrorCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtExplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtImplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtInapplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSmartCastedReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSuccessCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtBuiltinTypes": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtClassTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilationResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompilationResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompiledFile": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompiledFile";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilerTarget": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompilerTarget";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompletionExtensionCandidateChecker": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompletionExtensionCandidateChecker";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtDataFlowExitPointSnapshot": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaDataFlowExitPointSnapshot";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtDiagnosticCheckerFilter": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtExtensionApplicabilityResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaExtensionApplicabilityResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiver": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCast": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCastKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCastKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImportOptimizerResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeContext": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeContext";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeWithKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSmartCastInfo": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSubstitutorBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSubstitutorBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSubtypingErrorTypePolicy": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeParameterTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractCallsInPlaceContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConditionalContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConstantValue": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractParameterValue": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractReturnsContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBinaryLogicExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanConstantExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanValueParameterExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsInstancePredicateExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsNullPredicateExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractLogicalNotExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic": {
                object = "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi": {
                object = "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic0": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic1": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic2": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic3": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic4": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtIllegalLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInaccessibleLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaInaccessibleLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInvalidLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaInvalidLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwner": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerField": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerField";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtRendererAnnotationsFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaRendererAnnotationsFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationArgumentsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationArgumentsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationQualifierRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationQualifierRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationUseSiteTargetRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationUseSiteTargetRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverLabelRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverLabelRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtCallableReturnTypeFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaCallableReturnTypeFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtDeclarationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaDeclarationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRecommendedRendererCodeStyle": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRecommendedRendererCodeStyle";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererCodeStyle": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererCodeStyle";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererTypeApproximator": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererTypeApproximator";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtFunctionLikeBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaFunctionLikeBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtParameterDefaultValueRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaParameterDefaultValueRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtPropertyAccessorBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaPropertyAccessorBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeSorter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeSorter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtScriptInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaScriptInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtVariableInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaVariableInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForDebug": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForDebug";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KtDeclarationModifiersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KaDeclarationModifiersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KtDeclarationModifiersRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KaDeclarationModifiersRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifierListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifierListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifiersSorter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifiersSorter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererKeywordFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererKeywordFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererModalityModifierProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererModalityModifierProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererOtherModifiersProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererOtherModifiersProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererVisibilityModifierProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererVisibilityModifierProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtCallableParameterRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaCallableParameterRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyWithMembersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyWithMembersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtDeclarationNameRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaDeclarationNameRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParameterRendererFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParameterRendererFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParametersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParametersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtAnonymousFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaAnonymousFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtBackingFieldSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaBackingFieldSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReceiverRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReceiverRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReturnTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReturnTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableSignatureRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableSignatureRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtConstructorSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaConstructorSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtDestructuringDeclarationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaDestructuringDeclarationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtEnumEntrySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaEnumEntrySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtJavaFieldSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaJavaFieldSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtKotlinPropertySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaKotlinPropertySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtLocalVariableSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaLocalVariableSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyAccessorsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyAccessorsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyGetterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyGetterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertySetterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertySetterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSamConstructorSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSamConstructorSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtScriptSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaScriptSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSyntheticJavaPropertySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSyntheticJavaPropertySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtValueParameterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaValueParameterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassOrObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtAnonymousObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaAnonymousObjectSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtNamedClassOrObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtSingleTypeParameterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaSingleTypeParameterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtTypeAliasSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaTypeAliasSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesCallArgumentsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesCallArgumentsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtExpandedTypeRenderingMode": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/KaExpandedTypeRenderingMode";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/KaTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForDebug": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForDebug";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtCapturedTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaCapturedTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtClassTypeQualifierRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaClassTypeQualifierRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDefinitelyNotNullTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDefinitelyNotNullTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDynamicTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDynamicTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFlexibleTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFlexibleTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFunctionalTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFunctionalTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtIntersectionTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaIntersectionTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeErrorTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaErrorTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeNameRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeNameRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeParameterTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeParameterTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeProjectionRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeProjectionRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUnresolvedClassErrorTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUnresolvedClassErrorTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUsualClassTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUsualClassTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KtApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KtCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtension": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionFile": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionFile";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionNavigationTargetsProvider": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionNavigationTargetsProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionProvider": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScope": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaScope";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeLike": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeNameFilter": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/(Name) -> Boolean";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtTypeScope": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider": {
                object = "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaVariableLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtVariableLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaVariableLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousObjectSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtBackingFieldSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaBackingFieldSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassInitializerSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassInitializerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassifierSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDestructuringDeclarationSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDestructuringDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntryInitializerSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntryInitializerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtJavaFieldSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaJavaFieldSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtKotlinPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaKotlinPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtLocalVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaLocalVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtNamedClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPackageSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPackageSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyAccessorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyGetterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyGetterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySetterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySetterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtReceiverParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtScriptSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbolOrigin": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolOrigin";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSyntheticJavaPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSyntheticJavaPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeAliasSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaTypeAliasSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossibleMultiplatformSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithMembers": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithModality": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithTypeParameters": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithVisibility": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtAnnotatedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtNamedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossibleMultiplatformSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossiblyNamedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossiblyNamedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithMembers": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithModality": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithTypeParameters": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithVisibility": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtPsiBasedSymbolPointer": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtSymbolPointer": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFunctionalType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaNonErrorClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtCapturedType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaCapturedType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtClassErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtClassTypeQualifier": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtDefinitelyNotNullType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaDefinitelyNotNullType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtDynamicType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaDynamicType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtFlexibleType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFlexibleType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtFunctionalType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtIntersectionType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaIntersectionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtNonErrorClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeMappingMode": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeMappingMode";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeNullability": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeNullability";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeParameterType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeParameterType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtUsualClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaUsualClassType";
                break;
            }
            default: {
                String ktPrefix = "org/jetbrains/kotlin/analysis/api/";
                int lastIndex = StringsKt.lastIndexOf$default((CharSequence)s, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (StringsKt.startsWith$default((String)s, (String)ktPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)s, (String)"Kt", (int)(lastIndex + 1), (boolean)false, (int)4, null)) {
                    String string = s.substring(0, lastIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string3 = s.substring(lastIndex + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    object = string + "Ka" + string3;
                    break;
                }
                object = null;
            }
        }
        return object;
    }

    private final byte[] migrateClassNames(byte[] jarBytes) {
        ClassReader classReader = new ClassReader(jarBytes);
        ClassWriter classWriter2 = new ClassWriter(classReader){

            @NotNull
            protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
                String string;
                Intrinsics.checkNotNullParameter((Object)type1, (String)"type1");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type2");
                try {
                    string = super.getCommonSuperClass(type1, type2);
                    Intrinsics.checkNotNull((Object)string);
                }
                catch (TypeNotPresentException e) {
                    string = "java/lang/Object";
                }
                return string;
            }
        };
        Remapper mapper2 = new Remapper(this){
            final /* synthetic */ LintJarApiMigration this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public String mapMethodName(@Nullable String owner, @Nullable String name, @Nullable String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @Nullable
            public String mapInvokeDynamicMethodName(@Nullable String name, @Nullable String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @NotNull
            public String mapRecordComponentName(@Nullable String owner, @NotNull String name, @Nullable String descriptor) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @Nullable
            public String mapFieldName(@Nullable String owner, @Nullable String name, @Nullable String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @NotNull
            public String mapPackageName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @NotNull
            public String mapModuleName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            @Nullable
            public String map(@Nullable String internalName) {
                String string = this.this$0.mapClass(internalName);
                if (string == null) {
                    string = internalName;
                }
                return string;
            }
        };
        SwitchToInterfaceClassVisitor myVisitor = new SwitchToInterfaceClassVisitor((ClassVisitor)classWriter2);
        ClassRemapper classMapper = new ClassRemapper((ClassVisitor)myVisitor, mapper2);
        classReader.accept((ClassVisitor)classMapper, 0);
        byte[] byArray = classWriter2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final boolean isRelevantMethod(MethodNode methodNode) {
        return this.find(methodNode, (Function1<? super AbstractInsnNode, Boolean>)((Function1)isRelevantMethod.1.INSTANCE)) != null;
    }

    private final AbstractInsnNode find(MethodNode $this$find, Function1<? super AbstractInsnNode, Boolean> condition) {
        for (AbstractInsnNode instruction : $this$find.instructions) {
            Intrinsics.checkNotNull((Object)instruction);
            if (!((Boolean)condition.invoke((Object)instruction)).booleanValue()) continue;
            return instruction;
        }
        return null;
    }

    private final byte[] migrateAnalyzeCall(byte[] classBytes) {
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            Intrinsics.checkNotNull((Object)method);
            if (this.isRelevantMethod(method)) {
                String before = "";
                modified = this.migrateAnalyzeCall(method) || modified;
            }
            String string = cn.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"androidx/navigation/", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") || !this.handleLintUtilRedirection(method)) continue;
            modified = true;
        }
        if (!modified) {
            return classBytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        byte[] result = cw.toByteArray();
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final boolean handleLintUtilRedirection(MethodNode method) {
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;") || Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"))) {
            InsnList instructions = method.instructions;
            instructions.clear();
            LabelNode startLabel = new LabelNode();
            instructions.add((AbstractInsnNode)startLabel);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
            } else if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            } else {
                return false;
            }
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/android/tools/lint/detector/api/UastLintUtilsKt", method.name, "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"));
            instructions.add((AbstractInsnNode)new InsnNode(176));
            LabelNode endLabel = new LabelNode();
            instructions.add((AbstractInsnNode)endLabel);
            method.maxStack = 2;
            method.maxLocals = 4;
            method.tryCatchBlocks.clear();
            method.localVariables.clear();
            method.localVariables.add(new LocalVariableNode("$this$isClassReference", "Lorg/jetbrains/uast/UExpression;", null, startLabel, endLabel, 0));
            return true;
        }
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") && Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZILjava/lang/Object;)Lkotlin/Pair;")) {
            Object v1;
            block8: {
                InsnList insnList = method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                Iterable $this$firstOrNull$iv = (Iterable)insnList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isStaticCall(it, "isClassReference", "androidx/navigation/lint/common/LintUtilKt", "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            AbstractInsnNode abstractInsnNode = v1;
            if (abstractInsnNode == null) {
                return false;
            }
            AbstractInsnNode replace = abstractInsnNode;
            ((MethodInsnNode)replace).owner = "com/android/tools/lint/detector/api/UastLintUtilsKt";
            return true;
        }
        return false;
    }

    private final boolean isCall(AbstractInsnNode $this$isCall, String name, String owner, String desc) {
        MethodInsnNode methodInsnNode = $this$isCall instanceof MethodInsnNode ? (MethodInsnNode)$this$isCall : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode curr = methodInsnNode;
        return Intrinsics.areEqual((Object)curr.name, (Object)name) && Intrinsics.areEqual((Object)curr.owner, (Object)owner) && (desc == null || Intrinsics.areEqual((Object)curr.desc, (Object)desc));
    }

    static /* synthetic */ boolean isCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean isVirtualCall(AbstractInsnNode $this$isVirtualCall, String name, String owner, String desc) {
        return $this$isVirtualCall.getOpcode() == 182 && this.isCall($this$isVirtualCall, name, owner, desc);
    }

    static /* synthetic */ boolean isVirtualCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isVirtualCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean isStaticCall(AbstractInsnNode $this$isStaticCall, String name, String owner, String desc) {
        return $this$isStaticCall.getOpcode() == 184 && this.isCall($this$isStaticCall, name, owner, desc);
    }

    static /* synthetic */ boolean isStaticCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isStaticCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean migrateAnalyzeCall(MethodNode methodNode) {
        boolean modified = false;
        InsnList instructions = methodNode.instructions;
        Ref.ObjectRef curr = new Ref.ObjectRef();
        curr.element = instructions.getFirst();
        int ktElementVariable = -1;
        while (curr.element != null) {
            AbstractInsnNode end;
            Object object = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            if (this.isVirtualCall((AbstractInsnNode)object, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", "(Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V")) {
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n2 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n2 == null) break;
                int sessionProviderVariable = n2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n3 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n3 == null) break;
                int sessionProviderVariable2 = n3;
                Object object2 = curr.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                AbstractInsnNode startReplace = (AbstractInsnNode)object2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getAnalysisSession", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || ((AbstractInsnNode)curr.element).getOpcode() == 192 && LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n4 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n4 == null) break;
                ktElementVariable = n4;
                AbstractInsnNode last = startReplace.getPrevious();
                AbstractInsnNode c = last.getNext();
                while (c != end) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end;
                modified = true;
                continue;
            }
            Object object3 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element");
            if (LintJarApiMigration.isVirtualCall$default(this, (AbstractInsnNode)object3, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 4, null)) {
                AbstractInsnNode last;
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionProviderVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n5 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n5 == null) break;
                int sessionVariable = n5;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n6 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n6 == null) break;
                n6.intValue();
                if (((AbstractInsnNode)curr.element).getPrevious() == null) break;
                AbstractInsnNode c = last.getNext();
                while (c != end) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "afterLeavingAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end;
                modified = true;
                continue;
            }
            Object object4 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
            if (LintJarApiMigration.isStaticCall$default(this, (AbstractInsnNode)object4, "getAllSuperTypes$default", "org/jetbrains/kotlin/analysis/api/components/KtTypeProviderMixIn", null, 4, null)) {
                AbstractInsnNode shouldApproximateLoad;
                AbstractInsnNode aconstNull;
                AbstractInsnNode iconst1;
                AbstractInsnNode checkCast;
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                AbstractInsnNode sessionLoad = checkCast.getPrevious();
                AbstractInsnNode beforeInvokeStatic = ((AbstractInsnNode)curr.element).getPrevious();
                instructions.remove(checkCast);
                instructions.remove(iconst1);
                instructions.remove(aconstNull);
                MethodInsnNode newCall = new MethodInsnNode(185, "org/jetbrains/kotlin/analysis/api/KaSession", "getAllSuperTypes", "(Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)Ljava/util/List;", true);
                instructions.insert(shouldApproximateLoad, (AbstractInsnNode)newCall);
                AbstractInsnNode next = newCall.getNext();
                instructions.remove(next);
                curr.element = end;
                modified = true;
                continue;
            }
            if (((AbstractInsnNode)curr.element).getNext() == null) {
                Object cfr_ignored_0 = curr.element;
                break;
            }
            curr.element = curr.element;
        }
        return modified;
    }

    private final Class<?> findClass(String owner) {
        try {
            String className = Type.getObjectType((String)owner).getClassName();
            return Class.forName(className, false, LintJarApiMigration.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private final AbstractInsnNode prev(AbstractInsnNode $this$prev) {
        AbstractInsnNode curr = $this$prev.getPrevious();
        while (curr instanceof LabelNode || curr instanceof LineNumberNode) {
            curr = curr.getPrevious();
        }
        return curr;
    }

    @NotNull
    public final String prettyPrint(@NotNull MethodNode $this$prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyPrint, (String)"<this>");
        return $this$prettyPrint.toString();
    }

    private static final AbstractInsnNode migrateAnalyzeCall$prev(Ref.ObjectRef<AbstractInsnNode> curr, LintJarApiMigration this$0) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        curr.element = this$0.prev((AbstractInsnNode)object);
        return (AbstractInsnNode)curr.element;
    }

    private static final Integer migrateAnalyzeCall$expectAload(Ref.ObjectRef<AbstractInsnNode> curr) {
        Integer n;
        if (((AbstractInsnNode)curr.element).getOpcode() == 25) {
            Object object = curr.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
            n = ((VarInsnNode)object).var;
        } else {
            n = null;
        }
        return n;
    }

    private static final AbstractInsnNode migrateAnalyzeCall$expectVirtualCall(LintJarApiMigration this$0, Ref.ObjectRef<AbstractInsnNode> curr, String name, String owner, String desc) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return this$0.isVirtualCall((AbstractInsnNode)object, name, owner, desc) ? (AbstractInsnNode)curr.element : null;
    }

    static /* synthetic */ AbstractInsnNode migrateAnalyzeCall$expectVirtualCall$default(LintJarApiMigration lintJarApiMigration, Ref.ObjectRef objectRef, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        return LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall(lintJarApiMigration, (Ref.ObjectRef<AbstractInsnNode>)objectRef, string, string2, string3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$Companion;", "", "()V", "DEBUG", "", "getMigratedJar", "Ljava/io/File;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jar", "registryClass", "", "isRelevantType", "s", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRelevantType(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return StringsKt.startsWith$default((String)s, (String)"org/jetbrains/kotlin/analysis/api/", (boolean)false, (int)2, null);
        }

        @NotNull
        public final File getMigratedJar(@NotNull LintClient client, @NotNull File jar, @NotNull String registryClass) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
            Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
            return new LintJarApiMigration(client).getMigratedJar(jar, registryClass);
        }

        public static /* synthetic */ File getMigratedJar$default(Companion companion, LintClient lintClient, File file, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return companion.getMigratedJar(lintClient, file, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003JE\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "chained", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/ClassVisitor;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "access", "", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "lint-api"})
    private final class SwitchToInterfaceClassVisitor
    extends ClassVisitor {
        public SwitchToInterfaceClassVisitor(ClassVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor2 = super.visitMethod(access, name, descriptor, signature, exceptions);
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"visitMethod(...)");
            return new SwitchToInterfaceMethodVisitor(methodVisitor2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "chained", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/MethodVisitor;)V", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "descriptor", "isInterface", "", "lint-api"})
    private final class SwitchToInterfaceMethodVisitor
    extends MethodVisitor {
        public SwitchToInterfaceMethodVisitor(MethodVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if ((opcode == 184 || opcode == 182) && Companion.isRelevantType(owner)) {
                Class clz = LintJarApiMigration.this.findClass(owner);
                if (clz == null) {
                    LintJarApiMigration.this.client.log(Severity.WARNING, null, "WARNING: Missing analysis API method " + owner + "#" + name + descriptor, new Object[0]);
                } else if (clz.isInterface()) {
                    super.visitMethodInsn(185, owner, name, descriptor, true);
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

