/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintOptionsConfiguration;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.PathVariables;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 G2\u00020\u0001:\u0002GHB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010 \u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000bH\u0002J8\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0*2\u0010\b\u0002\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0*J8\u0010,\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u0002030*J\u000e\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0005J\u001e\u00106\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u000bJ.\u00107\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00182\u001e\b\u0002\u00108\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012J\"\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020:J\u0010\u0010?\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u0012\u0010@\u001a\u0004\u0018\u00010\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bJ\u0018\u0010C\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000b2\b\u0010D\u001a\u0004\u0018\u00010\u000bJ\b\u0010E\u001a\u00020FH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006I"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "rootDir", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dirToConfiguration", "", "Lcom/android/tools/lint/client/api/Configuration;", "fallback", "getFallback", "()Lcom/android/tools/lint/client/api/Configuration;", "setFallback", "(Lcom/android/tools/lint/client/api/Configuration;)V", "lintXmlCreator", "Lkotlin/Function2;", "overrides", "getOverrides", "setOverrides", "parentOf", "projectToConfiguration", "Lcom/android/tools/lint/detector/api/Project;", "getRootDir", "()Ljava/io/File;", "setRootDir", "(Ljava/io/File;)V", "addGlobalConfigurationFromFile", "", "override", "addGlobalConfigurations", "assignConfiguration", "dir", "configuration", "checkForCycle", "child", "createChainedConfigurations", "project", "middle", "createFirst", "Lkotlin/Function0;", "createLast", "createLintOptionsConfiguration", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "fatalOnly", "", "default", "configFactory", "Lcom/android/tools/lint/client/api/LintOptionsConfiguration;", "getConfigurationForFile", "xmlFile", "getConfigurationForFolder", "getConfigurationForProject", "create", "getDefinedSeverityWithoutOverride", "Lcom/android/tools/lint/detector/api/Severity;", "source", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "visibleDefault", "getParentConfiguration", "getParentFolder", "folder", "getScopeLeaf", "setParent", "parent", "toString", "", "Companion", "ProjectPlaceholderConfiguration", "lint-api"})
@SourceDebugExtension(value={"SMAP\nConfigurationHierarchy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationHierarchy.kt\ncom/android/tools/lint/client/api/ConfigurationHierarchy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,693:1\n1#2:694\n1863#3,2:695\n216#4,2:697\n*S KotlinDebug\n*F\n+ 1 ConfigurationHierarchy.kt\ncom/android/tools/lint/client/api/ConfigurationHierarchy\n*L\n506#1:695,2\n508#1:697,2\n*E\n"})
public class ConfigurationHierarchy {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LintClient client;
    @Nullable
    private File rootDir;
    @NotNull
    private final Map<File, Configuration> dirToConfiguration;
    @NotNull
    private final Map<Project, Configuration> projectToConfiguration;
    @NotNull
    private final Map<Configuration, Configuration> parentOf;
    @Nullable
    private Configuration fallback;
    @Nullable
    private Configuration overrides;
    @NotNull
    private final Function2<File, Configuration, Configuration> lintXmlCreator;
    @NotNull
    private static File defaultRootDir;
    @Nullable
    private static Set<File> ourAlreadyWarned;
    @NotNull
    private static final Companion.NONE.1 NONE;

    public ConfigurationHierarchy(@NotNull LintClient client, @Nullable File rootDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.rootDir = rootDir;
        this.dirToConfiguration = new HashMap();
        this.projectToConfiguration = new HashMap();
        this.parentOf = new HashMap();
        this.lintXmlCreator = lintXmlCreator.1.INSTANCE;
    }

    public /* synthetic */ ConfigurationHierarchy(LintClient lintClient, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = defaultRootDir;
        }
        this(lintClient, file);
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @Nullable
    public final File getRootDir() {
        return this.rootDir;
    }

    public final void setRootDir(@Nullable File file) {
        this.rootDir = file;
    }

    @Nullable
    public final Configuration getFallback() {
        return this.fallback;
    }

    public final void setFallback(@Nullable Configuration configuration) {
        this.fallback = configuration;
    }

    @Nullable
    public final Configuration getOverrides() {
        return this.overrides;
    }

    public final void setOverrides(@Nullable Configuration configuration) {
        this.overrides = configuration;
    }

    @NotNull
    public final Configuration getConfigurationForProject(@NotNull Project project, @NotNull Function2<? super File, ? super Configuration, ? extends Configuration> create) {
        Configuration configuration;
        LintXmlConfiguration lintXmlConfiguration;
        LintXmlConfiguration lintXmlConfiguration2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(create, (String)"create");
        Configuration prev = this.dirToConfiguration.get(project.getDir());
        if (prev != null && prev != NONE) {
            return prev;
        }
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        File dir = file;
        File file2 = Companion.getLintXmlFile(dir);
        if (file2.isFile()) {
            LintXmlConfiguration lintXmlConfiguration3;
            LintXmlConfiguration it = lintXmlConfiguration3 = LintXmlConfiguration.Companion.create(this, file2);
            boolean bl = false;
            it.setFileLevel(false);
            lintXmlConfiguration2 = lintXmlConfiguration3;
        } else {
            lintXmlConfiguration2 = lintXmlConfiguration = null;
        }
        if ((configuration = (Configuration)create.invoke((Object)dir, lintXmlConfiguration)) == null) {
            configuration = new ProjectPlaceholderConfiguration(this, dir);
        }
        Configuration configuration2 = configuration;
        this.projectToConfiguration.put(project, configuration2);
        if (this.dirToConfiguration.get(dir) == null) {
            this.assignConfiguration(dir, configuration2);
        }
        if (lintXmlConfiguration != null) {
            this.assignConfiguration(file2, lintXmlConfiguration);
        }
        configuration2.setFileLevel(false);
        return configuration2;
    }

    public static /* synthetic */ Configuration getConfigurationForProject$default(ConfigurationHierarchy configurationHierarchy, Project project, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getConfigurationForProject");
        }
        if ((n & 2) != 0) {
            function2 = configurationHierarchy.lintXmlCreator;
        }
        return configurationHierarchy.getConfigurationForProject(project, function2);
    }

    @NotNull
    public final Configuration getConfigurationForFile(@NotNull File xmlFile) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Configuration prev = this.dirToConfiguration.get(xmlFile);
        if (prev != null) {
            boolean bl;
            boolean bl2 = bl = prev != NONE;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return prev;
        }
        LintXmlConfiguration configuration = LintXmlConfiguration.Companion.create(this, xmlFile);
        File dir = configuration.getDir();
        if (dir != null && this.client.isKnownProjectDir(dir)) {
            configuration.setFileLevel(false);
        }
        if (dir != null && this.dirToConfiguration.get(dir) == null) {
            this.assignConfiguration(dir, configuration);
        }
        this.assignConfiguration(xmlFile, configuration);
        return configuration;
    }

    @Nullable
    public final Configuration getConfigurationForFolder(@Nullable File dir, @Nullable Configuration configuration) {
        Configuration parent;
        Configuration configuration2;
        Configuration configuration3;
        if (dir == null) {
            return configuration;
        }
        Configuration prev = this.dirToConfiguration.get(dir);
        if (prev != null) {
            return prev != NONE ? prev : null;
        }
        File file = Companion.getLintXmlFile(dir);
        if (file.isFile()) {
            return this.getConfigurationForFile(file);
        }
        if (!Intrinsics.areEqual((Object)dir, (Object)this.rootDir)) {
            configuration3 = this.getConfigurationForFolder(this.getParentFolder(dir), configuration);
        } else {
            configuration3 = configuration;
            if (configuration3 == null) {
                configuration3 = this.fallback;
            }
        }
        if ((configuration2 = (parent = configuration3)) == null) {
            configuration2 = NONE;
        }
        this.assignConfiguration(dir, configuration2);
        return parent;
    }

    public static /* synthetic */ Configuration getConfigurationForFolder$default(ConfigurationHierarchy configurationHierarchy, File file, Configuration configuration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getConfigurationForFolder");
        }
        if ((n & 2) != 0) {
            configuration = null;
        }
        return configurationHierarchy.getConfigurationForFolder(file, configuration);
    }

    @Nullable
    public File getParentFolder(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return folder.getParentFile();
    }

    @Nullable
    public final Configuration getParentConfiguration(@NotNull Configuration configuration) {
        Configuration parent;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Configuration previouslyCreated = this.parentOf.get(configuration);
        if (previouslyCreated != null) {
            return previouslyCreated != NONE ? previouslyCreated : (configuration.isOverriding() ? null : (configuration != this.fallback ? this.fallback : null));
        }
        File file = configuration.getDir();
        if (file == null) {
            return null;
        }
        File configurationDir = file;
        File dir = this.getParentFolder(configurationDir);
        Configuration configuration2 = parent = dir != null && !Intrinsics.areEqual((Object)dir, (Object)this.rootDir) ? this.getConfigurationForFolder(dir, null) : null;
        if (parent != null) {
            this.setParent(configuration, parent);
            if (!configuration.getFileLevel()) {
                parent.setFileLevel(false);
            }
        } else {
            this.parentOf.put(configuration, NONE);
        }
        return parent;
    }

    public final void setParent(@NotNull Configuration child, @Nullable Configuration parent) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (parent == null) {
            this.parentOf.remove(child);
            return;
        }
        this.parentOf.put(child, parent);
        this.checkForCycle(child);
    }

    private final void checkForCycle(Configuration child) {
        if (Lint.assertionsEnabled()) {
            Configuration current = child;
            Configuration current2 = child;
            while (current != null) {
                if (this.parentOf.get(current) == null) {
                    return;
                }
                Configuration configuration = this.parentOf.get(current2);
                if (configuration == null) {
                    return;
                }
                if (this.parentOf.get(configuration) == null) {
                    return;
                }
                if (current != current2) continue;
                this.client.log(Severity.ERROR, null, "Cyclical configuration chain", new Object[0]);
                this.parentOf.remove(child);
                break;
            }
        }
    }

    @NotNull
    public final Configuration getScopeLeaf(@NotNull Configuration child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        File dir = child.getDir();
        Configuration p = child;
        Configuration configuration = this.parentOf.get(p);
        if (configuration == null) {
            return p;
        }
        Configuration parent = configuration;
        while (Intrinsics.areEqual((Object)parent.getDir(), (Object)dir) && this.parentOf.get(p = parent) != null) {
        }
        return p;
    }

    @NotNull
    public final Configuration createLintOptionsConfiguration(@NotNull Project project, @NotNull LintModelLintOptions lintOptions, boolean fatalOnly, @Nullable Configuration configuration, @NotNull Function0<? extends LintOptionsConfiguration> configFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lintOptions, (String)"lintOptions");
        Intrinsics.checkNotNullParameter(configFactory, (String)"configFactory");
        return this.createChainedConfigurations(project, configuration, configFactory, (Function0<? extends Configuration>)((Function0)new Function0<Configuration>(lintOptions, this){
            final /* synthetic */ LintModelLintOptions $lintOptions;
            final /* synthetic */ ConfigurationHierarchy this$0;
            {
                this.$lintOptions = $lintOptions;
                this.this$0 = $receiver;
                super(0);
            }

            public final Configuration invoke() {
                Configuration configuration;
                File lintConfigXml = this.$lintOptions.getLintConfig();
                if (lintConfigXml != null && lintConfigXml.isFile()) {
                    LintXmlConfiguration lintXmlConfiguration;
                    LintXmlConfiguration $this$invoke_u24lambda_u240 = lintXmlConfiguration = LintXmlConfiguration.Companion.create(this.this$0, lintConfigXml);
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setFileLevel(false);
                    configuration = lintXmlConfiguration;
                } else {
                    configuration = null;
                }
                return configuration;
            }
        }));
    }

    public static /* synthetic */ Configuration createLintOptionsConfiguration$default(ConfigurationHierarchy configurationHierarchy, Project project, LintModelLintOptions lintModelLintOptions, boolean bl, Configuration configuration, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createLintOptionsConfiguration");
        }
        if ((n & 0x10) != 0) {
            function0 = (Function0)new Function0<LintOptionsConfiguration>(configurationHierarchy, lintModelLintOptions, bl, project){
                final /* synthetic */ ConfigurationHierarchy this$0;
                final /* synthetic */ LintModelLintOptions $lintOptions;
                final /* synthetic */ boolean $fatalOnly;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$lintOptions = $lintOptions;
                    this.$fatalOnly = $fatalOnly;
                    this.$project = $project;
                    super(0);
                }

                public final LintOptionsConfiguration invoke() {
                    LintOptionsConfiguration lintOptionsConfiguration = new LintOptionsConfiguration(this.this$0, this.$lintOptions, this.$fatalOnly);
                    Project project = this.$project;
                    LintOptionsConfiguration it = lintOptionsConfiguration;
                    boolean bl = false;
                    File file = project.getDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
                    it.setAssociatedLocation(Location.Companion.create(file));
                    return lintOptionsConfiguration;
                }
            };
        }
        return configurationHierarchy.createLintOptionsConfiguration(project, lintModelLintOptions, bl, configuration, (Function0<? extends LintOptionsConfiguration>)function0);
    }

    @NotNull
    public final Configuration createChainedConfigurations(@NotNull Project project, @Nullable Configuration middle, @NotNull Function0<? extends Configuration> createFirst, @NotNull Function0<? extends Configuration> createLast) {
        Configuration parent;
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(createFirst, (String)"createFirst");
        Intrinsics.checkNotNullParameter(createLast, (String)"createLast");
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        File dir = file;
        Object object = createFirst.invoke();
        Configuration $this$createChainedConfigurations_u24lambda_u241 = (Configuration)object;
        boolean bl = false;
        $this$createChainedConfigurations_u24lambda_u241.setDir(dir);
        $this$createChainedConfigurations_u24lambda_u241.setFileLevel(false);
        Configuration primary = (Configuration)object;
        Configuration auxiliary = (Configuration)createLast.invoke();
        File parentFolder = dir.getParentFile();
        if (middle != null && this.parentOf.get(middle) != null) {
            configuration = this.parentOf.get(middle);
            if (configuration == null) {
                configuration = NONE;
            }
        } else if (parentFolder != null && !Intrinsics.areEqual((Object)dir, (Object)this.rootDir)) {
            configuration = ConfigurationHierarchy.getConfigurationForFolder$default(this, parentFolder, null, 2, null);
            if (configuration == null) {
                configuration = NONE;
            }
        } else {
            configuration = parent = (Configuration)NONE;
        }
        if (auxiliary != null) {
            if (middle != null) {
                this.parentOf.put(primary, middle);
                this.parentOf.put(middle, auxiliary);
                this.parentOf.put(auxiliary, parent);
            } else {
                this.parentOf.put(primary, auxiliary);
                this.parentOf.put(auxiliary, parent);
            }
        } else if (middle != null) {
            this.parentOf.put(primary, middle);
            this.parentOf.put(middle, parent);
        } else {
            this.parentOf.put(primary, parent);
        }
        this.checkForCycle(primary);
        this.assignConfiguration(dir, primary);
        return primary;
    }

    public static /* synthetic */ Configuration createChainedConfigurations$default(ConfigurationHierarchy configurationHierarchy, Project project, Configuration configuration, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createChainedConfigurations");
        }
        if ((n & 8) != 0) {
            function02 = createChainedConfigurations.1.INSTANCE;
        }
        return configurationHierarchy.createChainedConfigurations(project, configuration, (Function0<? extends Configuration>)function0, (Function0<? extends Configuration>)function02);
    }

    private final void assignConfiguration(File dir, Configuration configuration) {
        this.dirToConfiguration.put(dir, configuration);
    }

    public final void addGlobalConfigurationFromFile(@Nullable File fallback, @Nullable Configuration override) {
        if (fallback != null) {
            if (!fallback.exists()) {
                Set warned;
                Set set = ourAlreadyWarned;
                if (set == null) {
                    HashSet hashSet;
                    HashSet it = hashSet = new HashSet();
                    boolean bl = false;
                    ourAlreadyWarned = it;
                    set = hashSet;
                }
                if ((warned = set).add((File)fallback)) {
                    Object[] objectArray = new Object[]{fallback};
                    this.client.log(Severity.ERROR, null, "Warning: Configuration file %1$s does not exist", objectArray);
                }
            } else {
                LintXmlConfiguration xmlConfiguration = LintXmlConfiguration.Companion.create(this, fallback);
                this.addGlobalConfigurations(xmlConfiguration, override);
                return;
            }
        }
        this.addGlobalConfigurations(null, override);
    }

    public static /* synthetic */ void addGlobalConfigurationFromFile$default(ConfigurationHierarchy configurationHierarchy, File file, Configuration configuration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGlobalConfigurationFromFile");
        }
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            configuration = null;
        }
        configurationHierarchy.addGlobalConfigurationFromFile(file, configuration);
    }

    public final void addGlobalConfigurations(@Nullable Configuration fallback, @Nullable Configuration override) {
        block5: {
            Object it;
            boolean bl;
            Configuration prev;
            if (override != null) {
                override.setOverriding(true);
                override.setFileLevel(false);
                override.setDir(null);
                prev = this.overrides;
                this.overrides = override;
                boolean bl2 = bl = this.parentOf.get(override) == null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Configuration configuration = prev;
                if (configuration != null) {
                    it = configuration;
                    boolean bl3 = false;
                    override.setParent(prev);
                }
            }
            if (fallback == null) break block5;
            fallback.setFileLevel(false);
            fallback.setDir(null);
            prev = this.fallback;
            boolean bl4 = bl = this.parentOf.get(fallback) == null;
            if (_Assertions.ENABLED && !bl) {
                it = "Assertion failed";
                throw new AssertionError(it);
            }
            this.fallback = fallback;
            Configuration configuration = prev;
            if (configuration != null) {
                it = configuration;
                boolean bl5 = false;
                fallback.setParent(prev);
            }
        }
    }

    public static /* synthetic */ void addGlobalConfigurations$default(ConfigurationHierarchy configurationHierarchy, Configuration configuration, Configuration configuration2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGlobalConfigurations");
        }
        if ((n & 1) != 0) {
            configuration = null;
        }
        if ((n & 2) != 0) {
            configuration2 = null;
        }
        configurationHierarchy.addGlobalConfigurations(configuration, configuration2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Severity getDefinedSeverityWithoutOverride(@NotNull Configuration source, @NotNull Issue issue, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        if (Intrinsics.areEqual((Object)source, (Object)this.overrides) || this.overrides == null) {
            return null;
        }
        Configuration prev = this.overrides;
        try {
            this.overrides = null;
            Severity severity = source.getDefinedSeverity(issue, source, visibleDefault);
            return severity;
        }
        finally {
            this.overrides = prev;
        }
    }

    public static /* synthetic */ Severity getDefinedSeverityWithoutOverride$default(ConfigurationHierarchy configurationHierarchy, Configuration configuration, Issue issue, Severity severity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefinedSeverityWithoutOverride");
        }
        if ((n & 4) != 0) {
            severity = issue.getDefaultSeverity();
        }
        return configurationHierarchy.getDefinedSeverityWithoutOverride(configuration, issue, severity);
    }

    @NotNull
    public String toString() {
        Configuration child;
        boolean bl;
        Iterator it;
        boolean bl2;
        Set configs = CollectionsKt.toMutableSet((Iterable)this.dirToConfiguration.values());
        Configuration configuration = this.overrides;
        if (configuration != null) {
            Configuration it2 = configuration;
            bl2 = false;
            configs.add(it2);
        }
        Configuration configuration2 = this.fallback;
        if (configuration2 != null) {
            it = configuration2;
            bl2 = false;
            configs.add(it);
        }
        Object $this$forEach$iv = configs;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv.iterator();
        while (it.hasNext()) {
            Object element$iv = it.next();
            Configuration entry = (Configuration)element$iv;
            bl = false;
            this.getParentConfiguration(entry);
        }
        $this$forEach$iv = this.parentOf;
        $i$f$forEach = false;
        it = $this$forEach$iv.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = it.next();
            bl = false;
            child = (Configuration)entry.getKey();
            Configuration parent = (Configuration)entry.getValue();
            configs.add(child);
            configs.add(parent);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("digraph Configurations {\n");
        Map keys = new LinkedHashMap();
        int key = 10;
        for (Configuration configuration3 : configs) {
            String description;
            Object object;
            String id;
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toHexString(key++), (String)"toHexString(...)");
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)((String)((Object)child)).toUpperCase(locale), (String)"toUpperCase(...)");
            keys.put(configuration3, id);
            sb.append("  ").append(id).append(" [label=\"");
            PathVariables vars = this.client.getPathVariables();
            Configuration configuration4 = configuration3;
            if (Intrinsics.areEqual((Object)configuration4, (Object)NONE)) {
                object = "NONE";
            } else if (configuration4 instanceof LintXmlConfiguration) {
                object = PathVariables.toPathString$default((PathVariables)vars, (File)((LintXmlConfiguration)configuration3).getConfigFile(), null, (boolean)false, (int)6, null);
            } else if (configuration4 instanceof ProjectPlaceholderConfiguration) {
                File file = configuration3.getDir();
                String string = file != null ? file.getPath() : null;
                if (string == null) {
                    string = "";
                }
                object = "Placeholder: " + PathVariables.toPathString$default((PathVariables)vars, (String)string, null, (boolean)false, (int)6, null);
            } else {
                object = description = configuration3.getClass().getSimpleName();
            }
            if (Intrinsics.areEqual((Object)configuration3, (Object)this.overrides)) {
                sb.append("Override: ");
            }
            sb.append(description);
            sb.append("\"");
            configuration4 = configuration3;
            if (Intrinsics.areEqual((Object)configuration4, (Object)NONE)) {
                sb.append(",shape=plain");
            } else if (configuration4 instanceof LintXmlConfiguration) {
                sb.append(",shape=ellipse");
            } else if (configuration4 instanceof ProjectPlaceholderConfiguration) {
                sb.append(",shape=box");
            } else {
                sb.append(",shape=parallelogram");
            }
            sb.append("]\n");
        }
        sb.append("\n");
        for (Map.Entry entry : this.parentOf.entrySet()) {
            Configuration child2 = (Configuration)entry.getKey();
            Configuration parent = (Configuration)entry.getValue();
            Object v = keys.get(child2);
            Intrinsics.checkNotNull(v);
            String childKey = (String)v;
            Object v2 = keys.get(parent);
            Intrinsics.checkNotNull(v2);
            String parentKey = (String)v2;
            sb.append("  ").append(childKey).append(" -> ").append(parentKey);
            if (Intrinsics.areEqual((Object)parent, (Object)this.fallback)) {
                sb.append(" [label=\"fallback\"]");
            }
            sb.append("\n");
        }
        sb.append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        File file;
        Companion = new Companion(null);
        String string = System.getenv("LINT_XML_ROOT");
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = new File(System.getProperty("user.home"));
        }
        defaultRootDir = file;
        ConfigurationHierarchy configurationHierarchy = new ConfigurationHierarchy(new LintClient(){

            private final Void unsupported() {
                throw new IllegalStateException("Not supported".toString());
            }

            public void report(Context context2, Incident incident, TextFormat format) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
                Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public void log(Severity severity, Throwable exception, String format, Object ... args) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public XmlParser getXmlParser() {
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public UastParser getUastParser(Project project) {
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public GradleVisitor getGradleVisitor() {
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public CharSequence readFile(File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.unsupported();
                throw new KotlinNothingValueException();
            }

            public ResourceRepository getResources(Project project, ResourceRepositoryScope scope) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
                this.unsupported();
                throw new KotlinNothingValueException();
            }
        }, null, 2, null);
        NONE = new Configuration(configurationHierarchy){
            private File baselineFile;

            public File getBaselineFile() {
                return this.baselineFile;
            }

            public void setBaselineFile(File file) {
                this.baselineFile = file;
            }

            public void ignore(Context context2, Issue issue, Location location2, String message2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            }

            public void ignore(Issue issue, File file) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            }

            public void ignore(String issueId, File file) {
                Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            }

            public void setSeverity(Issue issue, Severity severity) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            }

            public void addConfiguredIssues(Map<String, Severity> targetMap, IssueRegistry registry, boolean specificOnly) {
                Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
                Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            }

            public String getOption(Issue issue, String name, String string) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return string;
            }

            public Object getOption(Option option) {
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                return null;
            }

            public File getOptionAsFile(Issue issue, String name, File file) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return file;
            }

            public String toString() {
                return "NONE";
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy$Companion;", "", "()V", "NONE", "com/android/tools/lint/client/api/ConfigurationHierarchy$Companion$NONE$1", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy$Companion$NONE$1;", "defaultRootDir", "Ljava/io/File;", "getDefaultRootDir", "()Ljava/io/File;", "setDefaultRootDir", "(Ljava/io/File;)V", "ourAlreadyWarned", "", "getLintXmlFile", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getDefaultRootDir() {
            return defaultRootDir;
        }

        public final void setDefaultRootDir(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
            defaultRootDir = file;
        }

        @NotNull
        public final File getLintXmlFile(@NotNull File $this$getLintXmlFile) {
            Intrinsics.checkNotNullParameter((Object)$this$getLintXmlFile, (String)"<this>");
            return new File($this$getLintXmlFile, "lint.xml");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0018H\u0016J*\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0001H\u0016J*\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010.\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u00100\u001a\u00020\u0014H\u0016J\b\u00101\u001a\u00020\u0017H\u0016J*\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R(\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00069"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy$ProjectPlaceholderConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "dir", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Ljava/io/File;)V", "value", "baselineFile", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "fileLevel", "", "getFileLevel", "()Z", "setFileLevel", "(Z)V", "addConfiguredIssues", "", "targetMap", "", "", "Lcom/android/tools/lint/detector/api/Severity;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "specificOnly", "ensureParentIsLocalLintXml", "finishBulkEditing", "getDefinedSeverity", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "visibleDefault", "getLocalIssueConfigLocation", "Lcom/android/tools/lint/detector/api/Location;", "severityOnly", "ignore", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "message", "file", "issueId", "isEnabled", "setSeverity", "severity", "startBulkEditing", "toString", "validateIssueIds", "client", "Lcom/android/tools/lint/client/api/LintClient;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nConfigurationHierarchy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationHierarchy.kt\ncom/android/tools/lint/client/api/ConfigurationHierarchy$ProjectPlaceholderConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,693:1\n1#2:694\n*E\n"})
    private final class ProjectPlaceholderConfiguration
    extends Configuration {
        private boolean fileLevel;

        public ProjectPlaceholderConfiguration(@NotNull ConfigurationHierarchy configurations, File dir) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                super(configurations);
                this.setDir(dir);
                Configuration configuration = ConfigurationHierarchy.this.getFallback();
                if (configuration == null) break block0;
                Configuration it = configuration;
                boolean bl = false;
                this.setParent(it);
            }
        }

        @Override
        public boolean isEnabled(@NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.isEnabled(issue) : super.isEnabled(issue);
        }

        @Override
        @Nullable
        public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
            Object object = this.getParent();
            if (object == null || (object = object.getDefinedSeverity(issue, source, visibleDefault)) == null) {
                object = super.getDefinedSeverity(issue, source, visibleDefault);
            }
            return object;
        }

        @Override
        public void startBulkEditing() {
            block0: {
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.startBulkEditing();
            }
        }

        @Override
        public void finishBulkEditing() {
            block0: {
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.finishBulkEditing();
            }
        }

        @Override
        public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.validateIssueIds(client, driver, project, registry);
            }
        }

        @Override
        public void addConfiguredIssues(@NotNull Map<String, Severity> targetMap, @NotNull IssueRegistry registry, boolean specificOnly) {
            block0: {
                Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
                Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.addConfiguredIssues(targetMap, registry, specificOnly);
            }
        }

        @Override
        @Nullable
        public Location getLocalIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly, @NotNull Configuration source) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.getLocalIssueConfigLocation(issue, specificOnly, severityOnly, source) : null;
        }

        @Override
        public boolean getFileLevel() {
            return this.fileLevel;
        }

        @Override
        public void setFileLevel(boolean bl) {
            this.fileLevel = bl;
        }

        private final void ensureParentIsLocalLintXml() {
            File file = this.getDir();
            if (file == null || (file = Companion.getLintXmlFile(file)) == null) {
                return;
            }
            File xmlFile = file;
            if (!xmlFile.isFile()) {
                Configuration currentParent;
                FilesKt.writeText$default((File)xmlFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n</lint>", null, (int)2, null);
                LintXmlConfiguration configuration = LintXmlConfiguration.Companion.create(this.getConfigurations(), xmlFile);
                configuration.setFileLevel(false);
                this.setFileLevel(true);
                Configuration configuration2 = currentParent = this.getParent();
                if (configuration2 != null) {
                    Configuration it = configuration2;
                    boolean bl = false;
                    configuration.setParent(it);
                }
                this.setParent(configuration);
            }
        }

        @Override
        @Nullable
        public File getBaselineFile() {
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.getBaselineFile() : null;
        }

        @Override
        public void setBaselineFile(@Nullable File value) {
            this.ensureParentIsLocalLintXml();
            Configuration configuration = this.getParent();
            if (configuration != null) {
                configuration.setBaselineFile(value);
            }
        }

        @Override
        public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location2, @NotNull String message2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.ignore(context2, issue, location2, message2);
            }
        }

        @Override
        public void ignore(@NotNull Issue issue, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.ignore(issue.getId(), file);
        }

        @Override
        public void ignore(@NotNull String issueId, @NotNull File file) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.ignore(issueId, file);
            }
        }

        @Override
        public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.setSeverity(issue, severity);
            }
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.getDir();
        }
    }
}

