/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.lint.client.api.PlatformLookup;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup;", "Lcom/android/tools/lint/client/api/PlatformLookup;", "sdkHome", "Ljava/io/File;", "(Ljava/io/File;)V", "targets", "", "Lcom/android/sdklib/IAndroidTarget;", "getFile", "compileSdkPrefix", "", "pathId", "", "getLatestSdkTarget", "minApi", "includePreviews", "", "includeAddOns", "getTarget", "buildTargetHash", "getTargets", "Companion", "PlatformTarget", "lint-api"})
@SourceDebugExtension(value={"SMAP\nSimplePlatformLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePlatformLookup.kt\ncom/android/tools/lint/client/api/SimplePlatformLookup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n295#2,2:522\n543#2,6:524\n543#2,6:530\n*S KotlinDebug\n*F\n+ 1 SimplePlatformLookup.kt\ncom/android/tools/lint/client/api/SimplePlatformLookup\n*L\n85#1:522,2\n98#1:524,6\n100#1:530,6\n*E\n"})
public final class SimplePlatformLookup
implements PlatformLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File sdkHome;
    @NotNull
    private final List<IAndroidTarget> targets;
    @NotNull
    private static final Map<File, SimplePlatformLookup> cache = new LinkedHashMap();

    public SimplePlatformLookup(@NotNull File sdkHome) {
        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
        this.sdkHome = sdkHome;
        List targets = new ArrayList();
        SimplePlatformLookup.Companion.addPlatforms(targets, this.sdkHome, "platforms", null);
        CollectionsKt.sort((List)targets);
        this.targets = targets;
    }

    @Override
    @NotNull
    public List<IAndroidTarget> getTargets(boolean includeAddOns) {
        if (includeAddOns) {
            throw new IllegalStateException("Add-ons not supported in this platform lookup".toString());
        }
        return this.targets;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget(@NotNull String buildTargetHash) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)buildTargetHash, (String)"buildTargetHash");
            Iterable $this$firstOrNull$iv = PlatformLookup.getTargets$default(this, false, 1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IAndroidTarget it = (IAndroidTarget)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.hashString(), (Object)buildTargetHash)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public IAndroidTarget getLatestSdkTarget(int minApi, boolean includePreviews, boolean includeAddOns) {
        IAndroidTarget iAndroidTarget;
        if (includeAddOns) {
            throw new IllegalStateException("Add-ons not supported in this platform lookup".toString());
        }
        if (includePreviews) {
            IAndroidTarget iAndroidTarget2;
            block6: {
                List<IAndroidTarget> $this$lastOrNull$iv = this.targets;
                boolean $i$f$lastOrNull = false;
                ListIterator<IAndroidTarget> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    IAndroidTarget element$iv;
                    IAndroidTarget it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!it.isPlatform()) continue;
                    iAndroidTarget2 = element$iv;
                    break block6;
                }
                iAndroidTarget2 = null;
            }
            iAndroidTarget = iAndroidTarget2;
        } else {
            IAndroidTarget iAndroidTarget3;
            block7: {
                List<IAndroidTarget> $this$lastOrNull$iv = this.targets;
                boolean $i$f$lastOrNull = false;
                ListIterator<IAndroidTarget> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    IAndroidTarget element$iv;
                    IAndroidTarget it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.isPlatform() && it.getVersion().getCodename() == null)) continue;
                    iAndroidTarget3 = element$iv;
                    break block7;
                }
                iAndroidTarget3 = null;
            }
            iAndroidTarget = iAndroidTarget3;
        }
        if (iAndroidTarget == null) {
            return null;
        }
        IAndroidTarget latest = iAndroidTarget;
        return latest.getVersion().getApiLevel() >= minApi ? latest : null;
    }

    @Nullable
    public final File getFile(@NotNull String compileSdkPrefix, int pathId) {
        Intrinsics.checkNotNullParameter((Object)compileSdkPrefix, (String)"compileSdkPrefix");
        Object object = this.getTarget(compileSdkPrefix);
        return object != null && (object = object.getPath(pathId)) != null ? object.toFile() : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup$Companion;", "", "()V", "cache", "", "Ljava/io/File;", "Lcom/android/tools/lint/client/api/SimplePlatformLookup;", "addPlatforms", "", "into", "", "Lcom/android/sdklib/IAndroidTarget;", "sdkHome", "folder", "", "prefix", "get", "getOptionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "platform", "platformFromPackageXml", "location", "packageXml", "platformFromSourceProp", "sourceProperties", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nSimplePlatformLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePlatformLookup.kt\ncom/android/tools/lint/client/api/SimplePlatformLookup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n1#2:522\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimplePlatformLookup get(@NotNull File sdkHome) {
            Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
            SimplePlatformLookup simplePlatformLookup = (SimplePlatformLookup)cache.get(sdkHome);
            if (simplePlatformLookup == null) {
                SimplePlatformLookup simplePlatformLookup2;
                SimplePlatformLookup it = simplePlatformLookup2 = new SimplePlatformLookup(sdkHome);
                boolean bl = false;
                cache.put(sdkHome, it);
                simplePlatformLookup = simplePlatformLookup2;
            }
            return simplePlatformLookup;
        }

        private final void addPlatforms(List<IAndroidTarget> into, File sdkHome, String folder, String prefix) {
            File[] fileArray = new File(sdkHome, folder).listFiles();
            if (fileArray == null) {
                return;
            }
            for (File platformFolder : fileArray) {
                IAndroidTarget it;
                String name = platformFolder.getName();
                if (prefix != null) {
                    Intrinsics.checkNotNull((Object)name);
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'.', (boolean)false, (int)2, null)) continue;
                }
                if (!platformFolder.isDirectory()) continue;
                File packageXml = new File(platformFolder, "package.xml");
                if (packageXml.isFile()) {
                    Intrinsics.checkNotNull((Object)platformFolder);
                    if (this.platformFromPackageXml(platformFolder, packageXml) != null) {
                        IAndroidTarget it2;
                        boolean bl = false;
                        into.add(it2);
                    }
                    continue;
                }
                File sourceProperties = new File(platformFolder, "source.properties");
                if (!sourceProperties.isFile()) continue;
                Intrinsics.checkNotNull((Object)platformFolder);
                if (this.platformFromSourceProp(platformFolder, sourceProperties) == null) continue;
                boolean bl = false;
                into.add(it);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IAndroidTarget platformFromPackageXml(File location2, File packageXml) {
            String buildTargetHash = null;
            String codeName = null;
            int apiLevel = 0;
            apiLevel = -1;
            String vendorId = null;
            String nameId = null;
            int revision = 0;
            revision = 1;
            try {
                Object object = packageXml;
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
                object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                object2 = null;
                try {
                    BufferedReader reader = (BufferedReader)object;
                    boolean bl = false;
                    KXmlParser parser = new KXmlParser();
                    parser.setInput((Reader)reader);
                    while (parser.next() != 1) {
                        int eventType = parser.getEventType();
                        if (eventType != 2) continue;
                        int depth = parser.getDepth();
                        block3 : switch (depth) {
                            case 3: {
                                String tag = parser.getName();
                                if (!Intrinsics.areEqual((Object)tag, (Object)"revision") || parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"major") || parser.next() != 4) break;
                                String string = parser.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                Integer n2 = StringsKt.toIntOrNull((String)string);
                                revision = n2 != null ? n2 : 1;
                                break;
                            }
                            case 4: {
                                String tag = parser.getName();
                                if (tag == null) break;
                                int n3 = -1;
                                switch (tag.hashCode()) {
                                    case -820075192: {
                                        if (tag.equals("vendor")) {
                                            n3 = 1;
                                        }
                                        break;
                                    }
                                    case -867210760: {
                                        if (tag.equals("codename")) {
                                            n3 = 2;
                                        }
                                        break;
                                    }
                                    case -1513378287: {
                                        if (tag.equals("api-level")) {
                                            n3 = 3;
                                        }
                                        break;
                                    }
                                    case 114586: {
                                        if (tag.equals("tag")) {
                                            n3 = 4;
                                        }
                                        break;
                                    }
                                }
                                switch (n3) {
                                    case 3: {
                                        if (parser.next() != 4) break block3;
                                        String text = parser.getText();
                                        Intrinsics.checkNotNull((Object)text);
                                        Integer n4 = StringsKt.toIntOrNull((String)text);
                                        if (n4 != null) {
                                            int api = ((Number)n4).intValue();
                                            boolean bl2 = false;
                                            apiLevel = api;
                                            break;
                                        }
                                        break block3;
                                    }
                                    case 2: {
                                        if (parser.next() != 4) break block3;
                                        String text = parser.getText();
                                        Intrinsics.checkNotNull((Object)text);
                                        if (!(!StringsKt.isBlank((CharSequence)text))) break block3;
                                        codeName = text;
                                        break;
                                    }
                                    case 1: {
                                        if (parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"id") || parser.next() != 4) break block3;
                                        vendorId = parser.getText();
                                        break;
                                    }
                                    case 4: {
                                        if (parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"id") || parser.next() != 4) break block3;
                                        nameId = parser.getText();
                                    }
                                }
                                break;
                            }
                            case 2: {
                                String path2;
                                String tag = parser.getName();
                                if (!Intrinsics.areEqual((Object)tag, (Object)"localPackage") || (path2 = parser.getAttributeValue(null, "path")) == null || !StringsKt.startsWith$default((String)path2, (String)"platforms;", (boolean)false, (int)2, null)) break;
                                buildTargetHash = StringsKt.removePrefix((String)path2, (CharSequence)"platforms;");
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean platform = true;
            AndroidVersion version = new AndroidVersion(apiLevel, codeName);
            if (nameId != null && vendorId != null && apiLevel != -1) {
                buildTargetHash = AndroidTargetHash.getAddonHashString(vendorId, nameId, (AndroidVersion)version);
                platform = false;
            }
            return buildTargetHash != null && apiLevel != -1 ? (IAndroidTarget)new PlatformTarget(location2, buildTargetHash, version, revision, platform) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final IAndroidTarget platformFromSourceProp(File location, File sourceProperties) {
            try {
                var3_3 = new FileInputStream(sourceProperties);
                var4_5 = null;
                try {
                    input = (FileInputStream)var3_3;
                    $i$a$-use-SimplePlatformLookup$Companion$platformFromSourceProp$1 = false;
                    prop = new Properties();
                    prop.load(input);
                    platformVersion = prop.getProperty("Platform.Version");
                    var9_12 = prop.getProperty("Pkg.Revision");
                    v0 = var9_12;
                    if (v0 == null) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)v0);
                    v0 = StringsKt.toIntOrNull((String)var9_12);
                    if (v0 != null) {
                        v1 = v0.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = 1;
                    }
                    revision = v1;
                    v2 = var11_14 = prop.getProperty("AndroidVersion.ApiLevel");
                    if (v2 != null) {
                        Intrinsics.checkNotNull((Object)v2);
                        v3 = Integer.parseInt(var11_14);
                    } else {
                        v3 = null;
                    }
                    apiLevel = v3;
                    codeName = prop.getProperty("AndroidVersion.CodeName");
                    if (platformVersion != null && apiLevel != null) {
                        v4 = sourceProperties.getParentFile();
                        Intrinsics.checkNotNull((Object)v4);
                        v5 = v4.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getName(...)");
                        var12_15 = new PlatformTarget(location, v5, new AndroidVersion(apiLevel.intValue(), codeName), revision, true);
                        return var12_15;
                    }
                    var5_6 = Unit.INSTANCE;
                }
                catch (Throwable var5_7) {
                    var4_5 = var5_7;
                    throw var5_7;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_5);
                }
            }
            catch (IOException var3_4) {
                // empty catch block
            }
            return null;
        }

        private final List<OptionalLibrary> getOptionalLibraries(File platform) {
            File optional = new File(platform, "optional");
            File jsonFile = new File(optional, "optional.json");
            if (!jsonFile.isFile()) {
                return CollectionsKt.emptyList();
            }
            List libraries = new ArrayList();
            String json = FilesKt.readText$default((File)jsonFile, null, (int)1, null);
            Ref.IntRef index = new Ref.IntRef();
            while (com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextItem(index, json)) {
                Ref.ObjectRef name = new Ref.ObjectRef();
                String jar = null;
                Ref.BooleanRef manifest = new Ref.BooleanRef();
                while (com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextPair(index, json) != null) {
                    Pair<String, Object> pair;
                    String key = (String)pair.getFirst();
                    Object value = pair.getSecond();
                    if (Intrinsics.areEqual((Object)key, (Object)"name") && value instanceof String) {
                        name.element = value;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)key, (Object)"jar") && value instanceof String) {
                        jar = (String)value;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)key, (Object)"manifest") || !(value instanceof Boolean)) continue;
                    manifest.element = (Boolean)value;
                }
                if (name.element == null || jar == null) continue;
                Path jarPath = new File(optional, StringsKt.replace$default(jar, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).toPath();
                OptionalLibrary library2 = new OptionalLibrary((Ref.ObjectRef<String>)name, jarPath, manifest){
                    final /* synthetic */ Ref.ObjectRef<String> $name;
                    final /* synthetic */ Path $jarPath;
                    final /* synthetic */ Ref.BooleanRef $manifest;
                    {
                        this.$name = $name;
                        this.$jarPath = $jarPath;
                        this.$manifest = $manifest;
                    }

                    public String getName() {
                        return (String)this.$name.element;
                    }

                    public Path getJar() {
                        Path path2 = this.$jarPath;
                        Intrinsics.checkNotNull((Object)path2);
                        return path2;
                    }

                    public String getDescription() {
                        return (String)this.$name.element;
                    }

                    public boolean isManifestEntryRequired() {
                        return this.$manifest.element;
                    }

                    public String getLocalJarPath() {
                        return ((Object)this.getJar().getFileName()).toString();
                    }
                };
                libraries.add(library2);
            }
            return libraries;
        }

        private static final boolean getOptionalLibraries$nextItem(Ref.IntRef index, String json) {
            index.element = StringsKt.indexOf$default((CharSequence)json, (char)'{', (int)index.element, (boolean)false, (int)4, null);
            return index.element != -1;
        }

        private static final Object getOptionalLibraries$nextToken(Ref.IntRef index, String json) {
            while (index.element < json.length()) {
                char c = json.charAt(index.element);
                if (CharsKt.isWhitespace((char)c) || c == '{' || c == '[') {
                    int n = index.element;
                    index.element = n + 1;
                    continue;
                }
                if (c != '}' && c != ']') break;
                return null;
            }
            if (index.element == json.length()) {
                return null;
            }
            int start = index.element;
            StringBuilder buffer = new StringBuilder();
            if (json.charAt(start) == '\"') {
                int n = index.element;
                index.element = n + 1;
                while (index.element < json.length()) {
                    int n2 = index.element;
                    index.element = n2 + 1;
                    char c = json.charAt(n2);
                    if (c == '\\') {
                        n2 = index.element;
                        index.element = n2 + 1;
                        buffer.append(json.charAt(n2));
                        continue;
                    }
                    if (c == '\"') {
                        n2 = index.element;
                        index.element = n2 + 1;
                        return buffer.toString();
                    }
                    buffer.append(c);
                }
                return null;
            }
            int end = index.element + 1;
            while (index.element < json.length()) {
                int n = index.element;
                index.element = n + 1;
                char c = json.charAt(n);
                if (CharsKt.isWhitespace((char)c) || c == '{' || c == '[') {
                    end = index.element - 1;
                    break;
                }
                if (c != '}' && c != ']') continue;
                return null;
            }
            if (index.element == json.length()) {
                return null;
            }
            String string = json.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String valueString = string;
            if (Character.isDigit(json.charAt(start))) {
                int dot = StringsKt.indexOf$default((CharSequence)json, (char)'.', (int)start, (boolean)false, (int)4, null);
                return dot != -1 && dot < end ? (Number)StringsKt.toDoubleOrNull((String)valueString) : (Number)StringsKt.toIntOrNull((String)valueString);
            }
            if (Intrinsics.areEqual((Object)valueString, (Object)"true")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)valueString, (Object)"false")) {
                return false;
            }
            return null;
        }

        private static final Pair<String, Object> getOptionalLibraries$nextPair(Ref.IntRef index, String json) {
            Object keyToken = com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextToken(index, json);
            Object valueToken = com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextToken(index, json);
            return keyToken instanceof String && valueToken != null ? new Pair(keyToken, valueToken) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\u0011\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0001H\u0096\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\nJ\b\u0010#\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020\u0006H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010&\u001a\u00020\u0001H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0016\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060,H\u0016J\u0012\u0010-\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0016J\b\u00102\u001a\u00020\u0006H\u0016J\b\u00103\u001a\u00020\bH\u0016J\b\u00104\u001a\u00020\u0006H\u0016J\b\u00105\u001a\u00020\fH\u0016J\b\u00106\u001a\u00020\u0006H\u0016J\b\u00107\u001a\u00020\fH\u0016J\b\u00108\u001a\u00020\u0006H\u0016J\b\u00109\u001a\u00020:H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup$PlatformTarget;", "Lcom/android/sdklib/IAndroidTarget;", "", "location", "Ljava/io/File;", "buildTargetHash", "", "version", "Lcom/android/sdklib/AndroidVersion;", "revision", "", "platform", "", "(Ljava/io/File;Ljava/lang/String;Lcom/android/sdklib/AndroidVersion;IZ)V", "getBuildTargetHash", "()Ljava/lang/String;", "getLocation", "()Ljava/io/File;", "optionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "canRunOn", "target", "compareTo", "other", "getAdditionalLibraries", "", "getBootClasspath", "getBuildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "getClasspathName", "getDefaultSkin", "Ljava/nio/file/Path;", "getFile", "pathId", "getFullName", "getName", "getOptionalLibraries", "getParent", "getPath", "getPlatformLibraries", "", "()[Ljava/lang/String;", "getProperties", "", "getProperty", "name", "getRevision", "getShortClasspathName", "getSkins", "getVendor", "getVersion", "getVersionName", "hasRenderingLibrary", "hashString", "isPlatform", "toString", "unsupported", "", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nSimplePlatformLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePlatformLookup.kt\ncom/android/tools/lint/client/api/SimplePlatformLookup$PlatformTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n1#2:522\n*E\n"})
    private static final class PlatformTarget
    implements IAndroidTarget,
    Comparable<IAndroidTarget> {
        @NotNull
        private final File location;
        @NotNull
        private final String buildTargetHash;
        @NotNull
        private final AndroidVersion version;
        private final int revision;
        private final boolean platform;
        @Nullable
        private List<? extends OptionalLibrary> optionalLibraries;

        public PlatformTarget(@NotNull File location2, @NotNull String buildTargetHash, @NotNull AndroidVersion version, int revision, boolean platform) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)buildTargetHash, (String)"buildTargetHash");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.location = location2;
            this.buildTargetHash = buildTargetHash;
            this.version = version;
            this.revision = revision;
            this.platform = platform;
        }

        @NotNull
        public final File getLocation() {
            return this.location;
        }

        @NotNull
        public final String getBuildTargetHash() {
            return this.buildTargetHash;
        }

        public boolean isPlatform() {
            return this.platform;
        }

        @NotNull
        public String hashString() {
            return this.buildTargetHash;
        }

        @NotNull
        public AndroidVersion getVersion() {
            return this.version;
        }

        @NotNull
        public String getLocation() {
            String string = this.location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }

        @NotNull
        public Path getPath(int pathId) {
            Path path2 = this.getFile(pathId).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }

        @NotNull
        public final File getFile(int pathId) {
            File file;
            switch (pathId) {
                case 1: {
                    file = new File(this.location, "android.jar");
                    break;
                }
                case 7: {
                    file = new File(this.location, "data");
                    break;
                }
                case 11: {
                    file = new File(this.location, "data" + File.separator + "res");
                    break;
                }
                case 8: {
                    file = new File(this.location, "data/res/values/attrs.xml");
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported path id in " + SimplePlatformLookup.class.getName()).toString());
                }
            }
            return file;
        }

        public int getRevision() {
            return this.revision;
        }

        @NotNull
        public List<OptionalLibrary> getOptionalLibraries() {
            List list = this.optionalLibraries;
            if (list == null) {
                List list2;
                PlatformTarget $this$getOptionalLibraries_u24lambda_u241 = this;
                boolean bl = false;
                List it = list2 = Companion.getOptionalLibraries($this$getOptionalLibraries_u24lambda_u241.location);
                boolean bl2 = false;
                $this$getOptionalLibraries_u24lambda_u241.optionalLibraries = it;
                list = list2;
            }
            return list;
        }

        @Override
        public int compareTo(@NotNull IAndroidTarget other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int versionDelta = this.version.compareTo(other.getVersion());
            if (versionDelta != 0) {
                return versionDelta;
            }
            int typeDelta = (this.isPlatform() ? 1 : 0) - (other.isPlatform() ? 1 : 0);
            if (typeDelta != 0) {
                return typeDelta;
            }
            String string = this.location.getPath();
            String string2 = other.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocation(...)");
            return string.compareTo(string2);
        }

        @NotNull
        public String toString() {
            return (this.platform ? "Platform" : "Add-on") + " " + this.buildTargetHash + ": version=" + this.version;
        }

        @NotNull
        public String getVendor() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getName() {
            String string;
            AndroidVersion version = this.getVersion();
            if (version.isPreview()) {
                String string2 = "Android %s (Preview)";
                Object[] objectArray = new Object[]{version};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                String string4 = "Android %s";
                Object[] objectArray = new Object[]{version};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            }
            return string;
        }

        @NotNull
        public String getFullName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getClasspathName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getShortClasspathName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getVersionName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public IAndroidTarget getParent() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public BuildToolInfo getBuildToolInfo() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public List<String> getBootClasspath() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        public boolean hasRenderingLibrary() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public List<Path> getSkins() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Path getDefaultSkin() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String[] getPlatformLibraries() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getProperty(@Nullable String name) {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Map<String, String> getProperties() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        public boolean canRunOn(@Nullable IAndroidTarget target) {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public List<OptionalLibrary> getAdditionalLibraries() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        private final Void unsupported() {
            throw new IllegalStateException("This operation is not supported on light weight IAndroidTargets".toString());
        }
    }
}

