/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import com.android.tools.lint.detector.api.interprocedural.ClassHierarchy;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluator;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluatorKt;
import com.android.tools.lint.detector.api.interprocedural.MutableCallGraph;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u0018H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "receiverEval", "Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;", "classHierarchy", "Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;", "conservative", "", "(Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;Z)V", "callGraph", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "getCallGraph", "()Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "mutableCallGraph", "Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph;", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lorg/jetbrains/uast/UElement;", "constructors", "", "Lorg/jetbrains/uast/UMethod;", "isCallable", "isStaticallyDispatched", "ExplicitSuperConstructorCallFinder", "lint-api"})
@SourceDebugExtension(value={"SMAP\nCallGraphVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallGraphVisitor.kt\ncom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,233:1\n171#2:234\n171#2:245\n774#3:235\n865#3,2:236\n1863#3,2:239\n1557#3:241\n1628#3,3:242\n1863#3,2:246\n669#3,11:248\n1557#3:259\n1628#3,3:260\n1863#3,2:263\n774#3:265\n865#3,2:266\n1863#3,2:268\n1863#3,2:273\n1#4:238\n3829#5:270\n4344#5,2:271\n*S KotlinDebug\n*F\n+ 1 CallGraphVisitor.kt\ncom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor\n*L\n75#1:234\n144#1:245\n79#1:235\n79#1:236,2\n90#1:239,2\n136#1:241\n136#1:242,3\n155#1:246,2\n167#1:248,11\n176#1:259\n176#1:260,3\n177#1:263,2\n182#1:265\n182#1:266,2\n183#1:268,2\n141#1:273,2\n191#1:270\n191#1:271,2\n*E\n"})
public final class CallGraphVisitor
extends AbstractUastVisitor {
    @NotNull
    private final DispatchReceiverEvaluator receiverEval;
    @NotNull
    private final ClassHierarchy classHierarchy;
    private final boolean conservative;
    @NotNull
    private final MutableCallGraph mutableCallGraph;

    public CallGraphVisitor(@NotNull DispatchReceiverEvaluator receiverEval, @NotNull ClassHierarchy classHierarchy, boolean conservative) {
        Intrinsics.checkNotNullParameter((Object)receiverEval, (String)"receiverEval");
        Intrinsics.checkNotNullParameter((Object)classHierarchy, (String)"classHierarchy");
        this.receiverEval = receiverEval;
        this.classHierarchy = classHierarchy;
        this.conservative = conservative;
        this.mutableCallGraph = new MutableCallGraph();
    }

    public /* synthetic */ CallGraphVisitor(DispatchReceiverEvaluator dispatchReceiverEvaluator, ClassHierarchy classHierarchy, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(dispatchReceiverEvaluator, classHierarchy, bl);
    }

    @NotNull
    public final CallGraph getCallGraph() {
        return this.mutableCallGraph;
    }

    public boolean visitElement(@NotNull UElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UElement uElement = node;
        if (uElement instanceof UMethod ? true : uElement instanceof ULambdaExpression) {
            this.mutableCallGraph.getNode(node);
        }
        return super.visitElement(node);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UClass uClass = node.getSuperClass();
        PsiElement $this$toUElementOfType$iv = uClass != null && (uClass = uClass.getJavaPsi()) != null ? uClass.getNavigationElement() : null;
        boolean $i$f$toUElementOfType = false;
        UClass superClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
        if (superClass != null) {
            Object v1;
            Collection callers;
            block4: {
                UMethod it;
                void $this$filterTo$iv$iv;
                List<UMethod> constructors = this.constructors(node);
                Iterable $this$filter$iv = constructors;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (UMethod)element$iv$iv;
                    boolean bl = false;
                    ExplicitSuperConstructorCallFinder explicitSuperFinder = new ExplicitSuperConstructorCallFinder();
                    it.accept((UastVisitor)explicitSuperFinder);
                    if (!(!explicitSuperFinder.getFoundExplicitCall())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List thoseWithoutExplicitSuper = (List)destination$iv$iv;
                callers = !((Collection)constructors).isEmpty() ? (Collection)thoseWithoutExplicitSuper : (Collection)CollectionsKt.listOf((Object)node);
                Iterable $i$f$filterTo22 = this.constructors(superClass);
                for (Object element$iv$iv : $i$f$filterTo22) {
                    it = (UMethod)element$iv$iv;
                    boolean bl = false;
                    if (!it.getUastParameters().isEmpty()) continue;
                    v1 = element$iv$iv;
                    break block4;
                }
                v1 = null;
            }
            UMethod uMethod = v1;
            UElement callee = uMethod != null ? (UElement)uMethod : (UElement)superClass;
            MutableCallGraph $this$visitClass_u24lambda_u243 = this.mutableCallGraph;
            boolean bl = false;
            MutableCallGraph.MutableNode calleeNode = $this$visitClass_u24lambda_u243.getNode(callee);
            Iterable $this$forEach$iv = callers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UElement it = (UElement)element$iv;
                boolean bl2 = false;
                $this$visitClass_u24lambda_u243.getNode(it).getEdges().add(new CallGraph.Edge(calleeNode, null, CallGraph.Edge.Kind.DIRECT));
            }
        }
        return super.visitClass(node);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Object v4;
        Object it;
        boolean isFunctionalCall;
        boolean throughSuper;
        boolean staticallyDispatched;
        List overrides;
        UMethod baseCallee;
        List callerNodes;
        Collection collection;
        block26: {
            void $this$mapTo$iv$iv;
            List ctors;
            Collection collection2;
            UAnnotated parent;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Class[] classArray = new Class[]{ULambdaExpression.class, UClassInitializer.class, UField.class};
            UAnnotated uAnnotated = parent = (UAnnotated)UastUtils.getParentOfType((UElement)((UElement)node), (boolean)true, UMethod.class, (Class[])classArray);
            if (uAnnotated instanceof UMethod ? true : uAnnotated instanceof ULambdaExpression) {
                collection2 = CollectionsKt.listOf((Object)parent);
            } else if (uAnnotated instanceof UClassInitializer ? true : uAnnotated instanceof UField) {
                Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.uast.UDeclaration");
                UDeclaration decl = (UDeclaration)parent;
                if (decl.isStatic()) {
                    return super.visitCallExpression(node);
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)decl));
                if (uClass == null) {
                    return super.visitCallExpression(node);
                }
                UClass containingClass = uClass;
                ctors = this.constructors(containingClass);
                collection2 = !((Collection)ctors).isEmpty() ? ctors : CollectionsKt.listOf((Object)containingClass);
            } else {
                return super.visitCallExpression(node);
            }
            Collection callers = collection2;
            List $this$map$iv = (List)callers;
            boolean $i$f$map = false;
            ctors = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                UElement uElement = (UElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.mutableCallGraph.getNode((UElement)it2));
            }
            callerNodes = (List)destination$iv$iv;
            PsiElement $this$toUElementOfType$iv = (PsiElement)node.resolve();
            boolean $i$f$toUElementOfType = false;
            baseCallee = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (baseCallee == null) {
                if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    UReferenceExpression uReferenceExpression = node.getClassReference();
                    destination$iv$iv = UastContextKt.toUElement(uReferenceExpression != null && (uReferenceExpression = uReferenceExpression.resolve()) != null ? uReferenceExpression.getNavigationElement() : null);
                    UClass uClass = destination$iv$iv instanceof UClass ? (UClass)destination$iv$iv : null;
                    if (uClass == null) {
                        return super.visitCallExpression(node);
                    }
                    UClass constructedClass = uClass;
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)constructedClass, CallGraph.Edge.Kind.DIRECT);
                } else if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"invoke")) {
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, null, CallGraph.Edge.Kind.INVOKE);
                    Iterable $this$forEach$iv = DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallTarget it3 = (CallTarget)element$iv;
                        boolean bl = false;
                        CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, it3.getElement(), CallGraph.Edge.Kind.TYPE_EVIDENCED);
                    }
                }
                return super.visitCallExpression(node);
            }
            overrides = SequencesKt.toList(this.classHierarchy.allOverridesOf(baseCallee));
            staticallyDispatched = this.isStaticallyDispatched(baseCallee);
            throughSuper = node.getReceiver() instanceof USuperExpression;
            isFunctionalCall = Intrinsics.areEqual((Object)baseCallee.getJavaPsi(), (Object)LambdaUtil.getFunctionalInterfaceMethod((PsiType)node.getReceiverType()));
            Iterable $this$singleOrNull$iv = CollectionsKt.plus((Collection)overrides, (Object)baseCallee);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                it = (UMethod)element$iv;
                boolean bl = false;
                if (!this.isCallable((UMethod)it)) continue;
                if (found$iv) {
                    v4 = null;
                    break block26;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        UMethod uniqueImpl = v4;
        if (staticallyDispatched || throughSuper) {
            CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.DIRECT);
        } else if (uniqueImpl != null && !isFunctionalCall) {
            if (!Intrinsics.areEqual((Object)uniqueImpl, (Object)baseCallee)) {
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)uniqueImpl, CallGraph.Edge.Kind.UNIQUE);
        } else {
            UMethod it4;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
            boolean $i$f$map = false;
            Iterable found$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            it = $this$mapTo$iv$iv.iterator();
            while (it.hasNext()) {
                Object item$iv$iv = it.next();
                CallTarget callTarget = (CallTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it4.getElement());
            }
            List evidencedTargets = (List)destination$iv$iv;
            Iterable $this$forEach$iv = evidencedTargets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UElement it5 = (UElement)element$iv;
                boolean bl = false;
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, it5, CallGraph.Edge.Kind.TYPE_EVIDENCED);
            }
            if (!evidencedTargets.contains(baseCallee)) {
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            if (this.conservative) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$forEach$iv = overrides;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it4 = (UMethod)element$iv$iv;
                    boolean bl = false;
                    if (!(!evidencedTargets.contains(it4) && this.isCallable(it4))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UMethod it6 = (UMethod)element$iv;
                    boolean bl = false;
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)it6, CallGraph.Edge.Kind.NON_UNIQUE_OVERRIDE);
                }
            }
        }
        return super.visitCallExpression(node);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UMethod> constructors(UClass $this$constructors) {
        void $this$filterTo$iv$iv;
        UMethod[] $this$filter$iv = $this$constructors.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!it.isConstructor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isCallable(UMethod $this$isCallable) {
        boolean bl;
        if ($this$isCallable.getJavaPsi().hasModifierProperty("abstract")) {
            bl = false;
        } else {
            PsiClass psiClass = $this$isCallable.getJavaPsi().getContainingClass();
            bl = (psiClass != null ? psiClass.isInterface() : false) ? $this$isCallable.getJavaPsi().hasModifierProperty("default") : true;
        }
        return bl;
    }

    private final boolean isStaticallyDispatched(UMethod $this$isStaticallyDispatched) {
        PsiClass psiClass = $this$isStaticallyDispatched.getJavaPsi().getContainingClass();
        if (psiClass == null) {
            return true;
        }
        PsiClass parentClass = psiClass;
        return $this$isStaticallyDispatched.isConstructor() || $this$isStaticallyDispatched.isStatic() || $this$isStaticallyDispatched.isFinal() || $this$isStaticallyDispatched.getVisibility() == UastVisibility.PRIVATE || parentClass instanceof PsiAnonymousClass || parentClass.hasModifierProperty("final");
    }

    private static final void visitCallExpression$addEdge(UCallExpression $node, List<MutableCallGraph.MutableNode> callerNodes, CallGraphVisitor this$0, UElement callee, CallGraph.Edge.Kind kind) {
        MutableCallGraph.MutableNode mutableNode;
        UElement uElement = callee;
        if (uElement != null) {
            UElement it = uElement;
            boolean bl = false;
            mutableNode = this$0.mutableCallGraph.getNode(it);
        } else {
            mutableNode = null;
        }
        MutableCallGraph.MutableNode calleeNode = mutableNode;
        CallGraph.Edge edge = new CallGraph.Edge(calleeNode, $node, kind);
        Iterable $this$forEach$iv = callerNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableCallGraph.MutableNode it = (MutableCallGraph.MutableNode)element$iv;
            boolean bl = false;
            it.getEdges().add(edge);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor$ExplicitSuperConstructorCallFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "()V", "foundExplicitCall", "", "getFoundExplicitCall", "()Z", "setFoundExplicitCall", "(Z)V", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "lint-api"})
    private static final class ExplicitSuperConstructorCallFinder
    extends AbstractUastVisitor {
        private boolean foundExplicitCall;

        public final boolean getFoundExplicitCall() {
            return this.foundExplicitCall;
        }

        public final void setFoundExplicitCall(boolean bl) {
            this.foundExplicitCall = bl;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"super")) {
                this.foundExplicitCall = true;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return true;
        }
    }
}

