/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.DefaultLintTomlParser;
import com.android.tools.lint.client.api.DefaultLintTomlParserKt;
import com.android.tools.lint.client.api.LintTomlArrayValue;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlLiteralValue;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u000589:;<BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\"\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\n\u0010\u001d\u001a\u00060\u001cR\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0018\u0010\"\u001a\u00060#R\u00020\u00002\n\u0010\u001d\u001a\u00060#R\u00020\u0000H\u0002J8\u0010$\u001a\u00060%R\u00020\u00002\n\u0010\u001d\u001a\u00060\u001cR\u00020\u00002\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0018\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0011H\u0002J\u001a\u0010,\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010-2\b\b\u0002\u0010.\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\u000bH\u0002J&\u00100\u001a\u00020\n2\b\b\u0002\u00101\u001a\u00020\r2\b\b\u0002\u00102\u001a\u00020\r2\b\b\u0002\u00103\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u0011H\u0002J\u0012\u00107\u001a\u00020\u00112\b\b\u0002\u00101\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "", "file", "Ljava/io/File;", "source", "", "onProblem", "Lkotlin/Function3;", "Lcom/android/tools/lint/detector/api/Severity;", "Lcom/android/tools/lint/detector/api/Location;", "", "", "validate", "", "<init>", "(Ljava/io/File;Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function3;Z)V", "offset", "", "length", "document", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlDocument;", "getDocument", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "getDocument$lint_api", "warn", "message", "at", "parseMapElements", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlMapValue;", "parent", "inInlineTable", "sameLine", "offset1", "offset2", "parseArrayElements", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlArrayValue;", "parseValue", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "key", "keyStart", "keyEnd", "valueStart", "validateLiteralValue", "literal", "parseKey", "", "initial", "consumeToLineEnd", "getToken", "breakAtNewline", "breakOnDot", "arrayTableAllowed", "validateStringEnd", "start", "end", "skipToNextToken", "TomlDocument", "TomlValue", "TomlMapValue", "TomlArrayValue", "TomlLiteralValue", "lint-api"})
public final class DefaultLintTomlParser {
    @NotNull
    private final File file;
    @NotNull
    private final CharSequence source;
    @Nullable
    private final Function3<Severity, Location, String, Unit> onProblem;
    private final boolean validate;
    private int offset;
    private final int length;
    @NotNull
    private final TomlDocument document;

    public DefaultLintTomlParser(@NotNull File file, @NotNull CharSequence source, @Nullable Function3<? super Severity, ? super Location, ? super String, Unit> onProblem, boolean validate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.file = file;
        this.source = source;
        this.onProblem = onProblem;
        this.validate = validate;
        this.length = this.source.length();
        this.document = new TomlDocument();
        DefaultLintTomlParser.parseMapElements$default(this, this.document.getRoot(), false, 2, null);
    }

    public /* synthetic */ DefaultLintTomlParser(File file, CharSequence charSequence, Function3 function3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = function3 != null;
        }
        this(file, charSequence, (Function3<? super Severity, ? super Location, ? super String, Unit>)function3, bl);
    }

    @NotNull
    public final LintTomlDocument getDocument$lint_api() {
        return this.document;
    }

    private final void warn(String message2, int at) {
        block0: {
            Function3<Severity, Location, String, Unit> function3 = this.onProblem;
            if (function3 == null) break block0;
            function3.invoke((Object)Severity.WARNING, (Object)Location.Companion.create(this.file, this.source, at, at), (Object)message2);
        }
    }

    private final TomlMapValue parseMapElements(TomlMapValue parent, boolean inInlineTable) {
        int mapStart = this.offset;
        List currentArray = null;
        TomlMapValue target = parent;
        TomlValue lastValue = null;
        block15: while (this.offset < this.length) {
            int keyStart = this.skipToNextToken(false);
            if (this.offset == this.length) break;
            switch (DefaultLintTomlParser.getToken$default(this, false, false, !inInlineTable, 3, null)) {
                case "[": {
                    int start = this.offset - 1;
                    int keyStart2 = this.offset;
                    List list = DefaultLintTomlParser.parseKey$default(this, null, 1, null);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    currentArray = list;
                    int keyEnd = this.offset;
                    String close = DefaultLintTomlParser.getToken$default(this, false, false, false, 7, null);
                    if (this.validate) {
                        if (!Intrinsics.areEqual((Object)close, (Object)"]")) {
                            this.warn("= missing ]`", keyEnd);
                        }
                        if (parent.find(currentArray) != null) {
                            this.warn("You cannot define a table (`" + CollectionsKt.joinToString$default((Iterable)currentArray, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + "`) more than once", start);
                        }
                    }
                    if (inInlineTable) {
                        if (this.validate) {
                            this.warn("cannot define a table in an inline table", start);
                        }
                        this.offset = keyStart2;
                        continue block15;
                    }
                    target = parent.ensure(currentArray, this.validate);
                    if (target.getStartOffset() != -1) continue block15;
                    target.setStartOffset(start);
                    if (target.getKey() == null) continue block15;
                    target.setKeyRange(keyStart2, keyEnd);
                    continue block15;
                }
                case "[[": {
                    int start = this.offset - 2;
                    int keyStart2 = this.offset;
                    List list = DefaultLintTomlParser.parseKey$default(this, null, 1, null);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    currentArray = list;
                    int keyEnd = this.offset;
                    String close = DefaultLintTomlParser.getToken$default(this, false, false, true, 3, null);
                    if (this.validate && !Intrinsics.areEqual((Object)close, (Object)"]]")) {
                        this.warn("= missing ]]`", keyEnd);
                    }
                    if (inInlineTable) {
                        if (this.validate) {
                            this.warn("cannot define an array of tables in an inline table", start);
                        }
                        this.offset = keyStart2;
                        continue block15;
                    }
                    int arrayStart = this.skipToNextToken(false);
                    TomlValue array = parent.find(currentArray);
                    if (array instanceof TomlArrayValue) {
                        target = new TomlMapValue(this, array, arrayStart, this.offset, null, 0, 0, 56, null);
                        if (((TomlArrayValue)array).isLiteral() && this.validate) {
                            this.warn("Attempting to append to a statically defined array is not allowed", start);
                        }
                        ((TomlArrayValue)array).add(target);
                        continue block15;
                    }
                    TomlMapValue into = currentArray.size() > 1 ? parent.ensure(CollectionsKt.dropLast((List)currentArray, (int)1), false) : parent;
                    TomlValue tomlValue = into;
                    String string = (String)CollectionsKt.lastOrNull((List)currentArray);
                    if (string == null) {
                        string = "";
                    }
                    TomlArrayValue arrayValue = new TomlArrayValue(this, tomlValue, arrayStart, this.offset, string, start, keyEnd, false);
                    String string2 = (String)CollectionsKt.lastOrNull((List)currentArray);
                    if (string2 == null) {
                        string2 = "";
                    }
                    into.put(string2, arrayValue);
                    target = new TomlMapValue(this, arrayValue, arrayStart, this.offset, null, 0, 0, 56, null);
                    arrayValue.add(target);
                    continue block15;
                }
                case "}": {
                    break block15;
                }
                case ",": {
                    continue block15;
                }
                case "]]": 
                case "]": {
                    String token;
                    if (!this.validate) continue block15;
                    this.warn("Close found without a corresponding open: `" + token + "`", this.offset - token.length());
                    continue block15;
                }
                default: {
                    List<String> keys;
                    String token;
                    if (this.validate) {
                        if (StringsKt.startsWith$default((String)token, (String)"\"\"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)token, (String)"'''", (boolean)false, (int)2, null)) {
                            this.warn("Multi-line strings not allowed in keys", keyStart);
                        }
                        if (lastValue != null && !inInlineTable && this.sameLine(lastValue.getEndOffset(), keyStart)) {
                            this.warn("There must be a newline (or EOF) after a key/value pair", keyStart);
                        }
                    }
                    if (this.parseKey(DefaultLintTomlParserKt.access$tomlStringSourceToString(token)) == null) continue block15;
                    int keyEnd = this.offset;
                    String equals = DefaultLintTomlParser.getToken$default(this, false, false, false, 7, null);
                    if (!Intrinsics.areEqual((Object)equals, (Object)"=")) {
                        if (this.validate) {
                            this.warn("= missing after key `" + token + "`", keyEnd);
                        }
                        this.offset = keyEnd;
                        continue block15;
                    }
                    int valueStart = this.skipToNextToken(true);
                    if (this.offset == this.length) {
                        if (!this.validate) continue block15;
                        this.warn("Value missing after =", valueStart);
                        continue block15;
                    }
                    String string = (String)CollectionsKt.lastOrNull(keys);
                    if (string == null) {
                        string = "";
                    }
                    String key = string;
                    TomlMapValue into = keys.size() > 1 ? target.ensure(CollectionsKt.dropLast(keys, (int)1), this.validate) : target;
                    TomlValue value = this.parseValue(into, key, keyStart, keyEnd, valueStart);
                    if (this.validate && into.getMap().get(key) != null && !(into.getMap().get(key) instanceof TomlMapValue)) {
                        this.warn("Defining a key (`" + key + "`) multiple times is invalid", this.offset);
                    }
                    value.setKeyRange(keyStart, keyEnd);
                    into.put(key, value);
                    lastValue = value;
                    continue block15;
                }
            }
        }
        target.setValueRange(mapStart, this.offset);
        return target;
    }

    static /* synthetic */ TomlMapValue parseMapElements$default(DefaultLintTomlParser defaultLintTomlParser, TomlMapValue tomlMapValue, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return defaultLintTomlParser.parseMapElements(tomlMapValue, bl);
    }

    private final boolean sameLine(int offset1, int offset2) {
        for (int i = offset1; i < offset2; ++i) {
            if (this.source.charAt(i) != '\n') continue;
            return false;
        }
        return true;
    }

    private final TomlArrayValue parseArrayElements(TomlArrayValue parent) {
        block10: while (this.offset < this.length) {
            String elementToken;
            int elementStart = this.skipToNextToken(false);
            switch (DefaultLintTomlParser.getToken$default(this, false, false, false, 7, null)) {
                case ",": {
                    continue block10;
                }
                case "{": {
                    TomlMapValue map = new TomlMapValue(this, parent, elementStart, this.offset, null, 0, 0, 56, null);
                    this.parseMapElements(map, true);
                    map.setEndOffset(this.offset);
                    parent.add(map);
                    continue block10;
                }
                case "[": {
                    TomlArrayValue array = new TomlArrayValue(this, parent, elementStart, this.offset, null, 0, 0, false, 120, null);
                    this.parseArrayElements(array);
                    array.setEndOffset(this.offset);
                    parent.add(array);
                    continue block10;
                }
            }
            String element = StringsKt.removeSuffix((String)elementToken, (CharSequence)",");
            if (Intrinsics.areEqual((Object)element, (Object)"]")) break;
            if (this.validate) {
                this.validateLiteralValue(element, elementStart);
            }
            TomlLiteralValue value = new TomlLiteralValue(this, parent, element, elementStart, this.offset, null, 0, 0, 112, null);
            parent.add(value);
        }
        return parent;
    }

    private final TomlValue parseValue(TomlMapValue parent, String key, int keyStart, int keyEnd, int valueStart) {
        String token = DefaultLintTomlParser.getToken$default(this, false, false, false, 5, null);
        if (Intrinsics.areEqual((Object)token, (Object)"{")) {
            if (this.validate && parent.find(key) != null) {
                this.warn("Inline tables cannot be used to add keys or sub-tables to an already-defined table", valueStart);
            }
            TomlMapValue target = parent.ensure(key);
            return this.parseMapElements(target, true);
        }
        if (Intrinsics.areEqual((Object)token, (Object)"[")) {
            int arrayStart = this.skipToNextToken(false);
            TomlArrayValue arrayValue = new TomlArrayValue(this, parent, arrayStart, this.offset, key, keyStart, keyEnd, true);
            this.parseArrayElements(arrayValue);
            arrayValue.setEndOffset(this.offset);
            return arrayValue;
        }
        if (this.validate) {
            this.validateLiteralValue(token, valueStart);
        }
        return new TomlLiteralValue(this, parent, token, valueStart, this.offset, key, keyStart, keyEnd);
    }

    private final void validateLiteralValue(String literal, int valueStart) {
        if (!StringsKt.startsWith$default((CharSequence)literal, (char)'\"', (boolean)false, (int)2, null) && !StringsKt.startsWith$default((CharSequence)literal, (char)'\'', (boolean)false, (int)2, null)) {
            int dotIndex = StringsKt.indexOf$default((CharSequence)literal, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex == -1) {
                return;
            }
            if (dotIndex == 0 || dotIndex == literal.length() - 1 || !Character.isDigit(literal.charAt(dotIndex - 1)) || !Character.isDigit(literal.charAt(dotIndex + 1))) {
                this.warn("The decimal point, if used, must be surrounded by at least one digit on each side", valueStart);
            }
        }
    }

    private final List<String> parseKey(String initial) {
        List fqn = new ArrayList();
        boolean first = true;
        if (!StringsKt.isBlank((CharSequence)initial)) {
            if (Intrinsics.areEqual((Object)initial, (Object)"=")) {
                if (this.validate) {
                    this.warn("Bare key must be non-empty", this.offset);
                }
                this.consumeToLineEnd();
                return null;
            }
            fqn.add(initial);
            first = false;
        }
        block11: while (this.offset < this.length) {
            int before = this.offset;
            String token = DefaultLintTomlParserKt.access$tomlStringSourceToString(DefaultLintTomlParser.getToken$default(this, !first, false, false, 6, null));
            if (((CharSequence)token).length() == 0 && !first) {
                if (this.validate) {
                    this.warn("Key cannot be alone on a line", before);
                }
                return null;
            }
            first = false;
            int n = -1;
            switch (token.hashCode()) {
                case 2976: {
                    if (token.equals("]]")) {
                        n = 1;
                    }
                    break;
                }
                case 61: {
                    if (token.equals("=")) {
                        n = 1;
                    }
                    break;
                }
                case 93: {
                    if (token.equals("]")) {
                        n = 1;
                    }
                    break;
                }
                case 125: {
                    if (token.equals("}")) {
                        n = 1;
                    }
                    break;
                }
                case 46: {
                    if (!token.equals(".")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    continue block11;
                }
                case 1: {
                    this.offset = before;
                    break block11;
                }
                default: {
                    fqn.add(token);
                    continue block11;
                }
            }
        }
        return fqn;
    }

    static /* synthetic */ List parseKey$default(DefaultLintTomlParser defaultLintTomlParser, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return defaultLintTomlParser.parseKey(string);
    }

    private final void consumeToLineEnd() {
        while (!Intrinsics.areEqual((Object)DefaultLintTomlParser.getToken$default(this, true, false, false, 4, null), (Object)"")) {
        }
    }

    private final String getToken(boolean breakAtNewline, boolean breakOnDot, boolean arrayTableAllowed) {
        int start;
        this.skipToNextToken(breakAtNewline);
        if (this.offset == this.length || breakAtNewline && this.source.charAt(this.offset) == '\n') {
            return "";
        }
        int n = this.offset;
        this.offset = n + 1;
        switch (this.source.charAt(n)) {
            case '[': {
                if (arrayTableAllowed && StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"[", (int)this.offset, (boolean)false, (int)4, null)) {
                    ++this.offset;
                    return "[[";
                }
                return "[";
            }
            case ']': {
                if (arrayTableAllowed && StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"]", (int)this.offset, (boolean)false, (int)4, null)) {
                    ++this.offset;
                    return "]]";
                }
                return "]";
            }
            case ',': {
                return ",";
            }
            case '=': {
                return "=";
            }
            case '{': {
                return "{";
            }
            case '}': {
                return "}";
            }
            case '\'': {
                start = this.offset - 1;
                if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"''", (int)this.offset, (boolean)false, (int)4, null)) {
                    int n2;
                    int end = StringsKt.indexOf$default((CharSequence)this.source, (String)"'''", (int)(this.offset + 2), (boolean)false, (int)4, null);
                    if (end == -1) {
                        if (this.validate) {
                            this.validateStringEnd(start, end);
                        }
                        this.offset = this.length;
                        return ((Object)this.source.subSequence(start, this.length)).toString();
                    }
                    this.offset = end + 3;
                    if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"'", (int)this.offset, (boolean)false, (int)4, null)) {
                        n2 = this.offset;
                        this.offset = n2 + 1;
                    }
                    if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"'", (int)this.offset, (boolean)false, (int)4, null)) {
                        n2 = this.offset;
                        this.offset = n2 + 1;
                    }
                    if (this.validate) {
                        this.validateStringEnd(start, this.offset);
                    }
                    return ((Object)this.source.subSequence(start, this.offset)).toString();
                }
                int end = StringsKt.indexOf$default((CharSequence)this.source, (char)'\'', (int)this.offset, (boolean)false, (int)4, null);
                if (end == -1) {
                    if (this.validate) {
                        this.validateStringEnd(start, end);
                    }
                    this.offset = this.length;
                    return ((Object)this.source.subSequence(start, this.length)).toString();
                }
                this.offset = end + 1;
                return ((Object)this.source.subSequence(start, this.offset)).toString();
            }
            case '\"': {
                start = this.offset - 1;
                if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"\"\"", (int)this.offset, (boolean)false, (int)4, null)) {
                    int n3;
                    int end = StringsKt.indexOf$default((CharSequence)this.source, (String)"\"\"\"", (int)(this.offset + 2), (boolean)false, (int)4, null);
                    if (end == -1) {
                        if (this.validate) {
                            this.validateStringEnd(start, end);
                        }
                        this.offset = this.length;
                        return ((Object)this.source.subSequence(start, this.length)).toString();
                    }
                    this.offset = end + 3;
                    if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"\"", (int)this.offset, (boolean)false, (int)4, null)) {
                        n3 = this.offset;
                        this.offset = n3 + 1;
                    }
                    if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"\"", (int)this.offset, (boolean)false, (int)4, null)) {
                        n3 = this.offset;
                        this.offset = n3 + 1;
                    }
                    if (this.validate) {
                        this.validateStringEnd(start, this.offset);
                    }
                    return ((Object)this.source.subSequence(start, this.offset)).toString();
                }
                while (this.offset < this.length) {
                    int n4;
                    char c = this.source.charAt(this.offset);
                    switch (c) {
                        case '\"': {
                            ++this.offset;
                            if (this.validate) {
                                this.validateStringEnd(start, this.offset);
                            }
                            return ((Object)this.source.subSequence(start, this.offset)).toString();
                        }
                        case '\\': {
                            n4 = this.offset;
                            this.offset = n4 + 1;
                        }
                    }
                    n4 = this.offset;
                    this.offset = n4 + 1;
                }
                if (this.validate) {
                    this.validateStringEnd(start, -1);
                }
                return ((Object)this.source.subSequence(start, this.offset)).toString();
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                start = this.offset - 1;
                if (StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"+", (int)start, (boolean)false, (int)4, null) && StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"+nan", (int)start, (boolean)false, (int)4, null) || StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"+inf", (int)start, (boolean)false, (int)4, null) || StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"-", (int)start, (boolean)false, (int)4, null) && StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"-nan", (int)start, (boolean)false, (int)4, null) || StringsKt.startsWith$default((CharSequence)this.source, (CharSequence)"-inf", (int)start, (boolean)false, (int)4, null)) {
                    this.offset = start + 4;
                    return ((Object)this.source.subSequence(start, this.offset)).toString();
                }
                while (this.offset < this.length) {
                    int n5 = this.offset;
                    this.offset = n5 + 1;
                    char c = this.source.charAt(n5);
                    if (DefaultLintTomlParserKt.access$isNumberOrDateLiteralChar(c)) continue;
                    n5 = this.offset;
                    this.offset = n5 + -1;
                    break;
                }
                return ((Object)this.source.subSequence(start, this.offset)).toString();
            }
        }
        start = this.offset - 1;
        if (this.source.charAt(start) == '.' && breakOnDot) {
            return ".";
        }
        while (this.offset < this.length) {
            int n6 = this.offset;
            this.offset = n6 + 1;
            char c = this.source.charAt(n6);
            if (CharsKt.isWhitespace((char)c) || c == ']' || c == '}' || c == '=' || c == ',') {
                n6 = this.offset;
                this.offset = n6 + -1;
                break;
            }
            if (c != '.') continue;
            return ((Object)this.source.subSequence(start, this.offset - 1)).toString();
        }
        return ((Object)this.source.subSequence(start, this.offset)).toString();
    }

    static /* synthetic */ String getToken$default(DefaultLintTomlParser defaultLintTomlParser, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return defaultLintTomlParser.getToken(bl, bl2, bl3);
    }

    private final void validateStringEnd(int start, int end) {
        char next;
        if (end == -1) {
            if (this.validate) {
                this.warn("Unterminated string", start);
            }
        } else if (end < this.length && !CharsKt.isWhitespace((char)(next = this.source.charAt(end))) && next != '#' && next != ',' && next != '}' && next != ']') {
            int lineEnd;
            if (this.validate) {
                this.warn("Unexpected content after string terminator", end);
            }
            this.offset = (lineEnd = StringsKt.indexOf$default((CharSequence)this.source, (char)'\n', (int)start, (boolean)false, (int)4, null)) != -1 ? lineEnd + 1 : this.length;
        }
    }

    private final int skipToNextToken(boolean breakAtNewline) {
        while (this.offset < this.length) {
            int n;
            char c = this.source.charAt(this.offset);
            if (c == '\n' && breakAtNewline) {
                return this.offset;
            }
            if (!CharsKt.isWhitespace((char)c)) {
                if (c != '#') break;
                while (this.offset < this.length && this.source.charAt(this.offset) != '\n') {
                    n = this.offset;
                    this.offset = n + 1;
                }
                if (breakAtNewline || this.offset >= this.length) break;
                continue;
            }
            n = this.offset;
            this.offset = n + 1;
        }
        return this.offset;
    }

    static /* synthetic */ int skipToNextToken$default(DefaultLintTomlParser defaultLintTomlParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return defaultLintTomlParser.skipToNextToken(bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003BS\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0001R\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0001R\u00020\u0002J\b\u0010\u001c\u001a\u00020\tH\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0010R\u0018\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0001R\u00020\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0001R\u00020\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlArrayValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "Lcom/android/tools/lint/client/api/LintTomlArrayValue;", "parent", "startOffset", "", "endOffset", "key", "", "keyStartOffset", "keyEndOffset", "isLiteral", "", "<init>", "(Lcom/android/tools/lint/client/api/DefaultLintTomlParser;Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;IILjava/lang/String;IIZ)V", "()Z", "getArrayElements", "", "Lcom/android/tools/lint/client/api/LintTomlValue;", "add", "", "value", "_elements", "", "elements", "getElements", "()Ljava/util/List;", "toString", "lint-api"})
    private final class TomlArrayValue
    extends TomlValue
    implements LintTomlArrayValue {
        private final boolean isLiteral;
        @NotNull
        private final List<TomlValue> _elements;
        @NotNull
        private final List<TomlValue> elements;
        final /* synthetic */ DefaultLintTomlParser this$0;

        public TomlArrayValue(@Nullable DefaultLintTomlParser this$0, TomlValue parent, int startOffset, @Nullable int endOffset, String key, int keyStartOffset, int keyEndOffset, boolean isLiteral) {
            this.this$0 = this$0;
            super(this$0, parent, startOffset, endOffset, key, keyStartOffset, keyEndOffset);
            this.isLiteral = isLiteral;
            this._elements = new ArrayList();
            this.elements = this._elements;
        }

        public /* synthetic */ TomlArrayValue(DefaultLintTomlParser defaultLintTomlParser, TomlValue tomlValue, int n, int n2, String string, int n3, int n4, boolean bl, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 2) != 0) {
                n = -1;
            }
            if ((n5 & 4) != 0) {
                TomlValue tomlValue2 = tomlValue;
                int n6 = n2 = tomlValue2 != null ? tomlValue2.getEndOffset() : -1;
            }
            if ((n5 & 8) != 0) {
                string = null;
            }
            if ((n5 & 0x10) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x20) != 0) {
                n4 = -1;
            }
            if ((n5 & 0x40) != 0) {
                bl = true;
            }
            this(defaultLintTomlParser, tomlValue, n, n2, string, n3, n4, bl);
        }

        public final boolean isLiteral() {
            return this.isLiteral;
        }

        @Override
        @NotNull
        public List<LintTomlValue> getArrayElements() {
            return this._elements;
        }

        public final void add(@NotNull TomlValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean bl = Intrinsics.areEqual((Object)value.getParent(), (Object)this);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this._elements.add(value);
            this.updateOffsets(value);
        }

        @NotNull
        public final List<TomlValue> getElements() {
            return this.elements;
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.elements.size() + " elements)";
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0007\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016R\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlDocument;", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "<init>", "(Lcom/android/tools/lint/client/api/DefaultLintTomlParser;)V", "root", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlMapValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "getRoot", "()Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlMapValue;", "getFile", "Ljava/io/File;", "getValue", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "key", "", "Lcom/android/tools/lint/client/api/LintTomlMapValue;", "getSource", "", "", "lint-api"})
    private final class TomlDocument
    implements LintTomlDocument {
        @NotNull
        private final TomlMapValue root;

        public TomlDocument() {
            this.root = new TomlMapValue(DefaultLintTomlParser.this, null, 0, DefaultLintTomlParser.this.source.length(), null, 0, 0, 56, null);
        }

        @Override
        @NotNull
        public final TomlMapValue getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public File getFile() {
            return DefaultLintTomlParser.this.file;
        }

        @Override
        @Nullable
        public TomlValue getValue(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.root.find(key);
        }

        @Override
        @NotNull
        public LintTomlMapValue getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public CharSequence getSource() {
            return DefaultLintTomlParser.this.source;
        }

        @Override
        @Nullable
        public TomlValue getValue(@NotNull List<String> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.root.find(key);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003BQ\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0001R\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0006H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlLiteralValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "Lcom/android/tools/lint/client/api/LintTomlLiteralValue;", "parent", "text", "", "startOffset", "", "endOffset", "key", "keyStartOffset", "keyEndOffset", "<init>", "(Lcom/android/tools/lint/client/api/DefaultLintTomlParser;Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;Ljava/lang/String;IILjava/lang/String;II)V", "getText", "getActualValue", "", "dropDigitSeparators", "parseAsDate", "toString", "lint-api"})
    private final class TomlLiteralValue
    extends TomlValue
    implements LintTomlLiteralValue {
        @NotNull
        private final String text;
        final /* synthetic */ DefaultLintTomlParser this$0;

        public TomlLiteralValue(@Nullable DefaultLintTomlParser this$0, @NotNull TomlValue parent, String text, int startOffset, @Nullable int endOffset, String key, int keyStartOffset, int keyEndOffset) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.this$0 = this$0;
            super(this$0, parent, startOffset, endOffset, key, keyStartOffset, keyEndOffset);
            this.text = text;
        }

        public /* synthetic */ TomlLiteralValue(DefaultLintTomlParser defaultLintTomlParser, TomlValue tomlValue, String string, int n, int n2, String string2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 4) != 0) {
                n = -1;
            }
            if ((n5 & 8) != 0) {
                TomlValue tomlValue2 = tomlValue;
                int n6 = n2 = tomlValue2 != null ? tomlValue2.getEndOffset() : -1;
            }
            if ((n5 & 0x10) != 0) {
                string2 = null;
            }
            if ((n5 & 0x20) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x40) != 0) {
                n4 = -1;
            }
            this(defaultLintTomlParser, tomlValue, string, n, n2, string2, n3, n4);
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public Object getActualValue() {
            block45: {
                switch (this.text) {
                    case "": {
                        return this.text;
                    }
                    case "true": {
                        return true;
                    }
                    case "false": {
                        return false;
                    }
                    case "inf": 
                    case "+inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case "+nan": 
                    case "-nan": 
                    case "nan": {
                        return Double.NaN;
                    }
                }
                char first = this.text.charAt(0);
                switch (first) {
                    case '\"': 
                    case '\'': {
                        return DefaultLintTomlParserKt.access$tomlStringSourceToString(this.text);
                    }
                }
                if (first == '0') {
                    try {
                        if (StringsKt.startsWith$default((String)this.text, (String)"0x", (boolean)false, (int)2, null)) {
                            String string = this.text.substring(2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            return Long.parseLong(this.dropDigitSeparators(string), 16);
                        }
                        if (StringsKt.startsWith$default((String)this.text, (String)"0o", (boolean)false, (int)2, null)) {
                            String string = this.text.substring(2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            return Long.parseLong(this.dropDigitSeparators(string), 8);
                        }
                        if (StringsKt.startsWith$default((String)this.text, (String)"0b", (boolean)false, (int)2, null)) {
                            String string = this.text.substring(2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            return Long.parseLong(this.dropDigitSeparators(string), 2);
                        }
                    }
                    catch (NumberFormatException e) {
                        return this.text;
                    }
                }
                if ((StringsKt.contains$default((CharSequence)this.text, (CharSequence)":", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)this.text, (char)'-', (int)1, (boolean)false, (int)4, null) != -1) && !StringsKt.contains((CharSequence)this.text, (char)'e', (boolean)true)) {
                    Object object = this.parseAsDate();
                    if (object == null) {
                        return this.text;
                    }
                    return object;
                }
                try {
                    Number number;
                    if (!Character.isDigit(first) && first != '+' && first != '-') break block45;
                    String digits = this.dropDigitSeparators(this.text);
                    if (StringsKt.contains((CharSequence)this.text, (char)'e', (boolean)true)) {
                        return Double.parseDouble(digits);
                    }
                    if (StringsKt.contains$default((CharSequence)this.text, (char)'.', (boolean)false, (int)2, null)) {
                        return Double.parseDouble(digits);
                    }
                    try {
                        number = Integer.parseInt(digits);
                    }
                    catch (NumberFormatException e) {
                        number = Long.parseLong(digits);
                    }
                    return number;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.text;
        }

        private final String dropDigitSeparators(String $this$dropDigitSeparators) {
            if (StringsKt.contains$default((CharSequence)$this$dropDigitSeparators, (char)'_', (boolean)false, (int)2, null)) {
                StringBuilder sb = new StringBuilder();
                int n = ((CharSequence)$this$dropDigitSeparators).length();
                for (int i = 0; i < n; ++i) {
                    char c = $this$dropDigitSeparators.charAt(i);
                    if (c == '_' && i > 0 && Character.isLetterOrDigit($this$dropDigitSeparators.charAt(i - 1)) && i < $this$dropDigitSeparators.length() - 1 && Character.isLetterOrDigit($this$dropDigitSeparators.charAt(i + 1))) continue;
                    sb.append(c);
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            return $this$dropDigitSeparators;
        }

        private final Object parseAsDate() {
            Object[] objectArray = new KFunction[]{parseAsDate.1.INSTANCE, parseAsDate.2.INSTANCE, parseAsDate.3.INSTANCE, parseAsDate.4.INSTANCE, parseAsDate.5.INSTANCE, parseAsDate.6.INSTANCE};
            for (KFunction method : CollectionsKt.listOf((Object[])objectArray)) {
                try {
                    return ((Function1)method).invoke((Object)this.text);
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "(key=" + this.getKey() + ", value=" + this.getActualValue() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003BI\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0001R\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u0011H\u0016J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u001b\u001a\u00060\u0001R\u00020\u0002J \u0010\u001c\u001a\u00060\u0000R\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020 J8\u0010\u001c\u001a\u00060\u0000R\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010!\u001a\u00020\u00062\f\u0010\u0004\u001a\b\u0018\u00010\u0001R\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010\u001c\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001d\u001a\u00020\tJ\u001a\u0010\"\u001a\b\u0018\u00010\u0001R\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ$\u0010\"\u001a\b\u0018\u00010\u0001R\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0014\u0010\"\u001a\b\u0018\u00010\u0001R\u00020\u00022\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010#\u001a\u00020\tH\u0016R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\u0001R\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\u0001R\u00020\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlMapValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "Lcom/android/tools/lint/client/api/LintTomlMapValue;", "parent", "startOffset", "", "endOffset", "key", "", "keyStartOffset", "keyEndOffset", "<init>", "(Lcom/android/tools/lint/client/api/DefaultLintTomlParser;Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;IILjava/lang/String;II)V", "_map", "", "map", "", "getMap", "()Ljava/util/Map;", "getMappedValues", "Lcom/android/tools/lint/client/api/LintTomlValue;", "get", "first", "last", "put", "", "value", "ensure", "path", "", "validate", "", "index", "find", "toString", "lint-api"})
    private final class TomlMapValue
    extends TomlValue
    implements LintTomlMapValue {
        @NotNull
        private final Map<String, TomlValue> _map;
        @NotNull
        private final Map<String, TomlValue> map;
        final /* synthetic */ DefaultLintTomlParser this$0;

        public TomlMapValue(@Nullable DefaultLintTomlParser this$0, TomlValue parent, int startOffset, @Nullable int endOffset, String key, int keyStartOffset, int keyEndOffset) {
            this.this$0 = this$0;
            super(this$0, parent, startOffset, endOffset, key, keyStartOffset, keyEndOffset);
            this._map = new LinkedHashMap();
            this.map = this._map;
        }

        public /* synthetic */ TomlMapValue(DefaultLintTomlParser defaultLintTomlParser, TomlValue tomlValue, int n, int n2, String string, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 2) != 0) {
                n = -1;
            }
            if ((n5 & 4) != 0) {
                TomlValue tomlValue2 = tomlValue;
                int n6 = n2 = tomlValue2 != null ? tomlValue2.getEndOffset() : -1;
            }
            if ((n5 & 8) != 0) {
                string = null;
            }
            if ((n5 & 0x10) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x20) != 0) {
                n4 = -1;
            }
            this(defaultLintTomlParser, tomlValue, n, n2, string, n3, n4);
        }

        @NotNull
        public final Map<String, TomlValue> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public Map<String, LintTomlValue> getMappedValues() {
            return this.map;
        }

        @Override
        @Nullable
        public LintTomlValue get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!StringsKt.contains$default((CharSequence)key, (char)'.', (boolean)false, (int)2, null)) {
                return this.map.get(key);
            }
            return this.find(key);
        }

        @Override
        @Nullable
        public LintTomlValue first() {
            if (this.map.isEmpty()) {
                return null;
            }
            return this.map.get(CollectionsKt.first((Iterable)this.map.keySet()));
        }

        @Override
        @Nullable
        public LintTomlValue last() {
            if (this.map.isEmpty()) {
                return null;
            }
            return this.map.get(CollectionsKt.last((Iterable)this.map.keySet()));
        }

        public final void put(@NotNull String key, @NotNull TomlValue value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean bl = Intrinsics.areEqual((Object)value.getParent(), (Object)this);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this._map.put(key, value);
            this.updateOffsets(value);
        }

        @NotNull
        public final TomlMapValue ensure(@NotNull List<String> path2, boolean validate) {
            Intrinsics.checkNotNullParameter(path2, (String)"path");
            return this.ensure(path2, 0, this, validate);
        }

        private final TomlMapValue ensure(List<String> path2, int index, TomlValue parent, boolean validate) {
            if (path2.isEmpty()) {
                return this;
            }
            String key = path2.get(index);
            TomlValue match = this._map.get(key);
            if (index == path2.size() - 1 && match instanceof TomlMapValue) {
                return (TomlMapValue)match;
            }
            if (validate && match != null) {
                TomlValue tomlValue = parent;
                this.this$0.warn("Table `" + key + "` already specified as a value", tomlValue != null ? tomlValue.getEndOffset() : 0);
            }
            TomlMapValue map = new TomlMapValue(this.this$0, parent, 0, 0, key, 0, 0, 54, null);
            this._map.put(key, map);
            return index == path2.size() - 1 ? map : map.ensure(path2, index + 1, this, validate);
        }

        @NotNull
        public final TomlMapValue ensure(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (((CharSequence)path2).length() == 0) {
                return this;
            }
            char[] cArray = new char[]{'.'};
            return this.ensure(StringsKt.split$default((CharSequence)path2, (char[])cArray, (boolean)false, (int)0, (int)6, null), false);
        }

        @Nullable
        public final TomlValue find(@NotNull List<String> path2) {
            Intrinsics.checkNotNullParameter(path2, (String)"path");
            return this.find(path2, 0);
        }

        private final TomlValue find(List<String> path2, int index) {
            if (path2.isEmpty()) {
                return this;
            }
            String key = path2.get(index);
            TomlValue match = this._map.get(key);
            return match == null || index == path2.size() - 1 ? match : (match instanceof TomlMapValue ? ((TomlMapValue)match).find(path2, index + 1) : null);
        }

        @Nullable
        public final TomlValue find(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (((CharSequence)path2).length() == 0) {
                return this;
            }
            if (StringsKt.contains$default((CharSequence)path2, (char)'\"', (boolean)false, (int)2, null)) {
                List list = new ArrayList();
                int i = 0;
                int start = 0;
                block8: while (i < path2.length()) {
                    char c = path2.charAt(i++);
                    switch (c) {
                        case '.': {
                            if (i > start) {
                                String string = path2.substring(start, i - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                list.add(string);
                            }
                            start = i;
                            continue block8;
                        }
                        case '\"': {
                            StringBuilder sb = new StringBuilder();
                            block9: while (i < path2.length()) {
                                char d = path2.charAt(i++);
                                switch (d) {
                                    case '\\': {
                                        if (i >= path2.length()) continue block9;
                                        sb.append(path2.charAt(i++));
                                        continue block9;
                                    }
                                    case '\"': {
                                        if (((CharSequence)sb).length() > 0) {
                                            String string = sb.toString();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                            list.add(string);
                                        }
                                        start = i;
                                        continue block8;
                                    }
                                }
                                sb.append(d);
                            }
                            continue block8;
                        }
                    }
                }
                if (i > start) {
                    String string = path2.substring(start, i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    list.add(string);
                }
                return this.find(list);
            }
            char[] cArray = new char[]{'.'};
            return this.find(StringsKt.split$default((CharSequence)path2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }

        @NotNull
        public String toString() {
            return this.getParent() == null ? "root" : this.getClass().getSimpleName() + "(" + this.map.keySet() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0092\u0004\u0018\u00002\u00020\u0001BI\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0016J\u0014\u0010#\u001a\u00020\u00172\n\u0010$\u001a\u00060\u0000R\u00020\u0003H\u0004J\b\u0010%\u001a\u00020!H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0001H\u0016R\u0017\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "Lcom/android/tools/lint/client/api/LintTomlValue;", "parent", "Lcom/android/tools/lint/client/api/DefaultLintTomlParser;", "startOffset", "", "endOffset", "key", "", "keyStartOffset", "keyEndOffset", "<init>", "(Lcom/android/tools/lint/client/api/DefaultLintTomlParser;Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;IILjava/lang/String;II)V", "getParent", "()Lcom/android/tools/lint/client/api/DefaultLintTomlParser$TomlValue;", "getDocument", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "getKey", "getActualValue", "", "getText", "getStartOffset", "setStartOffset", "", "offset", "setEndOffset", "getEndOffset", "getKeyStartOffset", "getKeyEndOffset", "getFullKey", "setValueRange", "setKeyRange", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "getKeyLocation", "updateOffsets", "newChild", "getFullLocation", "next", "lint-api"})
    private class TomlValue
    implements LintTomlValue {
        @Nullable
        private final TomlValue parent;
        private int startOffset;
        private int endOffset;
        @Nullable
        private String key;
        private int keyStartOffset;
        private int keyEndOffset;
        final /* synthetic */ DefaultLintTomlParser this$0;

        public TomlValue(@Nullable DefaultLintTomlParser this$0, TomlValue parent, int startOffset, @Nullable int endOffset, String key, int keyStartOffset, int keyEndOffset) {
            this.this$0 = this$0;
            this.parent = parent;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.key = key;
            this.keyStartOffset = keyStartOffset;
            this.keyEndOffset = keyEndOffset;
        }

        public /* synthetic */ TomlValue(DefaultLintTomlParser defaultLintTomlParser, TomlValue tomlValue, int n, int n2, String string, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 2) != 0) {
                n = -1;
            }
            if ((n5 & 4) != 0) {
                TomlValue tomlValue2 = tomlValue;
                int n6 = n2 = tomlValue2 != null ? tomlValue2.getEndOffset() : -1;
            }
            if ((n5 & 8) != 0) {
                string = null;
            }
            if ((n5 & 0x10) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x20) != 0) {
                n4 = -1;
            }
            this(defaultLintTomlParser, tomlValue, n, n2, string, n3, n4);
        }

        @Nullable
        public final TomlValue getParent() {
            return this.parent;
        }

        @Override
        @NotNull
        public LintTomlDocument getDocument() {
            return this.this$0.document;
        }

        @Override
        @Nullable
        public String getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public Object getActualValue() {
            return null;
        }

        @Override
        @NotNull
        public String getText() {
            return ((Object)this.this$0.source.subSequence(this.startOffset, this.endOffset)).toString();
        }

        @Override
        public int getStartOffset() {
            return this.startOffset;
        }

        public final void setStartOffset(int offset) {
            this.startOffset = offset;
        }

        public final void setEndOffset(int offset) {
            this.endOffset = offset;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public int getKeyStartOffset() {
            return this.keyStartOffset;
        }

        @Override
        public int getKeyEndOffset() {
            return this.keyEndOffset;
        }

        @Override
        @NotNull
        public String getFullKey() {
            int index;
            if (this.parent == null) {
                String string = this.key;
                if (string == null) {
                    string = "";
                }
                return string;
            }
            if (this.key == null) {
                int index2;
                String prefix = this.parent.getFullKey();
                if (this.parent instanceof TomlArrayValue && (index2 = ((TomlArrayValue)this.parent).getElements().indexOf(this)) != -1) {
                    return prefix + "[" + index2 + "]";
                }
                return prefix;
            }
            Object prefix = this.parent.getFullKey();
            if (this.parent instanceof TomlArrayValue && (index = ((TomlArrayValue)this.parent).getElements().indexOf(this)) != -1) {
                prefix = (String)prefix + "[" + index + "]";
            }
            if (this.key == null) {
                return prefix;
            }
            if (((CharSequence)prefix).length() > 0) {
                return (String)prefix + "." + this.key;
            }
            String string = this.key;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public final void setValueRange(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public final void setKeyRange(int startOffset, int endOffset) {
            this.keyStartOffset = startOffset;
            this.keyEndOffset = endOffset;
        }

        @Override
        @NotNull
        public Location getLocation() {
            return Location.Companion.create(this.this$0.file, this.this$0.source, this.startOffset, this.endOffset);
        }

        @Override
        @Nullable
        public Location getKeyLocation() {
            return this.key != null ? Location.Companion.create(this.this$0.file, this.this$0.source, this.keyStartOffset, this.keyEndOffset) : null;
        }

        protected final void updateOffsets(@NotNull TomlValue newChild) {
            Intrinsics.checkNotNullParameter((Object)newChild, (String)"newChild");
            if (this.startOffset == -1) {
                this.startOffset = newChild.startOffset;
                this.endOffset = newChild.endOffset;
            } else {
                if (newChild.startOffset < this.startOffset) {
                    this.startOffset = newChild.startOffset;
                }
                if (newChild.endOffset < this.endOffset) {
                    this.endOffset = newChild.endOffset;
                }
            }
        }

        @Override
        @NotNull
        public Location getFullLocation() {
            return Location.Companion.create(this.this$0.file, this.this$0.source, this.key != null && this.keyStartOffset > -1 && this.keyStartOffset < this.startOffset ? this.keyStartOffset : this.startOffset, this.endOffset);
        }

        @Override
        @Nullable
        public LintTomlValue next() {
            block3: {
                block2: {
                    if (!(this.parent instanceof TomlMapValue)) break block2;
                    Iterator<Map.Entry<String, TomlValue>> iterator = ((TomlMapValue)this.parent).getMap().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, TomlValue> next = iterator.next();
                        if (!Intrinsics.areEqual((Object)next.getValue(), (Object)this)) continue;
                        return iterator.hasNext() ? (LintTomlValue)iterator.next().getValue() : null;
                    }
                    break block3;
                }
                if (!(this.parent instanceof TomlArrayValue)) break block3;
                Iterator<TomlValue> iterator = ((TomlArrayValue)this.parent).getElements().iterator();
                while (iterator.hasNext()) {
                    TomlValue next = iterator.next();
                    if (!Intrinsics.areEqual((Object)next, (Object)this)) continue;
                    return iterator.hasNext() ? (LintTomlValue)iterator.next() : null;
                }
            }
            return null;
        }
    }
}

