/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintJarApiMigration;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.LintJarVerifierKt;
import com.android.tools.lint.helpers.ZipStreamsKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001*\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\tJ\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0006\u0010\u001e\u001a\u00020\u000fJ\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\tJ\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000fH\u0002J\u0018\u0010<\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010>\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020.H\u0002J\u0010\u0010@\u001a\u00020\t2\u0006\u00109\u001a\u00020\u000fH\u0002J&\u0010A\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010B2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u000207H\u0002J\u0014\u0010E\u001a\u0006\u0012\u0002\b\u00030B2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010F\u001a\u00020G2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000fH\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002JK\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020.2\u0006\u0010:\u001a\u00020\u000f2\b\u0010M\u001a\u0004\u0018\u00010\u000f2\b\u0010N\u001a\u0004\u0018\u00010\u000f2\u0010\u0010O\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010PH\u0016\u00a2\u0006\u0002\u0010QJE\u0010R\u001a\u00020S2\u0006\u0010L\u001a\u00020.2\b\u0010:\u001a\u0004\u0018\u00010\u000f2\b\u0010;\u001a\u0004\u0018\u00010\u000f2\b\u0010M\u001a\u0004\u0018\u00010\u000f2\u0010\u0010T\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010PH\u0016\u00a2\u0006\u0002\u0010UR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R\u001e\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/android/tools/lint/client/api/LintJarVerifier;", "Lorg/objectweb/asm/ClassVisitor;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "bytes", "", "skip", "", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;[BZ)V", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Z)V", "isRelevantApi", "internal", "", "isCompatible", "isInaccessible", "getVerificationThrowable", "", "verify", "", "lintJarBytes", "classes", "", "describeFirstIncompatibleReference", "includeLocation", "toString", "referenceToDisplay", "reference", "getReferenceClassFile", "getReferenceLocation", "needsApiMigration", "apiMigrationNeeded", "verifyProblem", "incompatibleReference", "bundledClasses", "", "incompatibleReferenceFile", "incompatibleReferencer", "inaccessible", "methodVisitor", "com/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1", "Lcom/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1;", "checkClass", "value", "", "apiCount", "getApiCount", "()I", "currentClassFile", "currentClass", "currentMethod", "currentSuperClass", "classLoader", "Ljava/lang/ClassLoader;", "checkMethod", "owner", "name", "descriptor", "checkField", "recordViolation", "checkModifiers", "modifiers", "isCalledFromSubClass", "isSubClass", "Ljava/lang/Class;", "target", "loader", "getClass", "getMethod", "Ljava/lang/reflect/Executable;", "getField", "Ljava/lang/reflect/Field;", "visit", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintJarVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintJarVerifier.kt\ncom/android/tools/lint/client/api/LintJarVerifier\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,513:1\n216#2,2:514\n11158#3:516\n11493#3,3:517\n13402#3,2:525\n37#4:520\n36#4,3:521\n1#5:524\n*S KotlinDebug\n*F\n+ 1 LintJarVerifier.kt\ncom/android/tools/lint/client/api/LintJarVerifier\n*L\n121#1:514,2\n423#1:516\n423#1:517,3\n464#1:525,2\n423#1:520\n423#1:521,3\n*E\n"})
public final class LintJarVerifier
extends ClassVisitor {
    @NotNull
    private final LintClient client;
    @NotNull
    private final File jarFile;
    private final boolean skip;
    private boolean apiMigrationNeeded;
    @Nullable
    private Throwable verifyProblem;
    @Nullable
    private String incompatibleReference;
    @NotNull
    private final Set<String> bundledClasses;
    @Nullable
    private String incompatibleReferenceFile;
    @Nullable
    private String incompatibleReferencer;
    private boolean inaccessible;
    @NotNull
    private final methodVisitor.1 methodVisitor;
    private int apiCount;
    @Nullable
    private String currentClassFile;
    @Nullable
    private String currentClass;
    @Nullable
    private String currentMethod;
    @Nullable
    private String currentSuperClass;
    @Nullable
    private ClassLoader classLoader;

    public LintJarVerifier(@NotNull LintClient client, @NotNull File jarFile, @NotNull byte[] bytes, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(589824);
        this.client = client;
        this.jarFile = jarFile;
        this.skip = skip;
        this.bundledClasses = new LinkedHashSet();
        this.methodVisitor = new MethodVisitor(this){
            final /* synthetic */ LintJarVerifier this$0;
            {
                this.this$0 = $receiver;
                super(589824);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                LintJarVerifier.access$checkMethod(this.this$0, owner, name, descriptor);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                LintJarVerifier.access$checkField(this.this$0, owner, name);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        };
        try {
            this.verify(bytes);
        }
        catch (Throwable throwable) {
            this.verifyProblem = throwable;
        }
    }

    public /* synthetic */ LintJarVerifier(LintClient lintClient, File file, byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(lintClient, file, byArray, bl);
    }

    public LintJarVerifier(@NotNull LintClient client, @NotNull File jarFile, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        this(client, jarFile, FilesKt.readBytes((File)jarFile), skip);
    }

    public /* synthetic */ LintJarVerifier(LintClient lintClient, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(lintClient, file, bl);
    }

    private final boolean isRelevantApi(String internal) {
        boolean relevant = StringsKt.startsWith$default((String)internal, (String)"com/android/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/uast", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/kotlin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"com/intellij", (boolean)false, (int)2, null);
        return relevant && !this.bundledClasses.contains(internal);
    }

    public final boolean isCompatible() {
        return this.incompatibleReference == null;
    }

    public final boolean isInaccessible() {
        return this.inaccessible;
    }

    @Nullable
    public final Throwable getVerificationThrowable() {
        return this.verifyProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void verify(byte[] lintJarBytes) {
        if (this.skip) {
            return;
        }
        Map classes = new LinkedHashMap();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(lintJarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jar = (JarInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = jar.getNextEntry();
            while (entry != null) {
                boolean directory = entry.isDirectory();
                String name = entry.getName();
                if (!directory) {
                    Intrinsics.checkNotNull((Object)name);
                    if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) {
                        classes.put(name, ZipStreamsKt.readAllBytes(jar, entry));
                    }
                }
                entry = jar.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.verify(classes);
    }

    private final void verify(Map<String, byte[]> classes) {
        block2: {
            ClassLoader classLoader;
            Map<String, byte[]> $this$forEach$iv = classes;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, byte[]>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, byte[]> element$iv;
                Map.Entry<String, byte[]> entry = element$iv = iterator.next();
                boolean bl = false;
                String name = entry.getKey();
                this.bundledClasses.add(StringsKt.removeSuffix((String)name, (CharSequence)".class"));
            }
            for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
                String name = entry.getKey();
                byte[] bytes = entry.getValue();
                this.currentClassFile = name;
                ClassReader reader = new ClassReader(bytes);
                reader.accept((ClassVisitor)this, 6);
                if (this.incompatibleReference == null) continue;
            }
            URLClassLoader uRLClassLoader = (classLoader = this.classLoader) instanceof URLClassLoader ? (URLClassLoader)classLoader : null;
            if (uRLClassLoader == null) break block2;
            uRLClassLoader.close();
        }
    }

    @NotNull
    public final String describeFirstIncompatibleReference(boolean includeLocation) {
        String string = this.incompatibleReference;
        if (string == null) {
            return "Compatible";
        }
        String reference = string;
        String description = this.referenceToDisplay(reference);
        if (includeLocation) {
            return description + ", referenced from " + this.referenceToDisplay(this.getReferenceLocation());
        }
        return description;
    }

    public static /* synthetic */ String describeFirstIncompatibleReference$default(LintJarVerifier lintJarVerifier, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return lintJarVerifier.describeFirstIncompatibleReference(bl);
    }

    @NotNull
    public String toString() {
        String string = this.incompatibleReference;
        if (string == null) {
            return "Compatible";
        }
        String reference = string;
        StringBuilder sb = new StringBuilder();
        if (this.incompatibleReferencer != null) {
            String string2 = this.incompatibleReferencer;
            Intrinsics.checkNotNull((Object)string2);
            sb.append("In " + this.referenceToDisplay(string2) + ": ");
        }
        sb.append(this.referenceToDisplay(reference));
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private final String referenceToDisplay(String reference) {
        StringBuilder stringBuilder;
        int index = StringsKt.indexOf$default((CharSequence)reference, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string = Type.getObjectType((String)reference).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            return StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
        }
        String string = reference.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = Type.getObjectType((String)string).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
        String className = StringsKt.replace$default((String)string2, (char)'$', (char)'.', (boolean)false, (int)4, null);
        int paren = StringsKt.indexOf$default((CharSequence)reference, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (paren == -1) {
            String string3 = reference.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return className + "#" + string3;
        }
        String string4 = reference.substring(paren);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String descriptor = string4;
        CharSequence name = reference.subSequence(index + 1, paren);
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append("#");
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            String string5 = className.substring(StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            stringBuilder = sb.append(string5);
        } else {
            stringBuilder = sb.append(name);
        }
        Object[] arguments = Type.getArgumentTypes((String)descriptor);
        sb.append('(');
        Intrinsics.checkNotNull((Object)arguments);
        sb.append(ArraysKt.joinToString$default((Object[])arguments, (CharSequence)",", null, null, (int)0, null, (Function1)referenceToDisplay.1.INSTANCE, (int)30, null));
        sb.append(')');
        if (!Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            String returnType = Type.getReturnType((String)descriptor).getClassName();
            sb.append(": ");
            sb.append(returnType);
        }
        String string6 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        return string6;
    }

    @NotNull
    public final String getReferenceClassFile() {
        String string = this.incompatibleReferenceFile;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getReferenceLocation() {
        String string = this.incompatibleReferencer;
        if (string == null) {
            string = this.getReferenceClassFile();
        }
        return string;
    }

    public final boolean needsApiMigration() {
        return this.apiMigrationNeeded;
    }

    private final void checkClass(String internal) {
        if (this.isRelevantApi(internal)) {
            try {
                this.getClass(internal);
            }
            catch (Throwable e) {
                this.recordViolation(internal);
            }
        }
    }

    public final int getApiCount() {
        return this.apiCount;
    }

    private final void checkMethod(String owner, String name, String descriptor) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Executable method = this.getMethod(owner, name, descriptor);
                this.checkModifiers(owner, method.getModifiers());
            }
            catch (Throwable e) {
                this.recordViolation(owner + "#" + name + descriptor);
            }
        }
    }

    private final void checkField(String owner, String name) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Field field = this.getField(owner, name);
                this.checkModifiers(owner, field.getModifiers());
            }
            catch (Throwable e) {
                this.recordViolation(owner + "#" + name);
            }
        }
    }

    private final void recordViolation(String reference) {
        if (LintJarApiMigration.Companion.isRelevantType(reference)) {
            this.apiMigrationNeeded = true;
        }
        if (this.incompatibleReference != null) {
            return;
        }
        this.incompatibleReference = reference;
        this.incompatibleReferenceFile = this.currentClassFile;
        String currentClassFile = this.currentClassFile;
        String currentClass = this.currentClass;
        this.incompatibleReferencer = this.currentMethod == null || Intrinsics.areEqual((Object)this.currentMethod, (Object)"<init>") || Intrinsics.areEqual((Object)this.currentMethod, (Object)"<clinit>") ? currentClass : (currentClassFile != null && currentClass != null && StringsKt.contains$default((CharSequence)currentClassFile, (CharSequence)currentClass, (boolean)false, (int)2, null) ? currentClass + "." + this.currentMethod : currentClassFile + ":" + currentClass + "." + this.currentMethod);
    }

    private final void checkModifiers(String owner, int modifiers) {
        if ((modifiers & 1) != 0 || (modifiers & 4) != 0 && this.isCalledFromSubClass(owner)) {
            return;
        }
        this.inaccessible = true;
        throw new IllegalAccessException(owner);
    }

    private final boolean isCalledFromSubClass(String owner) {
        if (Intrinsics.areEqual((Object)this.currentSuperClass, (Object)owner)) {
            return true;
        }
        try {
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                ClassLoader classLoader2;
                List list = CollectionsKt.listOf((Object)this.jarFile);
                ClassLoader classLoader3 = ((Object)((Object)this)).getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader3, (String)"getClassLoader(...)");
                ClassLoader it = classLoader2 = this.client.createUrlClassLoader(list, classLoader3);
                boolean bl = false;
                this.classLoader = it;
                classLoader = classLoader2;
            }
            ClassLoader loader = classLoader;
            String string = this.currentClass;
            if (string == null) {
                return false;
            }
            String currentClass = string;
            Class<?> cls = Class.forName(StringsKt.replace$default((String)currentClass, (char)'/', (char)'.', (boolean)false, (int)4, null), false, loader);
            return this.isSubClass(cls, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), loader);
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private final boolean isSubClass(Class<?> currentClass, String target, ClassLoader loader) {
        if (currentClass == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)currentClass.getName(), (Object)target)) {
            return true;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (this.isSubClass(superClass, target, loader)) {
            return true;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])currentClass.getInterfaces());
        while (iterator.hasNext()) {
            Class itf = (Class)iterator.next();
            if (!this.isSubClass(itf, target, loader)) continue;
            return true;
        }
        return false;
    }

    private final Class<?> getClass(String internal) {
        int n = this.apiCount;
        this.apiCount = n + 1;
        String className = Type.getObjectType((String)internal).getClassName();
        Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final Executable getMethod(String owner, String name, String descriptor) {
        Executable executable;
        Executable executable2;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Class<?> clz = this.getClass(owner);
        Type[] typeArray = Type.getArgumentTypes((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getArgumentTypes(...)");
        Object $this$map$iv = typeArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)type);
            collection.add(LintJarVerifierKt.toTypeClass((Type)type));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Class[] argumentTypes = thisCollection$iv.toArray(new Class[0]);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            Constructor<?> constructor;
            try {
                constructor = clz.getDeclaredConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                constructor = clz.getConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            executable2 = constructor;
            Intrinsics.checkNotNull(executable2);
            executable = executable2;
        } else {
            Method method;
            try {
                method = clz.getDeclaredMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                method = clz.getMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            executable2 = method;
            Intrinsics.checkNotNull(executable2);
            executable = executable2;
        }
        return executable;
    }

    private final Field getField(String owner, String name) {
        Field field;
        Class<?> clz = this.getClass(owner);
        try {
            field = clz.getDeclaredField(name);
        }
        catch (Throwable e) {
            field = clz.getField(name);
        }
        return field;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        String[] it;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.currentClass = name;
        this.currentSuperClass = superName;
        if (superName != null) {
            it = superName;
            boolean bl = false;
            this.checkClass((String)it);
        }
        if (interfaces != null) {
            it = interfaces;
            boolean bl = false;
            String[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String internal = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                this.checkClass(internal);
            }
        }
        super.visit(version, access, name, signature, (String)superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        this.currentMethod = name;
        return this.methodVisitor;
    }

    public static final /* synthetic */ void access$checkMethod(LintJarVerifier $this, String owner, String name, String descriptor) {
        $this.checkMethod(owner, name, descriptor);
    }

    public static final /* synthetic */ void access$checkField(LintJarVerifier $this, String owner, String name) {
        $this.checkField(owner, name);
    }
}

