/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.EnumSet;

public class MergeMarkerDetector
extends Detector
implements Detector.OtherFileScanner {
    public static final Issue ISSUE = Issue.create((String)"MergeMarker", (String)"Code contains merge marker", (String)"Many version control systems leave unmerged files with markers such as <<< in the source code. This check looks for these markers, which are sometimes accidentally left in, particularly in resource files where they don't break compilation.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)new Implementation(MergeMarkerDetector.class, Scope.OTHER_SCOPE));

    public EnumSet<Scope> getApplicableFiles() {
        return Scope.OTHER_SCOPE;
    }

    public void run(Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (LintUtils.isBitmapFile((File)context.file)) {
            return;
        }
        CharSequence source = context.getContents();
        if (source == null) {
            return;
        }
        int length = source.length();
        int offset = 0;
        while ((offset = CharSequences.indexOf((CharSequence)source, (char)'\n', (int)offset)) != -1 && offset != length - 1) {
            char peek;
            if ((peek = source.charAt(++offset)) != '<' && peek != '=' && peek != '>' || !CharSequences.startsWith((CharSequence)source, (CharSequence)"<<<<<<< ", (int)offset) && !CharSequences.startsWith((CharSequence)source, (CharSequence)"=======\n", (int)offset) && !CharSequences.startsWith((CharSequence)source, (CharSequence)">>>>>>> ", (int)offset)) continue;
            Location location = Location.create((File)context.file, (CharSequence)source, (int)offset, (int)(offset + 7));
            context.report(ISSUE, location, "Missing merge marker?");
        }
    }
}

