/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GradleDetector
extends Detector
implements Detector.GradleScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
    public static final Issue DEPENDENCY = Issue.create((String)"GradleDependency", (String)"Obsolete Gradle Dependency", (String)"This detector looks for usages of libraries where the version you are using is not the current stable release. Using older versions is fine, and there are cases where you deliberately want to stick with an older version. However, you may simply not be aware that a more recent version is available, and that is what this lint check helps find.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue DEPRECATED = Issue.create((String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"This detector looks for deprecated Gradle constructs which currently work but will likely stop working in a future update.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY = Issue.create((String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"Not all versions of the Android Gradle plugin are compatible with all versions of the SDK. If you update your tools, or if you are trying to open a project that was built with an old version of the tools, you may need to update your plugin version number.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue PATH = Issue.create((String)"GradlePath", (String)"Gradle Path Issues", (String)"Gradle build scripts are meant to be cross platform, so file paths use Unix-style path separators (a forward slash) rather than Windows path separators (a backslash). Similarly, to keep projects portable and repeatable, avoid using absolute paths on the system; keep files within the project instead. To share code between projects, consider creating an android-library and an AAR dependency", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue IDE_SUPPORT = Issue.create((String)"GradleIdeError", (String)"Gradle IDE Support Issues", (String)"Gradle is highly flexible, and there are things you can do in Gradle files which can make it hard or impossible for IDEs to properly handle the project. This lint check looks for constructs that potentially break IDE support.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue PLUS = Issue.create((String)"GradleDynamicVersion", (String)"Gradle Dynamic Version", (String)"Using `+` in dependencies lets you automatically pick up the latest available version rather than a specific, named version. However, this is not recommended; your builds are not repeatable; you may have tested with a slightly different version than what the build server used. (Using a dynamic version as the major version number is more problematic than using it in the minor version position.)", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue GRADLE_GETTER = Issue.create((String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"Gradle will let you replace specific constants in your build scripts with method calls, so you can for example dynamically compute a version string based on your current version control revision number, rather than hardcoding a number.\n\nWhen computing a version name, it's tempting to for example call the method to do that `getVersionName`. However, when you put that method call inside the `defaultConfig` block, you will actually be calling the Groovy getter for the `versionName` property instead. Therefore, you need to name your method something which does not conflict with the existing implicit getters. Consider using `compute` as a prefix instead of `get`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue COMPATIBILITY = Issue.create((String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"There are some combinations of libraries, or tools and libraries, that are incompatible, or can lead to bugs. One such incompatibility is compiling with a version of the Android support libraries that is not the latest version (or in particular, a version lower than your `targetSdkVersion`.)", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue STRING_INTEGER = Issue.create((String)"StringShouldBeInt", (String)"String should be int", (String)"The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` are usually numbers, but can be strings when you are using an add-on (in the case of `compileSdkVersion`) or a preview platform (for the other two properties).\n\nHowever, you can not use a number as a string (e.g. \"19\" instead of 19); that will result in a platform not found error message at build/sync time.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue NOT_INTERPOLATED = Issue.create((String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"To insert the value of a variable, you can use `${variable}` inside a string literal, but **only** if you are using double quotes!", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://www.groovy-lang.org/syntax.html#_string_interpolation");
    public static final Issue REMOTE_VERSION = Issue.create((String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"This detector checks with a central repository to see if there are newer versions available for the dependencies used by this project. This is similar to the `GradleDependency` check, which checks for newer versions available in the Android SDK tools and libraries, but this works with any MavenCentral dependency, and connects to the library every time, which makes it more flexible but also **much** slower.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue ACCIDENTAL_OCTAL = Issue.create((String)"AccidentalOctal", (String)"Accidental Octal", (String)"In Groovy, an integer literal that starts with a leading 0 will be interpreted as an octal number. That is usually (always?) an accident and can lead to subtle bugs, for example when used in the `versionCode` of an app.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue BUNDLED_GMS = Issue.create((String)"UseOfBundledGooglePlayServices", (String)"Use of bundled version of Google Play services", (String)"Google Play services SDK's can be selectively included, which enables a smaller APK size. Consider declaring dependencies on individual Google Play services SDK's. If you are using Firebase API's (http://firebase.google.com/docs/android/setup), Android Studio's Tools \u2192 Firebase assistant window can automatically add just the dependencies needed for each feature.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developers.google.com/android/guides/setup#split");
    public static final Issue HIGH_APP_VERSION_CODE = Issue.create((String)"HighAppVersionCode", (String)"VersionCode too high", (String)"The declared `versionCode` is an Integer. Ensure that the version number is not close to the limit. It is recommended to monotonically increase this number each minor or major release of the app. Note that updating an app with a versionCode over `Integer.MAX_VALUE` is not possible.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/studio/publish/versioning.html");
    public static final Issue DEV_MODE_OBSOLETE = Issue.create((String)"DevModeObsolete", (String)"Dev Mode Obsolete", (String)"In the past, our documentation recommended creating a `dev` product flavor with has a minSdkVersion of 21, in order to enable multidexing to speed up builds significantly during development.\n\nThat workaround is no longer necessary, and it has some serious downsides, such as breaking API access checking (since the true `minSdkVersion` is no longer known.)\n\nIn recent versions of the IDE and the Gradle plugin, the IDE automatically passes the API level of the connected device used for deployment, and if that device is at least API 21, then multidexing is automatically turned on, meaning that you get the same speed benefits as the `dev` product flavor but without the downsides.", (Category)Category.PERFORMANCE, (int)2, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final String APP_PLUGIN_ID = "com.android.application";
    public static final String LIB_PLUGIN_ID = "com.android.library";
    public static final String OLD_APP_PLUGIN_ID = "android";
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    private static final GradleCoordinate PLAY_SERVICES_V650 = GradleCoordinate.parseCoordinateString((String)"com.google.android.gms:play-services:6.5.0");
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    private int minSdkVersion;
    private int compileSdkVersion;
    private int targetSdkVersion;
    private static int sMajorBuildTools;
    private static GradleVersion sLatestBuildTools;
    static GoogleMavenRepository googleMavenRepository;
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedSupportLibs;
    private boolean mCheckedWearableLibs;

    public void visitBuildScript(Context context, Map<String, Object> sharedData) {
    }

    protected static boolean isInterestingBlock(String parent, String parentParent) {
        switch (parent) {
            case "defaultConfig": 
            case "android": 
            case "dependencies": 
            case "repositories": {
                return true;
            }
            case "dev": {
                return "productFlavors".equals(parentParent);
            }
        }
        return "buildTypes".equals(parentParent);
    }

    protected static boolean isInterestingStatement(String statement, String parent) {
        return parent == null && statement.equals("apply");
    }

    protected static boolean isInterestingProperty(String property, String parent, String parentParent) {
        switch (property) {
            case "targetSdkVersion": 
            case "buildToolsVersion": 
            case "versionName": 
            case "versionCode": 
            case "compileSdkVersion": 
            case "minSdkVersion": 
            case "applicationIdSuffix": 
            case "packageName": 
            case "packageNameSuffix": {
                return true;
            }
        }
        return parent.equals("dependencies");
    }

    protected void checkOctal(Context context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || value.charAt(1) >= '8' && GradleDetector.isInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            String message = "The leading 0 turns this number into octal which is probably not what was intended";
            try {
                long numericValue = Long.decode(value);
                message = message + " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException nufe) {
                message = message + " (and it is not a valid octal number)";
            }
            this.report(context, cookie, ACCIDENTAL_OCTAL, message);
        }
    }

    protected void checkDslPropertyAssignment(Context context, String property, String value, String parent, String parentParent, Object valueCookie, Object statementCookie) {
        if (parent.equals("defaultConfig")) {
            int version;
            String message;
            int version2;
            if (property.equals("targetSdkVersion")) {
                version2 = GradleDetector.getSdkVersion(value);
                if (version2 > 0 && version2 < context.getClient().getHighestKnownApiLevel()) {
                    message = "Not targeting the latest versions of Android; compatibility \nmodes apply. Consider testing and updating this version. \nConsult the android.os.Build.VERSION_CODES javadoc for details.";
                    int highest = context.getClient().getHighestKnownApiLevel();
                    String label = "Update targetSdkVersion to " + highest;
                    LintFix fix = GradleDetector.fix().replace().all().with(Integer.toString(highest)).build();
                    this.report(context, valueCookie, ManifestDetector.TARGET_NEWER, message, fix);
                }
                if (version2 > 0) {
                    this.targetSdkVersion = version2;
                    this.checkTargetCompatibility(context, valueCookie);
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            } else if (property.equals("minSdkVersion")) {
                version2 = GradleDetector.getSdkVersion(value);
                if (version2 > 0) {
                    this.minSdkVersion = version2;
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            }
            if (value.startsWith("0")) {
                this.checkOctal(context, value, valueCookie);
            }
            if (property.equals("versionName") || property.equals("versionCode") && !GradleDetector.isInteger(value) || !GradleDetector.isStringLiteral(value)) {
                if (value.equals("getVersionCode") || value.equals("getVersionName")) {
                    String message2 = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                    this.report(context, valueCookie, GRADLE_GETTER, message2);
                }
            } else if (property.equals("packageName")) {
                String message3 = "Deprecated: Replace 'packageName' with 'applicationId'";
                LintFix fix = GradleDetector.fix().replace().text("packageName").with("applicationId").build();
                this.report(context, this.getPropertyKeyCookie(valueCookie), DEPRECATED, message3, fix);
            }
            if (property.equals("versionCode") && context.isEnabled(HIGH_APP_VERSION_CODE) && GradleDetector.isInteger(value) && (version = GradleDetector.getIntLiteralValue(value, -1)) >= 2000000000) {
                message = "The 'versionCode' is very high and close to the max allowed value";
                this.report(context, valueCookie, HIGH_APP_VERSION_CODE, message);
            }
        } else if (property.equals("compileSdkVersion") && parent.equals(OLD_APP_PLUGIN_ID)) {
            int version = -1;
            if (GradleDetector.isStringLiteral(value)) {
                AndroidVersion platformVersion;
                String hash = GradleDetector.getStringLiteralValue(value);
                if (hash != null && !GradleDetector.isNumberString(hash) && (platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                    version = platformVersion.getFeatureLevel();
                }
            } else {
                version = GradleDetector.getIntLiteralValue(value, -1);
            }
            if (version > 0) {
                this.compileSdkVersion = version;
                this.checkTargetCompatibility(context, valueCookie);
            } else {
                this.checkIntegerAsString(context, value, valueCookie);
            }
        } else if (property.equals("buildToolsVersion") && parent.equals(OLD_APP_PLUGIN_ID)) {
            GradleVersion version;
            String versionString = GradleDetector.getStringLiteralValue(value);
            if (versionString != null && (version = GradleVersion.tryParse((String)versionString)) != null) {
                String message;
                GradleVersion recommended = GradleDetector.getLatestBuildTools(context.getClient(), version.getMajor());
                if (recommended != null && version.compareTo(recommended) < 0) {
                    message = "Old buildToolsVersion " + version + "; recommended version is " + recommended + " or later";
                    LintFix fix = GradleDetector.getUpdateDependencyFix(version.toString(), recommended.toString());
                    this.report(context, valueCookie, DEPENDENCY, message, fix);
                }
                if (version.getMajor() == 23 && version.getMinor() == 0 && version.getMicro() == 0 && context.isEnabled(COMPATIBILITY)) {
                    if (recommended == null || recommended.getMajor() < 23) {
                        recommended = new GradleVersion(23, 0, 3);
                    }
                    message = String.format("Build Tools `23.0.0` should not be used; it has some known serious bugs. Use version `%1$s` instead.", recommended);
                    this.reportFatalCompatibilityIssue(context, valueCookie, message);
                }
            }
        } else if (parent.equals("dependencies")) {
            if (value.startsWith("files('") && value.endsWith("')")) {
                String path = value.substring("files('".length(), value.length() - 2);
                if (path.contains("\\\\")) {
                    String message = "Do not use Windows file separators in .gradle files; use / instead";
                    this.report(context, valueCookie, PATH, message);
                } else if (path.startsWith("/") || new File(path.replace('/', File.separatorChar)).isAbsolute()) {
                    String message = "Avoid using absolute paths in .gradle files";
                    this.report(context, valueCookie, PATH, message);
                }
            } else {
                String dependency = GradleDetector.getStringLiteralValue(value);
                if (dependency == null) {
                    dependency = GradleDetector.getNamedDependency(value);
                }
                if (dependency != null) {
                    LintFix fix;
                    String message;
                    GradleCoordinate gc = GradleCoordinate.parseCoordinateString((String)dependency);
                    boolean isResolved = false;
                    if (gc != null && dependency.contains("$")) {
                        if (value.startsWith("'") && value.endsWith("'") && context.isEnabled(NOT_INTERPOLATED)) {
                            message = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                            fix = GradleDetector.fix().name("Replace single quotes with double quotes").replace().text(value).with("\"" + value.substring(1, value.length() - 1) + "\"").build();
                            this.report(context, statementCookie, NOT_INTERPOLATED, message, fix);
                        }
                        gc = GradleDetector.resolveCoordinate(context, gc);
                        isResolved = true;
                    }
                    if (gc != null) {
                        if (gc.acceptsGreaterRevisions()) {
                            message = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ")";
                            fix = GradleDetector.fix().data(new Object[]{gc});
                            this.report(context, valueCookie, PLUS, message, fix);
                        }
                        this.checkDependency(context, gc, isResolved, valueCookie);
                    }
                }
            }
        } else if (property.equals("packageNameSuffix")) {
            String message = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
            LintFix fix = GradleDetector.fix().replace().text("packageNameSuffix").with("applicationIdSuffix").build();
            this.report(context, this.getPropertyKeyCookie(valueCookie), DEPRECATED, message, fix);
        } else if (property.equals("applicationIdSuffix")) {
            String suffix = GradleDetector.getStringLiteralValue(value);
            if (suffix != null && !suffix.startsWith(".")) {
                String message = "Application ID suffix should probably start with a \".\"";
                this.report(context, valueCookie, PATH, message);
            }
        } else if (property.equals("minSdkVersion") && parent.equals("dev") && "21".equals(value) && !"gradle".equals(LintClient.getClientName())) {
            this.report(context, statementCookie, DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks");
        }
    }

    private static int getSdkVersion(String value) {
        int version = 0;
        if (GradleDetector.isStringLiteral(value)) {
            String codeName = GradleDetector.getStringLiteralValue(value);
            if (codeName != null) {
                if (GradleDetector.isNumberString(codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleDetector.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private static GradleCoordinate resolveCoordinate(Context context, GradleCoordinate gc) {
        assert (gc.getRevision().contains("$")) : gc.getRevision();
        Project project = context.getProject();
        Variant variant = project.getCurrentVariant();
        if (variant != null) {
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                MavenCoordinates mc = library.getResolvedCoordinates();
                if (mc == null || !mc.getGroupId().equals(gc.getGroupId()) || !mc.getArtifactId().equals(gc.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc.getVersion());
                if (revisions.isEmpty()) break;
                return new GradleCoordinate(mc.getGroupId(), mc.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    static String getNamedDependency(String expression) {
        if (expression.indexOf(44) != -1 && expression.contains("version:")) {
            String artifact = null;
            String group = null;
            String version = null;
            Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (String property : splitter.split((CharSequence)expression)) {
                int valueEnd;
                int colon = property.indexOf(58);
                if (colon == -1) {
                    return null;
                }
                int quote = 39;
                int valueStart = property.indexOf(quote, colon + 1);
                if (valueStart == -1) {
                    quote = 34;
                    valueStart = property.indexOf(quote, colon + 1);
                }
                if (valueStart == -1) continue;
                if ((valueEnd = property.indexOf(quote, ++valueStart)) == -1) {
                    return null;
                }
                String value = property.substring(valueStart, valueEnd);
                if (property.startsWith("group:")) {
                    group = value;
                    continue;
                }
                if (property.startsWith("name:")) {
                    artifact = value;
                    continue;
                }
                if (!property.startsWith("version:")) continue;
                version = value;
            }
            if (artifact != null && group != null && version != null) {
                return group + ':' + artifact + ':' + version;
            }
        }
        return null;
    }

    private void checkIntegerAsString(Context context, String value, Object valueCookie) {
        String string = GradleDetector.getStringLiteralValue(value);
        if (GradleDetector.isNumberString(string)) {
            String message = String.format("Use an integer rather than a string here (replace %1$s with just %2$s)", value, string);
            LintFix fix = GradleDetector.fix().name("Replace with integer").replace().text(value).with(string).build();
            this.report(context, valueCookie, STRING_INTEGER, message, fix);
        }
    }

    private static boolean isNumberString(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void checkMethodCall(Context context, String statement, String parent, Map<String, String> namedArguments, List<String> unnamedArguments, Object cookie) {
        boolean isOldAppPlugin;
        String plugin = namedArguments.get("plugin");
        if (statement.equals("apply") && parent == null && ((isOldAppPlugin = OLD_APP_PLUGIN_ID.equals(plugin)) || OLD_LIB_PLUGIN_ID.equals(plugin))) {
            String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
            String message = String.format("'%1$s' is deprecated; use '%2$s' instead", plugin, replaceWith);
            LintFix fix = GradleDetector.fix().replace().text(plugin).with(replaceWith).build();
            this.report(context, cookie, DEPRECATED, message, fix);
        }
    }

    private static GradleVersion getLatestBuildTools(LintClient client, int major) {
        if (major != sMajorBuildTools) {
            File[] dirs;
            sMajorBuildTools = major;
            ArrayList revisions = Lists.newArrayList();
            switch (major) {
                case 25: {
                    revisions.add(new GradleVersion(25, 0, 2));
                    break;
                }
                case 24: {
                    revisions.add(new GradleVersion(24, 0, 2));
                    break;
                }
                case 23: {
                    revisions.add(new GradleVersion(23, 0, 3));
                    break;
                }
                case 22: {
                    revisions.add(new GradleVersion(22, 0, 1));
                    break;
                }
                case 21: {
                    revisions.add(new GradleVersion(21, 1, 2));
                    break;
                }
                case 20: {
                    revisions.add(new GradleVersion(20, 0));
                    break;
                }
                case 19: {
                    revisions.add(new GradleVersion(19, 1));
                    break;
                }
                case 18: {
                    revisions.add(new GradleVersion(18, 1, 1));
                }
            }
            File sdkHome = client.getSdkHome();
            if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                for (File dir : dirs) {
                    GradleVersion v;
                    String name = dir.getName();
                    if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleVersion.tryParse((String)name)) == null || v.getMajor() != major) continue;
                    revisions.add(v);
                }
            }
            if (!revisions.isEmpty()) {
                sLatestBuildTools = (GradleVersion)Collections.max(revisions);
            }
        }
        return sLatestBuildTools;
    }

    private void checkTargetCompatibility(Context context, Object cookie) {
        if (this.compileSdkVersion > 0 && this.targetSdkVersion > 0 && this.targetSdkVersion > this.compileSdkVersion) {
            String message = "The targetSdkVersion (" + this.targetSdkVersion + ") should not be higher than the compileSdkVersion (" + this.compileSdkVersion + ")";
            LintFix fix = GradleDetector.fix().name("Set compileSdkVersion to " + this.targetSdkVersion).replace().text(Integer.toString(this.compileSdkVersion)).with(Integer.toString(this.targetSdkVersion)).build();
            this.reportNonFatalCompatibilityIssue(context, cookie, message, fix);
        }
    }

    private static String getStringLiteralValue(String value) {
        if (value.length() > 2 && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private static int getIntLiteralValue(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean isInteger(String token) {
        return token.matches("\\d+");
    }

    private static boolean isStringLiteral(String token) {
        return token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'");
    }

    private void checkDependency(Context context, GradleCoordinate dependency, boolean isResolved, Object cookie) {
        GradleVersion latest;
        LintFix fix;
        GradleVersion version = dependency.getVersion();
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String revision = dependency.getRevision();
        if (version == null || groupId == null || artifactId == null) {
            return;
        }
        GradleVersion newerVersion = null;
        switch (groupId) {
            case "com.android.support": 
            case "com.android.support.test": {
                GradleVersion max;
                this.checkSupportLibraries(context, dependency, version, cookie);
                File sdkHome = context.getClient().getSdkHome();
                File repository = SdkMavenRepository.ANDROID.getRepositoryLocation(sdkHome, true, FileOpUtils.create());
                if (repository == null || (max = MavenRepositories.getHighestInstalledVersionNumber((String)groupId, (String)artifactId, (File)repository, null, (boolean)false, (FileOp)FileOpUtils.create())) == null || version.compareTo(max) >= 0 || !context.isEnabled(DEPENDENCY)) break;
                newerVersion = max;
                break;
            }
            case "com.google.android.gms": 
            case "com.google.firebase": 
            case "com.google.android.support": 
            case "com.google.android.wearable": {
                GradleVersion max;
                this.checkPlayServices(context, dependency, version, revision, cookie);
                File sdkHome = context.getClient().getSdkHome();
                File repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome, true, FileOpUtils.create());
                if (repository == null || (max = MavenRepositories.getHighestInstalledVersionNumber((String)groupId, (String)artifactId, (File)repository, null, (boolean)false, (FileOp)FileOpUtils.create())) == null || version.compareTo(max) >= 0 || !context.isEnabled(DEPENDENCY)) break;
                newerVersion = max;
                break;
            }
            case "com.android.tools.build": {
                if (!"gradle".equals(artifactId)) break;
                if (this.checkGradlePluginDependency(context, dependency, cookie)) {
                    return;
                }
                newerVersion = GradleVersion.max((GradleVersion)version, (GradleVersion)GradleDetector.getGoogleMavenRepoVersion(context, dependency));
                break;
            }
            case "com.google.guava": {
                if (!"guava".equals(artifactId)) break;
                newerVersion = GradleDetector.getNewerVersion(version, 21, 0);
                break;
            }
            case "com.google.code.gson": {
                if (!"gson".equals(artifactId)) break;
                newerVersion = GradleDetector.getNewerVersion(version, 2, 8, 0);
                break;
            }
            case "org.apache.httpcomponents": {
                if (!"httpclient".equals(artifactId)) break;
                newerVersion = GradleDetector.getNewerVersion(version, 4, 3, 5);
                break;
            }
            case "com.squareup.okhttp3": {
                if (!"okhttp".equals(artifactId)) break;
                newerVersion = GradleDetector.getNewerVersion(version, 3, 7, 0);
                break;
            }
            case "com.github.bumptech.glide": {
                if (!"glide".equals(artifactId)) break;
                newerVersion = GradleDetector.getNewerVersion(version, 3, 7, 0);
                break;
            }
            case "io.fabric.tools": {
                if (!"gradle".equals(artifactId)) break;
                GradleVersion parsed = GradleVersion.tryParse((String)revision);
                if (parsed != null && parsed.compareTo("1.21.6") < 0) {
                    fix = GradleDetector.getUpdateDependencyFix(revision, "1.22.1");
                    this.report(context, cookie, DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to improve Instant Run performance (was " + revision + ")", fix);
                    break;
                }
                newerVersion = GradleDetector.getNewerVersion(version, new GradleVersion(1, 22, 1));
                break;
            }
            case "com.bugsnag": {
                if (!"bugsnag-android-gradle-plugin".equals(artifactId)) break;
                if (!version.isAtLeast(2, 1, 2)) {
                    LintFix fix2 = GradleDetector.getUpdateDependencyFix(revision, "2.4.1");
                    this.report(context, cookie, DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to improve Instant Run performance (was " + revision + ")", fix2);
                    break;
                }
                newerVersion = GradleDetector.getNewerVersion(version, 2, 4, 1);
            }
        }
        Issue issue = DEPENDENCY;
        if (context.getScope().size() > 1 && context.isEnabled(REMOTE_VERSION) && (latest = GradleDetector.getLatestVersionFromRemoteRepo(context.getClient(), dependency, dependency.isPreview())) != null && version.compareTo(latest) < 0) {
            newerVersion = latest;
            issue = REMOTE_VERSION;
        }
        newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)this.findCachedNewerVersion(dependency));
        newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)this.getHighestKnownVersion(context.getClient(), dependency));
        if ((newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)GradleDetector.getGoogleMavenRepoVersion(context, dependency))) != null && newerVersion.compareTo(version) > 0) {
            String versionString = newerVersion.toString();
            String message = GradleDetector.getNewerVersionAvailableMessage(dependency, versionString);
            fix = !isResolved ? GradleDetector.getUpdateDependencyFix(revision, versionString) : null;
            this.report(context, cookie, issue, message, fix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GradleVersion getGoogleMavenRepoVersion(Context context, GradleCoordinate dependency) {
        Class<GradleDetector> clazz = GradleDetector.class;
        synchronized (GradleDetector.class) {
            if (googleMavenRepository == null) {
                final LintClient client = context.getClient();
                File cacheDir = client.getCacheDir("maven.google", true);
                googleMavenRepository = new GoogleMavenRepository(cacheDir){

                    public byte[] readUrlData(String url, int timeout) {
                        try {
                            return LintUtils.readUrlData((LintClient)client, (String)url, (int)timeout);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void error(Throwable throwable, String message) {
                        client.log(throwable, message, new Object[0]);
                    }
                };
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return googleMavenRepository.findVersion(dependency, dependency.isPreview());
        }
    }

    protected File getGradleUserHome() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File(gradleUserHome);
    }

    protected File getArtifactCacheHome() {
        if (this.artifactCacheHome == null) {
            this.artifactCacheHome = new File(this.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
        }
        return this.artifactCacheHome;
    }

    private GradleVersion findCachedNewerVersion(GradleCoordinate dependency) {
        File versionDir = new File(this.getArtifactCacheHome(), dependency.getGroupId() + File.separator + dependency.getArtifactId());
        if (versionDir.exists()) {
            return MavenRepositories.getHighestVersion((File)versionDir, null, (boolean)MavenRepositories.isPreview((GradleCoordinate)dependency), (FileOp)FileOpUtils.create());
        }
        return null;
    }

    private void ensureTargetCompatibleWithO(Context context, GradleVersion version, Object cookie, int major, int minor, int micro) {
        if (version != null && !version.isAtLeast(major, minor, micro)) {
            GradleVersion revision = new GradleVersion(major, minor, micro);
            GradleVersion newest = GradleDetector.getNewerVersion(version, revision);
            if (newest != null) {
                revision = newest;
            }
            String message = String.format("Version must be at least %1$s when targeting O", revision);
            this.reportFatalCompatibilityIssue(context, cookie, message);
        }
    }

    private static LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion) {
        return GradleDetector.fix().name("Change to " + suggestedVersion).replace().text(currentVersion).with(suggestedVersion).build();
    }

    private static String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version) {
        return "A newer version of " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " than " + dependency.getRevision() + " is available: " + version;
    }

    protected GradleVersion getHighestKnownVersion(LintClient client, GradleCoordinate coordinate) {
        return null;
    }

    public static GradleVersion getLatestVersionFromRemoteRepo(LintClient client, GradleCoordinate dependency, boolean allowPreview) {
        return GradleDetector.getLatestVersionFromRemoteRepo(client, dependency, true, allowPreview);
    }

    private static GradleVersion getLatestVersionFromRemoteRepo(LintClient client, GradleCoordinate dependency, boolean firstRowOnly, boolean allowPreview) {
        String response;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (groupId == null || artifactId == null) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        String encoding = Charsets.UTF_8.name();
        try {
            query.append("http://search.maven.org/solrsearch/select?q=g:%22");
            query.append(URLEncoder.encode(groupId, encoding));
            query.append("%22+AND+a:%22");
            query.append(URLEncoder.encode(artifactId, encoding));
        }
        catch (UnsupportedEncodingException ee) {
            return null;
        }
        query.append("%22&core=gav");
        if (firstRowOnly) {
            query.append("&rows=1");
        }
        query.append("&wt=json");
        try {
            response = LintUtils.readUrlDataAsString((LintClient)client, (String)query.toString(), (int)20000);
            if (response == null) {
                return null;
            }
        }
        catch (IOException ioe) {
            client.log((Throwable)ioe, "Could not connect to maven central to look up the latest available version for %1$s", new Object[]{dependency});
            return null;
        }
        boolean foundPreview = false;
        int index = response.indexOf("\"response\"");
        while (index != -1) {
            GradleVersion revision;
            int start;
            int end;
            if ((index = response.indexOf("\"v\":", index)) == -1 || (end = response.indexOf(34, (start = response.indexOf(34, index += 4) + 1) + 1)) <= start || start < 0 || (revision = GradleVersion.tryParse((String)response.substring(start, end))) == null) continue;
            foundPreview = revision.isPreview();
            if (!allowPreview && foundPreview) continue;
            return revision;
        }
        if (!allowPreview && foundPreview && firstRowOnly) {
            return GradleDetector.getLatestVersionFromRemoteRepo(client, dependency, false, false);
        }
        return null;
    }

    private boolean checkGradlePluginDependency(Context context, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate minimum = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:1.0.0");
        if (minimum != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, minimum) < 0) {
            GradleVersion recommended = GradleVersion.max((GradleVersion)GradleDetector.getGoogleMavenRepoVersion(context, minimum), (GradleVersion)GradleVersion.tryParse((String)"2.3.2"));
            String message = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 1.0.0 and the recommended version is " + recommended;
            this.report(context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message);
            return true;
        }
        return false;
    }

    private void checkSupportLibraries(Context context, GradleCoordinate dependency, GradleVersion version, Object cookie) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        if ("com.android.support".equals(groupId) && !artifactId.startsWith("multidex") && !artifactId.startsWith("renderscript") && !artifactId.equals("support-annotations")) {
            String message;
            if (this.compileSdkVersion >= 18 && dependency.getMajorVersion() != this.compileSdkVersion && dependency.getMajorVersion() != -1 && context.isEnabled(COMPATIBILITY)) {
                message = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.compileSdkVersion + ")";
                this.reportNonFatalCompatibilityIssue(context, cookie, message);
            } else if (this.targetSdkVersion > 0 && dependency.getMajorVersion() < this.targetSdkVersion && dependency.getMajorVersion() != -1 && context.isEnabled(COMPATIBILITY)) {
                message = "This support library should not use a lower version (" + dependency.getMajorVersion() + ") than the `targetSdkVersion` (" + this.targetSdkVersion + ")";
                this.reportNonFatalCompatibilityIssue(context, cookie, message);
            }
        }
        if (!(this.mCheckedSupportLibs || artifactId.startsWith("multidex") || artifactId.startsWith("renderscript") || artifactId.equals("support-annotations"))) {
            this.mCheckedSupportLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentSupportLibraries(context, cookie);
            }
        }
        if ("appcompat-v7".equals(artifactId)) {
            IAndroidTarget buildTarget;
            boolean compile26Beta;
            boolean supportLib26Beta = version.isAtLeast(26, 0, 0, "beta", 1, true);
            boolean bl = compile26Beta = this.compileSdkVersion >= 26;
            if (this.compileSdkVersion == 26 && (buildTarget = context.getProject().getBuildTarget()) != null) {
                boolean bl2 = compile26Beta = buildTarget.getRevision() != 1;
            }
            if (supportLib26Beta && !compile26Beta && this.compileSdkVersion == version.getMajor()) {
                this.reportNonFatalCompatibilityIssue(context, cookie, String.format("When using a `compileSdkVersion` older than android-O revision 2, the support library version must be 26.0.0-alpha1 or lower (was %1$s)", version));
            } else if (!supportLib26Beta && compile26Beta) {
                this.reportNonFatalCompatibilityIssue(context, cookie, String.format("When using a `compileSdkVersion` android-O revision 2 or higher, the support library version should be 26.0.0-beta1 or higher (was %1$s)", version));
            }
            if (this.minSdkVersion >= 14 && this.compileSdkVersion >= 1 && this.compileSdkVersion < 21) {
                this.report(context, cookie, DEPENDENCY, "Using the appcompat library when minSdkVersion >= 14 and compileSdkVersion < 21 is not necessary");
            }
        }
    }

    private void checkPlayServices(Context context, GradleCoordinate dependency, GradleVersion version, String revision, Object cookie) {
        String message;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        if ("5.2.08".equals(revision) && context.isEnabled(COMPATIBILITY)) {
            GradleCoordinate max;
            String maxVersion = "10.2.1";
            File sdkHome = context.getClient().getSdkHome();
            File repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome, true, FileOpUtils.create());
            if (repository != null && (max = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)repository, null, (boolean)false, (FileOp)FileOpUtils.create())) != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, max) < 0) {
                maxVersion = max.getRevision();
            }
            LintFix fix = GradleDetector.getUpdateDependencyFix(revision, maxVersion);
            String message2 = String.format("Version `5.2.08` should not be used; the app can not be published with this version. Use version `%1$s` instead.", maxVersion);
            this.reportFatalCompatibilityIssue(context, cookie, message2, fix);
        }
        if (context.isEnabled(BUNDLED_GMS) && PLAY_SERVICES_V650.isSameArtifact(dependency) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, PLAY_SERVICES_V650) >= 0) {
            message = "Avoid using bundled version of Google Play services SDK.";
            this.report(context, cookie, BUNDLED_GMS, message);
        }
        if (GMS_GROUP_ID.equals(groupId) && "play-services-appindexing".equals(artifactId)) {
            message = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + revision + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            LintFix fix = GradleDetector.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + revision).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            this.report(context, cookie, DEPRECATED, message, fix);
        }
        if (this.targetSdkVersion >= 26) {
            if (GMS_GROUP_ID.equals(groupId) && "play-services-gcm".equals(artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if (FIREBASE_GROUP_ID.equals(groupId) && "firebase-messaging".equals(artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if ("firebase-jobdispatcher".equals(artifactId) || "firebase-jobdispatcher-with-gcm-dep".equals(artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 0, 6, 0);
            }
        }
        if (GMS_GROUP_ID.equals(groupId) || FIREBASE_GROUP_ID.equals(groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                    this.checkConsistentPlayServices(context, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentWearableLibraries(context, cookie);
            }
        }
    }

    private void checkConsistentSupportLibraries(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, "com.android.support", null);
    }

    private void checkConsistentPlayServices(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    private void checkConsistentWearableLibraries(Context context, Object cookie) {
        MavenCoordinates coordinates;
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet supportVersions = Sets.newHashSet();
        HashSet wearableVersions = Sets.newHashSet();
        for (AndroidLibrary androidLibrary : GradleDetector.getAndroidLibraries(project)) {
            coordinates = androidLibrary.getResolvedCoordinates();
            if (coordinates == null || !WEARABLE_ARTIFACT_ID.equals(coordinates.getArtifactId()) || !GOOGLE_SUPPORT_GROUP_ID.equals(coordinates.getGroupId())) continue;
            supportVersions.add(coordinates.getVersion());
        }
        for (JavaLibrary javaLibrary : GradleDetector.getJavaLibraries(project)) {
            coordinates = javaLibrary.getResolvedCoordinates();
            if (coordinates == null || !WEARABLE_ARTIFACT_ID.equals(coordinates.getArtifactId()) || !ANDROID_WEAR_GROUP_ID.equals(coordinates.getGroupId())) continue;
            if (!javaLibrary.isProvided()) {
                String message;
                if (cookie != null) {
                    message = "This dependency should be marked as `provided`, not `compile`";
                    this.reportFatalCompatibilityIssue(context, cookie, message);
                } else {
                    message = String.format("The %1$s:%2$s dependency should be marked as `provided`, not `compile`", ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID);
                    GradleDetector.reportFatalCompatibilityIssue(context, LintUtils.guessGradleLocation((Project)context.getProject()), message);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        if (!supportVersions.isEmpty()) {
            String message;
            if (wearableVersions.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)supportVersions);
                String string = (String)Collections.min(list);
                message = String.format("Project depends on %1$s:%2$s:%3$s, so it must also depend (as a provided dependency) on %4$s:%5$s:%6$s", GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, string, ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID, string);
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message);
                } else {
                    GradleDetector.reportFatalCompatibilityIssue(context, LintUtils.guessGradleLocation((Project)context.getProject()), message);
                }
            } else if (!supportVersions.equals(wearableVersions)) {
                ArrayList sortedSupportVersions = Lists.newArrayList((Iterable)supportVersions);
                Collections.sort(sortedSupportVersions);
                ArrayList arrayList = Lists.newArrayList((Iterable)wearableVersions);
                Collections.sort(arrayList);
                message = String.format("The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s", GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? sortedSupportVersions.get(0) : ((Object)sortedSupportVersions).toString(), arrayList.size() == 1 ? arrayList.get(0) : ((Object)arrayList).toString());
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message);
                } else {
                    GradleDetector.reportFatalCompatibilityIssue(context, LintUtils.guessGradleLocation((Project)context.getProject()), message);
                }
            }
        }
    }

    private void checkConsistentLibraries(Context context, Object cookie, String groupId, String groupId2) {
        MavenCoordinates coordinates;
        Project project = context.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Collection<AndroidLibrary> androidLibraries = GradleDetector.getAndroidLibraries(project);
        for (AndroidLibrary androidLibrary : androidLibraries) {
            coordinates = androidLibrary.getResolvedCoordinates();
            if (coordinates == null || !coordinates.getGroupId().equals(groupId) && !coordinates.getGroupId().equals(groupId2) || coordinates.getArtifactId().startsWith("multidex") || coordinates.getArtifactId().startsWith("renderscript") || coordinates.getArtifactId().startsWith("firebase-jobdispatcher")) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        for (JavaLibrary javaLibrary : GradleDetector.getJavaLibraries(project)) {
            coordinates = javaLibrary.getResolvedCoordinates();
            if (coordinates == null || !coordinates.getGroupId().equals(groupId) && !coordinates.getGroupId().equals(groupId2) || coordinates.getArtifactId().equals("support-annotations")) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            ArrayList arrayList = Lists.newArrayList((Iterable)versions);
            arrayList.sort(Collections.reverseOrder());
            MavenCoordinates c1 = GradleDetector.findFirst(versionToCoordinate.get(arrayList.get(0)));
            MavenCoordinates c2 = GradleDetector.findFirst(versionToCoordinate.get(arrayList.get(1)));
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String groupDesc = GMS_GROUP_ID.equals(groupId) ? "gms/firebase" : groupId;
            String message = "All " + groupDesc + " libraries must use the exact same version specification (mixing versions can lead to runtime crashes). Found versions " + Joiner.on((String)", ").join((Iterable)arrayList) + ". Examples include `" + example1 + "` and `" + example2 + "`";
            block2: for (AndroidLibrary library : androidLibraries) {
                MavenCoordinates coordinates2 = library.getResolvedCoordinates();
                if (coordinates2 == null || !coordinates2.getGroupId().equals("com.android.databinding") || !coordinates2.getArtifactId().equals("library")) continue;
                for (AndroidLibrary dep : library.getLibraryDependencies()) {
                    MavenCoordinates c = dep.getResolvedCoordinates();
                    if (c == null || !c.getGroupId().equals("com.android.support") || !c.getArtifactId().equals("support-v4") || ((String)arrayList.get(0)).equals(c.getVersion())) continue;
                    message = message + ". Note that this project is using data binding (com.android.databinding:library:" + coordinates2.getVersion() + ") which pulls in com.android.support:support-v4:" + c.getVersion() + ". You can try to work around this by adding an explicit dependency on com.android.support:support-v4:" + (String)arrayList.get(0);
                    break block2;
                }
            }
            if (cookie != null) {
                this.reportNonFatalCompatibilityIssue(context, cookie, message);
            } else {
                File projectDir = context.getProject().getDir();
                Location location1 = LintUtils.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)example1);
                Location location2 = LintUtils.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)example2);
                if (location1.getStart() != null) {
                    if (location2.getStart() != null) {
                        location1.setSecondary(location2);
                    }
                } else if (location2.getStart() == null) {
                    location1 = LintUtils.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)(c1.getGroupId() + ":" + c1.getArtifactId() + ":"));
                    if (location1.getStart() == null) {
                        location1 = LintUtils.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)(c2.getGroupId() + ":" + c2.getArtifactId() + ":"));
                    }
                } else {
                    location1 = location2;
                }
                GradleDetector.reportNonFatalCompatibilityIssue(context, location1, message);
            }
        }
    }

    private static MavenCoordinates findFirst(Collection<MavenCoordinates> coordinates) {
        return Collections.min(coordinates, Comparator.comparing(Object::toString));
    }

    public static Collection<AndroidLibrary> getAndroidLibraries(Project project) {
        Dependencies compileDependencies = GradleDetector.getCompileDependencies(project);
        if (compileDependencies == null) {
            return Collections.emptyList();
        }
        HashSet allLibraries = Sets.newHashSet();
        GradleDetector.addIndirectAndroidLibraries(compileDependencies.getLibraries(), allLibraries);
        return allLibraries;
    }

    public static Collection<JavaLibrary> getJavaLibraries(Project project) {
        Dependencies compileDependencies = GradleDetector.getCompileDependencies(project);
        if (compileDependencies == null) {
            return Collections.emptyList();
        }
        HashSet allLibraries = Sets.newHashSet();
        GradleDetector.addIndirectJavaLibraries(compileDependencies.getJavaLibraries(), allLibraries);
        return allLibraries;
    }

    private static void addIndirectAndroidLibraries(Collection<? extends AndroidLibrary> libraries, Set<AndroidLibrary> result) {
        for (AndroidLibrary androidLibrary : libraries) {
            if (result.contains(androidLibrary)) continue;
            result.add(androidLibrary);
            GradleDetector.addIndirectAndroidLibraries(androidLibrary.getLibraryDependencies(), result);
        }
    }

    private static void addIndirectJavaLibraries(Collection<? extends JavaLibrary> libraries, Set<JavaLibrary> result) {
        for (JavaLibrary javaLibrary : libraries) {
            if (result.contains(javaLibrary)) continue;
            result.add(javaLibrary);
            GradleDetector.addIndirectJavaLibraries(javaLibrary.getDependencies(), result);
        }
    }

    public void afterCheckProject(Context context) {
        if (context.getProject() == context.getMainProject() && context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkConsistentPlayServices(context, null);
            this.checkConsistentSupportLibraries(context, null);
            this.checkConsistentWearableLibraries(context, null);
        }
    }

    private static GradleVersion getNewerVersion(GradleVersion version1, int major, int minor, int micro) {
        if (!version1.isAtLeast(major, minor, micro)) {
            return new GradleVersion(major, minor, micro);
        }
        return null;
    }

    private static GradleVersion getNewerVersion(GradleVersion version1, int major, int minor) {
        if (!version1.isAtLeast(major, minor, 0)) {
            return new GradleVersion(major, minor);
        }
        return null;
    }

    private static GradleVersion getNewerVersion(GradleVersion version1, GradleVersion version2) {
        if (version1.compareTo(version2) < 0) {
            return version2;
        }
        return null;
    }

    private void report(Context context, Object cookie, Issue issue, String message) {
        this.report(context, cookie, issue, message, null);
    }

    private void report(Context context, Object cookie, Issue issue, String message, LintFix fix) {
        if (context.isEnabled(issue)) {
            int startOffset;
            boolean checkComments = context.containsCommentSuppress();
            if (checkComments && (startOffset = this.getStartOffset(context, cookie)) >= 0 && context.isSuppressedWithComment(startOffset, issue)) {
                return;
            }
            context.report(issue, this.createLocation(context, cookie), message, fix);
        }
    }

    private void reportFatalCompatibilityIssue(Context context, Object cookie, String message) {
        this.report(context, cookie, COMPATIBILITY, message);
    }

    private void reportFatalCompatibilityIssue(Context context, Object cookie, String message, LintFix fix) {
        this.report(context, cookie, COMPATIBILITY, message, fix);
    }

    private static void reportFatalCompatibilityIssue(Context context, Location location, String message) {
        context.report(COMPATIBILITY, location, message);
    }

    private void reportNonFatalCompatibilityIssue(Context context, Object cookie, String message) {
        this.reportNonFatalCompatibilityIssue(context, cookie, message, null);
    }

    private void reportNonFatalCompatibilityIssue(Context context, Object cookie, String message, LintFix lintFix) {
        if (context.getDriver().isFatalOnlyMode()) {
            return;
        }
        this.report(context, cookie, COMPATIBILITY, message, lintFix);
    }

    private static void reportNonFatalCompatibilityIssue(Context context, Location location, String message) {
        if (context.getDriver().isFatalOnlyMode()) {
            return;
        }
        context.report(COMPATIBILITY, location, message);
    }

    protected Object getPropertyKeyCookie(Object cookie) {
        return cookie;
    }

    protected Object getPropertyPairCookie(Object cookie) {
        return cookie;
    }

    protected int getStartOffset(Context context, Object cookie) {
        return -1;
    }

    protected Location createLocation(Context context, Object cookie) {
        return null;
    }

    public static Dependencies getCompileDependencies(Project project) {
        if (!project.isGradleProject()) {
            return null;
        }
        Variant variant = project.getCurrentVariant();
        if (variant == null) {
            return null;
        }
        AndroidArtifact artifact = variant.getMainArtifact();
        return artifact.getDependencies();
    }
}

