/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ChildCountDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getAccurateChildCount", "", "element", "Lorg/w3c/dom/Element;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "Issues", "lint-checks_main"})
public final class ChildCountDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    public static final Issue SCROLLVIEW_ISSUE;
    @JvmField
    public static final Issue ADAPTER_VIEW_ISSUE;
    public static final Issues Issues;

    @Nullable
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "HorizontalScrollView", "ListView", "GridView");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        int childCount = LintUtils.getChildCount((Node)element);
        String tagName = element.getTagName();
        if (Intrinsics.areEqual((Object)tagName, (Object)"ScrollView") || Intrinsics.areEqual((Object)tagName, (Object)"HorizontalScrollView")) {
            if (childCount > 1 && this.getAccurateChildCount(element) > 1) {
                Issue issue = SCROLLVIEW_ISSUE;
                Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"SCROLLVIEW_ISSUE");
                XmlContext.report$default((XmlContext)context, (Issue)issue, (Node)element, (Location)context.getLocation((Node)element), (String)"A scroll view can have only one child", null, (int)16, null);
            }
        } else if (childCount > 0 && this.getAccurateChildCount(element) > 0) {
            Issue issue = ADAPTER_VIEW_ISSUE;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ADAPTER_VIEW_ISSUE");
            XmlContext.report$default((XmlContext)context, (Issue)issue, (Node)element, (Location)context.getLocation((Node)element), (String)"A list/grid should have no children declared in XML", null, (int)16, null);
        }
    }

    private final int getAccurateChildCount(Element element) {
        NodeList childNodes = element.getChildNodes();
        int childCount = 0;
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !(Intrinsics.areEqual((Object)"requestFocus", (Object)child.getNodeName()) ^ true)) continue;
            ++childCount;
        }
        return childCount;
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(ChildCountDetector.class, Scope.RESOURCE_FILE_SCOPE);
        SCROLLVIEW_ISSUE = Issue.create((String)"ScrollViewCount", (String)"ScrollViews can have only one child", (String)"\nScrollViews can only have one child widget. If you want more children, wrap them in a container \\\nlayout.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.WARNING, (Implementation)ChildCountDetector.Issues.getIMPLEMENTATION());
        ADAPTER_VIEW_ISSUE = Issue.create((String)"AdapterViewChildren", (String)"AdapterViews cannot have children in XML", (String)"\nAdapterViews such as ListViews must be configured with data from Java code, such as a \\\nListAdapter.", (Category)Category.CORRECTNESS, (int)10, (Severity)Severity.WARNING, (Implementation)ChildCountDetector.Issues.getIMPLEMENTATION()).addMoreInfo("http://developer.android.com/reference/android/widget/AdapterView.html");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/ChildCountDetector$Issues;", "", "()V", "ADAPTER_VIEW_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "SCROLLVIEW_ISSUE", "lint-checks_main"})
    public static final class Issues {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

