/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.java.JavaUAnnotation;

public abstract class RangeConstraint {
    public static RangeConstraint create(UAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        switch (qualifiedName) {
            case "android.support.annotation.IntRange": {
                return IntRangeConstraint.create(annotation);
            }
            case "android.support.annotation.FloatRange": {
                return FloatRangeConstraint.create(annotation);
            }
            case "android.support.annotation.Size": {
                return SizeConstraint.create(annotation);
            }
        }
        return null;
    }

    public static RangeConstraint create(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                RangeConstraint constraint = RangeConstraint.create(JavaUAnnotation.wrap((PsiAnnotation)annotation));
                if (constraint == null) continue;
                return constraint;
            }
        }
        return null;
    }

    public Boolean contains(RangeConstraint other) {
        return null;
    }
}

