/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChromeOsDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ChromeOsDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue UNSUPPORTED_CHROME_OS_HARDWARE = Issue.create((String)"UnsupportedChromeOsHardware", (String)"Unsupported Chrome OS Hardware Feature", (String)"The `<uses-feature>` element should not require this unsupported Chrome OS hardware feature. Any uses-feature not explicitly marked with `required=\"false\"` is necessary on the device to be installed on. Ensure that any features that might prevent it from being installed on a Chrome OS device are reviewed and marked as not required in the manifest.", (Category)Category.CHROME_OS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).setEnabledByDefault(false).addMoreInfo("https://developer.android.com/topic/arc/manifest.html#incompat-entries");
    public static final Issue PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE = Issue.create((String)"PermissionImpliesUnsupportedChromeOsHardware", (String)"Permission Implies Unsupported Chrome OS Hardware", (String)"The `<uses-permission>` element should not require a permission that implies an unsupported Chrome OS hardware feature. Google Play assumes that certain hardware related permissions indicate that the underlying hardware features are required by default. To fix the issue, consider declaring the corresponding uses-feature element with `required=\"false\"` attribute.", (Category)Category.CHROME_OS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).setEnabledByDefault(false).addMoreInfo("https://developer.android.com/topic/arc/manifest.html#implied-features");
    private static final String HARDWARE_FEATURE_CAMERA = "android.hardware.camera";
    private static final String HARDWARE_FEATURE_CAMERA_AUTOFOCUS = "android.hardware.camera.autofocus";
    private static final String HARDWARE_FEATURE_TELEPHONY = "android.hardware.telephony";
    private static final String ANDROID_PERMISSION_CAMERA = "android.permission.CAMERA";
    private static final String[] UNSUPPORTED_HARDWARE_FEATURES = new String[]{"android.hardware.camera", "android.hardware.camera.autofocus", "android.hardware.camera.capability.manual_post_processing", "android.hardware.camera.capability.manual_sensor", "android.hardware.camera.capability.raw", "android.hardware.camera.flash", "android.hardware.camera.level.full", "android.hardware.consumerir", "android.hardware.location.gps", "android.hardware.nfc", "android.hardware.nfc.hce", "android.hardware.sensor.barometer", "android.hardware.telephony", "android.hardware.telephony.cdma", "android.hardware.telephony.gsm", "android.hardware.touchscreen", "android.hardware.type.automotive", "android.hardware.type.television", "android.hardware.usb.accessory", "android.hardware.usb.host", "android.hardware.sensor.accelerometer", "android.hardware.sensor.compass", "android.hardware.sensor.gyroscope", "android.hardware.sensor.light", "android.hardware.sensor.proximity", "android.hardware.sensor.stepcounter", "android.hardware.sensor.stepdetector", "android.software.app_widgets", "android.software.device_admin", "android.software.home_screen", "android.software.input_methods", "android.software.leanback", "android.software.live_wallpaper", "android.software.live_tv", "android.software.managed_users", "android.software.midi", "android.software.sip", "android.software.sip.voip"};
    private boolean usesFeatureCamera;
    private boolean usesFeatureCameraAutofocus;
    private List<String> unsupportedHardwareImpliedPermissions;
    private Set<String> allUnsupportedChromeOsUsesFeatures;
    private Set<String> unsupportedChromeOsUsesFeatures;

    public Collection<String> getApplicableElements() {
        return Arrays.asList("uses-feature", "uses-permission");
    }

    public void beforeCheckFile(Context context) {
        this.usesFeatureCamera = false;
        this.usesFeatureCameraAutofocus = false;
        this.unsupportedHardwareImpliedPermissions = Lists.newArrayListWithExpectedSize((int)2);
        this.unsupportedChromeOsUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
        this.allUnsupportedChromeOsUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
    }

    public void afterCheckFile(Context context) {
        XmlContext xmlContext = (XmlContext)context;
        if (!context.getMainProject().isLibrary()) {
            if (!this.unsupportedChromeOsUsesFeatures.isEmpty() && xmlContext.isEnabled(UNSUPPORTED_CHROME_OS_HARDWARE)) {
                List<Element> usesFeatureElements = AndroidTvDetector.findUsesFeatureElements(this.unsupportedChromeOsUsesFeatures, xmlContext.document);
                for (Element element : usesFeatureElements) {
                    Attr attrRequired = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                    Node location = attrRequired == null ? element : attrRequired;
                    LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "required", "false").build();
                    xmlContext.report(UNSUPPORTED_CHROME_OS_HARDWARE, location, xmlContext.getLocation(location), "Expecting `android:required=\"false\"` for this hardware feature that may not be supported by all Chrome OS devices.", fix);
                }
            }
            if (!this.unsupportedHardwareImpliedPermissions.isEmpty() && xmlContext.isEnabled(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE)) {
                Predicate<String> p = input -> {
                    if (ANDROID_PERMISSION_CAMERA.equals(input)) {
                        return !this.usesFeatureCamera || !this.usesFeatureCameraAutofocus;
                    }
                    String usesFeature = input != null ? ChromeOsDetector.getImpliedUnsupportedHardware(input) : null;
                    return usesFeature != null && !this.allUnsupportedChromeOsUsesFeatures.contains(usesFeature);
                };
                Collection filteredPermissions = this.unsupportedHardwareImpliedPermissions.stream().filter(p).collect(Collectors.toCollection(HashSet::new));
                List<Element> permissionsWithoutUsesFeatures = AndroidTvDetector.findPermissionElements(filteredPermissions, xmlContext.document);
                for (Element permissionElement : permissionsWithoutUsesFeatures) {
                    String name = permissionElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    String[] unsupportedHardwareNames = new String[2];
                    unsupportedHardwareNames[0] = ChromeOsDetector.getImpliedUnsupportedHardware(name);
                    if (ANDROID_PERMISSION_CAMERA.equals(name)) {
                        if (this.usesFeatureCamera) {
                            unsupportedHardwareNames[0] = null;
                        }
                        if (!this.usesFeatureCameraAutofocus) {
                            unsupportedHardwareNames[1] = HARDWARE_FEATURE_CAMERA_AUTOFOCUS;
                        }
                    }
                    for (String unsupportedHardwareName : unsupportedHardwareNames) {
                        if (unsupportedHardwareName == null) continue;
                        String message = String.format("Permission exists without corresponding hardware `<uses-feature android:name=\"%1$s\" required=\"false\">` tag.", unsupportedHardwareName);
                        LintFix fix = this.fix().data(new Object[]{unsupportedHardwareName});
                        xmlContext.report(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, (Node)permissionElement, xmlContext.getLocation((Node)permissionElement), message, fix);
                    }
                }
            }
        }
    }

    private static String getImpliedUnsupportedHardware(String permission) {
        switch (permission) {
            case "android.permission.CAMERA": {
                return HARDWARE_FEATURE_CAMERA;
            }
            case "android.permission.CALL_PHONE": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.CALL_PRIVILEGED": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.MODIFY_PHONE_STATE": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.PROCESS_OUTGOING_CALLS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.READ_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_MMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_WAP_PUSH": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.SEND_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.WRITE_APN_SETTINGS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.WRITE_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
        }
        return null;
    }

    public void visitElement(XmlContext context, Element element) {
        String permissionName;
        String elementName = element.getTagName();
        if ("uses-feature".equals(elementName)) {
            String featureName;
            Attr name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (name != null && ChromeOsDetector.isUnsupportedHardwareFeature(featureName = name.getValue())) {
                this.allUnsupportedChromeOsUsesFeatures.add(featureName);
                Attr required = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                if (required == null || Boolean.parseBoolean(required.getValue())) {
                    this.unsupportedChromeOsUsesFeatures.add(featureName);
                }
                if (HARDWARE_FEATURE_CAMERA.equals(featureName)) {
                    this.usesFeatureCamera = true;
                }
                if (HARDWARE_FEATURE_CAMERA_AUTOFOCUS.equals(featureName)) {
                    this.usesFeatureCameraAutofocus = true;
                }
            }
        } else if ("uses-permission".equals(elementName) && ChromeOsDetector.getImpliedUnsupportedHardware(permissionName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            this.unsupportedHardwareImpliedPermissions.add(permissionName);
        }
    }

    private static boolean isUnsupportedHardwareFeature(String featureName) {
        for (String prefix : UNSUPPORTED_HARDWARE_FEATURES) {
            if (!featureName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

