/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TextViewDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(TextViewDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"TextViewEdits", (String)"TextView should probably be an EditText instead", (String)"Using a `<TextView>` to input text is generally an error, you should be using `<EditText>` instead.  `EditText` is a subclass of `TextView`, and some of the editing support is provided by `TextView`, so it's possible to set some input-related properties on a `TextView`. However, using a `TextView` along with input attributes is usually a cut & paste error. To input text you should be using `<EditText>`.\n\nThis check also checks subclasses of `TextView`, such as `Button` and `CheckBox`, since these have the same issue: they should not be used with editable attributes.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue SELECTABLE = Issue.create((String)"SelectableText", (String)"Dynamic text should probably be selectable", (String)"If a `<TextView>` is used to display data, the user might want to copy that data and paste it elsewhere. To allow this, the `<TextView>` should specify `android:textIsSelectable=\"true\"`.\n\nThis lint check looks for TextViews which are likely to be displaying data: views whose text is set dynamically. This value will be ignored on platforms older than API 11, so it is okay to set it regardless of your `minSdkVersion`.", (Category)Category.USABILITY, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);

    public Collection<String> getApplicableElements() {
        return Arrays.asList("TextView", "Button", "ToggleButton", "CheckBox", "RadioButton", "CheckedTextView", "Switch");
    }

    public void visitElement(XmlContext context, Element element) {
        if (element.getTagName().equals("TextView") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "text") && element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "textIsSelectable") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "visibility") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "onClick") && context.getMainProject().getTargetSdk() >= 11 && context.isEnabled(SELECTABLE)) {
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "textIsSelectable", "true").build();
            context.report(SELECTABLE, (Node)element, context.getLocation((Node)element), "Consider making the text value selectable by specifying `android:textIsSelectable=\"true\"`", fix);
        }
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getLocalName();
            if (name == null || name.isEmpty()) continue;
            boolean isEditAttribute = false;
            switch (name.charAt(0)) {
                case 'a': {
                    isEditAttribute = name.equals("autoText");
                    break;
                }
                case 'b': {
                    isEditAttribute = name.equals("bufferType") && attribute.getValue().equals("editable");
                    break;
                }
                case 'p': {
                    isEditAttribute = name.equals("password") || name.equals("phoneNumber") || name.equals("privateImeOptions");
                    break;
                }
                case 'c': {
                    isEditAttribute = name.equals("capitalize") || name.equals("cursorVisible");
                    break;
                }
                case 'd': {
                    isEditAttribute = name.equals("digits");
                    break;
                }
                case 'e': {
                    if (name.equals("editable")) {
                        isEditAttribute = attribute.getValue().equals("true");
                        break;
                    }
                    isEditAttribute = name.equals("editorExtras");
                    break;
                }
                case 'i': {
                    if (name.equals("inputType")) {
                        String value = attribute.getValue();
                        isEditAttribute = !value.isEmpty() && !value.equals("none");
                        break;
                    }
                    isEditAttribute = name.equals("inputType") || name.equals("imeOptions") || name.equals("imeActionLabel") || name.equals("imeActionId") || name.equals("inputMethod");
                    break;
                }
                case 'n': {
                    isEditAttribute = name.equals("numeric");
                }
            }
            if (!isEditAttribute || !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || !context.isEnabled(ISSUE)) continue;
            Location location = context.getLocation((Node)attribute);
            String view = element.getTagName();
            String message = view.equals("TextView") ? String.format("Attribute `%1$s` should not be used with `<TextView>`: Change element type to `<EditText>` ?", attribute.getName()) : String.format("Attribute `%1$s` should not be used with `<%2$s>`: intended for editable text widgets", attribute.getName(), view);
            context.report(ISSUE, (Node)attribute, location, message);
        }
    }
}

