/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002Jr\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkResult", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMemberAnnotations", "allClassAnnotations", "isExpressionValueUnused", "", "expression", "Lorg/jetbrains/uast/UExpression;", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "annotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class CheckResultDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CHECK_RESULT;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{"android.support.annotation.CheckResult", "edu.umd.cs.findbugs.annotations.CheckReturnValue", "javax.annotation.CheckReturnValue", "com.google.errorprone.annotations.CanIgnoreReturnValue", "io.reactivex.annotations.CheckReturnValue", "com.google.errorprone.annotations.CheckReturnValue"});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method == null) {
            return;
        }
        if (allPackageAnnotations.contains(annotation)) {
            return;
        }
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)"com.google.errorprone.annotations.CanIgnoreReturnValue")) {
            return;
        }
        this.checkResult(context, usage, method, annotation, allMemberAnnotations, allClassAnnotations);
    }

    private final void checkResult(JavaContext context, UElement element, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMemberAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        UElement parent;
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
        if (uExpression == null) {
            return;
        }
        UExpression expression = uExpression;
        for (UElement curr = parent = expression.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof ULambdaExpression) {
                return;
            }
            if (!(curr instanceof UQualifiedReferenceExpression) && !(curr instanceof UBlockExpression)) break;
        }
        if (this.isExpressionValueUnused(expression)) {
            if (UastLintUtils.containsAnnotation(allMemberAnnotations, (String)"com.google.errorprone.annotations.CanIgnoreReturnValue") || UastLintUtils.containsAnnotation(allClassAnnotations, (String)"com.google.errorprone.annotations.CanIgnoreReturnValue")) {
                return;
            }
            String methodName = JavaContext.Companion.getMethodName((UElement)expression);
            String suggested = UastLintUtils.getAnnotationStringValue((UAnnotation)annotation, (String)"suggest");
            Issue issue = CHECK_RESULT;
            if (methodName != null && StringsKt.startsWith$default((String)methodName, (String)"check", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)methodName, (CharSequence)"Permission", (boolean)false, (int)2, null)) {
                issue = PermissionDetector.CHECK_PERMISSION;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The result of `%1$s` is not used";
            Object[] objectArray = new Object[]{methodName};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message = string2;
            if (suggested != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = "The result of `%1$s` is not used; did you mean to call `%2$s`?";
                objectArray = new Object[]{methodName, suggested};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                message = string3;
            } else if (Intrinsics.areEqual((Object)"intersect", (Object)methodName) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message = message + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
            }
            LintFix fix = suggested != null ? this.fix().data(new Object[]{suggested}) : null;
            Location location = context.getLocation((UElement)expression);
            this.report(context, issue, (UElement)expression, location, message, fix);
        }
    }

    private final boolean isExpressionValueUnused(UExpression expression) {
        UElement parent = UastUtils.getQualifiedParentOrThis((UExpression)expression).getUastParent();
        if (parent instanceof UBlockExpression) {
            int index = ((UBlockExpression)parent).getExpressions().indexOf(expression);
            if (index == -1) {
                if (parent.getUastParent() instanceof ULambdaExpression) {
                    return false;
                }
                PsiElement psiElement = expression.getPsi();
                return !LintUtils.isKotlin((Language)(psiElement != null ? psiElement.getLanguage() : null));
            }
            if (index < ((UBlockExpression)parent).getExpressions().size() - 1) {
                return true;
            }
            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)expression), UExpression.class, (boolean)true);
            if (uExpression == null) {
                return true;
            }
            UExpression parentExpression = uExpression;
            return this.isExpressionValueUnused(parentExpression);
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(CheckResultDetector.class, Scope.JAVA_FILE_SCOPE);
        CHECK_RESULT = Issue.Companion.create("CheckResult", "Ignoring results", "Some methods have no side effects, an calling them without doing something without the result is suspicious. ", Category.CORRECTNESS, 6, Severity.WARNING, CheckResultDetector.Companion.getIMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector$Companion;", "", "()V", "CHECK_RESULT", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

