/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002Jr\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/RangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "checkIntRange", "allAnnotations", "checkSize", "getArrayLength", "", "array", "", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class RangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue RANGE;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{"android.support.annotation.IntRange", "android.support.annotation.FloatRange", "android.support.annotation.Size", "android.support.annotation.IntDef", "android.support.annotation.LongDef"});
    }

    /*
     * Exception decompiling
     */
    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl44 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl44 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, List<? extends UAnnotation> allAnnotations) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            return;
        }
        String message = Companion.getIntRangeError(context, annotation, argument);
        if (message != null) {
            if (TypedefDetector.Companion.findIntDef(allAnnotations) != null) {
                return;
            }
            this.report(context, RANGE, argument, context.getLocation(argument), message);
        }
    }

    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            return;
        }
        FloatRangeConstraint constraint = FloatRangeConstraint.create(annotation);
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(object instanceof Number)) {
            PsiElement resolved;
            if (object instanceof float[] || object instanceof double[] || object instanceof int[] || object instanceof long[]) {
                Object message2;
                int n;
                Object[] objectArray;
                if (object instanceof float[]) {
                    objectArray = (float[])object;
                    for (n = 0; n < objectArray.length; ++n) {
                        float value = objectArray[n];
                        if (constraint.isValid(value)) continue;
                        String message2 = constraint.describe(value);
                        Location location = context.getLocation(argument);
                        String string = message2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                        this.report(context, RANGE, argument, location, string);
                        return;
                    }
                }
                if (object instanceof double[]) {
                    message2 = (double[])object;
                    for (int i = 0; i < ((double[])message2).length; ++i) {
                        double value = message2[i];
                        if (constraint.isValid(value)) continue;
                        String message3 = constraint.describe(value);
                        Location location = context.getLocation(argument);
                        String string = message3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                        this.report(context, RANGE, argument, location, string);
                        return;
                    }
                }
                if (object instanceof int[]) {
                    objectArray = (int[])object;
                    for (n = 0; n < objectArray.length; ++n) {
                        float value = objectArray[n];
                        if (constraint.isValid(value)) continue;
                        message2 = constraint.describe(value);
                        Location location = context.getLocation(argument);
                        Intrinsics.checkExpressionValueIsNotNull((Object)message2, (String)"message");
                        this.report(context, RANGE, argument, location, (String)message2);
                        return;
                    }
                }
                if (object instanceof long[]) {
                    message2 = (long[])object;
                    for (int i = 0; i < ((double[])message2).length; ++i) {
                        double value = message2[i];
                        if (constraint.isValid(value)) continue;
                        String message4 = constraint.describe(value);
                        Location location = context.getLocation(argument);
                        String string = message4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                        this.report(context, RANGE, argument, location, string);
                        return;
                    }
                }
            }
            if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                Boolean contains;
                RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                RangeConstraint here = RangeConstraint.create(annotation);
                if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                    String message = here.toString();
                    this.report(context, RANGE, argument, context.getLocation(argument), message);
                }
            }
            return;
        }
        double value = ((Number)object).doubleValue();
        if (!constraint.isValid(value)) {
            UElement uElement = argument;
            if (!(uElement instanceof UExpression)) {
                uElement = null;
            }
            String message = constraint.describe((UExpression)uElement, value);
            Location location = context.getLocation(argument);
            String string = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
            this.report(context, RANGE, argument, location, string);
        }
    }

    private final void checkSize(JavaContext context, UAnnotation annotation, UElement argument) {
        long actual;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            UElement uElement = argument;
            if (uElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            actual = ((UCallExpression)uElement).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                if (((UIfExpression)argument).getThenExpression() != null) {
                    UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                    if (uExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.checkSize(context, annotation, (UElement)uExpression);
                }
                if (((UIfExpression)argument).getElseExpression() != null) {
                    UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                    if (uExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.checkSize(context, annotation, (UElement)uExpression);
                }
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = this.getArrayLength(object);
                if (actual == -1L) {
                    PsiElement resolved;
                    if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                        Boolean contains;
                        RangeConstraint constraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                        RangeConstraint here = RangeConstraint.create(annotation);
                        if (here != null && constraint != null && (contains = here.contains(constraint)) != null && !contains.booleanValue()) {
                            String message = here.toString();
                            this.report(context, RANGE, argument, context.getLocation(argument), message);
                        }
                    }
                    return;
                }
            }
        }
        SizeConstraint constraint = SizeConstraint.create(annotation);
        if (!constraint.isValid(actual)) {
            String unit = isString ? "length" : "size";
            UElement uElement = argument;
            if (!(uElement instanceof UExpression)) {
                uElement = null;
            }
            String message = constraint.describe((UExpression)uElement, unit, actual);
            Location location = context.getLocation(argument);
            String string = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
            this.report(context, RANGE, argument, location, string);
        }
    }

    private final int getArrayLength(Object array) {
        Object object = array;
        return object instanceof int[] ? ((int[])array).length : (object instanceof long[] ? ((long[])array).length : (object instanceof float[] ? ((float[])array).length : (object instanceof double[] ? ((double[])array).length : (object instanceof char[] ? ((char[])array).length : (object instanceof byte[] ? ((byte[])array).length : (object instanceof short[] ? ((short[])array).length : (object instanceof Object[] ? ((Object[])array).length : -1)))))));
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RangeDetector.class, Scope.JAVA_FILE_SCOPE);
        RANGE = Issue.Companion.create("Range", "Outside Range", "Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, RangeDetector.Companion.getIMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ \u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/RangeDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "findIntRange", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "", "getIntRangeError", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "argument", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @Nullable
        public final UAnnotation findIntRange(@NotNull List<? extends UAnnotation> annotations) {
            Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
            for (UAnnotation uAnnotation : annotations) {
                if (!Intrinsics.areEqual((Object)"android.support.annotation.IntRange", (Object)uAnnotation.getQualifiedName())) continue;
                return uAnnotation;
            }
            return null;
        }

        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression expression : newExpression.getValueArguments()) {
                    String error = this.getIntRangeError(context, annotation, (UElement)expression);
                    if (error == null) continue;
                    return error;
                }
            }
            IntRangeConstraint constraint = IntRangeConstraint.create(annotation);
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                PsiElement resolved;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        int[] nArray = (int[])o;
                        for (int error = 0; error < nArray.length; ++error) {
                            int value = nArray[error];
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                    if (o instanceof long[]) {
                        long[] lArray = (long[])o;
                        for (int i = 0; i < lArray.length; ++i) {
                            long value = lArray[i];
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                    Boolean contains;
                    RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                    RangeConstraint here = RangeConstraint.create(annotation);
                    if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                        return here.toString();
                    }
                }
                return null;
            }
            long value = ((Number)o).longValue();
            return !constraint.isValid(value) ? constraint.describe(value) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

