/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class LeakDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"StaticFieldLeak", (String)"Static Field Leaks", (String)"A static field will leak contexts.\n\nNon-static inner classes have an implicit reference to their outer class. If that outer class is for example a `Fragment` or `Activity`, then this reference means that the long-running handler/loader/task will hold a reference to the activity which prevents it from getting garbage collected.\n\nSimilarly, direct field references to activities and fragments from these longer running instances can cause leaks.\n\nViewModel classes should never point to Views or non-application Contexts.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final List<String> SUPER_CLASSES = Arrays.asList("android.content.Loader", "android.support.v4.content.Loader", "android.os.AsyncTask", "android.arch.lifecycle.ViewModel");

    public List<String> applicableSuperClasses() {
        return SUPER_CLASSES;
    }

    public void visitClass(JavaContext context, UClass declaration) {
        String name;
        UMethod method;
        boolean isStatic;
        UClass containingClass = UastUtils.getContainingUClass((UElement)declaration);
        boolean isAnonymous = declaration instanceof UAnonymousClass;
        JavaEvaluator evaluator = context.getEvaluator();
        boolean bl = isStatic = evaluator.isStatic((PsiModifierListOwner)declaration) || containingClass == null;
        if (isStatic || isAnonymous) {
            for (UField field : declaration.getFields()) {
                LeakDetector.checkInstanceField(context, field);
            }
            if (!isAnonymous) {
                return;
            }
        }
        String superClass = null;
        for (String cls : SUPER_CLASSES) {
            if (!evaluator.inheritsFrom((PsiClass)declaration, cls, false)) continue;
            superClass = cls;
            break;
        }
        assert (superClass != null);
        UElement uastParent = declaration.getUastParent();
        if (uastParent != null && (method = (UMethod)UastUtils.getParentOfType((UElement)uastParent, UMethod.class, (boolean)true, (Class[])new Class[]{UClass.class, UObjectLiteralExpression.class})) != null && evaluator.isStatic((PsiModifierListOwner)method)) {
            return;
        }
        UCallExpression invocation = (UCallExpression)UastUtils.getParentOfType((UElement)declaration, UObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class});
        Location location = isAnonymous && invocation != null ? context.getCallLocation(invocation, false, false) : context.getNameLocation(declaration);
        if (isAnonymous) {
            name = "anonymous " + ((UAnonymousClass)declaration).getBaseClassReference().getQualifiedName();
        } else {
            name = declaration.getQualifiedName();
            if (name == null) {
                name = declaration.getName();
            }
        }
        String superClassName = superClass.substring(superClass.lastIndexOf(46) + 1);
        context.report(ISSUE, declaration, location, String.format("This %1$s class should be static or leaks might occur (%2$s)", superClassName, name));
    }

    private static void checkInstanceField(JavaContext context, UField field) {
        PsiType type = field.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        String fqn = type.getCanonicalText();
        if (fqn.startsWith("java.")) {
            return;
        }
        PsiClass cls = ((PsiClassType)type).resolve();
        if (cls == null) {
            return;
        }
        if (LeakDetector.isLeakCandidate(cls, context.getEvaluator())) {
            context.report(ISSUE, field, context.getLocation(field), "This field leaks a context object");
        }
    }

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UField.class);
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new FieldChecker(context);
    }

    private static boolean isAppContextName(PsiClass cls, PsiField field) {
        String lower;
        String name = field.getName();
        return name != null && ((lower = name.toLowerCase(Locale.US)).contains("appcontext") || lower.contains("application")) && "android.content.Context".equals(cls.getQualifiedName());
    }

    static boolean isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
        return evaluator.extendsClass(cls, "android.content.Context", false) && !evaluator.extendsClass(cls, "android.app.Application", false) || evaluator.extendsClass(cls, "android.view.View", false) || evaluator.extendsClass(cls, "android.app.Fragment", false);
    }

    private static class FieldChecker
    extends UElementHandler {
        private final JavaContext mContext;

        public FieldChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitField(UField field) {
            block6: {
                PsiClass cls;
                String fqn;
                PsiModifierList modifierList;
                block5: {
                    modifierList = field.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("static")) {
                        return;
                    }
                    PsiType type = field.getType();
                    if (!(type instanceof PsiClassType)) {
                        return;
                    }
                    fqn = type.getCanonicalText();
                    if (fqn.startsWith("java.")) {
                        return;
                    }
                    cls = ((PsiClassType)type).resolve();
                    if (cls == null) {
                        return;
                    }
                    if (!fqn.startsWith("android.")) break block5;
                    if (!LeakDetector.isLeakCandidate(cls, this.mContext.getEvaluator()) || LeakDetector.isAppContextName(cls, (PsiField)field) || this.isInitializedToAppContext(field)) break block6;
                    String message = "Do not place Android context classes in static fields; this is a memory leak (and also breaks Instant Run)";
                    this.report((PsiField)field, modifierList, message);
                    break block6;
                }
                int count = 0;
                for (PsiField referenced : cls.getAllFields()) {
                    PsiClass innerCls;
                    if (count++ == 20) break;
                    PsiType innerType = referenced.getType();
                    if (!(innerType instanceof PsiClassType) || (fqn = innerType.getCanonicalText()).startsWith("java.") || (innerCls = ((PsiClassType)innerType).resolve()) == null || !fqn.startsWith("android.") || !LeakDetector.isLeakCandidate(innerCls, this.mContext.getEvaluator()) || LeakDetector.isAppContextName(innerCls, (PsiField)field)) continue;
                    String message = "Do not place Android context classes in static fields (static reference to `" + cls.getName() + "` which has field `" + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); this is a memory leak (and also breaks Instant Run)";
                    this.report((PsiField)field, modifierList, message);
                    break;
                }
            }
        }

        private boolean isInitializedToAppContext(final UField field) {
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            for (PsiMethod method : containingClass.getConstructors()) {
                UExpression methodBody = this.mContext.getUastContext().getMethodBody(method);
                if (methodBody == null) continue;
                final Ref assignedToAppContext = new Ref((Object)false);
                methodBody.accept((UastVisitor)new AbstractUastVisitor(){

                    public boolean visitBinaryExpression(UBinaryExpression node) {
                        if (UastExpressionUtils.isAssignment((UElement)node) && node.getLeftOperand() instanceof UResolvable && field.getPsi().equals(((UResolvable)node.getLeftOperand()).resolve())) {
                            UCallExpression call;
                            UExpression rhs = node.getRightOperand();
                            while (rhs instanceof UQualifiedReferenceExpression) {
                                rhs = ((UQualifiedReferenceExpression)rhs).getSelector();
                            }
                            if (rhs instanceof UCallExpression && "getApplicationContext".equals(LintUtils.getMethodName((UCallExpression)(call = (UCallExpression)rhs)))) {
                                assignedToAppContext.set((Object)true);
                            }
                        }
                        return super.visitBinaryExpression(node);
                    }
                });
                if (!((Boolean)assignedToAppContext.get()).booleanValue()) continue;
                return true;
            }
            return false;
        }

        private void report(PsiField field, PsiModifierList modifierList, String message) {
            PsiField locationNode = field;
            if (modifierList.hasExplicitModifier("static")) {
                for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof PsiKeyword) || !"static".equals(child.getText())) continue;
                    locationNode = child;
                    break;
                }
            }
            Location location = this.mContext.getLocation((PsiElement)locationNode);
            this.mContext.report(ISSUE, (PsiElement)field, location, message);
        }
    }
}

