/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/DeletedProviderDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class DeletedProviderDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String JAVAX_CRYPTO_CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)GET_INSTANCE);
    }

    public void visitMethod(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Object object = method.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object qualifiedName = object;
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)JAVAX_CRYPTO_CIPHER) ^ true && Intrinsics.areEqual((Object)qualifiedName, (Object)"java.security.SecureRandom") ^ true) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        UExpression expression = (UExpression)arguments.get(1);
        PsiType expressionType = expression.getExpressionType();
        if (expressionType != null && Intrinsics.areEqual((Object)expressionType.getCanonicalText(), (Object)"java.lang.String") ^ true) {
            return;
        }
        Object value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)expression));
        if (Intrinsics.areEqual((Object)value, (Object)"Crypto")) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)expression), (Location)context.getLocation((UElement)expression), (String)"The Crypto provider has been deleted in Android P (and was deprecated in Android N), so the code will crash.", null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        Implementation implementation = new Implementation(DeletedProviderDetector.class, Scope.JAVA_FILE_SCOPE);
        Severity severity = Severity.ERROR;
        int n = 9;
        Category category = Category.SECURITY;
        String string = "https://android-developers.googleblog.com/2018/03/cryptography-changes-in-android-p.html";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DeletedProvider", (String)"Using Deleted Provider", (String)"\n                The `Crypto` provider has been completely removed in Android P (and was \\\n                deprecated in an earlier release). This means that the code will throw a \\\n                `NoSuchProviderException` and the app will crash. Even if the code catches \\\n                that exception at a higher level, this is not secure and should not be \\\n                used.\n                ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (int)256, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/DeletedProviderDetector$Companion;", "", "()V", "GET_INSTANCE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JAVAX_CRYPTO_CIPHER", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

