/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkRequiredAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "attribute", "validateNestedRestrictions", "", "restrictionType", "keys", "", "depth", "", "validateRestriction", "node", "Lorg/w3c/dom/Node;", "verifyRestrictionTagName", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class RestrictionsDetector
extends ResourceXmlDetector {
    public static final int MAX_NESTING_DEPTH = 20;
    public static final int MAX_NUMBER_OF_NESTED_RESTRICTIONS = 1000;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String TAG_RESTRICTIONS = "restrictions";
    private static final String TAG_RESTRICTION = "restriction";
    private static final String ATTR_RESTRICTION_TYPE = "restrictionType";
    private static final String ATTR_KEY = "key";
    @NotNull
    public static final String ATTR_DESCRIPTION = "description";
    private static final String VALUE_BUNDLE = "bundle";
    private static final String VALUE_BUNDLE_ARRAY = "bundle_array";
    private static final String VALUE_CHOICE = "choice";
    private static final String VALUE_MULTI_SELECT = "multi-select";
    private static final String VALUE_ENTRIES = "entries";
    private static final String VALUE_ENTRY_VALUES = "entryValues";
    private static final String VALUE_HIDDEN = "hidden";
    private static final String VALUE_DEFAULT_VALUE = "defaultValue";
    private static final String VALUE_INTEGER = "integer";
    public static final Companion Companion;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        HashMap keys;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        if (Intrinsics.areEqual((Object)TAG_RESTRICTIONS, (Object)root.getTagName()) ^ true) {
            return;
        }
        HashMap hashMap = keys = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"keys");
        this.validateNestedRestrictions(context, root, null, hashMap, 0);
    }

    private final void validateNestedRestrictions(XmlContext context, Element element, String restrictionType, Map<String, Element> keys, int depth) {
        boolean bl;
        boolean bl2 = bl = depth == 0 || restrictionType != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List children = Lint.getChildren((Node)element);
        if (depth == 0 || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
            String string;
            XmlContext xmlContext;
            Issue issue;
            Node node;
            Location location;
            Object[] objectArray;
            Object object;
            StringCompanionObject stringCompanionObject;
            Attr defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE);
            if (defaultValue != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                object = "Restriction type `%1$s` should not have a default value";
                objectArray = new Object[]{restrictionType};
                location = context.getLocation((Node)defaultValue);
                node = element;
                issue = ISSUE;
                xmlContext = context;
                String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                string = string2;
                XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)string, null, (int)16, null);
            }
            for (Element child : children) {
                if (!this.verifyRestrictionTagName(context, child)) continue;
                this.validateRestriction(context, child, depth + 1, keys);
            }
            if (depth != 0) {
                if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
                    if (children.size() != 1) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Expected exactly one child for restriction of type `bundle_array`", null, (int)16, null);
                    }
                } else {
                    boolean bl3 = Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE);
                    if (_Assertions.ENABLED && !bl3) {
                        object = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError(object));
                    }
                    if (children.isEmpty()) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Restriction type `bundle` should have at least one nested restriction", null, (int)16, null);
                    }
                }
            }
            if (children.size() > 1000) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                object = "Invalid nested restriction: too many nested restrictions (was %1$d, max %2$d)";
                objectArray = new Object[]{children.size(), 1000};
                location = context.getElementLocation(element);
                node = element;
                issue = ISSUE;
                xmlContext = context;
                String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                string = string3;
                XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)string, null, (int)16, null);
            } else if (depth > 20) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                object = "Invalid nested restriction: nesting depth %1$d too large (max %2$d";
                objectArray = new Object[]{depth, 20};
                location = context.getElementLocation(element);
                node = element;
                issue = ISSUE;
                xmlContext = context;
                String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                string = string4;
                XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)string, null, (int)16, null);
            }
        } else if (!children.isEmpty()) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)"Only restrictions of type `bundle` and `bundle_array` can have one or multiple nested restriction elements", null, (int)16, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void validateRestriction(XmlContext context, Node node, int depth, Map<String, Element> keys) {
        Attr defaultValue;
        Object thisAttribute;
        if (node.getNodeType() != 1) {
            return;
        }
        Node node2 = node;
        if (node2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
        }
        Element element = (Element)node2;
        String restrictionType = this.checkRequiredAttribute(context, element, ATTR_RESTRICTION_TYPE);
        String key = this.checkRequiredAttribute(context, element, ATTR_KEY);
        String title = this.checkRequiredAttribute(context, element, "title");
        if (restrictionType == null || key == null || title == null) {
            return;
        }
        if (StringsKt.startsWith$default((String)key, (String)"@string/", (boolean)false, (int)2, null)) {
            Attr attribute;
            Attr attr = attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)attr, (String)"attribute");
            Location valueLocation = context.getValueLocation(attr);
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)valueLocation, (String)"Keys cannot be localized, they should be specified with a string literal", null, (int)16, null);
        } else if (keys.containsKey(key)) {
            Attr prevAttribute;
            Object object = thisAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"thisAttribute");
            Location location = context.getValueLocation((Attr)object);
            Element element2 = keys.get(key);
            if (element2 == null) {
                return;
            }
            Element prev = element2;
            Attr attr = prevAttribute = prev.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)attr, (String)"prevAttribute");
            Location previousLocation = context.getValueLocation(attr);
            previousLocation.setMessage("Previous use of key here");
            location.setSecondary(previousLocation);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Duplicate key `%1$s`";
            Object[] objectArray = new Object[]{key};
            Location location2 = location;
            Node node3 = element;
            Issue issue = ISSUE;
            XmlContext xmlContext = context;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node3, (Location)location2, (String)string3, null, (int)16, null);
        } else {
            thisAttribute = keys;
            Element location = element;
            thisAttribute.put(key, location);
        }
        if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_CHOICE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_MULTI_SELECT)) {
            if (this.checkRequiredAttribute(context, element, VALUE_ENTRIES) == null && this.checkRequiredAttribute(context, element, VALUE_ENTRY_VALUES) == null) {
                // empty if block
            }
        } else if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_HIDDEN)) {
            this.checkRequiredAttribute(context, element, VALUE_DEFAULT_VALUE);
        } else if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_INTEGER) && (defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE)) != null) {
            String string = defaultValue.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"defaultValue.value");
            if (!StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) {
                try {
                    Integer.decode(defaultValue.getValue());
                }
                catch (NumberFormatException e) {
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(defaultValue), (String)"Invalid number", null, (int)16, null);
                }
            }
        }
        this.validateNestedRestrictions(context, element, restrictionType, keys, depth);
    }

    private final boolean verifyRestrictionTagName(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (Intrinsics.areEqual((Object)tagName, (Object)TAG_RESTRICTION) ^ true) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Unexpected tag `<%1$s>`, expected `<%2$s>`";
            Object[] objectArray = new Object[]{tagName, TAG_RESTRICTION};
            Location location = context.getNameLocation((Node)element);
            Node node = element;
            Issue issue = ISSUE;
            XmlContext xmlContext = context;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)string3, null, (int)16, null);
            return false;
        }
        return true;
    }

    private final String checkRequiredAttribute(XmlContext context, Element element, String attribute) {
        String fullAttribute = attribute;
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", fullAttribute)) {
            String prefix = element.getOwnerDocument().lookupNamespaceURI("http://schemas.android.com/apk/res/android");
            if (prefix == null) {
                Element root;
                Document document = element.getOwnerDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"element.ownerDocument");
                Element element2 = root = document.getDocumentElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"root");
                NamedNodeMap attributes = element2.getAttributes();
                NamedNodeMap namedNodeMap = attributes;
                Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = attributes.item(i);
                    if (node == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
                    }
                    Attr a = (Attr)node;
                    String string = a.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"xmlns:", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)a.getValue())) continue;
                    String string2 = a.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"a.name");
                    String string3 = string2;
                    int n2 = "xmlns:".length();
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    prefix = string5;
                    break;
                }
            }
            if (prefix != null) {
                fullAttribute = prefix + ":" + fullAttribute;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Missing required attribute `%1$s`";
            Object[] objectArray = new Object[]{fullAttribute};
            Location location = context.getElementLocation(element);
            Node node = element;
            Issue issue = ISSUE;
            XmlContext xmlContext = context;
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
            String string7 = string6;
            XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)string7, null, (int)16, null);
            return null;
        }
        return element.getAttributeNS("http://schemas.android.com/apk/res/android", fullAttribute);
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        Implementation implementation = new Implementation(RestrictionsDetector.class, Scope.RESOURCE_FILE_SCOPE);
        Severity severity = Severity.FATAL;
        int n = 5;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/reference/android/content/RestrictionsManager.html";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ValidRestrictions", (String)"Invalid Restrictions Descriptor", (String)"Ensures that an applications restrictions XML file is properly formed", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (int)256, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0016\u0010\f\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector$Companion;", "", "()V", "ATTR_DESCRIPTION", "", "ATTR_KEY", "ATTR_RESTRICTION_TYPE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAX_NESTING_DEPTH", "", "MAX_NESTING_DEPTH$annotations", "MAX_NUMBER_OF_NESTED_RESTRICTIONS", "MAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations", "TAG_RESTRICTION", "TAG_RESTRICTIONS", "VALUE_BUNDLE", "VALUE_BUNDLE_ARRAY", "VALUE_CHOICE", "VALUE_DEFAULT_VALUE", "VALUE_ENTRIES", "VALUE_ENTRY_VALUES", "VALUE_HIDDEN", "VALUE_INTEGER", "VALUE_MULTI_SELECT", "lint-checks"})
    public static final class Companion {
        public static /* synthetic */ void MAX_NESTING_DEPTH$annotations() {
        }

        public static /* synthetic */ void MAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

