/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/AllCapsDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class AllCapsDetector
extends LayoutDetector {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"textAllCaps");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        String rawXmlValue;
        String text;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI()) ^ true) {
            return;
        }
        if (Intrinsics.areEqual((Object)"true", (Object)attribute.getValue()) ^ true) {
            return;
        }
        String string = text = attribute.getOwnerElement().getAttributeNS("http://schemas.android.com/apk/res/android", "text");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            return;
        }
        ResourceUrl url = ResourceUrl.parse((String)text);
        if (url == null || url.isFramework()) {
            return;
        }
        LintClient client = context.getClient();
        Project project = context.getMainProject();
        ResourceRepository resourceRepository = client.getResourceRepository(project, true, true);
        if (resourceRepository == null) {
            return;
        }
        ResourceRepository repository = resourceRepository;
        List items = repository.getResources(ResourceNamespace.TODO(), url.type, url.name);
        if (items.isEmpty()) {
            return;
        }
        Object e = items.get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"items[0]");
        ResourceValue resourceValue = ((ResourceItem)e).getResourceValue();
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        String string2 = rawXmlValue = resourceValue2.getRawXmlValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rawXmlValue");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"<", (boolean)false, (int)2, null)) {
            String message2 = "Using `textAllCaps` with a string (`" + url.name + "`) that " + "contains markup; the markup will be dropped by the caps " + "conversion";
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message2, null, (int)16, null);
        }
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.Companion.create("AllCaps", "Combining textAllCaps and markup", "\n            The textAllCaps text transform will end up calling `toString` on the `CharSequence`, which has \\\n            the net effect of removing any markup such as `<b>`. This check looks for usages of strings \\\n            containing markup that also specify `textAllCaps=true`.", Category.TYPOGRAPHY, 8, Severity.WARNING, new Implementation(AllCapsDetector.class, Scope.ALL_RESOURCES_SCOPE, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE}));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/AllCapsDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

