/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.checks.Coordinate;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Project;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bJ\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J$\u0010\u0019\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J$\u0010\u001e\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bH\u0002J\u001e\u0010 \u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u001fH\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/BlacklistedDeps;", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/detector/api/Project;)V", "map", "", "Lcom/android/tools/lint/checks/Coordinate;", "", "Lcom/android/builder/model/Library;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "checkDependency", "groupId", "", "artifactId", "remove", "", "checkLibrary", "", "stack", "Ljava/util/ArrayDeque;", "library", "getBlacklistedDependencies", "isBlacklistedDependency", "visitAndroidLibraries", "libraries", "", "Lcom/android/builder/model/AndroidLibrary;", "visitAndroidLibrary", "visitJavaLibraries", "Lcom/android/builder/model/JavaLibrary;", "visitJavaLibrary", "lint-checks"})
public final class BlacklistedDeps {
    private Map<Coordinate, List<Library>> map;
    @NotNull
    private final Project project;

    @Nullable
    public final List<Library> checkDependency(@NotNull String groupId, @NotNull String artifactId, boolean remove) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Map<Coordinate, List<Library>> map = this.map;
        if (map == null) {
            return null;
        }
        Map<Coordinate, List<Library>> map2 = map;
        Coordinate coordinate = new Coordinate(groupId, artifactId);
        List<Library> list = map2.get(coordinate);
        if (list == null) {
            return null;
        }
        List<Library> path = list;
        if (remove) {
            map2.remove(coordinate);
        }
        return path;
    }

    @NotNull
    public final List<List<Library>> getBlacklistedDependencies() {
        Iterable $receiver$iv;
        Map<Coordinate, List<Library>> map = this.map;
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<Coordinate, List<Library>> map2 = map;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.toMutableList(map2.values());
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                List it = (List)a;
                MavenCoordinates mavenCoordinates = ((Library)it.get(0)).getResolvedCoordinates();
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"it[0].resolvedCoordinates");
                it = (List)b;
                Comparable comparable = (Comparable)((Object)mavenCoordinates.getGroupId());
                MavenCoordinates mavenCoordinates2 = ((Library)it.get(0)).getResolvedCoordinates();
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates2, (String)"it[0].resolvedCoordinates");
                String string = mavenCoordinates2.getGroupId();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private final void visitAndroidLibraries(ArrayDeque<Library> stack, Collection<? extends AndroidLibrary> libraries) {
        for (AndroidLibrary androidLibrary : libraries) {
            this.visitAndroidLibrary(stack, androidLibrary);
        }
    }

    private final void visitJavaLibraries(ArrayDeque<Library> stack, Collection<? extends JavaLibrary> libraries) {
        for (JavaLibrary javaLibrary : libraries) {
            this.visitJavaLibrary(stack, javaLibrary);
        }
    }

    private final void visitAndroidLibrary(ArrayDeque<Library> stack, AndroidLibrary library) {
        stack.addLast((Library)library);
        this.checkLibrary(stack, (Library)library);
        List list = library.getLibraryDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"library.libraryDependencies");
        this.visitAndroidLibraries(stack, list);
        Collection collection = library.getJavaDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"library.javaDependencies");
        this.visitJavaLibraries(stack, collection);
        stack.removeLast();
    }

    private final void visitJavaLibrary(ArrayDeque<Library> stack, JavaLibrary library) {
        stack.addLast((Library)library);
        this.checkLibrary(stack, (Library)library);
        List list = library.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"library.dependencies");
        this.visitJavaLibraries(stack, list);
        stack.removeLast();
    }

    private final void checkLibrary(ArrayDeque<Library> stack, Library library) {
        block4: {
            if (library.isProvided()) {
                return;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (coordinates == null || coordinates.getGroupId() == null || coordinates.getArtifactId() == null) {
                return;
            }
            String string = coordinates.getGroupId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coordinates.groupId");
            String string2 = coordinates.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"coordinates.artifactId");
            if (!this.isBlacklistedDependency(string, string2)) break block4;
            if (this.map == null) {
                this.map = new HashMap();
            }
            Library library2 = stack.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"stack.first");
            MavenCoordinates root = library2.getResolvedCoordinates();
            Map<Coordinate, List<Library>> map = this.map;
            if (map != null) {
                MavenCoordinates mavenCoordinates = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"root");
                String string3 = mavenCoordinates.getGroupId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"root.groupId");
                String string4 = root.getArtifactId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"root.artifactId");
                List cfr_ignored_0 = map.put(new Coordinate(string3, string4), new ArrayList(stack));
            }
        }
    }

    private final boolean isBlacklistedDependency(String groupId, String artifactId) {
        switch (groupId) {
            case "org.apache.httpcomponents": {
                return Intrinsics.areEqual((Object)"httpclient", (Object)artifactId);
            }
            case "xpp3": {
                return Intrinsics.areEqual((Object)"xpp3", (Object)artifactId);
            }
            case "commons-logging": {
                return Intrinsics.areEqual((Object)"commons-logging", (Object)artifactId);
            }
            case "xerces": {
                return Intrinsics.areEqual((Object)"xmlParserAPIs", (Object)artifactId);
            }
            case "org.json": {
                return Intrinsics.areEqual((Object)"json", (Object)artifactId);
            }
            case "org.khronos": {
                return Intrinsics.areEqual((Object)"opengl-api", (Object)artifactId);
            }
            case "com.google.android": {
                return Intrinsics.areEqual((Object)"android", (Object)artifactId);
            }
        }
        return false;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public BlacklistedDeps(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Dependencies dependencies = GradleDetector.Companion.getCompileDependencies(this.project);
        if (dependencies != null) {
            ArrayDeque<Library> stack = new ArrayDeque<Library>();
            Collection collection = dependencies.getLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"dependencies.libraries");
            this.visitAndroidLibraries(stack, collection);
            Collection collection2 = dependencies.getJavaLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"dependencies.javaLibraries");
            this.visitJavaLibraries(stack, collection2);
        }
    }
}

