/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0019\u0018\u0000 02\u00020\u00012\u00020\u0002:\u0003/01B\u0005\u00a2\u0006\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J2\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J0\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\fH\u0002J2\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\f2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J \u0010,\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0010H\u0016J \u0010.\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "callsCommit", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "checker", "Lkotlin/Function2;", "Lorg/jetbrains/uast/UCallExpression;", "checkEditorApplied", "", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "checkRecycled", "recycleType", "", "recycleName", "checkResourceRecycled", "method", "checkTransactionCommits", "getApplicableConstructorTypes", "", "getApplicableMethodNames", "isBeginTransaction", "isCommittedInChainedCalls", "isCommitCall", "isEditorApplyMethodCall", "call", "isEditorCommitMethodCall", "isEditorCommittedInChainedCalls", "isMethodOnFragmentClass", "fragmentClass", "v4FragmentClass", "returnForUnresolved", "isSharedEditorCreation", "isShowFragmentMethodCall", "isTransactionCommitMethodCall", "lastArgCallsCommit", "methodInvocation", "suggestApplyIfApplicable", "visitConstructor", "constructor", "visitMethodCall", "CommitCallVisitor", "Companion", "FinishVisitor", "lint-checks"})
public final class CleanupDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue RECYCLE_RESOURCE;
    @JvmField
    @NotNull
    public static final Issue COMMIT_FRAGMENT;
    @JvmField
    @NotNull
    public static final Issue SHARED_PREF;
    @JvmField
    @NotNull
    public static final Issue APPLY_SHARED_PREF;
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_NOW = "commitNow";
    private static final String APPLY = "apply";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String EDIT = "edit";
    @NotNull
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    @NotNull
    public static final String SURFACE_CLS = "android.view.Surface";
    @NotNull
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    @NotNull
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    @NotNull
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    @NotNull
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    @NotNull
    public static final String CURSOR_CLS = "android.database.Cursor";
    @NotNull
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, EDIT);
    }

    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object[])new String[]{SURFACE_TEXTURE_CLS, SURFACE_CLS});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)name)) {
            this.checkTransactionCommits(context, node, method);
        } else if (Intrinsics.areEqual((Object)EDIT, (Object)name)) {
            this.checkEditorApplied(context, node, method);
        } else {
            this.checkResourceRecycled(context, node, method);
        }
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        Object object = constructor.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"constructor.containingCl\u2026?.qualifiedName ?: return");
        Object type = object;
        this.checkRecycled(context, node, (String)type, RELEASE);
    }

    private final void checkResourceRecycled(JavaContext context, UCallExpression node, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return");
        PsiClass containingClass = psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        if ((Intrinsics.areEqual((Object)OBTAIN, (Object)name) || Intrinsics.areEqual((Object)OBTAIN_NO_HISTORY, (Object)name)) && evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
            this.checkRecycled(context, node, MOTION_EVENT_CLS, RECYCLE);
        } else if (Intrinsics.areEqual((Object)OBTAIN, (Object)name) && evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
            this.checkRecycled(context, node, PARCEL_CLS, RECYCLE);
        } else if (Intrinsics.areEqual((Object)OBTAIN, (Object)name) && evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) {
            this.checkRecycled(context, node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((Intrinsics.areEqual((Object)OBTAIN_STYLED_ATTRIBUTES, (Object)name) || Intrinsics.areEqual((Object)OBTAIN_ATTRIBUTES, (Object)name) || Intrinsics.areEqual((Object)OBTAIN_TYPED_ARRAY, (Object)name)) && (evaluator.extendsClass(containingClass, "android.content.Context", false) || evaluator.extendsClass(containingClass, "android.content.res.Resources", false))) {
            PsiClass cls;
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiClassType && (cls = ((PsiClassType)returnType).resolve()) != null && Intrinsics.areEqual((Object)"android.content.res.TypedArray", (Object)cls.getQualifiedName())) {
                this.checkRecycled(context, node, "android.content.res.TypedArray", RECYCLE);
            }
        } else if (Intrinsics.areEqual((Object)ACQUIRE_CPC, (Object)name) && evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) {
            this.checkRecycled(context, node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((Intrinsics.areEqual((Object)QUERY, (Object)name) || Intrinsics.areEqual((Object)RAW_QUERY, (Object)name) || Intrinsics.areEqual((Object)QUERY_WITH_FACTORY, (Object)name) || Intrinsics.areEqual((Object)RAW_QUERY_WITH_FACTORY, (Object)name)) && (evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) || evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) || evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) || evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false))) {
            for (UElement curr = (UElement)node; curr != null; curr = curr.getUastParent()) {
                PsiElement psi = curr.getSourcePsi();
                if (psi == null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) == null) break;
                return;
            }
            this.checkRecycled(context, node, CURSOR_CLS, CLOSE);
        }
    }

    private final void checkRecycled(JavaContext context, UCallExpression node, String recycleType, String recycleName) {
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        AtomicBoolean recycled = new AtomicBoolean(false);
        AtomicBoolean escapes = new AtomicBoolean(false);
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(recycled, recycleName, context, recycleType, escapes, node, SetsKt.setOf((Object)node), CollectionsKt.emptyList()){
            final /* synthetic */ AtomicBoolean $recycled;
            final /* synthetic */ String $recycleName;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ String $recycleType;
            final /* synthetic */ AtomicBoolean $escapes;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (this.isCleanup(call)) {
                    this.$recycled.set(true);
                }
                super.receiver(call);
            }

            private final boolean isCleanup(UCallExpression call) {
                String methodName = Lint.getMethodName((UCallExpression)call);
                if (Intrinsics.areEqual((Object)"use", (Object)methodName) && Intrinsics.areEqual((Object)"close", (Object)this.$recycleName)) {
                    PsiElement resolved;
                    UExpression operand = call.getReceiver();
                    if (operand != null && this.getInstances().contains(operand)) {
                        return true;
                    }
                    if (operand instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && CollectionsKt.contains((Iterable)this.getReferences(), (Object)resolved)) {
                        return true;
                    }
                }
                if (Intrinsics.areEqual((Object)this.$recycleName, (Object)methodName) ^ true) {
                    return false;
                }
                PsiMethod resolved = call.resolve();
                if (resolved != null) {
                    PsiClass containingClass = resolved.getContainingClass();
                    return this.$context.getEvaluator().extendsClass(containingClass, this.$recycleType, false);
                }
                return false;
            }

            public void field(@NotNull UElement field) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                this.$escapes.set(true);
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                PsiMethod resolved;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                if (Intrinsics.areEqual((Object)this.$recycleType, (Object)"android.graphics.SurfaceTexture") && UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && (resolved = call.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.Surface")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)"obtain", (Object)Lint.getMethodName((UCallExpression)call))) {
                    resolved = call.resolve();
                    if (this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.MotionEvent")) {
                        return;
                    }
                }
                this.$escapes.set(true);
            }

            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.$escapes.set(true);
            }
            {
                this.$recycled = $captured_local_variable$0;
                this.$recycleName = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$recycleType = $captured_local_variable$3;
                this.$escapes = $captured_local_variable$4;
                this.$node = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7);
            }
        };
        method.accept((UastVisitor)visitor2);
        if (!recycled.get() && !escapes.get()) {
            String string;
            Object[] objectArray;
            String string2;
            StringCompanionObject stringCompanionObject;
            String string3 = recycleType;
            int n = StringsKt.lastIndexOf$default((CharSequence)recycleType, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String className = string5;
            if (Intrinsics.areEqual((Object)RECYCLE, (Object)recycleName)) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "This `%1$s` should be recycled after use with `#recycle()`";
                objectArray = new Object[]{className};
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
            } else {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "This `%1$s` should be freed up after use with `#%2$s()`";
                objectArray = new Object[]{className, recycleName};
                String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
            }
            String message2 = string;
            UElement locationNode = (UElement)node.getMethodIdentifier();
            if (locationNode == null) {
                locationNode = (UElement)node;
            }
            Location location = context.getLocation(locationNode);
            JavaContext.report$default((JavaContext)context, (Issue)RECYCLE_RESOURCE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
        }
    }

    private final void checkTransactionCommits(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context, calledMethod)) {
            PsiVariable boundVariable = Companion.getVariableElement(node, true, true);
            if (this.isCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) {
                    return;
                }
                UMethod method = uMethod;
                FinishVisitor commitVisitor2 = new FinishVisitor(this, context, boundVariable, context, boundVariable){
                    final /* synthetic */ CleanupDetector this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ PsiVariable $boundVariable;

                    protected boolean isCleanupCall(@NotNull UCallExpression call) {
                        UExpression first;
                        PsiElement resolved;
                        List arguments;
                        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                        if (CleanupDetector.access$isTransactionCommitMethodCall(this.this$0, this.getContext(), call)) {
                            List chain = UastUtils.getQualifiedChain((UExpression)((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)call))));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand = (UExpression)chain.get(0);
                            if (operand != null) {
                                PsiElement resolved2 = UastUtils.tryResolve((UElement)((UElement)operand));
                                if (resolved2 != null && CollectionsKt.contains((Iterable)this.getVariables(), (Object)resolved2)) {
                                    return true;
                                }
                                if (resolved2 instanceof PsiMethod && operand instanceof UCallExpression && CleanupDetector.access$isCommittedInChainedCalls(this.this$0, this.getContext(), (UCallExpression)operand)) {
                                    while (operand instanceof UCallExpression) {
                                        operand = ((UCallExpression)operand).getReceiver();
                                    }
                                    if (operand instanceof UResolvable && (resolved2 = ((UResolvable)operand).resolve()) != null && CollectionsKt.contains((Iterable)this.getVariables(), (Object)resolved2)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.access$isShowFragmentMethodCall(this.this$0, this.getContext(), call) && (arguments = call.getValueArguments()).size() == 2 && (resolved = UastUtils.tryResolve((UElement)((UElement)(first = (UExpression)arguments.get(0))))) != null && CollectionsKt.contains((Iterable)this.getVariables(), (Object)resolved)) {
                            return true;
                        }
                        return false;
                    }
                    {
                        this.this$0 = $outer;
                        this.$context = $captured_local_variable$1;
                        this.$boundVariable = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4);
                    }
                };
                method.accept((UastVisitor)commitVisitor2);
                if (commitVisitor2.isCleanedUp() || commitVisitor2.variableEscapes()) {
                    return;
                }
            }
            String message2 = "This transaction should be completed with a `commit()` call";
            JavaContext.report$default((JavaContext)context, (Issue)COMMIT_FRAGMENT, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
        }
    }

    private final boolean isCommittedInChainedCalls(JavaContext context, UCallExpression node) {
        Function2 checker2 = (Function2)new Function2<JavaContext, UCallExpression, Boolean>(this){
            final /* synthetic */ CleanupDetector this$0;

            public final boolean invoke(@NotNull JavaContext c, @NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                return CleanupDetector.access$isTransactionCommitMethodCall(this.this$0, c, call) || CleanupDetector.access$isShowFragmentMethodCall(this.this$0, c, call);
            }
            {
                this.this$0 = cleanupDetector;
                super(2);
            }
        };
        return this.isCommittedInChainedCalls(context, node, (Function2<? super JavaContext, ? super UCallExpression, Boolean>)checker2);
    }

    private final boolean isTransactionCommitMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        return (Intrinsics.areEqual((Object)COMMIT, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW, (Object)methodName)) && this.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private final boolean isShowFragmentMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        return Intrinsics.areEqual((Object)SHOW, (Object)methodName) && this.isMethodOnFragmentClass(context, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private final boolean isMethodOnFragmentClass(JavaContext context, UCallExpression call, String fragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        boolean bl;
        PsiMethod method = call.resolve();
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            bl = evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
        } else {
            bl = returnForUnresolved;
        }
        return bl;
    }

    private final void checkEditorApplied(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isSharedEditorCreation(context, calledMethod)) {
            if (!node.getValueArguments().isEmpty()) {
                return;
            }
            PsiVariable boundVariable = Companion.getVariableElement(node, true, true);
            if (this.isEditorCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) {
                    return;
                }
                UMethod method = uMethod;
                FinishVisitor commitVisitor2 = new FinishVisitor(this, context, boundVariable, context, boundVariable){
                    final /* synthetic */ CleanupDetector this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ PsiVariable $boundVariable;

                    protected boolean isCleanupCall(@NotNull UCallExpression call) {
                        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                        if (CleanupDetector.access$isEditorApplyMethodCall(this.this$0, this.getContext(), call) || CleanupDetector.access$isEditorCommitMethodCall(this.this$0, this.getContext(), call)) {
                            List chain = UastUtils.getQualifiedChain((UExpression)((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)call))));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand = (UExpression)chain.get(0);
                            if (operand != null) {
                                PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)operand));
                                if (resolved != null && CollectionsKt.contains((Iterable)this.getVariables(), (Object)resolved)) {
                                    return true;
                                }
                                if (resolved instanceof PsiMethod && operand instanceof UCallExpression && CleanupDetector.access$isEditorCommittedInChainedCalls(this.this$0, this.getContext(), (UCallExpression)operand)) {
                                    while (operand instanceof UCallExpression) {
                                        operand = ((UCallExpression)operand).getReceiver();
                                    }
                                    if (operand instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && CollectionsKt.contains((Iterable)this.getVariables(), (Object)resolved)) {
                                        return true;
                                    }
                                }
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = $outer;
                        this.$context = $captured_local_variable$1;
                        this.$boundVariable = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4);
                    }
                };
                method.accept((UastVisitor)commitVisitor2);
                if (commitVisitor2.isCleanedUp() || commitVisitor2.variableEscapes()) {
                    return;
                }
            } else if (UastUtils.getParentOfType$default((UElement)((UElement)node), UReturnExpression.class, (boolean)false, (int)2, null) != null) {
                return;
            }
            String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
            JavaContext.report$default((JavaContext)context, (Issue)SHARED_PREF, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)message2, null, (int)16, null);
        }
    }

    private final boolean isSharedEditorCreation(JavaContext context, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)EDIT, (Object)methodName)) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return false");
            PsiClass containingClass = psiClass;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"method.returnType ?: return false");
            PsiType type = psiType;
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches(type, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private final boolean isEditorCommittedInChainedCalls(JavaContext context, UCallExpression node) {
        Function2 checker2 = (Function2)new Function2<JavaContext, UCallExpression, Boolean>(this){
            final /* synthetic */ CleanupDetector this$0;

            public final boolean invoke(@NotNull JavaContext c, @NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                return CleanupDetector.access$isEditorCommitMethodCall(this.this$0, c, call) || CleanupDetector.access$isEditorApplyMethodCall(this.this$0, c, call);
            }
            {
                this.this$0 = cleanupDetector;
                super(2);
            }
        };
        return this.isCommittedInChainedCalls(context, node, (Function2<? super JavaContext, ? super UCallExpression, Boolean>)checker2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCommittedInChainedCalls(JavaContext context, UCallExpression node, Function2<? super JavaContext, ? super UCallExpression, Boolean> isCommitCall) {
        String methodName;
        UCallExpression parentCall;
        List chain = UastUtils.getQualifiedChain((UExpression)((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)node))));
        if (!chain.isEmpty()) {
            void i;
            UExpression call;
            UExpression lastExpression = (UExpression)chain.get(chain.size() - 1);
            if (lastExpression instanceof UCallExpression) {
                if (((Boolean)isCommitCall.invoke((Object)context, (Object)lastExpression)).booleanValue()) {
                    return true;
                }
                if (this.lastArgCallsCommit(context, (UCallExpression)lastExpression, isCommitCall)) {
                    return true;
                }
            }
            int n = chain.size() - 2;
            int n2 = 1;
            while (n >= n2 && (call = (UExpression)chain.get((int)i)) != node && call instanceof UCallExpression) {
                if (((Boolean)isCommitCall.invoke((Object)context, (Object)call)).booleanValue()) {
                    return true;
                }
                --i;
            }
        }
        if ((parentCall = (UCallExpression)UastUtils.getParentOfType$default((UElement)((UElement)node), UCallExpression.class, (boolean)false, (int)2, null)) != null && Intrinsics.areEqual((Object)"with", (Object)(methodName = Lint.getMethodName((UCallExpression)parentCall)))) {
            List args = parentCall.getValueArguments();
            return args.size() == 2 && this.lastArgCallsCommit(context, parentCall, isCommitCall);
        }
        return false;
    }

    private final boolean isEditorCommitMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        if (Intrinsics.areEqual((Object)COMMIT, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context.getEvaluator();
                if (evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false)) {
                    this.suggestApplyIfApplicable(context, call);
                    return true;
                }
            } else if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean isEditorApplyMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        if (Intrinsics.areEqual((Object)APPLY, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context.getEvaluator();
                return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false);
            }
            if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final void suggestApplyIfApplicable(JavaContext context, UCallExpression node) {
        AndroidVersion androidVersion = context.getProject().getMinSdkVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.project.minSdkVersion");
        if (androidVersion.getApiLevel() >= 9) {
            UExpression condition;
            UElement qualifiedNode = (UElement)node;
            UElement parent = Lint.skipParentheses((UElement)node.getUastParent());
            while (parent instanceof UReferenceExpression) {
                qualifiedNode = parent;
                parent = Lint.skipParentheses((UElement)parent.getUastParent());
            }
            boolean returnValueIgnored = true;
            if (parent instanceof UCallExpression || parent instanceof UVariable || parent instanceof UPolyadicExpression || parent instanceof UUnaryExpression || parent instanceof UReturnExpression) {
                returnValueIgnored = false;
            } else if (parent instanceof UIfExpression) {
                condition = ((UIfExpression)parent).getCondition();
                returnValueIgnored = Intrinsics.areEqual((Object)condition, (Object)qualifiedNode) ^ true;
            } else if (parent instanceof UWhileExpression) {
                condition = ((UWhileExpression)parent).getCondition();
                returnValueIgnored = Intrinsics.areEqual((Object)condition, (Object)qualifiedNode) ^ true;
            } else if (parent instanceof UDoWhileExpression) {
                condition = ((UDoWhileExpression)parent).getCondition();
                returnValueIgnored = Intrinsics.areEqual((Object)condition, (Object)qualifiedNode) ^ true;
            }
            if (returnValueIgnored) {
                String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
                Location location = context.getLocation((UElement)node);
                LintFix fix = LintFix.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
                context.report(APPLY_SHARED_PREF, (UElement)node, location, message2, fix);
            }
        }
    }

    private final boolean isBeginTransaction(JavaContext context, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    private final boolean lastArgCallsCommit(JavaContext context, UCallExpression methodInvocation, Function2<? super JavaContext, ? super UCallExpression, Boolean> checker2) {
        UExpression last;
        List args = methodInvocation.getValueArguments();
        if (!args.isEmpty() && (last = (UExpression)args.get(args.size() - 1)) instanceof ULambdaExpression) {
            UExpression body = ((ULambdaExpression)last).getBody();
            return this.callsCommit(context, (UElement)body, checker2);
        }
        return false;
    }

    private final boolean callsCommit(JavaContext context, UElement node, Function2<? super JavaContext, ? super UCallExpression, Boolean> checker2) {
        CommitCallVisitor visitor2 = new CommitCallVisitor(context, checker2);
        node.accept((UastVisitor)visitor2);
        return visitor2.isFound();
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Severity severity = Severity.WARNING;
        int n = 7;
        Boolean bl2 = true;
        String string = null;
        Category category = Category.PERFORMANCE;
        RECYCLE_RESOURCE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Recycle", (String)"Missing `recycle()` calls", (String)"\n                Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled \\\n                (with a `recycle()` call) after use. This lint check looks for missing \\\n                `recycle()` calls.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        severity = Severity.WARNING;
        n = 7;
        bl2 = true;
        string = null;
        category = Category.CORRECTNESS;
        COMMIT_FRAGMENT = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"CommitTransaction", (String)"Missing `commit()` calls", (String)"\n                After creating a `FragmentTransaction`, you typically need to commit it as well\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        severity = Severity.WARNING;
        n = 6;
        bl2 = true;
        string = null;
        category = Category.CORRECTNESS;
        SHARED_PREF = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"CommitPrefEdits", (String)"Missing `commit()` on `SharedPreference` editor", (String)"\n                After calling `edit()` on a `SharedPreference`, you must call `commit()` or \\\n                `apply()` on the editor to save the results.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        severity = Severity.WARNING;
        n = 6;
        bl2 = true;
        string = null;
        category = Category.CORRECTNESS;
        APPLY_SHARED_PREF = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ApplySharedPref", (String)"Use `apply()` on `SharedPreferences`", (String)"\n                Consider using `apply()` instead of `commit` on shared preferences. Whereas \\\n                `commit` blocks and writes its data to persistent storage immediately, `apply` \\\n                will handle it in the background.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    public static final /* synthetic */ boolean access$isTransactionCommitMethodCall(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression call) {
        return $this.isTransactionCommitMethodCall(context, call);
    }

    public static final /* synthetic */ boolean access$isCommittedInChainedCalls(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression node) {
        return $this.isCommittedInChainedCalls(context, node);
    }

    public static final /* synthetic */ boolean access$isShowFragmentMethodCall(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression call) {
        return $this.isShowFragmentMethodCall(context, call);
    }

    public static final /* synthetic */ boolean access$isEditorApplyMethodCall(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression call) {
        return $this.isEditorApplyMethodCall(context, call);
    }

    public static final /* synthetic */ boolean access$isEditorCommitMethodCall(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression call) {
        return $this.isEditorCommitMethodCall(context, call);
    }

    public static final /* synthetic */ boolean access$isEditorCommittedInChainedCalls(CleanupDetector $this, @NotNull JavaContext context, @NotNull UCallExpression node) {
        return $this.isEditorCommittedInChainedCalls(context, node);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
        return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(Companion, rhs, allowChainedCalls, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
        return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(Companion, rhs, false, false, 6, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H$J\u0006\u0010\u0017\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$FinishVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "originalVariableNode", "Lcom/intellij/psi/PsiVariable;", "(Lcom/android/tools/lint/detector/api/JavaContext;Lcom/intellij/psi/PsiVariable;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "escapes", "", "<set-?>", "isCleanedUp", "()Z", "setCleanedUp", "(Z)V", "variables", "", "getVariables", "()Ljava/util/List;", "isCleanupCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "variableEscapes", "visitBinaryExpression", "node", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitElement", "Lorg/jetbrains/uast/UElement;", "visitMethodCallExpression", "", "visitReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "visitVariable", "Lorg/jetbrains/uast/UVariable;", "lint-checks"})
    private static abstract class FinishVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final List<PsiVariable> variables;
        private boolean isCleanedUp;
        private boolean escapes;
        @NotNull
        private final JavaContext context;
        private final PsiVariable originalVariableNode;

        @NotNull
        protected final List<PsiVariable> getVariables() {
            return this.variables;
        }

        public final boolean isCleanedUp() {
            return this.isCleanedUp;
        }

        private final void setCleanedUp(boolean bl) {
            this.isCleanedUp = bl;
        }

        public final boolean variableEscapes() {
            return this.escapes;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.isCleanedUp || super.visitElement(node);
        }

        protected abstract boolean isCleanupCall(@NotNull UCallExpression var1);

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (node.getKind() == UastCallKind.METHOD_CALL) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private final void visitMethodCallExpression(UCallExpression call) {
            if (this.isCleanedUp) {
                return;
            }
            if (!this.escapes) {
                for (UExpression expression : call.getValueArguments()) {
                    PsiElement resolved;
                    if (!(expression instanceof UResolvable) || (resolved = ((UResolvable)expression).resolve()) == null || !CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) continue;
                    boolean wasEscaped = this.escapes;
                    this.escapes = true;
                    if (!Intrinsics.areEqual((Object)CleanupDetector.OBTAIN, (Object)Lint.getMethodName((UCallExpression)call))) continue;
                    PsiMethod method = call.resolve();
                    if (!this.context.getEvaluator().isMemberInClass((PsiMember)method, CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.escapes = wasEscaped;
                }
            }
            if (this.isCleanupCall(call)) {
                this.isCleanedUp = true;
            }
        }

        public boolean visitVariable(@NotNull UVariable node) {
            block2: {
                PsiVariable psi;
                PsiElement resolved;
                UExpression initializer;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!(node instanceof ULocalVariable) || !((initializer = node.getUastInitializer()) instanceof UResolvable) || (resolved = ((UResolvable)initializer).resolve()) == null || !CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) break block2;
                PsiElement psiElement = node.getSourcePsi();
                if (!(psiElement instanceof PsiVariable)) {
                    psiElement = null;
                }
                PsiVariable psiVariable = psi = (PsiVariable)psiElement;
                if (psiVariable != null) {
                    PsiVariable psiVariable2;
                    PsiVariable it = psiVariable2 = psiVariable;
                    this.variables.add(it);
                }
            }
            return super.visitVariable(node);
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            PsiElement resolved;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (!UastExpressionUtils.isAssignment((UElement)((UElement)node))) {
                return super.visitBinaryExpression(node);
            }
            boolean clearLhs = false;
            UExpression rhs = node.getRightOperand();
            if (rhs instanceof UResolvable && (resolved = ((UResolvable)rhs).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                clearLhs = false;
                PsiElement lhs = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
                if (lhs instanceof PsiLocalVariable) {
                    this.variables.add((PsiVariable)lhs);
                } else if (lhs instanceof PsiField) {
                    this.escapes = true;
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitReturnExpression(@NotNull UReturnExpression node) {
            PsiElement resolved;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UExpression returnValue = node.getReturnExpression();
            if (returnValue instanceof UResolvable && (resolved = ((UResolvable)returnValue).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                this.escapes = true;
            }
            return super.visitReturnExpression(node);
        }

        @NotNull
        protected final JavaContext getContext() {
            return this.context;
        }

        public FinishVisitor(@NotNull JavaContext context, @NotNull PsiVariable originalVariableNode) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)originalVariableNode, (String)"originalVariableNode");
            this.context = context;
            this.originalVariableNode = originalVariableNode;
            ArrayList arrayList = Lists.newArrayList((Object[])new PsiVariable[]{this.originalVariableNode});
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(originalVariableNode)");
            this.variables = arrayList;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$CommitCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "isCommitCall", "Lkotlin/Function2;", "Lorg/jetbrains/uast/UCallExpression;", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Lkotlin/jvm/functions/Function2;)V", "<set-?>", "isFound", "()Z", "setFound", "(Z)V", "visitCallExpression", "node", "lint-checks"})
    private static final class CommitCallVisitor
    extends AbstractUastVisitor {
        private boolean isFound;
        private final JavaContext context;
        private final Function2<JavaContext, UCallExpression, Boolean> isCommitCall;

        public final boolean isFound() {
            return this.isFound;
        }

        private final void setFound(boolean bl) {
            this.isFound = bl;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (((Boolean)this.isCommitCall.invoke((Object)this.context, (Object)node)).booleanValue()) {
                this.isFound = true;
            }
            return super.visitCallExpression(node);
        }

        public CommitCallVisitor(@NotNull JavaContext context, @NotNull Function2<? super JavaContext, ? super UCallExpression, Boolean> isCommitCall) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(isCommitCall, (String)"isCommitCall");
            this.context = context;
            this.isCommitCall = isCommitCall;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u000206H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$Companion;", "", "()V", "ACQUIRE_CPC", "", "ANDROID_CONTENT_SHARED_PREFERENCES", "ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR", "APPLY", "APPLY_SHARED_PREF", "Lcom/android/tools/lint/detector/api/Issue;", "BEGIN_TRANSACTION", "CLOSE", "COMMIT", "COMMIT_ALLOWING_LOSS", "COMMIT_FRAGMENT", "COMMIT_NOW", "COMMIT_NOW_ALLOWING_LOSS", "CONTENT_PROVIDER_CLIENT_CLS", "CONTENT_RESOLVER_CLS", "CURSOR_CLS", "DIALOG_FRAGMENT", "DIALOG_V4_FRAGMENT", "EDIT", "FRAGMENT_MANAGER_CLS", "FRAGMENT_MANAGER_V4_CLS", "FRAGMENT_TRANSACTION_CLS", "FRAGMENT_TRANSACTION_V4_CLS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MOTION_EVENT_CLS", "OBTAIN", "OBTAIN_ATTRIBUTES", "OBTAIN_NO_HISTORY", "OBTAIN_STYLED_ATTRIBUTES", "OBTAIN_TYPED_ARRAY", "PARCEL_CLS", "QUERY", "QUERY_WITH_FACTORY", "RAW_QUERY", "RAW_QUERY_WITH_FACTORY", "RECYCLE", "RECYCLE_RESOURCE", "RELEASE", "SHARED_PREF", "SHOW", "SQLITE_DATABASE_CLS", "SURFACE_CLS", "SURFACE_TEXTURE_CLS", "VELOCITY_TRACKER_CLS", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "lint-checks"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkParameterIsNotNull((Object)rhs, (String)"rhs");
            return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public static /* synthetic */ PsiVariable getVariableElement$default(Companion companion, UCallExpression uCallExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.getVariableElement(uCallExpression, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, allowChainedCalls, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, false, false, 6, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

