/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AppLinksValidDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksValidDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue TEST_URL = Issue.create((String)"TestAppLink", (String)"Unmatched URLs", (String)"Using one or more `tools:validation testUrl=\"some url\"/>` elements in your manifest allows the link attributes in your intent filter to be checked for matches.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue VALIDATION = Issue.create((String)"AppLinkUrlError", (String)"URL not supported by app for Firebase App Indexing", (String)"Ensure the URL is supported by your app, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    private static final Issue _OLD_ISSUE_URL = Issue.create((String)"GoogleAppIndexingUrlError", (String)"?", (String)"?", (Category)Category.USABILITY, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    private static final String TAG_VALIDATION = "validation";

    public Collection<String> getApplicableElements() {
        return Arrays.asList("activity", "activity-alias");
    }

    private static void reportUrlError(XmlContext context, Node node, Location location, String message2) {
        AppLinksValidDetector.reportUrlError(context, node, location, message2, null);
    }

    private static void reportUrlError(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        if (context.getDriver().isSuppressed(context, _OLD_ISSUE_URL, node)) {
            return;
        }
        context.report(VALIDATION, node, location, message2, quickfixData);
    }

    private static void reportTestUrlFailure(XmlContext context, Node node, Location location, String message2) {
        context.report(TEST_URL, node, location, message2);
    }

    public void visitElement(XmlContext context, Element activity) {
        List<UriInfo> infos = AppLinksValidDetector.createUriInfos(activity, context);
        Element current = XmlUtils.getFirstSubTagByName((Node)activity, (String)TAG_VALIDATION);
        while (current != null) {
            if ("http://schemas.android.com/tools".equals(current.getNamespaceURI())) {
                Attr testUrlAttr = current.getAttributeNode("testUrl");
                if (testUrlAttr == null) {
                    String message2 = "Expected `testUrl` attribute";
                    AppLinksValidDetector.reportUrlError(context, current, context.getLocation((Node)current), message2);
                } else {
                    String testUrlString = testUrlAttr.getValue();
                    try {
                        URL testUrl = new URL(testUrlString);
                        String reason = AppLinksValidDetector.testElement(testUrl, infos);
                        if (reason != null) {
                            AppLinksValidDetector.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), reason);
                        }
                    }
                    catch (MalformedURLException e) {
                        String message3 = "Invalid test URL: " + e.getLocalizedMessage();
                        AppLinksValidDetector.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), message3);
                    }
                }
            } else {
                AppLinksValidDetector.reportTestUrlFailure(context, current, context.getNameLocation((Node)current), "Validation nodes should be in the `tools:` namespace to ensure they are removed from the manifest at build time");
            }
            current = XmlUtils.getNextTagByName((Node)current, (String)TAG_VALIDATION);
        }
    }

    public static List<UriInfo> createUriInfos(Element activity, XmlContext context) {
        Element intent = XmlUtils.getFirstSubTagByName((Node)activity, (String)"intent-filter");
        ArrayList infos = Lists.newArrayList();
        while (intent != null) {
            UriInfo uriInfo = AppLinksValidDetector.checkIntent(context, intent, activity);
            if (uriInfo != null) {
                infos.add(uriInfo);
            }
            intent = XmlUtils.getNextTagByName((Node)intent, (String)"intent-filter");
        }
        return infos;
    }

    public static String testElement(URL testUrl, List<UriInfo> infos) {
        ArrayList reasons = null;
        for (UriInfo info : infos) {
            String reason = info.match(testUrl);
            if (reason == null) {
                return null;
            }
            if (reasons == null) {
                reasons = Lists.newArrayList();
            }
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
        }
        if (reasons != null) {
            return "Test URL " + Joiner.on((String)" or ").join(reasons);
        }
        return null;
    }

    private static UriInfo checkIntent(XmlContext context, Element intent, Element activity) {
        boolean implicitSchemes;
        boolean isHttp;
        List<AndroidPatternMatcher> paths;
        List<String> ports;
        List<String> hosts;
        List<String> schemes;
        boolean browsable;
        boolean actionView;
        Element firstData;
        block16: {
            block15: {
                firstData = XmlUtils.getFirstSubTagByName((Node)intent, (String)"data");
                actionView = AppLinksValidDetector.hasActionView(intent);
                browsable = AppLinksValidDetector.isBrowsable(intent);
                if (actionView && context != null) {
                    AppLinksValidDetector.ensureExported(context, activity, intent);
                }
                if (firstData == null) {
                    if (actionView && browsable && context != null) {
                        AppLinksValidDetector.reportUrlError(context, intent, context.getLocation((Node)intent), "Missing data element");
                    }
                    return null;
                }
                schemes = null;
                hosts = null;
                ports = null;
                paths = null;
                boolean hasMimeType = false;
                Element data = firstData;
                while (data != null) {
                    Attr mimeType = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "mimeType");
                    if (mimeType != null) {
                        hasMimeType = true;
                        if (context != null) {
                            String mimeTypeValue = mimeType.getValue();
                            String resolved = Lint.resolvePlaceHolders((Project)context.getProject(), (String)mimeTypeValue, null);
                            if (CharSequences.containsUpperCase((CharSequence)resolved)) {
                                String message2 = "Mime-type matching is case sensitive and should only use lower-case characters";
                                if (!CharSequences.containsUpperCase((CharSequence)Lint.resolvePlaceHolders(null, (String)mimeTypeValue, null))) {
                                    message2 = message2 + " (without placeholders, value is `" + resolved + "`)";
                                }
                                AppLinksValidDetector.reportUrlError(context, mimeType, context.getValueLocation(mimeType), message2);
                            }
                        }
                    }
                    schemes = AppLinksValidDetector.addAttribute(context, "scheme", schemes, data);
                    hosts = AppLinksValidDetector.addAttribute(context, "host", hosts, data);
                    ports = AppLinksValidDetector.addAttribute(context, "port", ports, data);
                    paths = AppLinksValidDetector.addMatcher(context, "path", 0, paths, data);
                    paths = AppLinksValidDetector.addMatcher(context, "pathPrefix", 1, paths, data);
                    paths = AppLinksValidDetector.addMatcher(context, "pathPattern", 2, paths, data);
                    data = XmlUtils.getNextTagByName((Node)data, (String)"data");
                }
                if (actionView && browsable && schemes == null && !hasMimeType && context != null) {
                    AppLinksValidDetector.reportUrlError(context, firstData, context.getLocation((Node)firstData), "Missing URL for the intent filter");
                }
                isHttp = false;
                implicitSchemes = false;
                if (schemes != null) break block15;
                if (!hasMimeType) break block16;
                schemes = Lists.newArrayList();
                schemes.add("content");
                schemes.add("file");
                implicitSchemes = true;
                break block16;
            }
            for (String scheme : schemes) {
                if (!"http".equals(scheme) && !"https".equals(scheme)) continue;
                isHttp = true;
                break;
            }
        }
        if (context != null) {
            LintFix fix;
            boolean hasScheme;
            boolean bl = hasScheme = schemes != null;
            if (!(hasScheme || hosts == null && paths == null && ports == null)) {
                fix = LintFix.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                AppLinksValidDetector.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `scheme` must be specified", fix);
            }
            if (hosts == null && (paths != null || ports != null)) {
                fix = LintFix.create().set("http://schemas.android.com/apk/res/android", "host", "").build();
                AppLinksValidDetector.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `host` must be specified", fix);
            }
            if (actionView && isHttp && !browsable) {
                AppLinksValidDetector.reportUrlError(context, intent, context.getLocation((Node)intent), "Activity supporting ACTION_VIEW is not set as BROWSABLE");
            }
            if (actionView && (!hasScheme || implicitSchemes)) {
                fix = LintFix.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                AppLinksValidDetector.reportUrlError(context, intent, context.getLocation((Node)intent), "Missing URL", fix);
            }
        }
        return new UriInfo(schemes, hosts, ports, paths);
    }

    private static void ensureExported(XmlContext context, Element activity, Element intent) {
        Attr exported = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (exported == null) {
            return;
        }
        if ("true".equals(exported.getValue())) {
            return;
        }
        Element prevIntent = XmlUtils.getPreviousTagByName((Node)intent, (String)"intent-filter");
        while (prevIntent != null) {
            if (AppLinksValidDetector.hasActionView(prevIntent)) {
                return;
            }
            prevIntent = XmlUtils.getNextTagByName((Node)prevIntent, (String)"intent-filter");
        }
        AppLinksValidDetector.reportUrlError(context, activity, context.getLocation((Node)activity), "Activity supporting ACTION_VIEW is not exported");
    }

    static boolean hasActionView(Element intent) {
        for (Element action : XmlUtils.getSubTagsByName((Node)intent, (String)"action")) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue().equals("android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBrowsable(Element intent) {
        for (Element e : XmlUtils.getSubTagsByName((Node)intent, (String)"category")) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue().equals("android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private static boolean containsUpperCase(List<AndroidPatternMatcher> matchers) {
        return matchers != null && matchers.stream().anyMatch(m -> CharSequences.containsUpperCase((CharSequence)m.getPath()));
    }

    private static List<String> addAttribute(XmlContext context, String attributeName, List<String> current, Element data) {
        Attr attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (attribute != null) {
            String value = attribute.getValue();
            if (AppLinksValidDetector.requireNonEmpty(context, attribute, value)) {
                return current;
            }
            if (value.startsWith("@") || value.startsWith("?")) {
                value = AppLinksValidDetector.replaceUrlWithValue(context, value);
            }
            if (current == null) {
                current = Lists.newArrayListWithCapacity((int)4);
            }
            current.add(value);
            if (AppLinksValidDetector.isSubstituted(value) || value.startsWith("@") || value.startsWith("?")) {
                return current;
            }
            if (context != null) {
                AppLinksValidDetector.validateAttribute(context, attributeName, data, attribute, value);
            }
        }
        return current;
    }

    private static void validateAttribute(XmlContext context, String attributeName, Element data, Attr attribute, String value) {
        switch (attributeName) {
            case "scheme": {
                if (value.endsWith(":")) {
                    AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "Don't include trailing colon in the `scheme` declaration");
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "Scheme matching is case sensitive and should only use lower-case characters");
                break;
            }
            case "host": {
                if (value.lastIndexOf(42) > 0) {
                    AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "The host wildcard (`*`) can only be the first character");
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "Host matching is case sensitive and should only use lower-case characters");
                break;
            }
            case "port": {
                try {
                    int port = Integer.parseInt(value);
                    if (port < 1 || port > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "not a valid port number");
                }
                if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) break;
                AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), "The port must be specified in the same `<data>` element as the `host`");
            }
        }
    }

    private static List<AndroidPatternMatcher> addMatcher(XmlContext context, String attributeName, int type, List<AndroidPatternMatcher> current, Element data) {
        Attr attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (attribute != null) {
            String value = attribute.getValue();
            if (AppLinksValidDetector.requireNonEmpty(context, attribute, value)) {
                return current;
            }
            if (current == null) {
                current = Lists.newArrayListWithCapacity((int)4);
            }
            if (value.startsWith("@") || value.startsWith("?")) {
                value = AppLinksValidDetector.replaceUrlWithValue(context, value);
            }
            AndroidPatternMatcher matcher = new AndroidPatternMatcher(value, type);
            current.add(matcher);
            if (!(context == null || value.startsWith("/") || AppLinksValidDetector.isSubstituted(value) || value.startsWith("@") || attributeName.equals("pathPattern"))) {
                LintFix fix = LintFix.create().replace().text(attribute.getValue()).with("/" + value).build();
                AppLinksValidDetector.reportUrlError(context, attribute, context.getValueLocation(attribute), String.format("`%1$s` attribute should start with `/`, but it is `" + value + "`", attribute.getName()), fix);
            }
        }
        return current;
    }

    private static boolean requireNonEmpty(XmlContext context, Attr attribute, String value) {
        if (context != null && (value == null || value.isEmpty())) {
            AppLinksValidDetector.reportUrlError(context, attribute, context.getLocation((Node)attribute), String.format("`%1$s` cannot be empty", attribute.getName()));
            return true;
        }
        return false;
    }

    private static String replaceUrlWithValue(XmlContext context, String str) {
        if (context == null) {
            return str;
        }
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return str;
        }
        ResourceUrl url = ResourceUrl.parse((String)str);
        if (url == null || url.isFramework()) {
            return str;
        }
        Project project = context.getProject();
        ResourceRepository resources = client.getResourceRepository(project, true, true);
        if (resources == null) {
            return str;
        }
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, url.name);
        if (items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue();
        if (resourceValue == null) {
            return str;
        }
        return resourceValue.getValue() == null ? str : resourceValue.getValue();
    }

    private static boolean matchesHost(String actualHost, String hostPattern) {
        if (!hostPattern.startsWith("*")) {
            return actualHost.equals(hostPattern);
        }
        try {
            String pattern = ".*" + Pattern.quote(hostPattern.substring(1));
            return actualHost.matches(pattern);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static boolean isSubstituted(String expression) {
        return Lint.isDataBindingExpression((String)expression) || Lint.isManifestPlaceHolderExpression((String)expression);
    }

    public static class UriInfo {
        private final List<String> schemes;
        private final List<String> hosts;
        private final List<String> ports;
        private final List<AndroidPatternMatcher> paths;

        public UriInfo(List<String> schemes, List<String> hosts, List<String> ports, List<AndroidPatternMatcher> paths) {
            this.schemes = schemes;
            this.hosts = hosts;
            this.ports = ports;
            this.paths = paths;
        }

        public String match(URL testUrl) {
            boolean hostOk;
            boolean schemeOk;
            if (this.schemes != null && !(schemeOk = this.schemes.stream().anyMatch(scheme -> scheme.equals(testUrl.getProtocol()) || AppLinksValidDetector.isSubstituted(scheme)))) {
                return String.format("did not match scheme %1$s", Joiner.on((String)", ").join(this.schemes));
            }
            if (this.hosts != null && !(hostOk = this.hosts.stream().anyMatch(host -> AppLinksValidDetector.matchesHost(testUrl.getHost(), host) || AppLinksValidDetector.isSubstituted(host)))) {
                return String.format("did not match host %1$s", Joiner.on((String)", ").join(this.hosts));
            }
            boolean portOk = false;
            if (testUrl.getPort() != -1) {
                String testPort = Integer.toString(testUrl.getPort());
                if (this.ports != null) {
                    portOk = this.ports.stream().anyMatch(port -> testPort.equals(port) || AppLinksValidDetector.isSubstituted(port));
                }
            } else if (this.ports == null) {
                portOk = true;
            }
            if (!portOk) {
                String portList = this.ports == null ? "none" : Joiner.on((String)", ").join(this.ports);
                return String.format("did not match port %1$s", portList);
            }
            if (this.paths != null) {
                String testPath = testUrl.getPath();
                boolean pathOk = this.paths.stream().anyMatch(matcher -> AppLinksValidDetector.isSubstituted(matcher.getPath()) || matcher.match(testPath));
                if (!pathOk) {
                    StringBuilder sb = new StringBuilder();
                    this.paths.forEach(matcher -> sb.append("path ").append(matcher.toString()).append(", "));
                    if (CharSequences.endsWith((CharSequence)sb, (CharSequence)", ", (boolean)true)) {
                        sb.setLength(sb.length() - 2);
                    }
                    String message2 = String.format("did not match %1$s", sb.toString());
                    if (AppLinksValidDetector.containsUpperCase(this.paths) || CharSequences.containsUpperCase((CharSequence)testPath)) {
                        message2 = message2 + " Note that matching is case sensitive.";
                    }
                    return message2;
                }
            }
            return null;
        }
    }
}

