/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JP\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JX\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002J<\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\"2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0014H\u0002J \u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0006H\u0002J|\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkRestrictTo", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMember;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "applyClassAnnotationsToMembers", "", "member", "scope", "", "checkVisibleForTesting", "containsRestrictionAnnotation", "list", "inheritAnnotation", "isGmsContext", "element", "isTestContext", "reportRestriction", "where", "containingClass", "Lcom/intellij/psi/PsiClass;", "isClassAnnotation", "reportVisibilityError", "desc", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final String ATTR_OTHERWISE = "otherwise";
    private static final String ATTR_PRODUCTION_VISIBILITY = "productionVisibility";
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_TESTS = 4;
    private static final int RESTRICT_TO_SUBCLASSES = 8;
    private static final int RESTRICT_TO_ALL = 16;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED;
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName(), AnnotationDetector.RESTRICT_TO_ANNOTATION.newName(), "com.google.android.gms.common.internal.Hide", AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName(), AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName(), "com.google.common.annotations.VisibleForTesting"});
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        PsiMember psiMember;
        PsiElement psiElement;
        PsiElement sourcePsi;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (type == AnnotationUsageType.EXTENDS && usage instanceof UTypeReferenceExpression && Lint.isKotlin((PsiElement)(sourcePsi = usage.getSourcePsi())) && Intrinsics.areEqual((Object)((psiElement = sourcePsi) != null && (psiElement = psiElement.getParent()) != null ? psiElement.toString() : null), (Object)"CONSTRUCTOR_CALLEE")) {
            return;
        }
        PsiMethod psiMethod = method;
        if (psiMethod != null) {
            psiMember = (PsiMember)psiMethod;
        } else {
            PsiElement psiElement2 = referenced;
            if (!(psiElement2 instanceof PsiMember)) {
                psiElement2 = null;
            }
            psiMember = (PsiMember)psiElement2;
        }
        PsiMember member = psiMember;
        String string = qualifiedName;
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName())) {
            this.checkRestrictTo(context, usage, member, annotation, allMemberAnnotations, allClassAnnotations, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.google.android.gms.common.internal.Hide")) {
            boolean isConstructor = method == null || method.isConstructor();
            boolean isStatic = method == null ? false : context.getEvaluator().isStatic((PsiModifierListOwner)method);
            this.checkRestrictTo(context, usage, (PsiMember)method, annotation, allMemberAnnotations, allClassAnnotations, isConstructor || isStatic);
        } else if ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)"com.google.common.annotations.VisibleForTesting")) && member != null) {
            this.checkVisibleForTesting(context, usage, member, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    private final boolean isGmsContext(JavaContext context, UElement element) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiPackage psiPackage = evaluator.getPackage(element);
        if (psiPackage == null) {
            return false;
        }
        PsiPackage pkg = psiPackage;
        String string = pkg.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pkg.qualifiedName");
        String qualifiedName = string;
        if (!StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.firebase", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.android.gms", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.ads", (boolean)false, (int)2, null);
    }

    private final boolean isTestContext(JavaContext context, UElement element) {
        UElement current = element;
        if (context.isTestSource()) {
            return true;
        }
        while ((UAnnotated)UastUtils.getParentOfType((UElement)current, UAnnotated.class, (boolean)true) != null) {
            UAnnotated owner;
            for (UAnnotation annotation : owner.getAnnotations()) {
                int restrictionScope;
                String name = annotation.getQualifiedName();
                if (!(AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(name) ? ((restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation)) & 4) != 0 : AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.isEquals(name))) continue;
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        int visibility = RestrictToDetector.Companion.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            RestrictToDetector.checkRestrictTo$default(this, context, node, method, annotation, allMethodAnnotations, allClassAnnotations, 4, false, 128, null);
        } else {
            boolean bl;
            PsiPackage methodPackage;
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.getPsiFile((UFile)uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.getContainingFile((PsiElement)((PsiElement)method)))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            if (Intrinsics.areEqual((Object)pkg, (Object)(methodPackage = evaluator.getPackage((PsiElement)method)))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "package private");
                }
                return;
            }
            boolean bl2 = bl = visibility == 4;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context, node)) {
                this.reportVisibilityError(context, node, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context, UElement node, String desc) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "This method should only be accessed from tests or within %1$s scope";
        Object[] objectArray = new Object[]{desc};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        Location location = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, false, false) : context.getLocation(node);
        this.report(context, TEST_VISIBILITY, node, location, message2);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, boolean applyClassAnnotationsToMembers) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, scope, applyClassAnnotationsToMembers);
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list, list2, bl);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember member, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, int scope, boolean applyClassAnnotationsToMembers) {
        String qualifiedName;
        StringCompanionObject stringCompanionObject;
        String methodGroup;
        String thisGroup;
        MavenCoordinates methodCoordinates;
        MavenCoordinates thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass;
        Object object;
        if (node instanceof UTypeReferenceExpression) {
            object = PsiTypesUtil.getPsiClass((PsiType)((UTypeReferenceExpression)node).getType());
        } else if (member != null) {
            object = member.getContainingClass();
        } else if (node instanceof UCallExpression) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)node).getClassReference();
            object = (PsiClass)(uReferenceExpression != null ? uReferenceExpression.resolve() : null);
        } else {
            object = node instanceof PsiClass ? (PsiClass)node : null;
        }
        if ((containingClass = object) == null) {
            return;
        }
        boolean isClassAnnotation = false;
        if (UastLintUtils.containsAnnotation(allMethodAnnotations, (UAnnotation)annotation)) {
            if (member != null && context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)member)) {
                return;
            }
        } else if (applyClassAnnotationsToMembers) {
            if (this.containsRestrictionAnnotation(allMethodAnnotations)) {
                return;
            }
            isClassAnnotation = UastLintUtils.containsAnnotation(allClassAnnotations, (UAnnotation)annotation);
            if (isClassAnnotation ? context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)containingClass) : this.containsRestrictionAnnotation(allClassAnnotations)) {
                return;
            }
        } else {
            return;
        }
        if ((scope & 1) != 0 && member != null) {
            Object object2;
            evaluator = context.getEvaluator();
            MavenCoordinates mavenCoordinates = evaluator.getLibrary(node);
            if (mavenCoordinates == null) {
                mavenCoordinates = thisCoordinates = context.getProject().getMavenCoordinates();
            }
            if ((object2 = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector restrictToDetector;
                RestrictToDetector $receiver = restrictToDetector = this;
                boolean bl = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context.getEvaluator().getProject((PsiElement)member);
                    object2 = project != null ? project.getMavenCoordinates() : null;
                } else {
                    object2 = null;
                }
            }
            methodCoordinates = object2;
            MavenCoordinates mavenCoordinates2 = thisCoordinates;
            thisGroup = mavenCoordinates2 != null ? mavenCoordinates2.getGroupId() : null;
            MavenCoordinates mavenCoordinates3 = methodCoordinates;
            String string = methodGroup = mavenCoordinates3 != null ? mavenCoordinates3.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) ^ true && methodGroup != null) {
                StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
                String string2 = "from within the same library group (groupId=%1$s)";
                StringCompanionObject stringCompanionObject3 = stringCompanionObject = new StringCompanionObject[]{methodGroup};
                String string3 = String.format(string2, Arrays.copyOf(stringCompanionObject3, ((Object[])stringCompanionObject3).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String where = string3;
                this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
            }
        }
        if ((scope & 2) != 0 && member != null) {
            Project project;
            evaluator = context.getEvaluator();
            MavenCoordinates mavenCoordinates = evaluator.getLibrary(node);
            if (mavenCoordinates == null) {
                mavenCoordinates = context.getProject().getMavenCoordinates();
            }
            thisCoordinates = mavenCoordinates;
            methodCoordinates = evaluator.getLibrary((PsiElement)member);
            MavenCoordinates mavenCoordinates4 = thisCoordinates;
            thisGroup = mavenCoordinates4 != null ? mavenCoordinates4.getGroupId() : null;
            MavenCoordinates mavenCoordinates5 = methodCoordinates;
            String string = methodGroup = mavenCoordinates5 != null ? mavenCoordinates5.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) ^ true && methodGroup != null) {
                String methodArtifact;
                MavenCoordinates mavenCoordinates6 = thisCoordinates;
                String thisArtifact = mavenCoordinates6 != null ? mavenCoordinates6.getArtifactId() : null;
                if (Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId())) ^ true) {
                    stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string4 = "from within the same library (%1$s:%2$s)";
                    Object[] objectArray = new Object[]{methodGroup, methodArtifact};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                    String where = string5;
                    this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
                }
            } else if (!(member instanceof PsiCompiledElement) && (project = context.getEvaluator().getProject((PsiElement)member)) != null && Intrinsics.areEqual((Object)project, (Object)context.getProject()) ^ true) {
                MavenCoordinates coordinates = project.getMavenCoordinates();
                String name = coordinates != null ? coordinates.getGroupId() + ':' + coordinates.getArtifactId() : project.getName();
                String where = "from within the same library (" + name + ')';
                this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
            }
        }
        if ((scope & 4) != 0 && !this.isTestContext(context, node)) {
            this.reportRestriction("from tests", containingClass, member, context, node, isClassAnnotation);
        }
        if ((scope & 0x10) != 0 && !this.isGmsContext(context, node)) {
            this.reportRestriction(null, containingClass, member, context, node, isClassAnnotation);
        }
        if ((scope & 8) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            JavaEvaluator evaluator2 = context.getEvaluator();
            UClass outer = null;
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = (UElement)outer;
            }
            if (!isSubClass) {
                this.reportRestriction("from subclasses", containingClass, member, context, node, isClassAnnotation);
            }
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list, List list2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list, list2, n, bl);
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMember member, JavaContext context, UElement node, boolean isClassAnnotation) {
        Object object;
        Object api = null;
        if (member == null || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            object = member;
            if (object == null || (object = object.getName()) == null) {
                object = Intrinsics.stringPlus((String)containingClass.getName(), (Object)" constructor");
            }
        } else {
            String string;
            if (Intrinsics.areEqual((Object)containingClass, (Object)member)) {
                string = member.getName();
                if (string == null) {
                    string = "class";
                }
            } else {
                string = containingClass.getName() + "." + member.getName();
            }
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (containingClass == m\u2026\" + member.name\n        }");
        }
        api = object;
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            if (isClassAnnotation) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = containingClass.getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api = className;
                }
            }
        }
        String message2 = null;
        if (where == null) {
            message2 = (String)api + " is marked as internal and should not be accessed from apps";
        } else {
            String refType = member instanceof PsiMethod ? "called" : "accessed";
            message2 = (String)api + " can only be " + refType + ' ' + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = null;
        location = locationNode instanceof UCallExpression ? context.getCallLocation((UCallExpression)locationNode, false, false) : context.getLocation(locationNode);
        this.report(context, RESTRICTED, node, location, message2, null);
    }

    private final boolean containsRestrictionAnnotation(List<? extends UAnnotation> list) {
        return UastLintUtils.containsAnnotation(list, (String)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) || UastLintUtils.containsAnnotation(list, (String)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName());
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
        RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                With the `@VisibleForTesting` annotation you can specify an `otherwise=` \\\n                attribute which specifies the intended visibility if the method had not \\\n                been made more widely visible for the tests.\n\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "()V", "ATTR_OTHERWISE", "", "ATTR_PRODUCTION_VISIBILITY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "RESTRICT_TO_ALL", "", "RESTRICT_TO_LIBRARY", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_SUBCLASSES", "RESTRICT_TO_TESTS", "TEST_VISIBILITY", "VISIBILITY_NONE", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PRIVATE", "VISIBILITY_PROTECTED", "getRestrictionScope", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "expression", "Lorg/jetbrains/uast/UExpression;", "getVisibilityForTesting", "lint-checks"})
    public static final class Companion {
        private final int getVisibilityForTesting(UAnnotation annotation) {
            UExpression value;
            UExpression uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
            if (uExpression == null) {
                uExpression = value = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY);
            }
            if (value instanceof ULiteralExpression) {
                Object v = ((ULiteralExpression)value).getValue();
                if (v instanceof Integer) {
                    return (Integer)v;
                }
            } else if (value instanceof UReferenceExpression) {
                String name;
                String string = name = ((UReferenceExpression)value).getResolvedName();
                if (string != null) {
                    switch (string) {
                        case "NONE": {
                            return 5;
                        }
                        case "PRIVATE": {
                            return 2;
                        }
                        case "PROTECTED": {
                            return 4;
                        }
                        case "PACKAGE_PRIVATE": {
                            return 3;
                        }
                    }
                }
            }
            return 2;
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value);
            }
            if (Intrinsics.areEqual((Object)"com.google.android.gms.common.internal.Hide", (Object)annotation.getQualifiedName())) {
                return 16;
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression) {
            int scope = 0;
            if (expression != null) {
                PsiElement resolved;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer);
                    }
                } else if (expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) instanceof PsiField) {
                    String string = ((PsiField)resolved).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolved.name");
                    String name = string;
                    if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                        scope |= 1;
                    } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                        scope |= 8;
                    } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                        scope |= 4;
                    } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                        scope |= 2;
                    }
                }
            }
            return scope;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

