/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AndroidTvDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AndroidTvDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue UNSUPPORTED_TV_HARDWARE = Issue.create((String)"UnsupportedTvHardware", (String)"Unsupported TV Hardware Feature", (String)"The <uses-feature> element should not require this unsupported TV hardware feature. Any uses-feature not explicitly marked with required=\"false\" is necessary on the device to be installed on. Ensure that any features that might prevent it from being installed on a TV device are reviewed and marked as not required in the manifest.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/hardware.html#unsupported-features");
    public static final Issue IMPLIED_TOUCHSCREEN_HARDWARE = Issue.create((String)"ImpliedTouchscreenHardware", (String)"Hardware feature touchscreen not explicitly marked as optional", (String)"Apps require the `android.hardware.touchscreen` feature by default. If you want your app to be available on TV, you must also explicitly declare that a touchscreen is not required as follows:\n`<uses-feature android:name=\"android.hardware.touchscreen\" android:required=\"false\"/>`", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/manifest/uses-feature-element.html");
    public static final Issue MISSING_LEANBACK_LAUNCHER = Issue.create((String)"MissingLeanbackLauncher", (String)"Missing Leanback Launcher Intent Filter.", (String)"An application intended to run on TV devices must declare a launcher activity for TV in its manifest using a `android.intent.category.LEANBACK_LAUNCHER` intent filter.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/start.html#tv-activity");
    public static final Issue MISSING_LEANBACK_SUPPORT = Issue.create((String)"MissingLeanbackSupport", (String)"Missing Leanback Support.", (String)"The manifest should declare the use of the Leanback user interface required by Android TV.\nTo fix this, add\n`<uses-feature android:name=\"android.software.leanback\"   android:required=\"false\" />`\nto your manifest.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/start.html#leanback-req");
    public static final Issue PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE = Issue.create((String)"PermissionImpliesUnsupportedHardware", (String)"Permission Implies Unsupported Hardware", (String)"The <uses-permission> element should not require a permission that implies an unsupported TV hardware feature. Google Play assumes that certain hardware related permissions indicate that the underlying hardware features are required by default. To fix the issue, consider declaring the corresponding uses-feature element with required=\"false\" attribute.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-feature-element.html#permissions");
    public static final Issue MISSING_BANNER = Issue.create((String)"MissingTvBanner", (String)"TV Missing Banner", (String)"A TV application must provide a home screen banner for each localization if it includes a Leanback launcher intent filter. The banner is the app launch point that appears on the home screen in the apps and games rows.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/tv/start/start.html#banner");
    public static final String SOFTWARE_FEATURE_LEANBACK = "android.software.leanback";
    public static final String HARDWARE_FEATURE_TOUCHSCREEN = "android.hardware.touchscreen";
    private static final String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";
    private static final String HARDWARE_FEATURE_CAMERA = "android.hardware.camera";
    private static final String HARDWARE_FEATURE_LOCATION_GPS = "android.hardware.location.gps";
    private static final String HARDWARE_FEATURE_TELEPHONY = "android.hardware.telephony";
    private static final String HARDWARE_FEATURE_BLUETOOTH = "android.hardware.bluetooth";
    private static final String ATTR_BANNER = "banner";
    private static final String HARDWARE_FEATURE_MICROPHONE = "android.hardware.microphone";
    private static final String[] UNSUPPORTED_HARDWARE_FEATURES = new String[]{"android.hardware.touchscreen", "android.hardware.faketouch", "android.hardware.telephony", "android.hardware.camera", "android.hardware.bluetooth", "android.hardware.nfc", "android.hardware.location.gps", "android.hardware.microphone", "android.hardware.sensors"};
    private boolean mHasLeanbackLauncherActivity;
    private boolean mHasLeanbackSupport;
    private boolean mHasLeanbackDependency;
    private boolean mHasApplicationBanner;
    private int mLeanbackActivitiesWithoutBanners;
    private List<String> mUnsupportedHardwareImpliedPermissions;
    private Set<String> mAllUnsupportedTvUsesFeatures;
    private Set<String> mUnsupportedTvUsesFeatures;

    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "activity-alias", "uses-feature", "uses-permission");
    }

    public void beforeCheckFile(Context context) {
        this.mHasLeanbackLauncherActivity = false;
        this.mHasLeanbackSupport = false;
        this.mHasApplicationBanner = false;
        this.mLeanbackActivitiesWithoutBanners = 0;
        this.mUnsupportedHardwareImpliedPermissions = Lists.newArrayListWithExpectedSize((int)2);
        this.mUnsupportedTvUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
        this.mAllUnsupportedTvUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
        Project mainProject = context.getMainProject();
        this.mHasLeanbackDependency = mainProject.isGradleProject() && Boolean.TRUE.equals(mainProject.dependsOn("com.android.support:leanback-v17"));
    }

    public void afterCheckFile(Context context) {
        boolean isTvApp;
        boolean bl = isTvApp = this.mHasLeanbackSupport || this.mHasLeanbackDependency || this.mHasLeanbackLauncherActivity;
        if (!context.getMainProject().isLibrary() && isTvApp) {
            Node applicationElement;
            Element manifestNode;
            XmlContext xmlContext = (XmlContext)context;
            if (!this.mHasLeanbackLauncherActivity && xmlContext.isEnabled(MISSING_LEANBACK_LAUNCHER) && (manifestNode = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(MISSING_LEANBACK_LAUNCHER, (Node)manifestNode, xmlContext.getNameLocation((Node)manifestNode), "Expecting an activity to have `android.intent.category.LEANBACK_LAUNCHER` intent filter.");
            }
            if (!this.mHasLeanbackSupport && xmlContext.isEnabled(MISSING_LEANBACK_SUPPORT) && (manifestNode = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(MISSING_LEANBACK_SUPPORT, (Node)manifestNode, xmlContext.getNameLocation((Node)manifestNode), "Expecting <uses-feature android:name=\"android.software.leanback\" android:required=\"false\" /> tag.");
            }
            if (!this.mHasApplicationBanner && this.mLeanbackActivitiesWithoutBanners > 0 && xmlContext.isEnabled(MISSING_BANNER) && (applicationElement = AndroidTvDetector.getApplicationElement(xmlContext.document)) != null) {
                LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", ATTR_BANNER).build();
                xmlContext.report(MISSING_BANNER, applicationElement, xmlContext.getNameLocation(applicationElement), "Expecting `android:banner` with the `<application>` tag or each Leanback launcher activity.", fix);
            }
            if (!this.mUnsupportedTvUsesFeatures.isEmpty() && xmlContext.isEnabled(UNSUPPORTED_TV_HARDWARE)) {
                List<Element> usesFeatureElements = AndroidTvDetector.findUsesFeatureElements(this.mUnsupportedTvUsesFeatures, xmlContext.document);
                for (Element element : usesFeatureElements) {
                    Attr attrRequired = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                    Location location = attrRequired == null ? xmlContext.getNameLocation((Node)element) : xmlContext.getLocation((Node)attrRequired);
                    LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "required", "false").autoFix().build();
                    xmlContext.report(UNSUPPORTED_TV_HARDWARE, (Node)element, location, "Expecting `android:required=\"false\"` for this hardware feature that may not be supported by all Android TVs.", fix);
                }
            }
            if (!this.mAllUnsupportedTvUsesFeatures.contains(HARDWARE_FEATURE_TOUCHSCREEN) && xmlContext.isEnabled(IMPLIED_TOUCHSCREEN_HARDWARE)) {
                Element manifestElement = xmlContext.document.getDocumentElement();
                xmlContext.report(IMPLIED_TOUCHSCREEN_HARDWARE, (Node)manifestElement, xmlContext.getNameLocation((Node)manifestElement), "Hardware feature `android.hardware.touchscreen` not explicitly marked as optional ");
            }
            if (!this.mUnsupportedHardwareImpliedPermissions.isEmpty() && xmlContext.isEnabled(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE)) {
                Collection filteredPermissions = Collections2.filter(this.mUnsupportedHardwareImpliedPermissions, input -> {
                    String usesFeature = input != null ? AndroidTvDetector.getImpliedUnsupportedHardware(input) : null;
                    return usesFeature != null && !this.mAllUnsupportedTvUsesFeatures.contains(usesFeature);
                });
                List<Element> permissionsWithoutUsesFeatures = AndroidTvDetector.findPermissionElements(filteredPermissions, xmlContext.document);
                for (Element permissionElement : permissionsWithoutUsesFeatures) {
                    String name = permissionElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    String unsupportedHardwareName = AndroidTvDetector.getImpliedUnsupportedHardware(name);
                    if (unsupportedHardwareName == null) continue;
                    String message2 = String.format("Permission exists without corresponding hardware `<uses-feature android:name=\"%1$s\" required=\"false\">` tag.", unsupportedHardwareName);
                    LintFix fix = this.fix().data(new Object[]{unsupportedHardwareName});
                    xmlContext.report(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, (Node)permissionElement, xmlContext.getNameLocation((Node)permissionElement), message2, fix);
                }
            }
        }
    }

    private static String getImpliedUnsupportedHardware(String permission) {
        switch (permission) {
            case "android.permission.BLUETOOTH": {
                return HARDWARE_FEATURE_BLUETOOTH;
            }
            case "android.permission.BLUETOOTH_ADMIN": {
                return HARDWARE_FEATURE_BLUETOOTH;
            }
            case "android.permission.CAMERA": {
                return HARDWARE_FEATURE_CAMERA;
            }
            case "android.permission.RECORD_AUDIO": {
                return HARDWARE_FEATURE_MICROPHONE;
            }
            case "android.permission.ACCESS_FINE_LOCATION": {
                return HARDWARE_FEATURE_LOCATION_GPS;
            }
            case "android.permission.CALL_PHONE": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.CALL_PRIVILEGED": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.PROCESS_OUTGOING_CALLS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.READ_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_MMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.RECEIVE_WAP_PUSH": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.SEND_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.WRITE_APN_SETTINGS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
            case "android.permission.WRITE_SMS": {
                return HARDWARE_FEATURE_TELEPHONY;
            }
        }
        return null;
    }

    static List<Element> findPermissionElements(Collection<String> permissions, Document document) {
        Element manifestElement = document.getDocumentElement();
        if (manifestElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> nodes = new ArrayList<Element>(permissions.size());
        for (Element child : XmlUtils.getSubTags((Node)manifestElement)) {
            if (!"uses-permission".equals(child.getTagName()) || !permissions.contains(child.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            nodes.add(child);
        }
        return nodes;
    }

    static List<Element> findUsesFeatureElements(Set<String> featureNames, Document document) {
        Element manifestElement = document.getDocumentElement();
        if (manifestElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> nodes = new ArrayList<Element>(featureNames.size());
        for (Element child : XmlUtils.getSubTags((Node)manifestElement)) {
            if (!"uses-feature".equals(child.getTagName()) || !featureNames.contains(child.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            nodes.add(child);
        }
        return nodes;
    }

    private static Node getApplicationElement(Document document) {
        Element manifestNode = document.getDocumentElement();
        if (manifestNode != null) {
            return AndroidTvDetector.getElementWithTagName("application", manifestNode);
        }
        return null;
    }

    public void visitElement(XmlContext context, Element element) {
        String permissionName;
        String elementName = element.getTagName();
        if ("application".equals(elementName)) {
            this.mHasApplicationBanner = element.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_BANNER);
        } else if ("uses-feature".equals(elementName)) {
            String featureName;
            Attr name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (name != null && AndroidTvDetector.isUnsupportedHardwareFeature(featureName = name.getValue())) {
                this.mAllUnsupportedTvUsesFeatures.add(featureName);
                Attr required = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                if (required == null || Boolean.parseBoolean(required.getValue())) {
                    this.mUnsupportedTvUsesFeatures.add(featureName);
                }
            }
            if (!this.mHasLeanbackSupport && AndroidTvDetector.hasLeanbackSupport(element)) {
                this.mHasLeanbackSupport = true;
            }
        } else if (("activity".equals(elementName) || "activity-alias".equals(elementName)) && AndroidTvDetector.hasLeanbackIntentFilter(element)) {
            this.mHasLeanbackLauncherActivity = true;
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_BANNER)) {
                ++this.mLeanbackActivitiesWithoutBanners;
            }
        } else if ("uses-permission".equals(elementName) && AndroidTvDetector.getImpliedUnsupportedHardware(permissionName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            this.mUnsupportedHardwareImpliedPermissions.add(permissionName);
        }
    }

    private static boolean hasLeanbackSupport(Element element) {
        assert ("uses-feature".equals(element.getTagName())) : element.getTagName();
        return SOFTWARE_FEATURE_LEANBACK.equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "name"));
    }

    private static boolean isUnsupportedHardwareFeature(String featureName) {
        for (String prefix : UNSUPPORTED_HARDWARE_FEATURES) {
            if (!featureName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLeanbackIntentFilter(Node activityNode) {
        for (Element activityChild : XmlUtils.getSubTags((Node)activityNode)) {
            if (!"intent-filter".equals(activityChild.getNodeName())) continue;
            for (Element intentFilterChild : XmlUtils.getSubTags((Node)activityChild)) {
                String attrName = intentFilterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (!"category".equals(intentFilterChild.getNodeName()) || !CATEGORY_LEANBACK_LAUNCHER.equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private static Node getElementWithTagName(String tagName, Node node) {
        for (Element child : XmlUtils.getSubTags((Node)node)) {
            if (!tagName.equals(child.getTagName())) continue;
            return child;
        }
        return null;
    }
}

