/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/MediaBrowserServiceCompatVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Issues", "lint-checks"})
public final class MediaBrowserServiceCompatVersionDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final GradleCoordinate MIN_SUPPORT_V4_VERSION;
    @NotNull
    public static final String MEDIA_BROWSER_SERVICE_COMPAT = "android.support.v4.media.MediaBrowserServiceCompat";
    public static final Issues Issues;

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)MEDIA_BROWSER_SERVICE_COMPAT);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (!context.getEvaluator().extendsClass((PsiClass)declaration, MEDIA_BROWSER_SERVICE_COMPAT, true)) {
            return;
        }
        Dependencies dependencies = GradleDetector.Companion.getCompileDependencies(context.getProject());
        if (dependencies == null) {
            return;
        }
        Dependencies dependencies2 = dependencies;
        Iterator iterator = dependencies2.getLibraries().iterator();
        while (iterator.hasNext()) {
            AndroidLibrary library;
            AndroidLibrary androidLibrary = library = (AndroidLibrary)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidLibrary, (String)"library");
            MavenCoordinates mc = androidLibrary.getResolvedCoordinates();
            if (mc == null || !Intrinsics.areEqual((Object)mc.getGroupId(), (Object)"com.android.support") || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)"support-v4") || mc.getVersion() == null) continue;
            GradleCoordinate libVersion = GradleCoordinate.parseVersionOnly((String)mc.getVersion());
            if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(libVersion, MIN_SUPPORT_V4_VERSION) >= 0) break;
            LintClient lintClient = context.getClient();
            File file = context.getProject().getDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.project.dir");
            Location location = Lint.guessGradleLocation((LintClient)lintClient, (File)file, (String)(mc.getGroupId() + ':' + mc.getArtifactId() + ':' + mc.getVersion()));
            String message2 = "Using a version of the class that is not forward compatible";
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)message2, null, (int)8, null);
            break;
        }
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(MediaBrowserServiceCompatVersionDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"IncompatibleMediaBrowserServiceCompatVersion", (String)"Obsolete version of MediaBrowserServiceCompat", (String)"\n            `MediaBrowserServiceCompat` from version 23.2.0 to 23.4.0 of the Support v4 Library \\\n            used private APIs and will not be compatible with future versions of Android beyond Android N. \\\n            Please upgrade to version 24.0.0 or higher of the Support Library.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseVersionOnly((String)"24.0.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleCoordinate, (String)"GradleCoordinate.parseVersionOnly(\"24.0.0\")");
        MIN_SUPPORT_V4_VERSION = gradleCoordinate;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/MediaBrowserServiceCompatVersionDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MEDIA_BROWSER_SERVICE_COMPAT", "", "MIN_SUPPORT_V4_VERSION", "Lcom/android/ide/common/repository/GradleCoordinate;", "getMIN_SUPPORT_V4_VERSION", "()Lcom/android/ide/common/repository/GradleCoordinate;", "lint-checks"})
    public static final class Issues {
        @NotNull
        public final GradleCoordinate getMIN_SUPPORT_V4_VERSION() {
            return MIN_SUPPORT_V4_VERSION;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

