/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/IteratorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks"})
public final class IteratorDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"add", "spliterator", "stream", "parallelStream"});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (context.getMainProject().getMinSdk() >= 26) {
            return;
        }
        UExpression uExpression = node.getReceiver();
        if (uExpression == null) {
            return;
        }
        UExpression receiver = uExpression;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"add")) {
            String c;
            PsiClass psiClass = method.getContainingClass();
            String string2 = c = psiClass != null ? psiClass.getName() : null;
            if (c == null || !StringsKt.endsWith$default((String)c, (String)"Iterator", (boolean)false, (int)2, null)) {
                return;
            }
        }
        PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)receiver));
        if (psiElement == null) {
            return;
        }
        PsiElement resolved = psiElement;
        PsiElement psiElement2 = resolved;
        if (!(psiElement2 instanceof PsiVariable)) {
            psiElement2 = null;
        }
        PsiVariable psiVariable = (PsiVariable)psiElement2;
        if (psiVariable == null) {
            return;
        }
        PsiVariable variable = psiVariable;
        UExpression uExpression2 = UastLintUtils.findLastAssignment((PsiVariable)variable, (UElement)((UElement)node));
        if (uExpression2 == null) {
            return;
        }
        UExpression initializer = uExpression2;
        if (initializer instanceof UQualifiedReferenceExpression) {
            String canonical;
            PsiClassType psiClassType;
            UExpression r = ((UQualifiedReferenceExpression)initializer).getReceiver();
            PsiType psiType = TypeEvaluator.evaluate((UElement)((UElement)r));
            if (psiType == null) {
                return;
            }
            PsiType type = psiType;
            PsiType psiType2 = type;
            if (!(psiType2 instanceof PsiClassType)) {
                psiType2 = null;
            }
            String string3 = (psiClassType = (PsiClassType)psiType2) != null && (psiClassType = psiClassType.rawType()) != null ? psiClassType.getCanonicalText() : (canonical = null);
            if (Intrinsics.areEqual((Object)canonical, (Object)"java.util.LinkedHashMap")) {
                UElement pp;
                UElement uElement = node.getUastParent();
                Object object = pp = uElement != null ? uElement.getUastParent() : null;
                if (pp instanceof UQualifiedReferenceExpression) {
                    UExpression uExpression3 = ((UQualifiedReferenceExpression)pp).getSelector();
                    if (!(uExpression3 instanceof UCallExpression)) {
                        uExpression3 = null;
                    }
                    UCallExpression uCallExpression = (UCallExpression)uExpression3;
                    if (Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getMethodName() : null), (Object)"characteristics")) {
                        return;
                    }
                }
                String collection = receiver.asSourceString();
                String workaround = Intrinsics.areEqual((Object)name, (Object)"spliterator") ? "Use `java.util.Spliterators.spliterator(" + collection + ", " + collection + ".spliterator().characteristics())`" : "Use `java.util.stream.StreamSupport.stream(spliterator, false)`";
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("`LinkedHashMap#" + name + "` was broken in API 24 and 25. Workaround: " + workaround), null, (int)16, null);
            } else if (Intrinsics.areEqual((Object)canonical, (Object)"java.util.Vector")) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)"`Vector#listIterator` was broken in API 24 and 25; it can return `hasNext()=false` before the last element. Consider switching to `ArrayList` with synchronization if you need it.", null, (int)16, null);
            }
        }
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(IteratorDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/reference/java/util/LinkedHashMap";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"BrokenIterator", (String)"Broken Iterator", (String)"\n                **For LinkedHashMap:**\n\n                The spliterators returned by `LinkedHashMap` in Android Nougat (API levels 24 \\\n                and 25) use the wrong order (inconsistent with the iterators, which use \\\n                the correct order), despite reporting `Spliterator.ORDERED`. You may use the \\\n                following code fragments to obtain a correctly ordered `Spliterator` on API \\\n                level 24 and 25:\n\n                For a Collection view `c = lhm.entrySet()`, `c = lhm.keySet()` or \\\n                `c = lhm.values()`, use \\\n                `java.util.Spliterators.spliterator(c, c.spliterator().characteristics())` \\\n                instead of `c.spliterator()`.\n\n                Instead of `c.stream()` or `c.parallelStream()`, use \\\n                `java.util.stream.StreamSupport.stream(spliterator, false)` to construct a\n                (nonparallel) Stream from such a `Spliterator`.\n\n                **For Vector:**\n\n                The `listIterator()` returned for a `Vector` has a broken `add()` implementation \\\n                on Android N (API level 24). Consider switching to `ArrayList` and if necessary \\\n                adding synchronization.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/IteratorDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

