/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MissingClassDetector
extends LayoutDetector
implements ClassScanner {
    public static final Issue MISSING = Issue.create((String)"MissingRegistered", (String)"Missing registered class", (String)"If a class is referenced in the manifest or in a layout file, it must also exist in the project (or in one of the libraries included by the project. This check helps uncover typos in registration names, or attempts to rename or move classes without updating the XML references properly.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)new Implementation(MissingClassDetector.class, EnumSet.of(Scope.MANIFEST, Scope.CLASS_FILE, Scope.JAVA_LIBRARIES, Scope.RESOURCE_FILE))).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html").setAndroidSpecific(true).setEnabledByDefault(false);
    public static final Issue INSTANTIATABLE = Issue.create((String)"Instantiatable", (String)"Registered class is not instantiatable", (String)"Activities, services, broadcast receivers etc. registered in the manifest file (or for custom views, in a layout file) must be \"instantiatable\" by the system, which means that the class must be public, it must have an empty public constructor, and if it's an inner class, it must be a static inner class.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(MissingClassDetector.class, Scope.CLASS_FILE_SCOPE)).setAndroidSpecific(true);
    public static final Issue INNERCLASS = Issue.create((String)"InnerclassSeparator", (String)"Inner classes should use `$` rather than `.`", (String)"When you reference an inner class in a manifest file, you must use '$' instead of '.' as the separator character, i.e. Outer$Inner instead of Outer.Inner.\n\n(If you get this warning for a class which is not actually an inner class, it's because you are using uppercase characters in your package name, which is not conventional.)", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(MissingClassDetector.class, Scope.MANIFEST_SCOPE)).setAndroidSpecific(true);
    private Map<String, Location.Handle> mReferencedClasses;
    private Set<String> mCustomViews;
    private boolean mHaveClasses;

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitElement(XmlContext context, Element element) {
        int index;
        void var4_13;
        String fqcn;
        String className;
        Attr attr;
        String pkg = null;
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType == ResourceFolderType.VALUES) {
            if (!tag.equals("string")) {
                return;
            }
            attr = element.getAttributeNode("name");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr2 = attr;
        } else if (folderType == ResourceFolderType.LAYOUT) {
            if (tag.indexOf(46) > 0) {
                className = tag;
                Element element2 = element;
            } else {
                if (!tag.equals("fragment") && !tag.equals("view")) return;
                attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (attr == null) {
                    attr = element.getAttributeNode("class");
                }
                if (attr == null) {
                    return;
                }
                className = attr.getValue();
                Attr attr3 = attr;
            }
        } else if (folderType == ResourceFolderType.XML) {
            if (!tag.equals("header")) {
                return;
            }
            attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr4 = attr;
        } else {
            if (!"application".equals(tag) && !"activity".equals(tag) && !"service".equals(tag) && !"receiver".equals(tag) && !"provider".equals(tag)) return;
            attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr5 = attr;
            pkg = context.getProject().getPackage();
        }
        if (className.isEmpty()) {
            return;
        }
        int dotIndex = className.indexOf(46);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? pkg + className : pkg + '.' + className;
        } else {
            fqcn = className;
            if (folderType == ResourceFolderType.VALUES && !SdkUtils.endsWith((CharSequence)context.file.getPath(), (CharSequence)"analytics.xml")) {
                return;
            }
        }
        String signature = ClassContext.getInternalName((String)fqcn);
        if (signature.isEmpty() || signature.startsWith("android.")) {
            return;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        Location.Handle handle = null;
        if (!context.getDriver().isSuppressed(context, MISSING, (Node)element)) {
            if (this.mReferencedClasses == null) {
                this.mReferencedClasses = Maps.newHashMapWithExpectedSize((int)16);
                this.mCustomViews = Sets.newHashSetWithExpectedSize((int)8);
            }
            handle = context.createLocationHandle((Node)element);
            this.mReferencedClasses.put(signature, handle);
            if (folderType == ResourceFolderType.LAYOUT && !tag.equals("fragment")) {
                this.mCustomViews.add(ClassContext.getInternalName((String)className));
            }
        }
        if (signature.indexOf(36) == -1) return;
        MissingClassDetector.checkInnerClass(context, element, pkg, (Node)var4_13, className);
        if (handle == null) return;
        while ((index = signature.indexOf(36)) != -1) {
            signature = signature.substring(0, index) + '/' + signature.substring(index + 1);
            this.mReferencedClasses.put(signature, handle);
            if (folderType != ResourceFolderType.LAYOUT || tag.equals("fragment")) continue;
            this.mCustomViews.add(signature);
        }
    }

    private static void checkInnerClass(XmlContext context, Element element, String pkg, Node classNameNode, String className) {
        if (pkg != null && className.indexOf(36) == -1 && className.indexOf(46, 1) > 0) {
            boolean haveUpperCase = false;
            int n = pkg.length();
            for (int i = 0; i < n; ++i) {
                if (!Character.isUpperCase(pkg.charAt(i))) continue;
                haveUpperCase = true;
                break;
            }
            if (!haveUpperCase) {
                String fixed = className.charAt(0) + className.substring(1).replace('.', '$');
                String message2 = "Use '$' instead of '.' for inner classes (or use only lowercase letters in package names); replace \"" + className + "\" with \"" + fixed + "\"";
                Location location = context.getLocation(classNameNode);
                LintFix fix = LintFix.create().replace().text(className).with(fixed).autoFix().build();
                context.report(INNERCLASS, (Node)element, location, message2, fix);
            }
        }
    }

    public void afterCheckRootProject(Context context) {
        Project mainProject = context.getMainProject();
        if (context.getProject() == mainProject && this.mHaveClasses && !mainProject.isLibrary() && this.mReferencedClasses != null && !this.mReferencedClasses.isEmpty() && context.getDriver().getScope().contains(Scope.CLASS_FILE)) {
            ArrayList<String> classes = new ArrayList<String>(this.mReferencedClasses.keySet());
            Collections.sort(classes);
            block0: for (String owner : classes) {
                Location.Handle handle = this.mReferencedClasses.get(owner);
                String fqcn = ClassContext.getFqcn((String)owner);
                String signature = ClassContext.getInternalName((String)fqcn);
                if (!signature.equals(owner) ? !this.mReferencedClasses.containsKey(signature) : signature.indexOf(36) != -1 && !this.mReferencedClasses.containsKey(signature = signature.replace('$', '/'))) continue;
                this.mReferencedClasses.remove(owner);
                if (owner.startsWith("android/")) continue;
                ArrayList all = Lists.newArrayList((Iterable)mainProject.getAllLibraries());
                all.add(mainProject);
                for (Project project : all) {
                    for (File root : project.getJavaSourceFolders()) {
                        File source = new File(root, owner.replace('/', File.separatorChar) + ".java");
                        if (!source.exists()) continue;
                        continue block0;
                    }
                }
                PsiClass cls = context.getClient().getUastParser(mainProject).getEvaluator().findClass(fqcn);
                if (cls != null) {
                    String expectedName = owner.substring(owner.lastIndexOf(47) + 1);
                    if (owner.contains("$") && cls.getContainingClass() != null || expectedName.equals(cls.getName())) continue;
                }
                String message2 = String.format("Class referenced in the manifest, `%1$s`, was not found in the project or the libraries", fqcn);
                Location location = handle.resolve();
                File parentFile = location.getFile().getParentFile();
                if (parentFile != null) {
                    String parent = parentFile.getName();
                    ResourceFolderType type = ResourceFolderType.getFolderType((String)parent);
                    if (type == ResourceFolderType.LAYOUT) {
                        message2 = String.format("Class referenced in the layout file, `%1$s`, was not found in the project or the libraries", fqcn);
                    } else if (type == ResourceFolderType.XML) {
                        message2 = String.format("Class referenced in the preference header file, `%1$s`, was not found in the project or the libraries", fqcn);
                    } else if (type == ResourceFolderType.VALUES) {
                        message2 = String.format("Class referenced in the analytics file, `%1$s`, was not found in the project or the libraries", fqcn);
                    }
                }
                context.report(MISSING, location, message2);
            }
        }
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        if (!this.mHaveClasses && !context.isFromClassLibrary() && context.getProject() == context.getMainProject()) {
            this.mHaveClasses = true;
        }
        String curr = classNode.name;
        if (this.mReferencedClasses != null && this.mReferencedClasses.containsKey(curr)) {
            boolean isCustomView = this.mCustomViews.contains(curr);
            this.removeReferences(curr);
            if ((classNode.access & 2) != 0) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This class should be public (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)));
                return;
            }
            if (classNode.name.indexOf(36) != -1 && !Lint.isStaticInnerClass((ClassNode)classNode)) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This inner class should be static (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)));
                return;
            }
            boolean hasDefaultConstructor = false;
            List methodList = classNode.methods;
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                if (!method.name.equals("<init>") || !method.desc.equals("()V")) continue;
                if ((method.access & 1) == 0) {
                    context.report(INSTANTIATABLE, context.getLocation(method, classNode), "The default constructor must be public");
                }
                hasDefaultConstructor = true;
            }
            if (!hasDefaultConstructor && !isCustomView && !context.isFromClassLibrary() && context.getProject().getReportIssues()) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This class should provide a default constructor (a public constructor with no arguments) (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)));
            }
        }
    }

    private void removeReferences(String curr) {
        this.mReferencedClasses.remove(curr);
        int index = curr.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        boolean hasCapitalizedPackageName = false;
        for (int i = index - 1; i >= 0; --i) {
            char c = curr.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            hasCapitalizedPackageName = true;
            break;
        }
        if (!hasCapitalizedPackageName) {
            return;
        }
        while ((index = curr.lastIndexOf(47)) != -1) {
            curr = curr.substring(0, index) + '$' + curr.substring(index + 1);
            this.mReferencedClasses.remove(curr);
        }
    }
}

