/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConstraintLayoutDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"MissingConstraints", (String)"Missing Constraints in ConstraintLayout", (String)"The layout editor allows you to place widgets anywhere on the canvas, and it records the current position with designtime attributes (such as `layout_editor_absoluteX`). These attributes are **not** applied at runtime, so if you push your layout on a device, the widgets may appear in a different location than shown in the editor. To fix this, make sure a widget has both horizontal and vertical constraints by dragging from the edge connections.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ConstraintLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final GradleCoordinate LATEST_KNOWN_VERSION = new GradleCoordinate("com.android.support.constraint", "constraint-layout", "1.0.2");

    public Collection<String> getApplicableElements() {
        return ImmutableSet.of((Object)SdkConstants.CONSTRAINT_LAYOUT.oldName(), (Object)SdkConstants.CONSTRAINT_LAYOUT.newName(), (Object)SdkConstants.MOTION_LAYOUT.oldName(), (Object)SdkConstants.MOTION_LAYOUT.newName());
    }

    public void visitElement(XmlContext context, Element layout) {
        Variant variant = context.getMainProject().getCurrentVariant();
        GradleCoordinate latestAvailable = null;
        if (variant != null) {
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                GradleCoordinate version;
                MavenCoordinates rc = library.getResolvedCoordinates();
                if (!"com.android.support.constraint".equals(rc.getGroupId()) || !"constraint-layout".equals(rc.getArtifactId())) continue;
                if (latestAvailable == null) {
                    latestAvailable = ConstraintLayoutDetector.getLatestVersion(context);
                }
                if (GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable, version = new GradleCoordinate("com.android.support.constraint", "constraint-layout", rc.getVersion())) <= 0) continue;
                String message2 = "Using version " + version.getRevision() + " of the constraint library, which is obsolete";
                LintFix fix = this.fix().data(new Object[]{ConstraintLayoutDetector.class});
                context.report(GradleDetector.DEPENDENCY, (Node)layout, context.getLocation((Node)layout), message2, fix);
            }
        }
        for (Node child = layout.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            String elementTagName;
            if (child.getNodeType() != 1 || SdkConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(elementTagName = (element = (Element)child).getTagName()) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEquals(elementTagName) || "include".equals(elementTagName) || Lint.isLayoutMarkerTag((String)elementTagName)) continue;
            if (!Strings.isNullOrEmpty((String)elementTagName) && SdkConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(elementTagName) && ConstraintLayoutDetector.scanForBarrierConstraint(element)) break;
            boolean isConstrainedHorizontally = false;
            boolean isConstrainedVertically = false;
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null || !name.startsWith("layout_") || name.endsWith("_creator")) continue;
                if ("layout_width".equals(name) && "match_parent".equals(attribute.getNodeValue()) || name.endsWith("toLeftOf") || name.endsWith("toRightOf") || name.endsWith("toStartOf") || name.endsWith("toEndOf") || name.endsWith("toCenterX")) {
                    isConstrainedHorizontally = true;
                    if (!isConstrainedVertically) continue;
                    break;
                }
                if ((!"layout_height".equals(name) || !"match_parent".equals(attribute.getNodeValue())) && !name.endsWith("toTopOf") && !name.endsWith("toBottomOf") && !name.endsWith("toCenterY") && !name.endsWith("toBaselineOf")) continue;
                isConstrainedVertically = true;
                if (isConstrainedHorizontally) break;
            }
            if (isConstrainedHorizontally && isConstrainedVertically) continue;
            String message3 = isConstrainedVertically ? "This view is not constrained horizontally: at runtime it will jump to the left unless you add a horizontal constraint" : (isConstrainedHorizontally ? "This view is not constrained vertically: at runtime it will jump to the top unless you add a vertical constraint" : "This view is not constrained. It only has designtime positions, so it will jump to (0,0) at runtime unless you add the constraints");
            context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), message3);
        }
    }

    private static boolean scanForBarrierConstraint(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getLocalName();
            if (name == null || !name.endsWith("barrierDirection")) continue;
            return true;
        }
        return false;
    }

    private static GradleCoordinate getLatestVersion(XmlContext context) {
        GradleCoordinate fromPackage;
        ProgressIndicator progress;
        RepoPackage latestPackage;
        GradleCoordinate latestAvailable = LATEST_KNOWN_VERSION;
        AndroidSdkHandler sdkHandler = context.getClient().getSdk();
        if (sdkHandler != null && (latestPackage = SdkMavenRepository.findLatestVersion((GradleCoordinate)LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)(progress = context.getClient().getRepositoryLogger()))) != null && (fromPackage = SdkMavenRepository.getCoordinateFromSdkPath((String)latestPackage.getPath())) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable, fromPackage) < 0) {
            latestAvailable = fromPackage;
        }
        return latestAvailable;
    }
}

