/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

class SizeConstraint
extends RangeConstraint {
    final long exact;
    final long min;
    final long max;
    final long multiple;

    public static SizeConstraint create(UAnnotation annotation) {
        assert (AnnotationDetector.SIZE_ANNOTATION.isEquals(annotation.getQualifiedName()));
        long exact = UastLintUtils.getAnnotationLongValue((UAnnotation)annotation, (String)"value", (long)-1L);
        long min = UastLintUtils.getAnnotationLongValue((UAnnotation)annotation, (String)"min", (long)Long.MIN_VALUE);
        long max = UastLintUtils.getAnnotationLongValue((UAnnotation)annotation, (String)"max", (long)Long.MAX_VALUE);
        long multiple = UastLintUtils.getAnnotationLongValue((UAnnotation)annotation, (String)"multiple", (long)1L);
        return new SizeConstraint(exact, min, max, multiple);
    }

    @VisibleForTesting
    static SizeConstraint exactly(long value) {
        return new SizeConstraint(value, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
    }

    @VisibleForTesting
    static SizeConstraint atLeast(long value) {
        return new SizeConstraint(-1L, value, Long.MAX_VALUE, 1L);
    }

    @VisibleForTesting
    static SizeConstraint atMost(long value) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, value, 1L);
    }

    @VisibleForTesting
    static SizeConstraint range(long from, long to) {
        return new SizeConstraint(-1L, from, to, 1L);
    }

    @VisibleForTesting
    static SizeConstraint multiple(int multiple) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, Long.MAX_VALUE, multiple);
    }

    @VisibleForTesting
    static SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
        return new SizeConstraint(-1L, from, to, multiple);
    }

    @VisibleForTesting
    static SizeConstraint minWithMultiple(long from, int multiple) {
        return new SizeConstraint(-1L, from, Long.MAX_VALUE, multiple);
    }

    private SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public String toString() {
        return this.describe(null, null, null);
    }

    public boolean isValid(long actual) {
        return !(this.exact != -1L ? this.exact != actual : actual < this.min || actual > this.max || actual % this.multiple != 0L);
    }

    public String describe() {
        return this.describe(null, null, null);
    }

    public String describe(long argument) {
        return this.describe(null, null, argument);
    }

    public String describe(UExpression argument, String unit, Long actualValue) {
        if (unit == null) {
            unit = argument != null && argument.getExpressionType() != null && argument.getExpressionType().getCanonicalText().equals("java.lang.String") ? "Length" : "Size";
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            long actual = actualValue;
            if (this.exact != -1L) {
                if (this.exact != actual) {
                    return String.format("Expected %1$s %2$d (was %3$d)", unit, this.exact, actual);
                }
            } else {
                if (actual < this.min || actual > this.max) {
                    StringBuilder sb = new StringBuilder(20);
                    if (actual < this.min) {
                        sb.append("Expected ").append(unit).append(" \u2265 ");
                        sb.append(Long.toString(this.min));
                    } else {
                        assert (actual > this.max);
                        sb.append("Expected ").append(unit).append(" \u2264 ");
                        sb.append(Long.toString(this.max));
                    }
                    sb.append(" (was ").append(actual).append(')');
                    return sb.toString();
                }
                if (actual % this.multiple != 0L) {
                    return String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, this.multiple, actual, actual / this.multiple * this.multiple, (actual / this.multiple + 1L) * this.multiple);
                }
            }
        }
        StringBuilder sb = new StringBuilder(20);
        sb.append(unit);
        sb.append(" must be");
        if (this.exact != -1L) {
            sb.append(" exactly ");
            sb.append(Long.toString(this.exact));
            return sb.toString();
        }
        boolean continued = true;
        if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
            sb.append(" and at most ");
            sb.append(Long.toString(this.max));
        } else if (this.min != Long.MIN_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
        } else if (this.max != Long.MAX_VALUE) {
            sb.append(" at most ");
            sb.append(Long.toString(this.max));
        } else {
            continued = false;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb.append(" and");
            }
            sb.append(" a multiple of ");
            sb.append(Long.toString(this.multiple));
        }
        if (actualValue != null) {
            sb.append(" (was ").append(actualValue).append(')');
        }
        return sb.toString();
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof SizeConstraint) {
            SizeConstraint otherRange = (SizeConstraint)other;
            if (this.exact != -1L && otherRange.exact != -1L) {
                return this.exact == otherRange.exact;
            }
            if (this.multiple != 1L && (otherRange.exact != -1L ? otherRange.exact % this.multiple != 0L : otherRange.multiple % this.multiple != 0L)) {
                return false;
            }
            if (otherRange.exact != -1L) {
                return otherRange.exact >= this.min && otherRange.exact <= this.max;
            }
            return otherRange.min >= this.min && otherRange.max <= this.max;
        }
        return null;
    }
}

