/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.PrivateApiDetector$WhenMappings;
import com.android.tools.lint.checks.PrivateApiLookup;
import com.android.tools.lint.checks.Restriction;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J*\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/PrivateApiLookup;", "getApiDatabase", "()Lcom/android/tools/lint/checks/PrivateApiLookup;", "cachedApiDatabase", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "privateApiDatabase", "psiFactory", "Lcom/intellij/psi/PsiElementFactory;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkGetDeclaredMethod", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkLoadClass", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "getJavaClassFromMemberLookup", "getJavaClassType", "Lcom/intellij/psi/PsiType;", "element", "Lorg/jetbrains/uast/UElement;", "reportIssue", "restriction", "Lcom/android/tools/lint/checks/Restriction;", "api", "visitMethodCall", "node", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "lint-checks"})
public final class PrivateApiDetector
extends Detector
implements SourceCodeScanner {
    private LintClient client;
    private PsiElementFactory psiFactory;
    private boolean cachedApiDatabase;
    private PrivateApiLookup privateApiDatabase;
    @JvmField
    @NotNull
    public static final Issue PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue DISCOURAGED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue SOON_BLOCKED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue BLOCKED_PRIVATE_API;
    private static final String LOAD_CLASS = "loadClass";
    private static final String FOR_NAME = "forName";
    private static final String GET_CLASS = "getClass";
    private static final String GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    private static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    private static final String GET_DECLARED_FIELD = "getDeclaredField";
    private static final List<String> KOTLIN_REFLECTION_METHODS;
    private static final String ERROR_MESSAGE = "Accessing internal APIs via reflection is not supported and may not work on all devices or in the future";
    public static final Issues Issues;

    private final PrivateApiLookup getApiDatabase() {
        if (!this.cachedApiDatabase && this.privateApiDatabase == null && this.client != null) {
            LintClient lintClient = this.client;
            if (lintClient == null) {
                Intrinsics.throwNpe();
            }
            this.privateApiDatabase = PrivateApiLookup.Companion.get(lintClient);
            this.cachedApiDatabase = true;
        }
        return this.privateApiDatabase;
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.client = context.getClient();
        this.cachedApiDatabase = false;
        this.psiFactory = PsiElementFactory.SERVICE.getInstance((Project)context.getProject().getIdeaProject());
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{FOR_NAME, LOAD_CLASS, GET_DECLARED_CONSTRUCTOR, GET_DECLARED_METHOD, GET_DECLARED_FIELD});
    }

    @Nullable
    public List<String> getApplicableReferenceNames() {
        return KOTLIN_REFLECTION_METHODS;
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (Intrinsics.areEqual((Object)LOAD_CLASS, (Object)method.getName())) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.ClassLoader") || evaluator.isMemberInClass((PsiMember)method, "dalvik.system.DexFile")) {
                this.checkLoadClass(context, node);
            }
        } else {
            if (!evaluator.isMemberInClass((PsiMember)method, "java.lang.Class")) {
                return;
            }
            if (Intrinsics.areEqual((Object)GET_DECLARED_METHOD, (Object)method.getName())) {
                this.checkGetDeclaredMethod(context, node);
            } else {
                this.checkLoadClass(context, node);
            }
        }
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)referenced, (String)"referenced");
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGetDeclaredMethod(JavaContext context, UCallExpression call) {
        String string = this.getJavaClassFromMemberLookup(call);
        if (string == null) {
            return;
        }
        String cls = string;
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String methodName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass != null) {
            PsiMethod[] psiMethodArray = aClass.findMethodsByName(methodName, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"aClass.findMethodsByName(methodName, true)");
            PsiMethod[] psiMethodArray2 = psiMethodArray;
            boolean bl = false;
            PsiMethod[] psiMethodArray3 = psiMethodArray2;
            boolean bl2 = false;
            if (!(psiMethodArray3.length == 0)) {
                return;
            }
        }
        int targetSdk = context.getProject().getTargetSdk();
        Location location = context.getLocation((UElement)call);
        if (targetSdk < 26) {
            if (!StringsKt.startsWith$default((String)cls, (String)"com.android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)cls, (String)"android.", (boolean)false, (int)2, null)) {
                return;
            }
            JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        } else if (methodName != null) {
            PsiType[] psiTypeArray;
            if (arguments.size() >= 2) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = arguments.subList(1, arguments.size());
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiType psiType;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UExpression it = (UExpression)element$iv$iv;
                    boolean bl3 = false;
                    if (this.getJavaClassType((UElement)it) == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PsiType it$iv$iv = psiType;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiType[] psiTypeArray2 = thisCollection$iv.toArray(new PsiType[0]);
                if (psiTypeArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                psiTypeArray = psiTypeArray2;
            } else {
                psiTypeArray = new PsiType[]{};
            }
            PsiType[] argTypes = psiTypeArray;
            String string2 = JavaEvaluator.constructMethodDescription$default((JavaEvaluator)context.getEvaluator(), (String)methodName, (boolean)false, (PsiType[])argTypes, null, (boolean)false, (int)26, null);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction = privateApiLookup != null ? privateApiLookup.getMethodRestriction(cls, methodName, desc) : null;
            this.reportIssue(context, restriction, methodName, call);
        }
    }

    private final void checkLoadClass(JavaContext context, UCallExpression call) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)));
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String value = string;
        boolean isInternal = false;
        if (StringsKt.startsWith$default((String)value, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            isInternal = true;
        } else if (StringsKt.startsWith$default((String)value, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)value, (String)"android.support.", (boolean)false, (int)2, null)) {
            PsiClass aClass = context.getEvaluator().findClass(value);
            if (aClass != null) {
                return;
            }
            ApiLookup apiLookup = ApiLookup.get(context.getClient(), context.getMainProject().getBuildTarget());
            if (apiLookup == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)apiLookup, (String)"ApiLookup.get(\n         \u2026t\n            ) ?: return");
            ApiLookup apiLookup2 = apiLookup;
            boolean bl = isInternal = !apiLookup2.containsClass(value);
        }
        if (isInternal) {
            Location location = context.getLocation((UElement)call);
            JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final String getJavaClassFromMemberLookup(UCallExpression call) {
        PsiType psiType = this.getJavaClassType((UElement)call.getReceiver());
        return psiType != null ? psiType.getCanonicalText() : null;
    }

    private final PsiType getJavaClassType(UElement element) {
        if (element instanceof UExpression) {
            PsiType clazz;
            PsiType type = ((UExpression)element).getExpressionType();
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 1 && (clazz = ((PsiClassType)type).getParameters()[0]) instanceof PsiClassType) {
                PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)clazz);
                if (psiPrimitiveType != null) {
                    PsiPrimitiveType psiPrimitiveType2 = psiPrimitiveType;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiPrimitiveType it = psiPrimitiveType2;
                    boolean bl3 = false;
                    if (element instanceof UQualifiedReferenceExpression) {
                        String identifier;
                        UExpression uExpression = ((UQualifiedReferenceExpression)element).getSelector();
                        if (!(uExpression instanceof USimpleNameReferenceExpression)) {
                            uExpression = null;
                        }
                        USimpleNameReferenceExpression uSimpleNameReferenceExpression = (USimpleNameReferenceExpression)uExpression;
                        String string = identifier = uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null;
                        if (Intrinsics.areEqual((Object)identifier, (Object)"javaPrimitiveType") || Intrinsics.areEqual((Object)identifier, (Object)"TYPE")) {
                            clazz = (PsiType)it;
                        }
                    }
                    if (element instanceof UClassLiteralExpression && ((UExpression)element).evaluate() instanceof PsiPrimitiveType) {
                        clazz = (PsiType)it;
                    }
                }
                return clazz;
            }
            if (element instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiVariable) {
                    UExpression uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, element);
                    if (uExpression != null) {
                        UExpression uExpression2 = uExpression;
                        boolean bl = false;
                        boolean bl4 = false;
                        UExpression expression = uExpression2;
                        boolean bl5 = false;
                        return this.getJavaClassType((UElement)expression);
                    }
                }
                if (element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                    UExpression uExpression = ((UQualifiedReferenceExpression)element).getSelector();
                    if (uExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    UCallExpression call = (UCallExpression)uExpression;
                    String name = call.getMethodName();
                    if (Intrinsics.areEqual((Object)FOR_NAME, (Object)name) || Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
                        List arguments = call.getValueArguments();
                        Object object = arguments;
                        boolean bl = false;
                        if (!object.isEmpty()) {
                            PsiType psiType;
                            String string = ConstantEvaluator.evaluateString(null, (UElement)((UElement)arguments.get(0)), (boolean)false);
                            if (string != null) {
                                object = string;
                                bl = false;
                                boolean bl6 = false;
                                Object it = object;
                                boolean bl7 = false;
                                PsiElementFactory psiElementFactory = this.psiFactory;
                                if (psiElementFactory == null) {
                                    Intrinsics.throwNpe();
                                }
                                psiType = psiElementFactory.createTypeFromText((String)it, null);
                            } else {
                                psiType = null;
                            }
                            return psiType;
                        }
                    } else if (Intrinsics.areEqual((Object)GET_CLASS, (Object)name)) {
                        return TypeEvaluator.evaluate((UElement)((UElement)((UQualifiedReferenceExpression)element).getReceiver()));
                    }
                }
            }
        }
        return TypeEvaluator.evaluate((UElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void reportIssue(JavaContext context, Restriction restriction, String api, UCallExpression call) {
        int targetSdk = context.getProject().getTargetSdk();
        Function0<Unit> $fun$fatal$1 = new Function0<Unit>(context, call, api, targetSdk){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $call;
            final /* synthetic */ String $api;
            final /* synthetic */ int $targetSdk;

            public final void invoke() {
                JavaContext.report$default((JavaContext)this.$context, (Issue)PrivateApiDetector.BLOCKED_PRIVATE_API, (UElement)((UElement)this.$call), (Location)this.$context.getLocation((UElement)this.$call), (String)("Reflective access to " + this.$api + " is forbidden when targeting API " + this.$targetSdk + " and above"), null, (int)16, null);
            }
            {
                this.$context = javaContext;
                this.$call = uCallExpression;
                this.$api = string;
                this.$targetSdk = n;
                super(0);
            }
        };
        Function0<Unit> $fun$error$2 = new Function0<Unit>(context, call, api, targetSdk){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $call;
            final /* synthetic */ String $api;
            final /* synthetic */ int $targetSdk;

            public final void invoke() {
                JavaContext.report$default((JavaContext)this.$context, (Issue)PrivateApiDetector.SOON_BLOCKED_PRIVATE_API, (UElement)((UElement)this.$call), (Location)this.$context.getLocation((UElement)this.$call), (String)("Reflective access to " + this.$api + " will throw an exception when targeting API " + this.$targetSdk + " and above"), null, (int)16, null);
            }
            {
                this.$context = javaContext;
                this.$call = uCallExpression;
                this.$api = string;
                this.$targetSdk = n;
                super(0);
            }
        };
        Function0<Unit> $fun$warning$3 = new Function0<Unit>(context, call, api){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $call;
            final /* synthetic */ String $api;

            public final void invoke() {
                JavaContext.report$default((JavaContext)this.$context, (Issue)PrivateApiDetector.DISCOURAGED_PRIVATE_API, (UElement)((UElement)this.$call), (Location)this.$context.getLocation((UElement)this.$call), (String)("Reflective access to " + this.$api + ", which is not part of the public SDK and therefore likely to change in future Android releases"), null, (int)16, null);
            }
            {
                this.$context = javaContext;
                this.$call = uCallExpression;
                this.$api = string;
                super(0);
            }
        };
        Restriction restriction2 = restriction;
        if (restriction2 == null) return;
        switch (PrivateApiDetector$WhenMappings.$EnumSwitchMapping$0[restriction2.ordinal()]) {
            case 1: {
                $fun$fatal$1.invoke();
                return;
            }
            case 2: {
                if (targetSdk <= 26 || VersionChecks.isWithinVersionCheckConditional(context.getEvaluator(), (UElement)call, 26, false)) {
                    $fun$warning$3.invoke();
                    return;
                }
                $fun$error$2.invoke();
                return;
            }
            case 3: {
                if (targetSdk <= 28 || VersionChecks.isWithinVersionCheckConditional(context.getEvaluator(), (UElement)call, 28, false)) {
                    $fun$warning$3.invoke();
                    return;
                }
                $fun$error$2.invoke();
                return;
            }
            case 4: {
                $fun$warning$3.invoke();
                return;
            }
            default: {
                return;
            }
        }
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/preview/restrictions-non-sdk-interfaces";
        PRIVATE_API = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"PrivateApi", (String)"Using Private APIs", (String)"\n            Using reflection to access hidden/private Android APIs is not safe; it will often not work on \\\n            devices from other vendors, and it may suddenly stop working (if the API is removed) or crash \\\n            spectacularly (if the API behavior changes, since there are no guarantees for compatibility).\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.WARNING;
        n = 6;
        category = Category.CORRECTNESS;
        string = "https://developer.android.com/preview/restrictions-non-sdk-interfaces";
        DISCOURAGED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DiscouragedPrivateApi", (String)"Using Discouraged Private API", (String)"\n            Usage of restricted non-SDK interface may throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 6;
        category = Category.CORRECTNESS;
        string = "https://developer.android.com/preview/restrictions-non-sdk-interfaces";
        SOON_BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"SoonBlockedPrivateApi", (String)"Using Soon-to-Be Blocked Private API", (String)"\n            Usage of restricted non-SDK interface will throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.FATAL;
        n = 6;
        category = Category.CORRECTNESS;
        string = "https://developer.android.com/preview/restrictions-non-sdk-interfaces";
        BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"BlockedPrivateApi", (String)"Using Blocked Private API", (String)"\n            Usage of restricted non-SDK interface is forbidden for this targetSDK. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
        KOTLIN_REFLECTION_METHODS = CollectionsKt.listOf((Object[])new String[]{"members", "declaredMembers", "declaredFunctions", "declaredMemberFunctions", "declaredMemberProperties"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector$Issues;", "", "()V", "BLOCKED_PRIVATE_API", "Lcom/android/tools/lint/detector/api/Issue;", "DISCOURAGED_PRIVATE_API", "ERROR_MESSAGE", "", "FOR_NAME", "GET_CLASS", "GET_DECLARED_CONSTRUCTOR", "GET_DECLARED_FIELD", "GET_DECLARED_METHOD", "KOTLIN_REFLECTION_METHODS", "", "LOAD_CLASS", "PRIVATE_API", "SOON_BLOCKED_PRIVATE_API", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

