/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ThreadDetector$Companion$CHECKED$1;
import com.android.tools.lint.checks.ThreadDetector$WhenMappings;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.reflection.ReflectionUtilsKt;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0002J\u001e\u0010%\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010'\u001a\u00020\u0006H\u0002J|\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020+0\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+0\u000b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+0\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020+0\u000bH\u0016J\f\u00102\u001a\u00020\u001a*\u00020\bH\u0002\u00a8\u00064"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "addThreadAnnotations", "", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "result", "applicableAnnotations", "", "checkThreading", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "callerThreads", "calleeThreads", "describeThread", "describeThreads", "annotations", "any", "", "getThreadContext", "methodCall", "getThreadsFromExpressionContext", "lambdaCall", "Lorg/jetbrains/uast/UExpression;", "getThreadsFromMethod", "originalMethod", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isCompatibleThread", "caller", "callee", "callers", "visitAnnotationUsage", "usage", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "referenced", "Lcom/intellij/psi/PsiElement;", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "isThreadingAnnotation", "Companion", "lint-checks"})
public final class ThreadDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final Key<Boolean> CHECKED;
    @JvmField
    @NotNull
    public static final Issue THREAD;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.UI_THREAD_ANNOTATION.oldName(), AnnotationDetector.UI_THREAD_ANNOTATION.newName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.newName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.newName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.newName(), AnnotationDetector.ANY_THREAD_ANNOTATION.oldName(), AnnotationDetector.ANY_THREAD_ANNOTATION.newName()});
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return type == AnnotationUsageType.METHOD_CALL || type == AnnotationUsageType.METHOD_CALL_CLASS || type == AnnotationUsageType.METHOD_CALL_PARAMETER;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method == null) {
            return;
        }
        PsiElement psiElement = usage.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement usagePsi = psiElement;
        if (Intrinsics.areEqual((Object)((Boolean)usagePsi.getUserData(CHECKED)), (Object)true)) {
            return;
        }
        usagePsi.putUserData(CHECKED, (Object)true);
        switch (ThreadDetector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                List<String> list = this.getThreadContext(context, usage);
                if (list == null) {
                    return;
                }
                List<String> list2 = this.getThreadsFromMethod(context, method);
                if (list2 == null) {
                    return;
                }
                this.checkThreading(context, usage, method, list, list2);
                break;
            }
            case 3: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                UElement uElement = usage;
                if (!(uElement instanceof UCallableReferenceExpression)) {
                    uElement = null;
                }
                UCallableReferenceExpression uCallableReferenceExpression = (UCallableReferenceExpression)uElement;
                if (uCallableReferenceExpression == null) {
                    return;
                }
                UCallableReferenceExpression reference = uCallableReferenceExpression;
                PsiElement psiElement2 = reference.resolve();
                if (!(psiElement2 instanceof PsiMethod)) {
                    psiElement2 = null;
                }
                PsiMethod psiMethod = (PsiMethod)psiElement2;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod referencedMethod = psiMethod;
                Iterable iterable = annotations;
                PsiMethod psiMethod2 = referencedMethod;
                UElement uElement2 = usage;
                JavaContext javaContext = context;
                ThreadDetector threadDetector = this;
                boolean $i$f$mapNotNull = false;
                void var17_21 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UAnnotation it = (UAnnotation)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getQualifiedName() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String it$iv$iv = string;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                List<String> list3 = this.getThreadsFromMethod(context, referencedMethod);
                if (list3 == null) {
                    return;
                }
                threadDetector.checkThreading(javaContext, uElement2, psiMethod2, list, list3);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void checkThreading(JavaContext context, UElement node, PsiMethod method, List<String> callerThreads, List<String> calleeThreads) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = calleeThreads;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isCompatibleThread(callerThreads, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"post", (boolean)false, (int)2, null) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
            return;
        }
        if (calleeThreads.containsAll((Collection)callerThreads)) {
            return;
        }
        if (calleeThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || calleeThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.newName())) {
            return;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread";
        Object[] objectArray = new Object[]{method.isConstructor() ? "Constructor" : "Method", method.getName(), this.describeThreads(calleeThreads, true), this.describeThreads(callerThreads, false)};
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String message2 = string3;
        Location location = context.getLocation(node);
        this.report(context, THREAD, node, location, message2);
    }

    private final boolean isThreadingAnnotation(@NotNull PsiAnnotation $this$isThreadingAnnotation) {
        String signature = $this$isThreadingAnnotation.getQualifiedName();
        return signature != null && StringsKt.endsWith$default((String)signature, (String)"Thread", (boolean)false, (int)2, null) && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(signature);
    }

    /*
     * WARNING - void declaration
     */
    private final String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = ((Collection)annotations).size();
        while (n < n2) {
            void i;
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.describeThread(annotations.get((int)i)));
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String describeThread(String annotation) {
        String string = annotation;
        return Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.newName()) ? "UI" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.newName()) ? "main" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.newName()) ? "binder" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.newName()) ? "worker" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.newName()) ? "any" : "other"))));
    }

    private final boolean isCompatibleThread(List<String> callers, String callee) {
        Collection collection = callers;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (String caller : callers) {
            if (this.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCompatibleThread(String caller, String callee) {
        if (Intrinsics.areEqual((Object)callee, (Object)caller)) {
            return true;
        }
        if (AnnotationDetector.ANY_THREAD_ANNOTATION.isEquals(callee)) {
            return true;
        }
        if (AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(callee) ? AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(caller) : AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(callee) && AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(caller)) {
            return true;
        }
        int callerNameIndex = StringsKt.lastIndexOf$default((CharSequence)caller, (char)'.', (int)0, (boolean)false, (int)6, null);
        int calleeNameIndex = StringsKt.lastIndexOf$default((CharSequence)callee, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (callerNameIndex != -1 && calleeNameIndex != -1) {
            return StringsKt.regionMatches((String)caller, (int)callerNameIndex, (String)callee, (int)calleeNameIndex, (int)(caller.length() - callerNameIndex), (boolean)false);
        }
        return false;
    }

    private final List<String> getThreadContext(JavaContext context, UElement methodCall) {
        PsiMethod method;
        UElement uElement = UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class, ULambdaExpression.class});
        if (!(uElement instanceof PsiMethod)) {
            uElement = null;
        }
        if ((method = (PsiMethod)uElement) != null) {
            UClass containingClass = UastUtils.getContainingUClass((UElement)methodCall);
            if (containingClass instanceof UAnonymousClass) {
                UObjectLiteralExpression anonClassCall = (UObjectLiteralExpression)UastUtils.getParentOfType((UElement)methodCall, UObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{UCallExpression.class});
                List<String> list = this.getThreadsFromExpressionContext(context, (UExpression)anonClassCall);
                if (list == null) {
                    list = this.getThreadsFromMethod(context, method);
                }
                return list;
            }
            return this.getThreadsFromMethod(context, method);
        }
        ULambdaExpression lambdaCall = (ULambdaExpression)UastUtils.getParentOfType((UElement)methodCall, ULambdaExpression.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class, ULambdaExpression.class});
        return this.getThreadsFromExpressionContext(context, (UExpression)lambdaCall);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getThreadsFromExpressionContext(JavaContext context, UExpression lambdaCall) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        UExpression uExpression = lambdaCall;
        Object object = uExpression != null ? uExpression.getUastParent() : null;
        if (!(object instanceof UCallExpression)) {
            object = null;
        }
        UCallExpression uCallExpression = (UCallExpression)object;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression lambdaCallExpression = uCallExpression;
        PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)lambdaCallExpression, (UExpression)lambdaCall);
        if (psiParameter == null) {
            return null;
        }
        PsiParameter lambdaArgument = psiParameter;
        PsiAnnotation[] $this$filter$iv = context.getEvaluator().getAllAnnotations((PsiModifierListOwner)lambdaArgument, false);
        boolean $i$f$filter = false;
        PsiAnnotation[] psiAnnotationArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_10 = $this$filterTo$iv$iv;
        int n = ((void)var11_10).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var11_10[i];
            boolean bl = false;
            if (!this.isThreadingAnnotation((PsiAnnotation)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiAnnotation it = (PsiAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getQualifiedName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return annotations.isEmpty() ? null : annotations;
    }

    private final List<String> getThreadsFromMethod(JavaContext context, PsiMethod originalMethod) {
        PsiMethod method = originalMethod;
        if (method != null) {
            PsiAnnotation[] annotations;
            JavaEvaluator evaluator = context.getEvaluator();
            List<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, false)) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                if (evaluator.isStatic((PsiModifierListOwner)method)) {
                    return null;
                }
                method = evaluator.getSuperMethod(method);
            }
            while (cls != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private final List<String> addThreadAnnotations(PsiAnnotation annotation, List<String> result) {
        List resultList = result;
        String name = annotation.getQualifiedName();
        if (name != null && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(name) && StringsKt.endsWith$default((String)name, (String)"Thread", (boolean)false, (int)2, null)) {
            if (resultList == null) {
                resultList = new ArrayList(4);
            }
            String string = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SUPPORT_ANNOTATIONS_PREFIX.newName()");
            if (StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                String string2 = name;
                int n = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length();
                StringBuilder stringBuilder = new StringBuilder().append(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName());
                boolean bl = false;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                String oldName = stringBuilder.append(string4).toString();
                resultList.add(oldName);
            } else {
                resultList.add(name);
            }
        }
        return resultList;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ThreadDetector.class, Scope.JAVA_FILE_SCOPE);
        Key key = Key.create((String)ReflectionUtilsKt.getQualifiedName((KProperty)((KProperty)new ThreadDetector$Companion$CHECKED$1(Companion))));
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(::CHECKED.qualifiedName)");
        CHECKED = key;
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/guide/components/processes-and-threads.html#Threads";
        THREAD = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"WrongThread", (String)"Wrong Thread", (String)"\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread.\n                ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
    }

    public static final /* synthetic */ Key access$getCHECKED$cp() {
        return CHECKED;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector$Companion;", "", "()V", "CHECKED", "Lcom/intellij/openapi/util/Key;", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

