/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;

public class ParcelDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"ParcelCreator", (String)"Missing Parcelable `CREATOR` field", (String)"According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true).addMoreInfo("https://developer.android.com/reference/android/os/Parcelable.html");

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        PsiModifierList modifierList;
        PsiModifierList modifierList2;
        if (declaration instanceof UAnonymousClass) {
            return;
        }
        if (declaration.isInterface()) {
            return;
        }
        if (declaration.hasModifierProperty("abstract")) {
            return;
        }
        if (context.getEvaluator().implementsInterface((PsiClass)declaration, "android.text.ParcelableSpan", false)) {
            return;
        }
        boolean isKotlin = Lint.isKotlin((PsiElement)declaration);
        if (isKotlin && (modifierList2 = declaration.getModifierList()) != null && modifierList2.findAnnotation("kotlinx.android.parcel.Parcelize") != null) {
            return;
        }
        PsiField field = declaration.findFieldByName("CREATOR", true);
        if (field == null) {
            Location location = context.getNameLocation(declaration);
            String message2 = "This class implements `Parcelable` but does not provide a `CREATOR` field";
            context.report(ISSUE, declaration, location, message2, null);
        } else if (Lint.isKotlin((PsiElement)field) && !ParcelDetector.hasCreatorInnerClass(declaration) && (modifierList = field.getModifierList()) != null && modifierList.findAnnotation("kotlin.jvm.JvmField") == null) {
            Location location = context.getNameLocation((PsiElement)field);
            LintFix fix = this.fix().name("Add @JvmField", true).replace().text("val").with("@JvmField val").range(context.getLocation((PsiElement)field)).autoFix().build();
            context.report(ISSUE, (PsiElement)field, location, "Field should be annotated with `@JvmField`", fix);
        }
    }

    private static boolean hasCreatorInnerClass(UClass declaration) {
        for (UClass inner : declaration.getInnerClasses()) {
            String name = inner.getName();
            if (!"CREATOR".equals(name)) continue;
            return true;
        }
        return false;
    }
}

