/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.model.LintModelMavenName;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JP\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JX\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002J<\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\"2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0014H\u0002J \u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0006H\u0002J|\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkRestrictTo", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMember;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "applyClassAnnotationsToMembers", "", "member", "scope", "", "checkVisibleForTesting", "containsRestrictionAnnotation", "list", "inheritAnnotation", "isGmsContext", "element", "isTestContext", "reportRestriction", "where", "containingClass", "Lcom/intellij/psi/PsiClass;", "isClassAnnotation", "reportVisibilityError", "desc", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final String ATTR_OTHERWISE = "otherwise";
    private static final String ATTR_PRODUCTION_VISIBILITY = "productionVisibility";
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_LIBRARY_GROUP_PREFIX = 4;
    private static final int RESTRICT_TO_TESTS = 8;
    private static final int RESTRICT_TO_SUBCLASSES = 16;
    private static final int RESTRICT_TO_ALL = 32;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED;
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[6];
        String string = AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.oldName()");
        objectArray[0] = string;
        String string2 = AnnotationDetector.RESTRICT_TO_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RESTRICT_TO_ANNOTATION.newName()");
        objectArray[1] = string2;
        objectArray[2] = "com.google.android.gms.common.internal.Hide";
        String string3 = AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VISIBLE_FOR_TESTING_ANNOTATION.oldName()");
        objectArray[3] = string3;
        String string4 = AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"VISIBLE_FOR_TESTING_ANNOTATION.newName()");
        objectArray[4] = string4;
        objectArray[5] = "com.google.common.annotations.VisibleForTesting";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        block5: {
            String string;
            PsiMember member;
            block6: {
                block4: {
                    PsiMember psiMember;
                    PsiElement psiElement;
                    PsiElement sourcePsi;
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
                    Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                    Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
                    Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
                    Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
                    Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
                    Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
                    Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
                    if (type == AnnotationUsageType.EXTENDS && usage instanceof UTypeReferenceExpression && Lint.isKotlin((PsiElement)(sourcePsi = usage.getSourcePsi())) && Intrinsics.areEqual((Object)((psiElement = sourcePsi) != null && (psiElement = psiElement.getParent()) != null ? psiElement.toString() : null), (Object)"CONSTRUCTOR_CALLEE")) {
                        return;
                    }
                    PsiMethod psiMethod = method;
                    if (psiMethod != null) {
                        psiMember = (PsiMember)psiMethod;
                    } else {
                        PsiElement psiElement2 = referenced;
                        if (!(psiElement2 instanceof PsiMember)) {
                            psiElement2 = null;
                        }
                        psiMember = (PsiMember)psiElement2;
                    }
                    member = psiMember;
                    string = qualifiedName;
                    if (!Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) && !Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName())) break block4;
                    this.checkRestrictTo(context, usage, member, annotation, allMemberAnnotations, allClassAnnotations, true);
                    break block5;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"com.google.android.gms.common.internal.Hide")) break block6;
                boolean isConstructor = method == null || method.isConstructor();
                boolean isStatic = method == null ? false : context.getEvaluator().isStatic((PsiModifierListOwner)method);
                this.checkRestrictTo(context, usage, (PsiMember)method, annotation, allMemberAnnotations, allClassAnnotations, isConstructor || isStatic);
                break block5;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName()) && !Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName()) && !Intrinsics.areEqual((Object)string, (Object)"com.google.common.annotations.VisibleForTesting") || member == null) break block5;
            this.checkVisibleForTesting(context, usage, member, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    private final boolean isGmsContext(JavaContext context, UElement element) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiPackage psiPackage = evaluator.getPackage(element);
        if (psiPackage == null) {
            return false;
        }
        PsiPackage pkg = psiPackage;
        String string = pkg.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pkg.qualifiedName");
        String qualifiedName = string;
        if (!StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.firebase", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.android.gms", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.ads", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.mlkit", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTestContext(JavaContext context, UElement element) {
        UElement current = element;
        if (context.isTestSource()) {
            return true;
        }
        while (true) {
            UAnnotated owner;
            void $this$getParentOfType$iv;
            UElement uElement = current;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if ((UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UAnnotated.class, (boolean)strict$iv) == null) {
                break;
            }
            for (UAnnotation annotation : owner.getUAnnotations()) {
                int restrictionScope;
                String name = annotation.getQualifiedName();
                if (!(AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(name) ? ((restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation)) & 8) != 0 : AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.isEquals(name))) continue;
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        int visibility = RestrictToDetector.Companion.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            RestrictToDetector.checkRestrictTo$default(this, context, node, method, annotation, allMethodAnnotations, allClassAnnotations, 8, false, 128, null);
        } else {
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.Companion.getPsiFile(uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.Companion.getContainingFile((PsiElement)method))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            PsiPackage methodPackage = evaluator.getPackage((PsiElement)method);
            PsiPackage psiPackage = pkg;
            PsiPackage psiPackage2 = methodPackage;
            if (Intrinsics.areEqual((Object)(psiPackage != null ? psiPackage.getQualifiedName() : null), (Object)(psiPackage2 != null ? psiPackage2.getQualifiedName() : null))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "package private");
                }
                return;
            }
            boolean bl = visibility == 4;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context, node)) {
                this.reportVisibilityError(context, node, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context, UElement node, String desc) {
        String message2 = "This method should only be accessed from tests or within " + desc + " scope";
        Location location = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, false, false) : context.getLocation(node);
        this.report(context, TEST_VISIBILITY, node, location, message2);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, boolean applyClassAnnotationsToMembers) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, scope, applyClassAnnotationsToMembers);
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list, list2, bl);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember member, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, int scope, boolean applyClassAnnotationsToMembers) {
        String qualifiedName;
        String methodGroup2;
        Object thisGroup;
        LintModelMavenName methodCoordinates;
        Object $this$run;
        LintModelMavenName thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass;
        Object object;
        if (node instanceof UTypeReferenceExpression) {
            object = PsiTypesUtil.getPsiClass((PsiType)((UTypeReferenceExpression)node).getType());
        } else if (member != null) {
            object = member.getContainingClass();
        } else if (node instanceof UCallExpression) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)node).getClassReference();
            Object object2 = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
            if (!(object2 instanceof PsiClass)) {
                object2 = null;
            }
            object = (PsiClass)object2;
        } else {
            object = node instanceof PsiClass ? (PsiClass)node : null;
        }
        if ((containingClass = object) == null) {
            return;
        }
        boolean isClassAnnotation = false;
        if (UastLintUtils.Companion.containsAnnotation(allMethodAnnotations, annotation)) {
            if (member != null && context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)member)) {
                return;
            }
        } else if (applyClassAnnotationsToMembers) {
            if (this.containsRestrictionAnnotation(allMethodAnnotations)) {
                return;
            }
            isClassAnnotation = UastLintUtils.Companion.containsAnnotation(allClassAnnotations, annotation);
            if (isClassAnnotation ? context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)containingClass) : this.containsRestrictionAnnotation(allClassAnnotations)) {
                return;
            }
        } else {
            return;
        }
        if ((scope & 1) != 0 && member != null) {
            Object object3;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = thisCoordinates = context.getProject().getMavenCoordinate();
            }
            if ((object3 = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector restrictToDetector = this;
                boolean bl = false;
                boolean bl2 = false;
                $this$run = restrictToDetector;
                boolean bl3 = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context.getEvaluator().getProject((PsiElement)member);
                    object3 = project != null ? project.getMavenCoordinate() : null;
                } else {
                    object3 = null;
                }
            }
            methodCoordinates = object3;
            LintModelMavenName lintModelMavenName2 = thisCoordinates;
            thisGroup = lintModelMavenName2 != null ? lintModelMavenName2.getGroupId() : null;
            LintModelMavenName lintModelMavenName3 = methodCoordinates;
            String string = methodGroup2 = lintModelMavenName3 != null ? lintModelMavenName3.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup2) ^ true && methodGroup2 != null) {
                String where = "from within the same library group (groupId=" + methodGroup2 + ')';
                this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
            }
        } else if ((scope & 4) != 0 && member != null) {
            int n;
            Object object4;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = thisCoordinates = context.getProject().getMavenCoordinate();
            }
            if ((object4 = evaluator.getLibrary((PsiElement)member)) == null) {
                thisGroup = this;
                boolean methodGroup2 = false;
                boolean where = false;
                $this$run = thisGroup;
                n = 0;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context.getEvaluator().getProject((PsiElement)member);
                    object4 = project != null ? project.getMavenCoordinate() : null;
                } else {
                    object4 = null;
                }
            }
            methodCoordinates = object4;
            LintModelMavenName lintModelMavenName4 = thisCoordinates;
            thisGroup = lintModelMavenName4 != null ? lintModelMavenName4.getGroupId() : null;
            LintModelMavenName lintModelMavenName5 = methodCoordinates;
            String string = methodGroup2 = lintModelMavenName5 != null ? lintModelMavenName5.getGroupId() : null;
            if (!(methodGroup2 == null || thisGroup != null && Companion.sameLibraryGroupPrefix((String)thisGroup, methodGroup2))) {
                $this$run = methodGroup2;
                n = 0;
                int n2 = StringsKt.lastIndexOf$default((CharSequence)methodGroup2, (char)'.', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string2 = ((String)$this$run).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String expectedPrefix = string2;
                String where = "from within the same library group prefix (referenced groupId=`" + methodGroup2 + "` with prefix " + expectedPrefix + (thisGroup != null ? " from groupId=`" + (String)thisGroup + '`' : "") + ')';
                this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
            }
        } else if ((scope & 2) != 0 && member != null) {
            Project project;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = context.getProject().getMavenCoordinate();
            }
            thisCoordinates = lintModelMavenName;
            methodCoordinates = evaluator.getLibrary((PsiElement)member);
            LintModelMavenName lintModelMavenName6 = thisCoordinates;
            thisGroup = lintModelMavenName6 != null ? lintModelMavenName6.getGroupId() : null;
            LintModelMavenName lintModelMavenName7 = methodCoordinates;
            String string = methodGroup2 = lintModelMavenName7 != null ? lintModelMavenName7.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup2) ^ true && methodGroup2 != null) {
                String methodArtifact;
                LintModelMavenName lintModelMavenName8 = thisCoordinates;
                String thisArtifact = lintModelMavenName8 != null ? lintModelMavenName8.getArtifactId() : null;
                if (Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId())) ^ true) {
                    String where = "from within the same library (" + methodGroup2 + ':' + methodArtifact + ')';
                    this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
                }
            } else if (!(member instanceof PsiCompiledElement) && (project = context.getEvaluator().getProject((PsiElement)member)) != null && Intrinsics.areEqual((Object)project, (Object)context.getProject()) ^ true) {
                LintModelMavenName coordinates = project.getMavenCoordinate();
                String name = coordinates != null ? coordinates.getGroupId() + ':' + coordinates.getArtifactId() : project.getName();
                String where = "from within the same library (" + name + ')';
                this.reportRestriction(where, containingClass, member, context, node, isClassAnnotation);
            }
        }
        if ((scope & 8) != 0 && !this.isTestContext(context, node)) {
            this.reportRestriction("from tests", containingClass, member, context, node, isClassAnnotation);
        }
        if ((scope & 0x20) != 0 && !this.isGmsContext(context, node)) {
            this.reportRestriction(null, containingClass, member, context, node, isClassAnnotation);
        }
        if ((scope & 0x10) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            JavaEvaluator evaluator2 = context.getEvaluator();
            UClass outer = null;
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = (UElement)outer;
            }
            if (!isSubClass) {
                this.reportRestriction("from subclasses", containingClass, member, context, node, isClassAnnotation);
            }
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list, List list2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list, list2, n, bl);
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMember member, JavaContext context, UElement node, boolean isClassAnnotation) {
        Object object;
        Object api = null;
        if (member == null || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            Object object2 = member;
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = Intrinsics.stringPlus((String)containingClass.getName(), (Object)" constructor");
            }
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"member?.name ?: containi\u2026ass.name + \" constructor\"");
        } else {
            String string;
            if (Intrinsics.areEqual((Object)containingClass, (Object)member)) {
                string = member.getName();
                if (string == null) {
                    string = "class";
                }
            } else {
                string = containingClass.getName() + "." + member.getName();
            }
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (containingClass == m\u2026\" + member.name\n        }");
        }
        api = object;
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            if (isClassAnnotation) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = containingClass.getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api = className;
                }
            }
        }
        String message2 = null;
        if (where == null) {
            message2 = (String)api + " is marked as internal and should not be accessed from apps";
        } else {
            String refType = member instanceof PsiMethod ? "called" : "accessed";
            message2 = (String)api + " can only be " + refType + ' ' + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = null;
        location = locationNode instanceof UCallExpression ? context.getCallLocation((UCallExpression)locationNode, false, false) : context.getLocation(locationNode);
        this.report(context, RESTRICTED, node, location, message2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsRestrictionAnnotation(List<? extends UAnnotation> list) {
        String string = AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.oldName()");
        if (UastLintUtils.Companion.containsAnnotation(list, string)) return true;
        String string2 = AnnotationDetector.RESTRICT_TO_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RESTRICT_TO_ANNOTATION.newName()");
        if (!UastLintUtils.Companion.containsAnnotation(list, string2)) return false;
        return true;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
        RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                With the `@VisibleForTesting` annotation you can specify an `otherwise=` \\\n                attribute which specifies the intended visibility if the method had not \\\n                been made more widely visible for the tests.\n\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "()V", "ATTR_OTHERWISE", "", "ATTR_PRODUCTION_VISIBILITY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "RESTRICT_TO_ALL", "", "RESTRICT_TO_LIBRARY", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_LIBRARY_GROUP_PREFIX", "RESTRICT_TO_SUBCLASSES", "RESTRICT_TO_TESTS", "TEST_VISIBILITY", "VISIBILITY_NONE", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PRIVATE", "VISIBILITY_PROTECTED", "getRestrictionScope", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "expression", "Lorg/jetbrains/uast/UExpression;", "getVisibilityForTesting", "sameLibraryGroupPrefix", "", "group1", "group2", "lint-checks"})
    public static final class Companion {
        /*
         * Enabled aggressive block sorting
         */
        private final int getVisibilityForTesting(UAnnotation annotation) {
            JvmAnnotationAttribute otherwise;
            UExpression value;
            UExpression uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
            if (uExpression == null) {
                uExpression = value = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY);
            }
            if (value instanceof ULiteralExpression) {
                Object v = ((ULiteralExpression)value).getValue();
                if (!(v instanceof Integer)) return 2;
                return (Integer)v;
            }
            if (value instanceof UReferenceExpression) {
                String name;
                String string = name = ((UReferenceExpression)value).getResolvedName();
                if (string == null) {
                    return 2;
                }
                String string2 = string;
                int n = -1;
                switch (string2.hashCode()) {
                    case 2402104: {
                        if (!string2.equals("NONE")) return 2;
                        n = 1;
                        break;
                    }
                    case -2116912242: {
                        if (!string2.equals("PROTECTED")) return 2;
                        n = 2;
                        break;
                    }
                    case 403485027: {
                        if (!string2.equals("PRIVATE")) return 2;
                        n = 3;
                        break;
                    }
                    case 1152750154: {
                        if (!string2.equals("PACKAGE_PRIVATE")) return 2;
                        n = 4;
                    }
                }
                switch (n) {
                    case 1: {
                        return 5;
                    }
                    case 3: {
                        return 2;
                    }
                    case 2: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                }
                return 2;
            }
            if (!(value instanceof UastEmptyExpression)) return 2;
            PsiElement psi = annotation.getSourcePsi();
            if (!(psi instanceof ClsAnnotationImpl)) return 2;
            JvmAnnotationAttribute jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_OTHERWISE);
            if (jvmAnnotationAttribute == null) {
                jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY);
            }
            JvmAnnotationAttribute jvmAnnotationAttribute2 = otherwise = jvmAnnotationAttribute;
            JvmAnnotationAttributeValue v = jvmAnnotationAttribute2 != null ? jvmAnnotationAttribute2.getAttributeValue() : null;
            if (!(v instanceof JvmAnnotationConstantValue)) return 2;
            Object constant = ((JvmAnnotationConstantValue)v).getConstantValue();
            if (!(constant instanceof Number)) return 2;
            return ((Number)constant).intValue();
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value, annotation);
            }
            if (Intrinsics.areEqual((Object)"com.google.android.gms.common.internal.Hide", (Object)annotation.getQualifiedName())) {
                return 32;
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression, UAnnotation annotation) {
            int scope = 0;
            if (expression != null) {
                PsiElement psi;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer, annotation);
                    }
                } else if (expression instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)expression).resolve();
                    if (resolved instanceof PsiField) {
                        String string = ((PsiField)resolved).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolved.name");
                        String name = string;
                        if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                            scope |= 1;
                        } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                            scope |= 0x10;
                        } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                            scope |= 8;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                            scope |= 2;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY_GROUP_PREFIX", (Object)name)) {
                            scope |= 4;
                        }
                    }
                } else if (expression instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = otherwise = ((ClsAnnotationImpl)psi).findAttribute("value");
                    Object object = v = jvmAnnotationAttribute != null ? jvmAnnotationAttribute.getAttributeValue() : null;
                    if (v instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v).getConstantValue()) instanceof Number) {
                        scope |= ((Number)constant).intValue();
                    }
                }
            }
            return scope;
        }

        public final boolean sameLibraryGroupPrefix(@NotNull String group1, @NotNull String group2) {
            Intrinsics.checkParameterIsNotNull((Object)group1, (String)"group1");
            Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group2");
            if (Intrinsics.areEqual((Object)group1, (Object)group2)) {
                return true;
            }
            int i1 = StringsKt.lastIndexOf$default((CharSequence)group1, (char)'.', (int)0, (boolean)false, (int)6, null);
            int i2 = StringsKt.lastIndexOf$default((CharSequence)group2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (i2 != i1 || i1 == -1) {
                return false;
            }
            return StringsKt.regionMatches$default((String)group1, (int)0, (String)group2, (int)0, (int)i1, (boolean)false, (int)16, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

