/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccessibilityDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"ContentDescription", (String)"Image without `contentDescription`", (String)"Non-textual widgets like ImageViews and ImageButtons should use the `contentDescription` attribute to specify a textual description of the widget such that screen readers and other accessibility tools can adequately describe the user interface.\n\nNote that elements in application screens that are purely decorative and do not provide any content or enable a user action should not have accessibility content descriptions. In this case, just suppress the lint warning with a tools:ignore=\"ContentDescription\" attribute.\n\nNote that for text fields, you should not set both the `hint` and the `contentDescription` attributes since the hint will never be shown. Just set the `hint`.", (Category)Category.A11Y, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(AccessibilityDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/ui/accessibility/apps#special-cases");

    public Collection<String> getApplicableElements() {
        return Arrays.asList("ImageButton", "ImageView", SdkConstants.FLOATING_ACTION_BUTTON.oldName(), SdkConstants.FLOATING_ACTION_BUTTON.newName());
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("contentDescription");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            context.report(ISSUE, (Node)element, context.getLocation((Node)attribute), "Do not set both `contentDescription` and `hint`: the `contentDescription` will mask the `hint`");
        }
    }

    public void visitElement(XmlContext context, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "contentDescription")) {
            if ("no".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "importantForAccessibility"))) {
                return;
            }
            LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "contentDescription").build();
            context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), "Missing `contentDescription` attribute on image", fix);
        } else {
            Attr attributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
            String attribute = attributeNode.getValue();
            if (attribute.isEmpty() || attribute.equals("TODO")) {
                LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "contentDescription").build();
                context.report(ISSUE, (Node)attributeNode, context.getLocation((Node)attributeNode), "Empty `contentDescription` attribute on image", fix);
            }
        }
    }
}

