/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUTypeCheckExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/AssertDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkKotlinAssertion", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "assertion", "Lorg/jetbrains/uast/UCallExpression;", "createKotlinAssertionStatusFix", "Lcom/android/tools/lint/detector/api/LintFix;", "assertCall", "getApplicableMethodNames", "", "", "isExpensive", "", "argument", "Lorg/jetbrains/uast/UExpression;", "depth", "", "isWithinAssertionStatusCheck", "node", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "warnAboutWork", "condition", "Issues", "lint-checks"})
public final class AssertDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue EXPENSIVE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"assert");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!Lint.isKotlin((PsiElement)node.getSourcePsi())) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        String string2 = string = psiClass == null ? null : psiClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String string3 = string;
        String containingClass = string3;
        if (!Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt") && !Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt__AssertionsJVMKt")) {
            return;
        }
        this.checkKotlinAssertion(context, node);
    }

    private final void checkKotlinAssertion(JavaContext context, UCallExpression assertion) {
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)assertion.getValueArguments());
        if (uExpression == null) {
            return;
        }
        UExpression condition = uExpression;
        if (context.isEnabled(EXPENSIVE) && this.warnAboutWork(assertion, condition)) {
            Location location = context.getLocation((UElement)condition);
            String message2 = "Kotlin assertion arguments are always evaluated, even when assertions are off";
            LintFix fix = null;
            UClass cls = (UClass)UastUtils.getParentOfType((UElement)((UElement)assertion), UClass.class, (boolean)true);
            UClass uClass = cls;
            if ((uClass == null ? null : uClass.getSourcePsi()) != null) {
                fix = this.createKotlinAssertionStatusFix(context, assertion);
                message2 = Intrinsics.stringPlus((String)message2, (Object)". Consider surrounding assertion with `if (javaClass.desiredAssertionStatus()) { assert(...) }`");
            } else {
                fix = null;
            }
            context.report(EXPENSIVE, (UElement)assertion, location, message2, fix);
        }
    }

    private final LintFix createKotlinAssertionStatusFix(JavaContext context, UCallExpression assertCall) {
        return this.fix().name("Surround with desiredAssertionStatus() check").replace().range(context.getLocation((UElement)assertCall)).pattern("(.*)").with("if (javaClass.desiredAssertionStatus()) { \\k<1> }").reformat(true).build();
    }

    private final boolean warnAboutWork(UCallExpression assertCall, UExpression condition) {
        return this.isExpensive(condition, 0) && !this.isWithinAssertionStatusCheck((UExpression)assertCall);
    }

    private final boolean isExpensive(UExpression argument, int depth) {
        PsiMethod method;
        if (depth == 4) {
            return true;
        }
        if (argument instanceof ULiteralExpression || argument instanceof UInstanceExpression) {
            return false;
        }
        if (argument instanceof UBinaryExpressionWithType) {
            return argument instanceof KotlinUTypeCheckExpression ? false : this.isExpensive(((UBinaryExpressionWithType)argument).getOperand(), depth + 1);
        }
        if (argument instanceof UPolyadicExpression) {
            for (UExpression value : ((UPolyadicExpression)argument).getOperands()) {
                if (!this.isExpensive(value, depth + 1)) continue;
                return true;
            }
            return false;
        }
        if (argument instanceof UParenthesizedExpression) {
            return this.isExpensive(((UParenthesizedExpression)argument).getExpression(), depth + 1);
        }
        if (argument instanceof UBinaryExpression) {
            return this.isExpensive(((UBinaryExpression)argument).getLeftOperand(), depth + 1) || this.isExpensive(((UBinaryExpression)argument).getRightOperand(), depth + 1);
        }
        if (argument instanceof UUnaryExpression) {
            return this.isExpensive(((UUnaryExpression)argument).getOperand(), depth + 1);
        }
        if (argument instanceof USimpleNameReferenceExpression) {
            return false;
        }
        if (argument instanceof UQualifiedReferenceExpression) {
            if (((UQualifiedReferenceExpression)argument).getSelector() instanceof UCallExpression) {
                return this.isExpensive(((UQualifiedReferenceExpression)argument).getSelector(), depth + 1);
            }
            Object value = argument.evaluate();
            if (value != null) {
                return false;
            }
            PsiElement resolved = ((UQualifiedReferenceExpression)argument).resolve();
            if (resolved instanceof PsiVariable) {
                return false;
            }
        } else if (argument instanceof UCallExpression && (method = ((UCallExpression)argument).resolve()) != null && !(method instanceof PsiCompiledElement)) {
            UExpression uExpression;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)method), UMethod.class);
            UExpression uExpression2 = uExpression = uMethod == null ? null : uMethod.getUastBody();
            if (uExpression == null) {
                return true;
            }
            UExpression body = uExpression;
            if (body instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)body).getExpressions();
                if (expressions.size() == 1 && expressions.get(0) instanceof UReturnExpression) {
                    UExpression retExp = ((UReturnExpression)expressions.get(0)).getReturnExpression();
                    return retExp == null || this.isExpensive(retExp, depth + 1);
                }
            } else {
                return this.isExpensive(body, depth + 1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isWithinAssertionStatusCheck(UExpression node) {
        UExpression curr = node;
        while (true) {
            void $this$getParentOfType$iv;
            Object object = (UElement)curr;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UIfExpression uIfExpression = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv);
            if (uIfExpression == null) break;
            UIfExpression ifStatement = uIfExpression;
            if (Intrinsics.areEqual((uIfExpression = ifStatement.getCondition().getSourcePsi()) == null ? null : ((object = uIfExpression.getText()) == null ? null : Boolean.valueOf(StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"desiredAssertionStatus", (boolean)false, (int)2, null))), (Object)true)) {
                return true;
            }
            curr = (UExpression)ifStatement;
        }
        return false;
    }

    static {
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE);
        EXPENSIVE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ExpensiveAssertion", (String)"Expensive Assertions", (String)"\n                In Kotlin, assertions are not handled the same way as from the Java programming \\\n                language. In particular, they're just implemented as a library call, and inside \\\n                the library call the error is only thrown if assertions are enabled.\n\n                This means that the arguments to the `assert` call will **always** \\\n                be evaluated. If you're doing any computation in the expression being \\\n                asserted, that computation will unconditionally be performed whether or not \\\n                assertions are turned on. This typically turns into wasted work in release \\\n                builds.\n\n                This check looks for cases where the assertion condition is nontrivial, e.g. \\\n                it is performing method calls or doing more work than simple comparisons \\\n                on local variables or fields.\n\n                You can work around this by writing your own inline assert method instead:\n\n                ```kotlin\n                @Suppress(\"INVISIBLE_REFERENCE\", \"INVISIBLE_MEMBER\")\n                inline fun assert(condition: () -> Boolean) {\n                    if (_Assertions.ENABLED && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n\n                In Android, because assertions are not enforced at runtime, instead use this:\n\n                ```kotlin\n                inline fun assert(condition: () -> Boolean) {\n                    if (BuildConfig.DEBUG && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3600, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/AssertDetector$Issues;", "", "()V", "EXPENSIVE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

