/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkRequiredAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "attribute", "validateNestedRestrictions", "", "restrictionType", "keys", "", "depth", "", "validateRestriction", "node", "Lorg/w3c/dom/Node;", "verifyRestrictionTagName", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class RestrictionsDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_NESTING_DEPTH = 20;
    public static final int MAX_NUMBER_OF_NESTED_RESTRICTIONS = 1000;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String TAG_RESTRICTIONS = "restrictions";
    @NotNull
    private static final String TAG_RESTRICTION = "restriction";
    @NotNull
    private static final String ATTR_RESTRICTION_TYPE = "restrictionType";
    @NotNull
    private static final String ATTR_KEY = "key";
    @NotNull
    public static final String ATTR_DESCRIPTION = "description";
    @NotNull
    private static final String VALUE_BUNDLE = "bundle";
    @NotNull
    private static final String VALUE_BUNDLE_ARRAY = "bundle_array";
    @NotNull
    private static final String VALUE_CHOICE = "choice";
    @NotNull
    private static final String VALUE_MULTI_SELECT = "multi-select";
    @NotNull
    private static final String VALUE_ENTRIES = "entries";
    @NotNull
    private static final String VALUE_ENTRY_VALUES = "entryValues";
    @NotNull
    private static final String VALUE_HIDDEN = "hidden";
    @NotNull
    private static final String VALUE_DEFAULT_VALUE = "defaultValue";
    @NotNull
    private static final String VALUE_INTEGER = "integer";

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        if (!Intrinsics.areEqual((Object)TAG_RESTRICTIONS, (Object)root.getTagName())) {
            return;
        }
        HashMap keys = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)keys, (String)"keys");
        this.validateNestedRestrictions(context, root, null, keys, 0);
    }

    private final void validateNestedRestrictions(XmlContext context, Element element, String restrictionType, Map<String, Element> keys, int depth) {
        boolean bl = depth == 0 || restrictionType != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List children = Lint.getChildren((Node)element);
        if (depth == 0 || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
            boolean bl5;
            Attr defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE);
            if (defaultValue != null) {
                Node node = element;
                Location location = context.getLocation((Node)defaultValue);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Restriction type `%1$s` should not have a default value";
                Object[] objectArray = new Object[]{restrictionType};
                bl5 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            }
            for (Element child : children) {
                if (!this.verifyRestrictionTagName(context, child)) continue;
                this.validateRestriction(context, child, depth + 1, keys);
            }
            if (depth != 0) {
                if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
                    if (children.size() != 1) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Expected exactly one child for restriction of type `bundle_array`", null, (int)16, null);
                    }
                } else {
                    boolean bl6 = Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (_Assertions.ENABLED && !bl6) {
                        bl5 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    if (children.isEmpty()) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Restriction type `bundle` should have at least one nested restriction", null, (int)16, null);
                    }
                }
            }
            if (children.size() > 1000) {
                Node node = element;
                Location location = context.getElementLocation(element);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Invalid nested restriction: too many nested restrictions (was %1$d, max %2$d)";
                Object[] objectArray = new Object[]{children.size(), 1000};
                bl5 = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string3, null, (int)16, null);
            } else if (depth > 20) {
                Node node = element;
                Location location = context.getElementLocation(element);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Invalid nested restriction: nesting depth %1$d too large (max %2$d";
                Object[] objectArray = new Object[]{depth, 20};
                bl5 = false;
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string4, null, (int)16, null);
            }
        } else if (!children.isEmpty()) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)"Only restrictions of type `bundle` and `bundle_array` can have one or multiple nested restriction elements", null, (int)16, null);
        }
    }

    private final void validateRestriction(XmlContext context, Node node, int depth, Map<String, Element> keys) {
        Attr defaultValue;
        Object thisAttribute;
        if (node.getNodeType() != 1) {
            return;
        }
        Element element = (Element)node;
        String restrictionType = this.checkRequiredAttribute(context, element, ATTR_RESTRICTION_TYPE);
        String key = this.checkRequiredAttribute(context, element, ATTR_KEY);
        String title = this.checkRequiredAttribute(context, element, "title");
        if (restrictionType == null || key == null || title == null) {
            return;
        }
        if (StringsKt.startsWith$default((String)key, (String)"@string/", (boolean)false, (int)2, null)) {
            Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"attribute");
            Location valueLocation = context.getValueLocation(attribute);
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)valueLocation, (String)"Keys cannot be localized, they should be specified with a string literal", null, (int)16, null);
        } else if (keys.containsKey(key)) {
            thisAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)thisAttribute, (String)"thisAttribute");
            Location location = context.getValueLocation((Attr)thisAttribute);
            Element element2 = keys.get(key);
            if (element2 == null) {
                return;
            }
            Element prev = element2;
            Attr prevAttribute = prev.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Intrinsics.checkExpressionValueIsNotNull((Object)prevAttribute, (String)"prevAttribute");
            Location previousLocation = context.getValueLocation(prevAttribute);
            previousLocation.setMessage("Previous use of key here");
            location.setSecondary(previousLocation);
            Node node2 = element;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Duplicate key `%1$s`";
            Object[] objectArray = new Object[]{key};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node2, (Location)location, (String)string2, null, (int)16, null);
        } else {
            thisAttribute = keys;
            boolean location = false;
            thisAttribute.put(key, element);
        }
        if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_CHOICE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_MULTI_SELECT)) {
            if (this.checkRequiredAttribute(context, element, VALUE_ENTRIES) == null) {
                this.checkRequiredAttribute(context, element, VALUE_ENTRY_VALUES);
            }
        } else if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_HIDDEN)) {
            this.checkRequiredAttribute(context, element, VALUE_DEFAULT_VALUE);
        } else if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_INTEGER) && (defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE)) != null) {
            String location = defaultValue.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"defaultValue.value");
            if (!StringsKt.startsWith$default((String)location, (String)"@", (boolean)false, (int)2, null)) {
                try {
                    Integer.decode(defaultValue.getValue());
                }
                catch (NumberFormatException e) {
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getValueLocation(defaultValue), (String)"Invalid number", null, (int)16, null);
                }
            }
        }
        this.validateNestedRestrictions(context, element, restrictionType, keys, depth);
    }

    private final boolean verifyRestrictionTagName(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (!Intrinsics.areEqual((Object)tagName, (Object)TAG_RESTRICTION)) {
            Node node = element;
            Location location = context.getNameLocation((Node)element);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Unexpected tag `<%1$s>`, expected `<%2$s>`";
            Object[] objectArray = new Object[]{tagName, TAG_RESTRICTION};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            return false;
        }
        return true;
    }

    private final String checkRequiredAttribute(XmlContext context, Element element, String attribute) {
        String fullAttribute = attribute;
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", fullAttribute)) {
            String prefix = element.getOwnerDocument().lookupNamespaceURI("http://schemas.android.com/apk/res/android");
            if (prefix == null) {
                Element root = element.getOwnerDocument().getDocumentElement();
                NamedNodeMap attributes = root.getAttributes();
                int i = 0;
                int n = attributes.getLength();
                while (i < n) {
                    Object object = attributes.item(i);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
                    }
                    Attr a = (Attr)object;
                    object = a.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"a.name");
                    if (StringsKt.startsWith$default((String)object, (String)"xmlns:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)a.getValue())) {
                        object = a.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"a.name");
                        int n2 = "xmlns:".length();
                        boolean bl = false;
                        String string = ((String)object).substring(n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                        prefix = string;
                        break;
                    }
                    int n3 = i;
                    i = n3 + 1;
                }
            }
            if (prefix != null) {
                fullAttribute = prefix + ':' + fullAttribute;
            }
            Node node = element;
            Location location = context.getElementLocation(element);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Missing required attribute `%1$s`";
            Object[] objectArray = new Object[]{fullAttribute};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            return null;
        }
        return element.getAttributeNS("http://schemas.android.com/apk/res/android", fullAttribute);
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(RestrictionsDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ValidRestrictions", (String)"Invalid Restrictions Descriptor", (String)"Ensures that an applications restrictions XML file is properly formed", (Implementation)implementation, (String)"https://developer.android.com/reference/android/content/RestrictionsManager.html", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0016\u0010\f\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector$Companion;", "", "()V", "ATTR_DESCRIPTION", "", "ATTR_KEY", "ATTR_RESTRICTION_TYPE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAX_NESTING_DEPTH", "", "getMAX_NESTING_DEPTH$annotations", "MAX_NUMBER_OF_NESTED_RESTRICTIONS", "getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations", "TAG_RESTRICTION", "TAG_RESTRICTIONS", "VALUE_BUNDLE", "VALUE_BUNDLE_ARRAY", "VALUE_CHOICE", "VALUE_DEFAULT_VALUE", "VALUE_ENTRIES", "VALUE_ENTRY_VALUES", "VALUE_HIDDEN", "VALUE_INTEGER", "VALUE_MULTI_SELECT", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NESTING_DEPTH$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

