/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightFieldForSourceDeclaration;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUTypeCastExpression;
import org.jetbrains.uast.kotlin.KotlinUSwitchExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class AnnotationDetector
extends Detector
implements SourceCodeScanner {
    public static final String GMS_HIDE_ANNOTATION = "com.google.android.gms.common.internal.Hide";
    public static final String GMS_SHOW_FIRST_PARTY_ANNOTATION = "com.google.android.gms.common.internal.ShowFirstParty";
    public static final AndroidxName CHECK_RESULT_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"CheckResult");
    public static final AndroidxName INT_RANGE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"IntRange");
    public static final AndroidxName FLOAT_RANGE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"FloatRange");
    public static final AndroidxName SIZE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Size");
    public static final AndroidxName PERMISSION_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresPermission");
    public static final AndroidxName UI_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"UiThread");
    public static final AndroidxName MAIN_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"MainThread");
    public static final AndroidxName WORKER_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"WorkerThread");
    public static final AndroidxName BINDER_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"BinderThread");
    public static final AndroidxName ANY_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AnyThread");
    public static final AndroidxName RESTRICT_TO_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RestrictTo");
    public static final AndroidxName VISIBLE_FOR_TESTING_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"VisibleForTesting");
    public static final AndroidxName PERMISSION_ANNOTATION_READ = AndroidxName.of((AndroidxName)PERMISSION_ANNOTATION, (String)"Read");
    public static final AndroidxName PERMISSION_ANNOTATION_WRITE = AndroidxName.of((AndroidxName)PERMISSION_ANNOTATION, (String)"Write");
    public static final AndroidxName HALF_FLOAT_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"HalfFloat");
    public static final String KEY_CASES = "cases";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    public static final String FINDBUGS_ANNOTATIONS_CHECK_RETURN_VALUE = "edu.umd.cs.findbugs.annotations.CheckReturnValue";
    public static final String JAVAX_ANNOTATION_CHECK_RETURN_VALUE = "javax.annotation.CheckReturnValue";
    public static final String ERRORPRONE_CAN_IGNORE_RETURN_VALUE = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    public static final String GUAVA_VISIBLE_FOR_TESTING = "com.google.common.annotations.VisibleForTesting";
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create((String)"LocalSuppress", (String)"@SuppressLint on invalid element", (String)"The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue ANNOTATION_USAGE = Issue.create((String)"SupportAnnotationUsage", (String)"Incorrect support annotation usage", (String)"This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) are used correctly. For example, it's an error to specify an `@IntRange` where the `from` value is higher than the `to` value.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create((String)"UniqueConstants", (String)"Overlapping Enumeration Constants", (String)"The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes).  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue FLAG_STYLE = Issue.create((String)"ShiftFlags", (String)"Dangerous Flag Constant Declaration", (String)"When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue SWITCH_TYPE_DEF = Issue.create((String)"SwitchIntDef", (String)"Missing @IntDef in Switch", (String)"This check warns if a `switch` statement does not explicitly include all the values declared by the typedef `@IntDef` declaration.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    private Set<PsiElement> mWarnedFlags;

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(2);
        types.add(UAnnotation.class);
        types.add(USwitchExpression.class);
        return types;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new AnnotationChecker(context);
    }

    private static String displayConstants(List<String> list) {
        return CollectionsKt.joinToString(list, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", s -> {
            int classIndex;
            int index = s.lastIndexOf(46);
            if (index != -1 && (classIndex = s.lastIndexOf(46, index - 1)) != -1) {
                return "`" + s.substring(classIndex + 1) + "`";
            }
            return "`" + s + "`";
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static List<String> computeFieldNames(USwitchExpression node, Iterable<?> allowedValues) {
        ArrayList list = Lists.newArrayList();
        Iterator<?> iterator = allowedValues.iterator();
        while (true) {
            PsiClass containingClass;
            void var4_4;
            block12: {
                PsiElement resolved;
                if (!iterator.hasNext()) {
                    Collections.sort(list);
                    return list;
                }
                Object obj = iterator.next();
                if (obj instanceof ExternalReferenceExpression) {
                    ExternalReferenceExpression externalRef = (ExternalReferenceExpression)obj;
                    resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)node);
                    if (resolved != null) {
                        PsiElement psiElement = resolved;
                    }
                } else {
                    PsiReferenceExpression ref;
                    if (obj instanceof PsiReferenceExpression) {
                        ref = (PsiReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved != null) {
                            PsiElement psiElement = resolved;
                            break block12;
                        } else {
                            String referenceName = ref.getReferenceName();
                            if (referenceName == null) continue;
                            list.add(referenceName);
                            continue;
                        }
                    }
                    if (obj instanceof PsiLiteral) {
                        list.add((String)((PsiLiteral)obj).getValue());
                        continue;
                    }
                    if (obj instanceof UReferenceExpression) {
                        ref = (UReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved == null) {
                            String resolvedName = ref.getResolvedName();
                            if (resolvedName == null) continue;
                            list.add(resolvedName);
                            continue;
                        }
                        PsiElement psiElement = resolved;
                    }
                }
            }
            if (!(var4_4 instanceof PsiField)) continue;
            PsiField field = (PsiField)var4_4;
            String name = field.getName();
            UClass clz = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (clz != null && (containingClass = field.getContainingClass()) != null && !containingClass.isEquivalentTo((PsiElement)clz.getPsi())) {
                name = containingClass.getQualifiedName() + '.' + field.getName();
            }
            list.add(name);
        }
    }

    private static UElement getAnnotationScope(UAnnotation node) {
        UElement scope = UastUtils.getParentOfType((UElement)node, UAnnotation.class, (boolean)true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private static boolean removeFieldFromList(List<Object> fields, PsiField resolvedField) {
        for (Object field : fields) {
            PsiField candidateField;
            if (!(field instanceof PsiField) || !(candidateField = (PsiField)field).isEquivalentTo((PsiElement)resolvedField)) continue;
            return true;
        }
        return false;
    }

    private class AnnotationChecker
    extends UElementHandler {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitAnnotation(UAnnotation annotation) {
            String type = annotation.getQualifiedName();
            if (type == null || type.startsWith("java.lang.")) {
                return;
            }
            this.checkAnnotation(annotation, type);
        }

        private void checkAnnotation(UAnnotation annotation, String type) {
            if ("android.annotation.SuppressLint".equals(type)) {
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                if (parent == null) {
                    return;
                }
                if (!(parent instanceof UDeclarationsExpression || parent instanceof ULocalVariable || parent instanceof UParameter)) {
                    return;
                }
                List attributes = annotation.getAttributeValues();
                if (attributes.size() == 1) {
                    UNamedExpression attribute = (UNamedExpression)attributes.get(0);
                    UExpression value = UastUtils.skipParenthesizedExprDown((UExpression)attribute.getExpression());
                    if (value instanceof ULiteralExpression) {
                        Object v = ((ULiteralExpression)value).getValue();
                        if (v instanceof String) {
                            String id = (String)v;
                            this.checkSuppressLint(annotation, id);
                        }
                    } else if (value != null && UastExpressionUtils.isArrayInitializer((UElement)value)) {
                        for (UExpression ex : ((UCallExpression)value).getValueArguments()) {
                            String id;
                            Object v;
                            if (!((ex = UastUtils.skipParenthesizedExprDown((UExpression)ex)) instanceof ULiteralExpression) || !((v = ((ULiteralExpression)ex).getValue()) instanceof String) || this.checkSuppressLint(annotation, id = (String)v)) continue;
                            return;
                        }
                    }
                }
            } else if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(type)) {
                if (CHECK_RESULT_ANNOTATION.isEquals(type)) {
                    UMethod method;
                    UElement parent = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                    if (parent instanceof UMethod && !(method = (UMethod)parent).isConstructor() && PsiType.VOID.equals((Object)method.getReturnType())) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "@CheckResult should not be specified on `void` methods");
                    }
                } else if (INT_RANGE_ANNOTATION.isEquals(type) || FLOAT_RANGE_ANNOTATION.isEquals(type)) {
                    boolean invalid;
                    if (INT_RANGE_ANNOTATION.isEquals(type)) {
                        this.checkTargetType(annotation, type, "int", "long", true);
                        long from = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (long)Long.MIN_VALUE);
                        long to = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (long)Long.MAX_VALUE);
                        invalid = from > to;
                    } else {
                        this.checkTargetType(annotation, type, "float", "double", true);
                        double from = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (double)Double.NEGATIVE_INFINITY);
                        double to = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (double)Double.POSITIVE_INFINITY);
                        boolean bl = invalid = from > to;
                    }
                    if (invalid) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid range: the `from` attribute must be less than the `to` attribute");
                    }
                } else if (SIZE_ANNOTATION.isEquals(type)) {
                    int unset = -42;
                    long exact = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)"value", (long)unset);
                    long min = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MIN, (long)Long.MIN_VALUE);
                    long max = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MAX, (long)Long.MAX_VALUE);
                    long multiple = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MULTIPLE, (long)1L);
                    if (min > max) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid size range: the `min` attribute must be less than the `max` attribute");
                    } else if (multiple < 1L) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size multiple must be at least 1");
                    } else if (exact < 0L && exact != (long)unset || min < 0L && min != Long.MIN_VALUE) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size can't be negative");
                    }
                } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(type)) {
                    this.checkTargetType(annotation, type, "int", "long", true);
                } else if (ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(type) || ResourceEvaluator.PX_ANNOTATION.isEquals(type)) {
                    this.checkTargetType(annotation, type, "int", "long", "float", "double", true);
                } else if (SdkConstants.INT_DEF_ANNOTATION.isEquals(type) || SdkConstants.LONG_DEF_ANNOTATION.isEquals(type)) {
                    this.ensureUniqueValues(annotation);
                } else if (PERMISSION_ANNOTATION.isEquals(type) || PERMISSION_ANNOTATION_READ.isEquals(type) || PERMISSION_ANNOTATION_WRITE.isEquals(type)) {
                    UElement parent = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                    if (parent instanceof UMethod) {
                        String value = UastLintUtils.getAnnotationStringValue((UAnnotation)annotation, (String)"value");
                        String[] anyOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ANY_OF);
                        String[] allOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ALL_OF);
                        int set = 0;
                        if (value != null) {
                            ++set;
                        }
                        if (allOf != null) {
                            ++set;
                        }
                        if (anyOf != null) {
                            ++set;
                        }
                        if (set == 0) {
                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`");
                        } else if (set > 1) {
                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Only specify one of `value`, `anyOf` or `allOf`");
                        }
                    }
                } else if (HALF_FLOAT_ANNOTATION.isEquals(type)) {
                    this.checkTargetType(annotation, type, "short", null, true);
                } else if (type.endsWith("Res")) {
                    this.checkTargetType(annotation, type, "int", "long", true);
                } else if (RESTRICT_TO_ANNOTATION.isEquals(type)) {
                    UExpression attributeValue = annotation.findDeclaredAttributeValue("value");
                    if (attributeValue == null) {
                        attributeValue = annotation.findDeclaredAttributeValue(null);
                    }
                    if (attributeValue == null) {
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Restrict to what? Expected at least one `RestrictTo.Scope` arguments.");
                    } else {
                        String values = attributeValue.asSourceString();
                        if (values.contains("SUBCLASSES") && UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent()) instanceof UClass) {
                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "`RestrictTo.Scope.SUBCLASSES` should only be specified on methods and fields");
                        }
                    }
                }
            } else {
                PsiClass cls;
                PsiClass resolved = annotation.resolve();
                if (resolved != null && (cls = resolved).isAnnotationType() && cls.getModifierList() != null) {
                    for (PsiAnnotation a : this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)cls, false)) {
                        String name = a.getQualifiedName();
                        if (name == null) continue;
                        if (AndroidPlatformAnnotations.isPlatformAnnotation((String)name)) {
                            name = AndroidPlatformAnnotations.toAndroidxAnnotation((String)name);
                        }
                        if (SdkConstants.INT_DEF_ANNOTATION.isEquals(name)) {
                            this.checkTargetType(annotation, name, "int", null, true);
                            continue;
                        }
                        if (SdkConstants.LONG_DEF_ANNOTATION.isEquals(name)) {
                            this.checkTargetType(annotation, name, "long", null, true);
                            continue;
                        }
                        if (!SdkConstants.STRING_DEF_ANNOTATION.isEquals(type)) continue;
                        this.checkTargetType(annotation, name, "java.lang.String", null, true);
                    }
                }
                if (AndroidPlatformAnnotations.isPlatformAnnotation((String)type)) {
                    this.checkAnnotation(annotation, AndroidPlatformAnnotations.toAndroidxAnnotation((String)type));
                }
            }
        }

        private void checkTargetType(UAnnotation node, String name, String type1, String type2, boolean allowCollection) {
            this.checkTargetType(node, name, type1, type2, null, null, allowCollection);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkTargetType(UAnnotation node, String name, String type1, String type2, String type3, String type4, boolean allowCollection) {
            PsiType type;
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            if (parent instanceof UDeclarationsExpression) {
                List elements = ((UDeclarationsExpression)parent).getDeclarations();
                if (elements.isEmpty()) return;
                UDeclaration element = (UDeclaration)elements.get(0);
                if (!(element instanceof ULocalVariable)) return;
                type = ((ULocalVariable)element).getType();
            } else if (parent instanceof UMethod) {
                UMethod method = (UMethod)parent;
                type = method.isConstructor() ? this.mContext.getEvaluator().getClassType((PsiClass)UastUtils.getContainingUClass((UElement)method)) : method.getReturnType();
            } else {
                if (!(parent instanceof UVariable)) return;
                UVariable variable = (UVariable)parent;
                if (variable.getTypeReference() == null) {
                    return;
                }
                type = variable.getType();
            }
            if (type == null) {
                return;
            }
            PsiType originalType = type;
            if (type instanceof PsiImmediateClassType && type.getCanonicalText().equals("kotlin.properties.ReadWriteProperty")) {
                PsiClassType classType;
                PsiType[] parameters;
                PsiType accurateType;
                boolean unknownDelegateType = true;
                if (parent instanceof UVariable && (accurateType = Lint.getKotlinDelegatePropertyType((PsiElement)parent.getSourcePsi(), (UVariable)((UVariable)parent))) instanceof PsiClassType && (parameters = (classType = (PsiClassType)accurateType).getParameters()).length >= 1) {
                    type = parameters[parameters.length - 1];
                    unknownDelegateType = false;
                    originalType = type;
                }
                if (unknownDelegateType) {
                    return;
                }
            }
            if (allowCollection) {
                PsiClassType classType;
                PsiType[] parameters;
                if (type instanceof PsiArrayType) {
                    type = type.getDeepComponentType();
                } else if (type instanceof PsiClassType && (parameters = (classType = (PsiClassType)type).getParameters()).length >= 1) {
                    type = parameters[0];
                }
            }
            if (!type.isValid()) {
                return;
            }
            String typeName = type.getCanonicalText();
            if (typeName.equals("error.NonExistentClass")) {
                return;
            }
            if (typeName.equals("android.util.SparseIntArray")) {
                typeName = "int";
            } else if (typeName.equals("android.util.LongSparseArray") || typeName.equals("android.util.SparseLongArray")) {
                typeName = "long";
            } else if (typeName.equals("android.util.SparseBooleanArray")) {
                typeName = "boolean";
            }
            if (typeName.equals(type1) || typeName.equals(type2) || typeName.equals(type3) || typeName.equals(type4)) return;
            if (typeName.equals(Lint.getAutoBoxedType((String)type1)) || type2 != null && typeName.equals(Lint.getAutoBoxedType((String)type2)) || type3 != null && typeName.equals(Lint.getAutoBoxedType((String)type3)) || type4 != null && typeName.equals(Lint.getAutoBoxedType((String)type4))) {
                return;
            }
            if ((typeName.equals("byte") || typeName.equals(Lint.getAutoBoxedType((String)"byte")) || typeName.equals("short") || typeName.equals(Lint.getAutoBoxedType((String)"short"))) && (type1.equals("int") || type1.equals("long"))) {
                return;
            }
            if (type2 == null && type1.equals("int") && (typeName.equals("long") || typeName.equals(Lint.getAutoBoxedType((String)"long")))) {
                return;
            }
            if (type2 == null && type1.equals("long") && (typeName.equals("int") || typeName.equals(Lint.getAutoBoxedType((String)"int")))) {
                return;
            }
            String expectedTypes = type4 != null ? type1 + ", " + type2 + ", " + type3 + ", or " + type4 : (type3 != null ? type1 + ", " + type2 + ", or " + type3 : (type2 != null ? type1 + " or " + type2 : type1));
            typeName = originalType.getCanonicalText();
            boolean isString = typeName.equals("java.lang.String");
            if (isString) {
                typeName = "String";
            }
            String message2 = String.format("This annotation does not apply for type %1$s; expected %2$s", typeName, expectedTypes);
            if (isString && type1.equals("int") && SdkConstants.INT_DEF_ANNOTATION.isEquals(name)) {
                message2 = message2 + ". Should `" + node.asSourceString() + "` be annotated with `@StringDef` instead?";
            }
            Location location = this.mContext.getLocation((UElement)node);
            this.mContext.report(ANNOTATION_USAGE, (UElement)node, location, message2);
        }

        public void visitSwitchExpression(USwitchExpression switchExpression) {
            UAnnotation annotation;
            UExpression condition = switchExpression.getExpression();
            if (condition != null && PsiType.INT.equals((Object)condition.getExpressionType()) && (annotation = this.findIntDefAnnotation(condition)) != null) {
                UExpression value = annotation.findAttributeValue("value");
                if (value == null) {
                    value = annotation.findAttributeValue(null);
                }
                if (value != null) {
                    value = UastUtils.skipParenthesizedExprDown((UExpression)value);
                }
                if (value != null && UastExpressionUtils.isArrayInitializer((UElement)value)) {
                    List allowedValues = ((UCallExpression)value).getValueArguments();
                    switchExpression.accept((UastVisitor)new SwitchChecker(switchExpression, allowedValues));
                }
            }
        }

        private UAnnotation findIntDefAnnotation(UExpression expression) {
            if (expression instanceof UReferenceExpression) {
                PsiLocalVariable variable;
                UExpression lastAssignment;
                UAnnotation annotation;
                PsiElement resolved = ((UReferenceExpression)expression).resolve();
                if (resolved instanceof PsiModifierListOwner && (annotation = this.findTypeDef(expression, (PsiModifierListOwner)resolved)) != null) {
                    return annotation;
                }
                if (resolved instanceof PsiLocalVariable && (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable = (PsiLocalVariable)resolved), (UElement)expression)) != null) {
                    return this.findIntDefAnnotation(lastAssignment);
                }
            } else if (expression instanceof UCallExpression) {
                UAnnotation annotation;
                PsiMethod method = ((UCallExpression)expression).resolve();
                if (method != null && (annotation = this.findTypeDef(expression, (PsiModifierListOwner)method)) != null) {
                    return annotation;
                }
            } else if (expression instanceof UIfExpression) {
                UAnnotation result;
                UIfExpression ifExpression = (UIfExpression)expression;
                if (ifExpression.getThenExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getThenExpression())) != null) {
                    return result;
                }
                if (ifExpression.getElseExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getElseExpression())) != null) {
                    return result;
                }
            } else {
                if (expression instanceof JavaUTypeCastExpression) {
                    return this.findIntDefAnnotation(((JavaUTypeCastExpression)expression).getOperand());
                }
                if (expression instanceof UParenthesizedExpression) {
                    return this.findIntDefAnnotation(((UParenthesizedExpression)expression).getExpression());
                }
            }
            return null;
        }

        private UAnnotation findTypeDef(UExpression expression, PsiModifierListOwner owner) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiAnnotation[] annotations = evaluator.getAllAnnotations(owner, true);
            List uAnnotations = evaluator.filterRelevantAnnotations(annotations, (UElement)expression, SetsKt.setOf((Object[])new String[]{SdkConstants.INT_DEF_ANNOTATION.oldName(), SdkConstants.INT_DEF_ANNOTATION.newName()}));
            return TypedefDetector.Companion.findIntDef(uAnnotations);
        }

        private Integer getConstantValue(PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            if (constant instanceof Number) {
                return ((Number)constant).intValue();
            }
            return null;
        }

        private void ensureUniqueValues(UAnnotation node) {
            boolean flag;
            UExpression value = node.findDeclaredAttributeValue("value");
            if (value == null) {
                value = node.findDeclaredAttributeValue(null);
            }
            if (value == null) {
                return;
            }
            if ((value = UastUtils.skipParenthesizedExprDown((UExpression)value)) == null || !UastExpressionUtils.isArrayInitializer((UElement)value)) {
                return;
            }
            List initializers = ((UCallExpression)value).getValueArguments();
            HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)initializers.size());
            boolean bl = flag = UastLintUtils.getAnnotationBooleanValue((UAnnotation)node, (String)"flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator();
            for (int index = 0; index < initializers.size(); ++index) {
                UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)initializers.get(index)));
                Object o = constantEvaluator.evaluate((UElement)expression);
                if (!(o instanceof Number)) continue;
                Number number = (Number)o;
                if (valueToIndex.containsKey(number)) {
                    String prevLocationLabel;
                    String message2;
                    String constant2;
                    Number repeatedValue = number;
                    int prevIndex = (Integer)valueToIndex.get(number);
                    UExpression prevConstant = (UExpression)initializers.get(prevIndex);
                    String constant1 = expression.asSourceString();
                    if (constant1.equals(constant2 = prevConstant.asSourceString())) {
                        message2 = String.format("Constant `%1$s` has already been included", constant1);
                        prevLocationLabel = "Previous occurrence";
                    } else {
                        PsiElement resolved;
                        String valueString = repeatedValue.toString();
                        if (expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) instanceof PsiField) {
                            PsiElement referencedField;
                            UExpression initializer;
                            PsiElement resolvePrev;
                            PsiField field = (PsiField)resolved;
                            PsiField prevField = null;
                            if (prevConstant instanceof UReferenceExpression && (resolvePrev = ((UReferenceExpression)prevConstant).resolve()) instanceof PsiField) {
                                prevField = (PsiField)resolvePrev;
                                if (field.getName().equals(prevField.getName())) {
                                    return;
                                }
                            }
                            if ((initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)field)) instanceof ULiteralExpression) {
                                PsiElement source = initializer.getSourcePsi();
                                if (source != null) {
                                    valueString = source.getText();
                                }
                            } else if (initializer instanceof UReferenceExpression && prevField != null && (referencedField = ((UReferenceExpression)initializer).resolve()) != null && referencedField.isEquivalentTo((PsiElement)prevField)) {
                                return;
                            }
                            if (prevField != null && this.isDeprecated(field) != this.isDeprecated(prevField)) {
                                return;
                            }
                        }
                        message2 = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", constant1, constant2, valueString);
                        prevLocationLabel = "Previous same value";
                    }
                    Location location = this.mContext.getLocation((UElement)expression);
                    Location secondary = this.mContext.getLocation((UElement)prevConstant);
                    secondary.setMessage(prevLocationLabel);
                    location.setSecondary(secondary);
                    UElement scope = AnnotationDetector.getAnnotationScope(node);
                    this.mContext.report(UNIQUE, scope, location, message2);
                    break;
                }
                valueToIndex.put(number, index);
            }
        }

        private boolean isDeprecated(PsiField field) {
            UField uField;
            if (field instanceof KtUltraLightFieldForSourceDeclaration && (uField = (UField)UastContextKt.toUElement((PsiElement)field)) != null) {
                List annotations = uField.getUAnnotations();
                return annotations.stream().anyMatch(uAnnotation -> {
                    String name = uAnnotation.getQualifiedName();
                    return name != null && (name.equals("java.lang.Deprecated") || name.equals("kotlin.Deprecated"));
                });
            }
            return field.hasAnnotation("java.lang.Deprecated") || field.hasAnnotation("kotlin.Deprecated");
        }

        private void ensureUsingFlagStyle(List<UExpression> constants) {
            if (constants.size() < 3) {
                return;
            }
            ArrayList<Triple> oneBitConstants = new ArrayList<Triple>();
            for (UExpression constant : constants) {
                long value;
                ULiteralExpression literal;
                Object o;
                PsiElement resolved;
                if (!(constant instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)constant).resolve()) instanceof PsiCompiledElement || !(resolved instanceof PsiField)) continue;
                UExpression initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)((PsiField)resolved));
                if (initializer != null) {
                    initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                }
                if (!(initializer instanceof ULiteralExpression) || !((o = (literal = (ULiteralExpression)initializer).getValue()) instanceof Number) || Math.abs(value = ((Number)o).longValue()) <= 1L) continue;
                if (Long.bitCount(value) != 1) {
                    return;
                }
                oneBitConstants.add(new Triple((Object)initializer, (Object)resolved, (Object)((Number)o)));
            }
            for (Triple triple : oneBitConstants) {
                UExpression initializer = (UExpression)triple.component1();
                PsiElement resolved = (PsiElement)triple.component2();
                Number o = (Number)triple.component3();
                long value = o.longValue();
                int shift = Long.numberOfTrailingZeros(value);
                if (AnnotationDetector.this.mWarnedFlags == null) {
                    AnnotationDetector.this.mWarnedFlags = Sets.newHashSet();
                }
                if (!AnnotationDetector.this.mWarnedFlags.add(resolved)) {
                    return;
                }
                String operator = Lint.isKotlin((PsiElement)resolved) ? "shl" : "<<";
                String message2 = String.format(Locale.US, "Consider declaring this constant using 1 %s %d instead", operator, shift);
                String replace = String.format(Locale.ROOT, "1%s %s %d", o instanceof Long ? "L" : "", operator, shift);
                LintFix fix = AnnotationDetector.this.fix().replace().sharedName("Change declaration to " + operator).with(replace).autoFix().build();
                Location location = this.mContext.getLocation((UElement)initializer);
                this.mContext.report(FLAG_STYLE, (UElement)initializer, location, message2, fix);
            }
        }

        private boolean checkSuppressLint(UAnnotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains(Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getLocation((UElement)node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }

        private class SwitchChecker
        extends AbstractUastVisitor {
            private final USwitchExpression mSwitchExpression;
            private final List<UExpression> mAllowedValues;
            private final List<Object> mFields;
            private final List<Integer> mSeenValues;
            private boolean mReported = false;

            private SwitchChecker(USwitchExpression switchExpression, List<UExpression> allowedValues) {
                this.mSwitchExpression = switchExpression;
                this.mAllowedValues = allowedValues;
                this.mFields = Lists.newArrayListWithCapacity((int)allowedValues.size());
                for (UExpression allowedValue : allowedValues) {
                    if (allowedValue instanceof ExternalReferenceExpression) {
                        ExternalReferenceExpression externalRef = (ExternalReferenceExpression)allowedValue;
                        PsiElement resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)switchExpression);
                        if (!(resolved instanceof PsiField)) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (allowedValue instanceof UReferenceExpression) {
                        PsiElement resolved = ((UReferenceExpression)allowedValue).resolve();
                        if (resolved == null) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (!(allowedValue instanceof ULiteralExpression)) continue;
                    this.mFields.add(allowedValue);
                }
                this.mSeenValues = Lists.newArrayListWithCapacity((int)allowedValues.size());
            }

            public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
                if (this.mReported) {
                    return true;
                }
                if (this.mAllowedValues == null) {
                    return true;
                }
                List caseValues = node.getCaseValues();
                if (caseValues.isEmpty()) {
                    this.mFields.clear();
                    return true;
                }
                for (UExpression caseValue : caseValues) {
                    if (caseValue instanceof ULiteralExpression) {
                        List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                        String message2 = "Don't use a constant here; expected one of: " + AnnotationDetector.displayConstants(list);
                        AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, AnnotationChecker.this.mContext.getLocation((UElement)caseValue), message2);
                        this.mReported = true;
                        continue;
                    }
                    if (!(caseValue instanceof UReferenceExpression)) continue;
                    PsiElement resolved = ((UReferenceExpression)caseValue).resolve();
                    if (resolved == null) {
                        return true;
                    }
                    if (!(resolved instanceof PsiField)) continue;
                    PsiField resolvedField = (PsiField)resolved;
                    boolean found = AnnotationDetector.removeFieldFromList(this.mFields, resolvedField);
                    if (!found) {
                        UExpression initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)((PsiField)resolved));
                        if (initializer != null) {
                            initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                        }
                        if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiField) {
                            found = AnnotationDetector.removeFieldFromList(this.mFields, (PsiField)resolved);
                        }
                    }
                    if (found) {
                        Integer cv = AnnotationChecker.this.getConstantValue((PsiField)resolved);
                        if (cv == null) continue;
                        this.mSeenValues.add(cv);
                        continue;
                    }
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                    String message3 = "Unexpected constant; expected one of: " + AnnotationDetector.displayConstants(list);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{AnnotationDetector.KEY_CASES, list});
                    Location location = AnnotationChecker.this.mContext.getNameLocation((UElement)caseValue);
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, location, message3, fix);
                }
                return true;
            }

            public void afterVisitSwitchExpression(USwitchExpression node) {
                this.reportMissingSwitchCases();
                super.afterVisitSwitchExpression(node);
            }

            private void reportMissingSwitchCases() {
                if (this.mReported) {
                    return;
                }
                if (this.mAllowedValues == null) {
                    return;
                }
                if (!this.mFields.isEmpty()) {
                    ListIterator<Object> iterator = this.mFields.listIterator();
                    while (iterator.hasNext()) {
                        Integer cv;
                        Object next = iterator.next();
                        if (!(next instanceof PsiField) || !this.mSeenValues.contains(cv = AnnotationChecker.this.getConstantValue((PsiField)next))) continue;
                        iterator.remove();
                    }
                }
                if (!this.mFields.isEmpty()) {
                    PsiElement keyword;
                    PsiElement sourcePsi;
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mFields);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{AnnotationDetector.KEY_CASES, list});
                    UIdentifier identifier = this.mSwitchExpression.getSwitchIdentifier();
                    Location location = AnnotationChecker.this.mContext.getLocation((UElement)identifier);
                    if (this.mSwitchExpression instanceof KotlinUSwitchExpression && !"when".equals(identifier.getName()) && (sourcePsi = this.mSwitchExpression.getSourcePsi()) != null && (keyword = sourcePsi.getFirstChild()) != null) {
                        location = AnnotationChecker.this.mContext.getLocation(keyword);
                    }
                    String message2 = "Switch statement on an `int` with known associated constant missing case " + AnnotationDetector.displayConstants(list);
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)this.mSwitchExpression, location, message2, fix);
                }
            }
        }
    }
}

