/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationMethod;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUTernaryIfExpression;
import org.jetbrains.uast.java.expressions.JavaUSynchronizedExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "expectsSideEffect", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isThrowingRunnable", "s", "visitAnnotationUsage", "", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "lint-checks"})
public final class CheckResultDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY_SUGGESTION = "suggestion";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CHECK_RESULT;
    @JvmField
    @NotNull
    public static final Issue CHECK_PERMISSION;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[7];
        String string = AnnotationDetector.CHECK_RESULT_ANNOTATION.oldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CHECK_RESULT_ANNOTATION.oldName()");
        objectArray[0] = string;
        string = AnnotationDetector.CHECK_RESULT_ANNOTATION.newName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CHECK_RESULT_ANNOTATION.newName()");
        objectArray[1] = string;
        objectArray[2] = "edu.umd.cs.findbugs.annotations.CheckReturnValue";
        objectArray[3] = "javax.annotation.CheckReturnValue";
        objectArray[4] = "com.google.errorprone.annotations.CanIgnoreReturnValue";
        objectArray[5] = "io.reactivex.annotations.CheckReturnValue";
        objectArray[6] = "com.google.errorprone.annotations.CheckReturnValue";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type != AnnotationUsageType.METHOD_OVERRIDE && super.isApplicableAnnotationUsage(type);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (Intrinsics.areEqual((Object)annotationInfo.getQualifiedName(), (Object)"com.google.errorprone.annotations.CanIgnoreReturnValue")) {
            return;
        }
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMethod psiMethod2 = psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        if (Intrinsics.areEqual((Object)method.getReturnType(), (Object)PsiType.VOID) || method.isConstructor()) {
            return;
        }
        if (Companion.isExpressionValueUnused(element)) {
            LintFix lintFix;
            if (context.getEvaluator().isSuspend((PsiModifierListOwner)method)) {
                PsiType psiType = method.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"method.parameterList.parameters");
                Object object = (PsiParameter)ArraysKt.lastOrNull((Object[])((Object[])psiType));
                PsiType psiType2 = object == null ? null : object.getType();
                PsiClassType psiClassType = psiElement = psiType2 instanceof PsiClassType ? (PsiClassType)psiType2 : null;
                if (psiElement == null) {
                    return;
                }
                PsiElement classReference = psiElement;
                psiType = classReference.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"classReference.parameters");
                object = ArraysKt.singleOrNull((Object[])((Object[])psiType));
                PsiWildcardType psiWildcardType = psiType2 = object instanceof PsiWildcardType ? (PsiWildcardType)object : null;
                if (psiType2 == null) {
                    return;
                }
                PsiType wildcard = psiType2;
                psiType = wildcard.getBound();
                if (psiType == null) {
                    return;
                }
                object = psiType;
                Object bound = object;
                if (Intrinsics.areEqual((Object)bound, (Object)PsiType.VOID) || Intrinsics.areEqual((Object)bound.getCanonicalText(), (Object)"kotlin.Unit")) {
                    return;
                }
            }
            if (usageInfo.anyCloser((Function1)visitAnnotationUsage.1.INSTANCE)) {
                return;
            }
            if (context.isTestSource() && this.expectsSideEffect(context, element)) {
                return;
            }
            String methodName = JavaContext.Companion.getMethodName(element);
            UAnnotation annotation = annotationInfo.getAnnotation();
            String suggested = UastLintUtils.Companion.getAnnotationStringValue(annotation, "suggest");
            Issue issue = CHECK_RESULT;
            if (methodName != null && StringsKt.startsWith$default((String)methodName, (String)"check", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)methodName, (CharSequence)"Permission", (boolean)false, (int)2, null)) {
                issue = CHECK_PERMISSION;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = "The result of `%1$s` is not used";
            Object[] objectArray2 = new Object[]{methodName};
            boolean bl = false;
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            String message2 = string;
            if (suggested != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                objectArray = "The result of `%1$s` is not used; did you mean to call `%2$s`?";
                objectArray2 = new Object[]{methodName, suggested};
                bl = false;
                String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                message2 = string2;
            } else if (Intrinsics.areEqual((Object)"intersect", (Object)methodName) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message2 = Intrinsics.stringPlus((String)message2, (Object)". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.");
            }
            if (suggested != null) {
                objectArray = new Object[]{KEY_SUGGESTION, suggested};
                lintFix = this.fix().data(objectArray);
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Location location = context.getLocation(element);
            this.report(context, issue, element, location, message2, fix);
        }
    }

    private final boolean expectsSideEffect(JavaContext context, UElement element) {
        UExpression receiver;
        PsiParameter containingClass2;
        UElement previousStatement;
        PsiParameter resolved;
        Object object;
        List annotations;
        String methodName;
        UElement nextStatement;
        UMethod containingMethod = (UMethod)UastUtils.getParentOfType$default((UElement)element, UMethod.class, (boolean)false, (int)2, null);
        UExpression uExpression = UastLintUtilsKt.nextStatement((UElement)element);
        UElement uElement = nextStatement = uExpression == null ? null : UastLintUtilsKt.findSelector((UElement)((UElement)uExpression));
        if (nextStatement instanceof UCallExpression && (Intrinsics.areEqual((Object)(methodName = ((UCallExpression)nextStatement).getMethodName()), (Object)"fail") || Intrinsics.areEqual((Object)methodName, (Object)"error") || Intrinsics.areEqual((Object)methodName, (Object)"TODO"))) {
            return true;
        }
        UMethod uMethod = containingMethod;
        List list = annotations = uMethod == null ? null : uMethod.getUAnnotations();
        if (annotations != null) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = annotations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"org.junit.Test") && ((object = it.findAttributeValue("expected")) == null ? null : object.evaluate()) != null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        if (nextStatement == null) {
            UElement containingClass2;
            PsiParameter parameter2;
            UElement lambda = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getParentOfType$default((UElement)element, ULambdaExpression.class, (boolean)false, (int)2, null));
            if (lambda instanceof UExpression) {
                UElement call = lambda.getUastParent();
                if (call instanceof UCallExpression && (resolved = ((UCallExpression)call).resolve()) != null && (parameter2 = (PsiParameter)context.getEvaluator().computeArgumentMapping((UCallExpression)call, (PsiMethod)resolved).get(lambda)) != null) {
                    String string = parameter2.getType().getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter.type.canonicalText");
                    if (this.isThrowingRunnable(string)) {
                        return true;
                    }
                }
            } else if (containingMethod != null && (containingClass2 = containingMethod.getUastParent()) instanceof UAnonymousClass) {
                parameter2 = ((UAnonymousClass)containingClass2).getSuperTypes();
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"containingClass.superTypes");
                resolved = parameter2;
                int n = ((PsiClassType[])resolved).length;
                for (int parameter2 = 0; parameter2 < n; ++parameter2) {
                    PsiParameter type = resolved[parameter2];
                    object = type.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type.canonicalText");
                    if (!this.isThrowingRunnable((String)object)) continue;
                    return true;
                }
            }
        }
        UElement uElement2 = previousStatement = (containingClass2 = UastLintUtilsKt.previousStatement((UElement)element)) == null ? null : UastLintUtilsKt.findSelector((UElement)((UElement)containingClass2));
        if (previousStatement instanceof UCallExpression && (containingClass2 = ((UCallExpression)previousStatement).resolve()) != null) {
            String containingClass3;
            resolved = containingClass2;
            boolean parameter2 = false;
            boolean bl = false;
            PsiParameter calledMethod = resolved;
            boolean bl3 = false;
            PsiClass psiClass = calledMethod.getContainingClass();
            String string = containingClass3 = psiClass == null ? null : psiClass.getQualifiedName();
            if (Intrinsics.areEqual((Object)containingClass3, (Object)"org.junit.rules.ExpectedException")) {
                return true;
            }
        }
        if (element instanceof UCallExpression && (receiver = ((UCallExpression)element).getReceiver()) instanceof UResolvable && (resolved = ((UResolvable)receiver).resolve()) instanceof PsiMethod) {
            String containingClass4;
            PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
            String string = containingClass4 = psiClass == null ? null : psiClass.getQualifiedName();
            if (containingClass4 != null && StringsKt.startsWith$default((String)containingClass4, (String)"org.mockito.", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }

    private final boolean isThrowingRunnable(String s) {
        boolean bl;
        switch (s) {
            case "com.google.truth.ExpectFailure.DelegatedAssertionCallback": 
            case "com.google.truth.ExpectFailure.SimpleSubjectBuilderCallback": 
            case "org.junit.function.ThrowingRunnable": 
            case "com.google.truth.ExpectFailure.AssertionCallback": 
            case "org.junit.jupiter.api.function.Executable": 
            case "com.google.truth.ExpectFailure.StandardSubjectBuilderCallback": 
            case "org.assertj.core.api.ThrowableAssert$ThrowingCallable": 
            case "com.google.devtools.build.lib.testutil.MoreAsserts$ThrowingRunnable": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(CheckResultDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), enumSetArray);
        CHECK_RESULT = Issue.Companion.create("CheckResult", "Ignoring results", "\n                Some methods have no side effects, and calling them without doing something \\\n                without the result is suspicious.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
        enumSetArray = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CHECK_PERMISSION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UseCheckPermission", (String)"Using the result of check permission calls", (String)"\n                You normally want to use the result of checking a permission; these methods \\\n                return whether the permission is held; they do not throw an error if the \\\n                permission is not granted. Code which does not do anything with the return \\\n                value probably meant to be calling the enforce methods instead, e.g. rather \\\n                than `Context#checkCallingPermission` it should call \\\n                `Context#enforceCallingPermission`.", (Implementation)implementation, null, (Category)enumSetArray, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector$Companion;", "", "()V", "CHECK_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "CHECK_RESULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_SUGGESTION", "", "isExpressionValueUnused", "", "element", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExpressionValueUnused(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof UParenthesizedExpression) {
                return this.isExpressionValueUnused((UElement)((UParenthesizedExpression)element).getExpression());
            }
            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
            if (uExpression == null) {
                return true;
            }
            UElement prev = (UElement)uExpression;
            UElement uElement = prev.getUastParent();
            if (uElement == null) {
                return true;
            }
            UElement curr = uElement;
            while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev || curr instanceof UParenthesizedExpression) {
                prev = curr;
                uElement = curr.getUastParent();
                if (uElement == null) {
                    return true;
                }
                curr = uElement;
            }
            if (curr instanceof UBlockExpression) {
                if (curr instanceof JavaUSynchronizedExpression) {
                    return false;
                }
                UElement block = curr;
                UElement expression = prev;
                int index = CollectionsKt.indexOf((List)((UBlockExpression)block).getExpressions(), (Object)expression);
                if (index == -1) {
                    return true;
                }
                if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                    return true;
                }
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                if (parent instanceof ULambdaExpression && Lint.isKotlin((PsiElement)curr.getSourcePsi())) {
                    String expressionType;
                    PsiType psiType = ((ULambdaExpression)parent).getExpressionType();
                    String string = expressionType = psiType == null ? null : psiType.getCanonicalText();
                    return expressionType != null && StringsKt.startsWith$default((String)expressionType, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionType, (String)"kotlin.Unit>", (boolean)false, (int)2, null);
                }
                if (Lint.isJava((PsiElement)curr.getSourcePsi())) {
                    return true;
                }
                UElement uElement2 = parent;
                if (uElement2 == null) {
                    return true;
                }
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(parent);
            }
            if (curr instanceof UMethod && ((UMethod)curr).isConstructor()) {
                return true;
            }
            if (curr instanceof UIfExpression) {
                if (((UIfExpression)curr).getCondition() == prev) {
                    return false;
                }
                if (curr instanceof JavaUTernaryIfExpression) {
                    return false;
                }
                UElement expression = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                if (expression == null) {
                    return true;
                }
                UElement parent = expression;
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(curr);
            }
            if (curr instanceof UMethod || curr instanceof UClassInitializer) {
                return !(curr instanceof UAnnotationMethod);
            }
            if (curr instanceof UYieldExpression) {
                USwitchClauseExpressionWithBody index;
                UElement expression = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                UElement p2 = UastUtils.skipParenthesizedExprUp((UElement)(expression == null ? null : expression.getUastParent()));
                USwitchClauseExpressionWithBody uSwitchClauseExpressionWithBody = index = p2 instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)p2 : null;
                if (index == null) {
                    return false;
                }
                USwitchClauseExpressionWithBody body = index;
                USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType$default((UElement)((UElement)body), USwitchExpression.class, (boolean)false, (int)2, null);
                if (uSwitchExpression == null) {
                    return true;
                }
                USwitchExpression uSwitchExpression2 = uSwitchExpression;
                return this.isExpressionValueUnused((UElement)uSwitchExpression2);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

