/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J&\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J&\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/TypoLookup;", "", "data", "", "indices", "", "wordCount", "", "([B[II)V", "computeSuggestions", "", "", "begin", "initialOffset", "glob", "getTypos", "utf8Text", "end", "text", "", "Companion", "lint-checks"})
public final class TypoLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] data;
    @NotNull
    private int[] indices;
    private int wordCount;
    @NotNull
    private static final TypoLookup NONE = new TypoLookup(new byte[0], new int[0], 0);
    @NotNull
    private static final String WORD_SEPARATOR = "->";
    @NotNull
    private static final String FILE_HEADER = "Typo database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 2;
    private static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final int BYTES_PER_ENTRY = 28;
    @NotNull
    private static final WeakHashMap<String, TypoLookup> instanceMap = new WeakHashMap();

    private TypoLookup(byte[] data, int[] indices, int wordCount) {
        this.data = data;
        this.indices = indices;
        this.wordCount = wordCount;
    }

    /* synthetic */ TypoLookup(byte[] byArray, int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(byArray, nArray, n);
    }

    @Nullable
    public final List<String> getTypos(@NotNull CharSequence text, int begin, int end) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = end <= text.length() ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Lint.assertionsEnabled() && (n = begin) < end) {
            do {
                int i;
                char c;
                if ((c = text.charAt(i = n++)) < '\u0080') continue;
                boolean bl4 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-TypoLookup$getTypos$22 = false;
                    String $i$a$-assert-TypoLookup$getTypos$22 = "Call the UTF-8 version of this method instead";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypoLookup$getTypos$22));
                }
                return null;
            } while (n < end);
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != (byte)text.charAt(begin) && Character.isLowerCase(text.charAt(begin))) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    int n2 = offset;
                    offset = n2 + 1;
                    byte b = this.data[n2];
                    if (b == 0) {
                        n2 = offset;
                        offset = n2 + -1;
                        break;
                    }
                    if (b == 42) {
                        int globEnd = i;
                        while (globEnd < text.length() && Character.isLetter(text.charAt(globEnd))) {
                            int n3 = globEnd;
                            globEnd = n3 + 1;
                        }
                        glob = ((Object)text.subSequence(i, globEnd)).toString();
                        break;
                    }
                    char c = text.charAt(i);
                    byte cb = (byte)c;
                    if (b != cb && i > begin) {
                        return null;
                    }
                    int n4 = i;
                    i = n4 + 1;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    @Nullable
    public final List<String> getTypos(@NotNull byte[] utf8Text, int begin, int end) {
        Intrinsics.checkNotNullParameter((Object)utf8Text, (String)"utf8Text");
        boolean bl = end <= utf8Text.length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, utf8Text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != utf8Text[begin] && TypoLookup.Companion.isUpperCase(this.data[offset])) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    int n;
                    int n2 = offset;
                    offset = n2 + 1;
                    byte b = this.data[n2];
                    if (b == 0) {
                        n2 = offset;
                        offset = n2 + -1;
                        break;
                    }
                    if (b == 42) {
                        int globEnd = i;
                        while (globEnd < utf8Text.length && Companion.isLetter(utf8Text[globEnd])) {
                            n = globEnd;
                            globEnd = n + 1;
                        }
                        n = globEnd - i;
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        boolean bl5 = false;
                        glob = new String(utf8Text, i, n, charset);
                        break;
                    }
                    byte cb = utf8Text[i];
                    if (b != cb && i > begin) {
                        return null;
                    }
                    n = i;
                    i = n + 1;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    private final List<String> computeSuggestions(int begin, int initialOffset, String glob) {
        int offset = initialOffset;
        Object object = this.data;
        int n = offset - begin;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        int n2 = 0;
        String typo = new String((byte[])object, begin, n, charset);
        if (glob != null) {
            object = typo;
            String string = "\\*";
            boolean bl = false;
            string = new Regex(string);
            bl = false;
            typo = string.replace((CharSequence)object, glob);
        }
        int n3 = this.data[offset] == 0 ? 1 : 0;
        n = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n3 == 0) {
            n2 = 0;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n3 = offset;
        int replacementEnd = offset = n3 + 1;
        while (this.data[replacementEnd] != 0) {
            n = replacementEnd;
            replacementEnd = n + 1;
        }
        byte[] byArray = this.data;
        n2 = replacementEnd - offset;
        Charset charset2 = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        boolean bl2 = false;
        String replacements = new String(byArray, offset, n2, charset2);
        ArrayList<String> words = new ArrayList<String>();
        words.add(typo);
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)replacements)) {
            if (glob != null) {
                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                CharSequence charSequence = s;
                String string = "\\*";
                boolean bl3 = false;
                string = new Regex(string);
                bl3 = false;
                words.add(string.replace(charSequence, glob));
                continue;
            }
            words.add(s);
        }
        return words;
    }

    @JvmStatic
    @Nullable
    public static final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
        return Companion.get(client, locale, region);
    }

    @VisibleForTesting
    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @VisibleForTesting
    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @JvmStatic
    public static final boolean isLetter(byte b) {
        return Companion.isLetter(b);
    }

    public /* synthetic */ TypoLookup(byte[] data, int[] indices, int wordCount, DefaultConstructorMarker $constructor_marker) {
        this(data, indices, wordCount);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J#\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\tH\u0082\u0002J%\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0087\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0014H\u0007J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0014H\u0002J$\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J#\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0.H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/lint/checks/TypoLookup$Companion;", "", "()V", "BINARY_FORMAT_VERSION", "", "BYTES_PER_ENTRY", "DEBUG_FORCE_REGENERATE_BINARY", "", "FILE_HEADER", "", "NONE", "Lcom/android/tools/lint/checks/TypoLookup;", "WORD_SEPARATOR", "instanceMap", "Ljava/util/WeakHashMap;", "compare", "data", "", "offset", "terminator", "", "s", "begin", "initialEnd", "", "createCache", "client", "Lcom/android/tools/lint/client/api/LintClient;", "xmlStream", "Ljava/io/InputStream;", "binaryData", "Ljava/io/File;", "get", "name", "locale", "region", "isLetter", "b", "isUpperCase", "readData", "binaryFile", "toLowerCase", "writeDatabase", "", "file", "lines", "", "(Ljava/io/File;[Ljava/lang/String;)V", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Class<TypoLookup> clazz = TypoLookup.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                TypoLookup db;
                boolean bl3 = false;
                String key = locale;
                if (region != null && region.length() == 2) {
                    boolean bl4 = Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1));
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean $i$a$-assert-TypoLookup$Companion$get$1$32 = false;
                        String $i$a$-assert-TypoLookup$Companion$get$1$32 = region;
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypoLookup$Companion$get$1$32));
                    }
                    key = locale + 'r' + region;
                }
                if ((db = (TypoLookup)instanceMap.get(key)) == null) {
                    File file;
                    String build;
                    String name = "typos-" + key + ".txt";
                    String path = Intrinsics.stringPlus((String)"/typos/", (Object)name);
                    InputStream stream = TypoLookup.class.getResourceAsStream(path);
                    if (stream == null && (build = System.getenv("ANDROID_BUILD_TOP")) != null && (file = new File(build, StringsKt.replace$default((String)Intrinsics.stringPlus((String)"sdk/files", (Object)path), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null))).exists()) {
                        try {
                            stream = new BufferedInputStream(new FileInputStream(file));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (stream == null) {
                        if (region != null) {
                            return Companion.get(client, locale, null);
                        }
                        db = NONE;
                    } else {
                        db = Companion.get(client, stream, name);
                        boolean bl6 = db != null;
                        boolean bl7 = false;
                        if (_Assertions.ENABLED && !bl6) {
                            boolean bl8 = false;
                            String string = name;
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                    }
                    Map map = instanceMap;
                    boolean bl9 = false;
                    map.put(key, db);
                }
                return db == NONE ? (TypoLookup)null : db;
            }
        }

        private final TypoLookup get(LintClient client, InputStream xmlStream, String name) {
            File file = client.getCacheDir(null, true);
            if (file == null) {
                return null;
            }
            File cacheDir = file;
            File binaryData = new File(cacheDir, Intrinsics.stringPlus((String)name, (Object)"-2.bin"));
            if (!binaryData.exists() && !this.createCache(client, xmlStream, binaryData)) {
                return null;
            }
            if (!binaryData.exists()) {
                Object[] objectArray = new Object[]{binaryData};
                client.log(null, "The typo database file %1$s does not exist", objectArray);
                return null;
            }
            return this.readData(client, xmlStream, binaryData);
        }

        private final TypoLookup readData(LintClient client, InputStream xmlStream, File binaryFile) {
            Object[] objectArray = binaryFile;
            if (objectArray == null) {
                return null;
            }
            if (!binaryFile.exists()) {
                objectArray = new Object[]{binaryFile};
                client.log(null, "%1$s does not exist", objectArray);
                return null;
            }
            try {
                MappedByteBuffer buffer = Files.map((File)binaryFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
                boolean bl = Intrinsics.areEqual((Object)buffer.order(), (Object)ByteOrder.BIG_ENDIAN);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String string = TypoLookup.FILE_HEADER;
                Charset charset = Charsets.US_ASCII;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
                int n = 0;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] expectedHeader = byArray;
                buffer.rewind();
                for (Object anExpectedHeader : (String)expectedHeader) {
                    if (anExpectedHeader == buffer.get()) continue;
                    client.log(null, "Incorrect file header: not an typo database cache file, or a corrupt cache file", new Object[0]);
                    return null;
                }
                if (buffer.get() != 2) {
                    if (this.createCache(client, xmlStream, (File)binaryFile)) {
                        return this.readData(client, xmlStream, (File)binaryFile);
                    }
                    return null;
                }
                int wordCount = buffer.getInt();
                int[] offsets = new int[wordCount];
                n = 0;
                if (n < wordCount) {
                    do {
                        int i = n++;
                        offsets[i] = buffer.getInt();
                    } while (n < wordCount);
                }
                int size = buffer.limit();
                byte[] b = new byte[size];
                buffer.rewind();
                buffer.get(b);
                return new TypoLookup(b, offsets, wordCount, null);
            }
            catch (IOException e) {
                client.log((Throwable)e, null, new Object[0]);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean createCache(LintClient client, InputStream xmlStream, File binaryData) {
            String[] lines = null;
            try {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                Object object = ByteStreams.toByteArray((InputStream)xmlStream);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toByteArray(xmlStream)");
                Object object2 = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"UTF_8");
                int n = 0;
                object = new String((byte[])object, (Charset)object2);
                object2 = "\n";
                n = 0;
                object2 = new Regex((String)object2);
                n = 0;
                boolean bl = false;
                object = object2.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        CharSequence charSequence = it;
                        boolean bl3 = false;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                lines = stringArray;
            }
            catch (IOException e) {
                client.log((Throwable)e, "Can't read typo database file", new Object[0]);
                return false;
            }
            try {
                this.writeDatabase(binaryData, lines);
                return true;
            }
            catch (IOException ioe) {
                client.log((Throwable)ioe, "Can't write typo cache file", new Object[0]);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void writeDatabase(File file, String[] lines) throws IOException {
            int word2;
            int startIndex$iv$iv;
            int $i$f$trim3;
            ArrayList<String> words = new ArrayList<String>(lines.length);
            String[] stringArray = lines;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                CharSequence $this$trim$iv;
                void $this$trim$iv2;
                String line22 = stringArray[n];
                ++n;
                CharSequence charSequence = line22;
                boolean bl = false;
                if (charSequence.length() == 0 || !Character.isLetter(line22.charAt(0))) continue;
                int end = StringsKt.indexOf$default((CharSequence)line22, (String)TypoLookup.WORD_SEPARATOR, (int)0, (boolean)false, (int)6, null);
                if (end == -1) {
                    String $this$trim$iv3 = line22;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv3;
                    $i$f$trim3 = 0;
                    int startIndex$iv$iv2 = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl2 = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv2;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    end = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString().length();
                }
                String $i$f$trim = line22;
                int $this$trim$iv$iv = 0;
                $i$f$trim3 = 0;
                String string = $i$f$trim;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring($this$trim$iv$iv, end);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $i$f$trim = string2;
                boolean $i$f$trim22 = false;
                CharSequence $this$trim$iv$iv22 = (CharSequence)$this$trim$iv2;
                boolean $i$f$trim4 = false;
                int startIndex$iv$iv3 = 0;
                int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv3 <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv3 : endIndex$iv$iv;
                    char it = $this$trim$iv$iv22.charAt(index$iv$iv);
                    boolean bl4 = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv3;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String typo = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv3, endIndex$iv$iv + 1)).toString();
                String $i$f$trim22 = line22;
                int $this$trim$iv$iv22 = end + TypoLookup.WORD_SEPARATOR.length();
                $i$f$trim4 = false;
                String string3 = $i$f$trim22;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring($this$trim$iv$iv22);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                $i$f$trim22 = string4;
                $i$f$trim3 = 0;
                CharSequence $this$trim$iv$iv3 = $this$trim$iv;
                boolean $i$f$trim5 = false;
                startIndex$iv$iv = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv3.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv <= endIndex$iv$iv2) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv2;
                    char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                    boolean bl6 = false;
                    boolean bl7 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv2;
                }
                String replacements = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv, endIndex$iv$iv2 + 1)).toString();
                $this$trim$iv = replacements;
                $i$f$trim3 = 0;
                if ($this$trim$iv.length() == 0) continue;
                String combined = typo + '\u0000' + replacements;
                words.add(combined);
            }
            byte[][] wordArrays = new byte[words.size()][];
            Companion companion = this;
            n2 = 0;
            boolean line22 = false;
            Companion $this$writeDatabase_u24lambda_u2d82 = companion;
            boolean bl = false;
            int i = 0;
            int n3 = words.size();
            while (i < n3) {
                Object $i$f$trim = words.get(i);
                Intrinsics.checkNotNullExpressionValue($i$f$trim, (String)"words[i]");
                String word2 = (String)$i$f$trim;
                $i$f$trim = word2;
                Charset $i$f$trim5 = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim5, (String)"UTF_8");
                startIndex$iv$iv = 0;
                Intrinsics.checkNotNullExpressionValue((Object)((String)$i$f$trim).getBytes($i$f$trim5), (String)"(this as java.lang.String).getBytes(charset)");
                $i$f$trim3 = i;
                i = $i$f$trim3 + 1;
            }
            Arrays.sort((Object[])wordArrays, writeDatabase.3.INSTANCE);
            String string = TypoLookup.FILE_HEADER;
            Charset line22 = Charsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)line22, (String)"US_ASCII");
            boolean $this$writeDatabase_u24lambda_u2d82 = false;
            byte[] byArray = string.getBytes(line22);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] headerBytes = byArray;
            int entryCount = ((Object[])wordArrays).length;
            int capacity = entryCount * 28 + headerBytes.length + 5;
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.put(headerBytes);
            buffer.put((byte)2);
            buffer.putInt(entryCount);
            int wordOffsetTable = buffer.position();
            i = 0;
            if (i < entryCount) {
                do {
                    int i2 = i++;
                    buffer.putInt(0);
                } while (i < entryCount);
            }
            int nextEntry = buffer.position();
            int nextOffset = wordOffsetTable;
            byte[][] $i$f$trim = wordArrays;
            int $i$f$trim5 = ((Object[])$i$f$trim).length;
            for (word2 = 0; word2 < $i$f$trim5; ++word2) {
                byte[] word3 = $i$f$trim[word2];
                buffer.position(nextOffset);
                buffer.putInt(nextEntry);
                nextOffset = buffer.position();
                buffer.position(nextEntry);
                buffer.put(word3);
                buffer.put((byte)0);
                nextEntry = buffer.position();
            }
            int size = buffer.position();
            word2 = size <= buffer.limit() ? 1 : 0;
            $i$f$trim5 = 0;
            boolean bl8 = false;
            if (_Assertions.ENABLED && word2 == 0) {
                boolean bl9 = false;
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            buffer.mark();
            byte[] b = new byte[size];
            buffer.rewind();
            buffer.get(b);
            File tmp = new File(file.getPath() + '.' + new Random().nextInt());
            File file2 = tmp.getParentFile();
            if (file2 != null) {
                File file3 = file2;
                boolean bl10 = false;
                boolean bl11 = false;
                File it = file3;
                boolean bl12 = false;
                if (it.exists()) {
                    it.mkdirs();
                }
            }
            Files.asByteSink((File)tmp, (FileWriteMode[])new FileWriteMode[0]).write(b);
            if (!tmp.renameTo(file)) {
                tmp.delete();
            }
        }

        @VisibleForTesting
        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int max;
                byte b;
                if ((b = data[i]) == 32 && j == end && end < (max = s.length()) && s.charAt(end) == ' ') {
                    while (end < max) {
                        int n;
                        char c = s.charAt(end);
                        if (!Character.isLetter(c)) {
                            if (c != ' ' || end != j) break;
                            n = end;
                            end = n + 1;
                            continue;
                        }
                        n = end;
                        end = n + 1;
                    }
                }
                if (j == end) break;
                if (b == 42) {
                    return 0;
                }
                char c = s.charAt(j);
                byte cb = (byte)c;
                int delta = b - cb;
                if (delta != 0 && b != (cb = (byte)Character.toLowerCase(c)) && (delta = (b = (byte)Character.toLowerCase(b)) - cb) != 0) {
                    return delta;
                }
                int n = i;
                i = n + 1;
                n = j;
                j = n + 1;
            }
            return data[i] - terminator;
        }

        @VisibleForTesting
        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int n;
                int max;
                byte b;
                if ((b = data[i]) == 32 && j == end && end < (max = s.length) && s[end] == 32) {
                    while (end < max) {
                        byte cb = s[end];
                        if (!this.isLetter(cb)) {
                            if (cb != 32 || end != j) break;
                            n = end;
                            end = n + 1;
                            continue;
                        }
                        n = end;
                        end = n + 1;
                    }
                }
                if (j == end) break;
                if (b == 42) {
                    return 0;
                }
                byte cb = s[j];
                int delta = b - cb;
                if (delta != 0) {
                    cb = this.toLowerCase(cb);
                    delta = (b = this.toLowerCase(b)) - cb;
                    if (delta != 0) {
                        return delta;
                    }
                }
                if (b == terminator || cb == terminator) {
                    return delta;
                }
                n = i;
                i = n + 1;
                n = j;
                j = n + 1;
            }
            return data[i] - terminator;
        }

        private final boolean isUpperCase(byte b) {
            return Character.isUpperCase((char)b);
        }

        private final byte toLowerCase(byte b) {
            return (byte)Character.toLowerCase((char)b);
        }

        @JvmStatic
        public final boolean isLetter(byte b) {
            return Character.isLetter((char)b) || (b & 0x80) != 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

