/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "cachedStoragePermissions", "Lcom/android/tools/lint/checks/ScopedStorageDetector$StoragePermissions;", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "getMaxSdk", "", "element", "Lorg/w3c/dom/Element;", "getStoragePermissions", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "Companion", "StoragePermissions", "lint-checks"})
public final class ScopedStorageDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StoragePermissions cachedStoragePermissions;
    @NotNull
    private static final String ATTR_MAX_SDK = "maxSdk";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr permission = attr;
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            int maxSdk = this.getMaxSdk(element);
            Incident incident = new Incident(ISSUE, context.getValueLocation(permission), "");
            context.report(incident, this.map().put(ATTR_MAX_SDK, maxSdk));
        }
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.MANAGE_EXTERNAL_STORAGE")) {
            Incident incident = new Incident(ISSUE, context.getValueLocation(permission), "The Google Play store has a policy that limits usage of MANAGE_EXTERNAL_STORAGE");
            context.report(incident);
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Integer n = map.getInt(ATTR_MAX_SDK, Integer.valueOf(Integer.MAX_VALUE));
        if (n == null) {
            return false;
        }
        int maxSdk = n;
        int n2 = context.getMainProject().getTargetSdk();
        boolean bl = false;
        int sdk = Math.min(n2, maxSdk);
        if (sdk < 29) {
            return false;
        }
        StoragePermissions storagePermissions = this.getStoragePermissions(context);
        if (storagePermissions == null) {
            return false;
        }
        StoragePermissions permissions = storagePermissions;
        if (permissions.getCanManageStorage()) {
            return false;
        }
        if (sdk == 29 && permissions.getRequestedLegacyStorage()) {
            return false;
        }
        String msg = "WRITE_EXTERNAL_STORAGE no longer provides write access when targeting ";
        msg = Intrinsics.stringPlus((String)msg, (Object)(permissions.getRequestedLegacyStorage() ? "Android 11+, even when using `requestLegacyExternalStorage`" : (sdk == 29 ? "Android 10, unless you use `requestLegacyExternalStorage`" : "Android 10+")));
        incident.setMessage(msg);
        return true;
    }

    private final int getMaxSdk(Element element) {
        Integer n;
        String string;
        Attr maxSdkAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "maxSdkVersion");
        Attr attr = maxSdkAttr;
        return attr == null ? Integer.MAX_VALUE : ((string = attr.getValue()) == null ? Integer.MAX_VALUE : ((n = StringsKt.toIntOrNull((String)string)) == null ? Integer.MAX_VALUE : n));
    }

    private final StoragePermissions getStoragePermissions(Context context) {
        StoragePermissions storagePermissions = this.cachedStoragePermissions;
        if (storagePermissions != null) {
            StoragePermissions storagePermissions2 = storagePermissions;
            boolean bl = false;
            boolean bl2 = false;
            StoragePermissions it = storagePermissions2;
            boolean bl3 = false;
            return it;
        }
        Document document = context.getMainProject().getMergedManifest();
        if (document == null) {
            return null;
        }
        Document manifest = document;
        boolean canManageStorage = false;
        boolean requestedLegacyStorage = false;
        Element it = manifest.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"manifest.documentElement");
        Object object = DomExtensions.iterator((Element)it);
        while (object.hasNext()) {
            String permission;
            Element tag = (Element)object.next();
            String string = tag.getNodeName();
            if (Intrinsics.areEqual((Object)string, (Object)"application")) {
                String legacy = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "requestLegacyExternalStorage");
                if (!Intrinsics.areEqual((Object)legacy, (Object)"true")) continue;
                requestedLegacyStorage = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"uses-permission") || !Intrinsics.areEqual((Object)(permission = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "name")), (Object)"android.permission.MANAGE_EXTERNAL_STORAGE")) continue;
            canManageStorage = true;
        }
        object = new StoragePermissions(canManageStorage, requestedLegacyStorage);
        boolean bl = false;
        boolean bl4 = false;
        Object it2 = object;
        boolean bl5 = false;
        this.cachedStoragePermissions = it2;
        return object;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ScopedStorageDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ScopedStorage", (String)"Affected by scoped storage", (String)"\n                Scoped storage is enforced on Android 10+ (or Android 11+ if using \\\n                `requestLegacyExternalStorage`). In particular, `WRITE_EXTERNAL_STORAGE` \\\n                will no longer provide write access to all files; it will provide the \\\n                equivalent of `READ_EXTERNAL_STORAGE` instead.\n\n                The `MANAGE_EXTERNAL_STORAGE` permission can be used to manage all files, but \\\n                it is rarely necessary and most apps on Google Play are not allowed to use it. \\\n                Most apps should instead migrate to use scoped storage. To modify or delete files, \\\n                apps should request write access from the user as described at \\\n                https://goo.gle/android-mediastore-createwriterequest.\n\n                To learn more, read these resources: \\\n                Play policy: https://goo.gle/policy-storage-help \\\n                Allowable use cases: https://goo.gle/policy-storage-usecases\n            ", (Implementation)implementation, (String)"https://goo.gle/android-storage-usecases", (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector$StoragePermissions;", "", "canManageStorage", "", "requestedLegacyStorage", "(ZZ)V", "getCanManageStorage", "()Z", "getRequestedLegacyStorage", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
    private static final class StoragePermissions {
        private final boolean canManageStorage;
        private final boolean requestedLegacyStorage;

        public StoragePermissions(boolean canManageStorage, boolean requestedLegacyStorage) {
            this.canManageStorage = canManageStorage;
            this.requestedLegacyStorage = requestedLegacyStorage;
        }

        public final boolean getCanManageStorage() {
            return this.canManageStorage;
        }

        public final boolean getRequestedLegacyStorage() {
            return this.requestedLegacyStorage;
        }

        public final boolean component1() {
            return this.canManageStorage;
        }

        public final boolean component2() {
            return this.requestedLegacyStorage;
        }

        @NotNull
        public final StoragePermissions copy(boolean canManageStorage, boolean requestedLegacyStorage) {
            return new StoragePermissions(canManageStorage, requestedLegacyStorage);
        }

        public static /* synthetic */ StoragePermissions copy$default(StoragePermissions storagePermissions, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = storagePermissions.canManageStorage;
            }
            if ((n & 2) != 0) {
                bl2 = storagePermissions.requestedLegacyStorage;
            }
            return storagePermissions.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "StoragePermissions(canManageStorage=" + this.canManageStorage + ", requestedLegacyStorage=" + this.requestedLegacyStorage + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.canManageStorage ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.requestedLegacyStorage) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoragePermissions)) {
                return false;
            }
            StoragePermissions storagePermissions = (StoragePermissions)other;
            if (this.canManageStorage != storagePermissions.canManageStorage) {
                return false;
            }
            return this.requestedLegacyStorage == storagePermissions.requestedLegacyStorage;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ScopedStorageDetector$Companion;", "", "()V", "ATTR_MAX_SDK", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

