/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/HardcodedValuesDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "lint-checks"})
public final class HardcodedValuesDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("HardcodedText", "Hardcoded text", "\n                Hardcoding text attributes directly in layout files is bad for several reasons:\n\n                * When creating configuration variations (for example for landscape or \\\n                portrait) you have to repeat the actual text (and keep it up to date when \\\n                making changes)\n\n                * The application cannot be translated to other languages by just adding new \\\n                translations for existing string resources.\n\n                There are quickfixes to automatically extract this hardcoded string into a \\\n                resource lookup.\n                ", Category.I18N, 5, Severity.WARNING, new Implementation(HardcodedValuesDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"text", "contentDescription", "hint", "label", "prompt", "textOn", "textOff", "title", "description"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.XML;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String value = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (!(((CharSequence)value).length() == 0) && value.charAt(0) != '@' && value.charAt(0) != '?') {
            String tagName;
            if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
                return;
            }
            if (Intrinsics.areEqual((Object)value, (Object)"Hello World!")) {
                return;
            }
            if (Intrinsics.areEqual((Object)value, (Object)"Large Text") || Intrinsics.areEqual((Object)value, (Object)"Medium Text") || Intrinsics.areEqual((Object)value, (Object)"Small Text") || StringsKt.startsWith$default((String)value, (String)"New ", (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)value, (Object)"New Text") || Intrinsics.areEqual((Object)value, (Object)Intrinsics.stringPlus((String)"New ", (Object)attribute.getOwnerElement().getTagName())))) {
                return;
            }
            if (context.getResourceFolderType() == ResourceFolderType.XML && !Intrinsics.areEqual((Object)(tagName = attribute.getOwnerDocument().getDocumentElement().getTagName()), (Object)"restrictions")) {
                return;
            }
            Node node = attribute;
            Location location = context.getLocation((Node)attribute);
            String string = "Hardcoded string \"%1$s\", should use `@string` resource";
            Object[] objectArray = new Object[]{value};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/HardcodedValuesDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

