/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J9\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\tH\u0002J8\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000bH\u0016J \u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkEditorApplied", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "checkRecycled", "recycleType", "", "recycleNames", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;Ljava/lang/String;[Ljava/lang/String;)V", "checkResourceRecycled", "method", "checkTransactionCommits", "getApplicableConstructorTypes", "", "getApplicableMethodNames", "isBeginTransaction", "", "isEditorApplyMethodCall", "call", "isEditorCommitMethodCall", "isMethodOnFragmentClass", "fragmentClass", "platformFragmentClass", "v4FragmentClass", "returnForUnresolved", "isSharedEditorCreation", "isShowFragmentMethodCall", "isSuperConstructorCall", "isTransactionCommitMethodCall", "suggestApplyIfApplicable", "visitConstructor", "constructor", "visitMethodCall", "Companion", "lint-checks"})
public final class CleanupDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RECYCLE_RESOURCE;
    @JvmField
    @NotNull
    public static final Issue COMMIT_FRAGMENT;
    @JvmField
    @NotNull
    public static final Issue SHARED_PREF;
    @JvmField
    @NotNull
    public static final Issue APPLY_SHARED_PREF;
    @NotNull
    private static final String OF_INT = "ofInt";
    @NotNull
    private static final String OF_ARGB = "ofArgb";
    @NotNull
    private static final String OF_FLOAT = "ofFloat";
    @NotNull
    private static final String OF_OBJECT = "ofObject";
    @NotNull
    private static final String OF_PROPERTY_VALUES_HOLDER = "ofPropertyValuesHolder";
    @NotNull
    private static final String START = "start";
    @NotNull
    private static final String RECYCLE = "recycle";
    @NotNull
    private static final String RELEASE = "release";
    @NotNull
    private static final String OBTAIN = "obtain";
    @NotNull
    private static final String SHOW = "show";
    @NotNull
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    @NotNull
    private static final String ACQUIRE_UNSTABLE_CPC = "acquireUnstableContentProviderClient";
    @NotNull
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    @NotNull
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    @NotNull
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    @NotNull
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    @NotNull
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    @NotNull
    private static final String COMMIT = "commit";
    @NotNull
    private static final String COMMIT_NOW = "commitNow";
    @NotNull
    private static final String APPLY = "apply";
    @NotNull
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    @NotNull
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    @NotNull
    private static final String QUERY = "query";
    @NotNull
    private static final String RAW_QUERY = "rawQuery";
    @NotNull
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    @NotNull
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    @NotNull
    private static final String CLOSE = "close";
    @NotNull
    private static final String CLOSE_WITH_ERROR = "closeWithError";
    @NotNull
    private static final String EDIT = "edit";
    @NotNull
    private static final String OPEN_ASSET_FILE = "openAssetFile";
    @NotNull
    private static final String OPEN_ASSET_FILE_DESCRIPTOR = "openAssetFileDescriptor";
    @NotNull
    private static final String OPEN_FILE = "openFile";
    @NotNull
    private static final String OPEN_FILE_DESCRIPTOR = "openFileDescriptor";
    @NotNull
    private static final String OPEN_INPUT_STREAM = "openInputStream";
    @NotNull
    private static final String OPEN_OUTPUT_STREAM = "openOutputStream";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE = "openTypedAssetFile";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE_DESCRIPTOR = "openTypedAssetFileDescriptor";
    @NotNull
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    @NotNull
    private static final String PARCEL_CLS = "android.os.Parcel";
    @NotNull
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    @NotNull
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    @NotNull
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    @NotNull
    private static final String DIALOG_ANDROIDX_FRAGMENT = "androidx.fragment.app.DialogFragment";
    @NotNull
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_ANDROIDX_CLS = "androidx.fragment.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_ANDROIDX_CLS = "androidx.fragment.app.FragmentTransaction";
    @NotNull
    private static final String VALUE_ANIMATOR_CLS = "android.animation.ValueAnimator";
    @NotNull
    private static final String OBJECT_ANIMATOR_CLS = "android.animation.ObjectAnimator";
    @NotNull
    private static final String ANIMATOR_SET_CLS = "android.animation.AnimatorSet";
    @NotNull
    public static final String SURFACE_CLS = "android.view.Surface";
    @NotNull
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    @NotNull
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    @NotNull
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    @NotNull
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    @NotNull
    public static final String CURSOR_CLS = "android.database.Cursor";
    @NotNull
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    @NotNull
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";
    @NotNull
    private static final String ASSET_FILE_DESCRIPTOR_CLS = "android.content.res.AssetFileDescriptor";
    @NotNull
    private static final String INPUT_STREAM_CLS = "java.io.InputStream";
    @NotNull
    private static final String OUTPUT_STREAM_CLS = "java.io.OutputStream";
    @NotNull
    private static final String PARCEL_FILE_DESCRIPTOR_CLS = "android.os.ParcelFileDescriptor";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, ACQUIRE_UNSTABLE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, OPEN_ASSET_FILE, OPEN_ASSET_FILE_DESCRIPTOR, OPEN_TYPED_ASSET_FILE, OPEN_TYPED_ASSET_FILE_DESCRIPTOR, OPEN_INPUT_STREAM, OPEN_OUTPUT_STREAM, OPEN_FILE, OPEN_FILE_DESCRIPTOR, EDIT, OF_INT, OF_ARGB, OF_FLOAT, OF_OBJECT, OF_PROPERTY_VALUES_HOLDER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{SURFACE_TEXTURE_CLS, SURFACE_CLS, VALUE_ANIMATOR_CLS, OBJECT_ANIMATOR_CLS, ANIMATOR_SET_CLS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method.getName()) {
            case "beginTransaction": {
                this.checkTransactionCommits(context, node, method);
                break;
            }
            case "edit": {
                this.checkEditorApplied(context, node, method);
                break;
            }
            default: {
                this.checkResourceRecycled(context, node, method);
            }
        }
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Object object = constructor.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object type = object;
        if (this.isSuperConstructorCall(node)) {
            return;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SURFACE_TEXTURE_CLS) || Intrinsics.areEqual((Object)type, (Object)SURFACE_CLS)) {
            String[] stringArray = new String[]{RELEASE};
            this.checkRecycled(context, node, (String)type, stringArray);
        } else {
            String[] stringArray = new String[]{START};
            this.checkRecycled(context, node, (String)type, stringArray);
        }
    }

    private final void checkResourceRecycled(JavaContext context, UCallExpression node, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        switch (name) {
            case "obtain": 
            case "obtainNoHistory": {
                if (evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
                    String[] stringArray = new String[]{RECYCLE};
                    this.checkRecycled(context, node, MOTION_EVENT_CLS, stringArray);
                    break;
                }
                if (evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
                    String[] stringArray = new String[]{RECYCLE};
                    this.checkRecycled(context, node, PARCEL_CLS, stringArray);
                    break;
                }
                if (!evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) break;
                String[] stringArray = new String[]{RECYCLE};
                this.checkRecycled(context, node, VELOCITY_TRACKER_CLS, stringArray);
                break;
            }
            case "obtainTypedArray": 
            case "obtainStyledAttributes": 
            case "obtainAttributes": {
                PsiClass cls;
                PsiType returnType;
                if (!evaluator.extendsClass(containingClass, "android.content.Context", false) && !evaluator.extendsClass(containingClass, "android.content.res.Resources", false) || !((returnType = method.getReturnType()) instanceof PsiClassType) || (cls = ((PsiClassType)returnType).resolve()) == null || !Intrinsics.areEqual((Object)"android.content.res.TypedArray", (Object)cls.getQualifiedName())) break;
                String[] stringArray = new String[]{RECYCLE};
                this.checkRecycled(context, node, "android.content.res.TypedArray", stringArray);
                break;
            }
            case "acquireContentProviderClient": 
            case "acquireUnstableContentProviderClient": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{RELEASE, CLOSE};
                this.checkRecycled(context, node, CONTENT_PROVIDER_CLIENT_CLS, returnType);
                break;
            }
            case "query": 
            case "queryWithFactory": 
            case "rawQueryWithFactory": 
            case "rawQuery": {
                if (!evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, CURSOR_CLS, returnType);
                break;
            }
            case "openAssetFile": 
            case "openTypedAssetFile": 
            case "openTypedAssetFileDescriptor": 
            case "openAssetFileDescriptor": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, ASSET_FILE_DESCRIPTOR_CLS, returnType);
                break;
            }
            case "openFile": 
            case "openFileDescriptor": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE, CLOSE_WITH_ERROR};
                this.checkRecycled(context, node, PARCEL_FILE_DESCRIPTOR_CLS, returnType);
                break;
            }
            case "openInputStream": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, INPUT_STREAM_CLS, returnType);
                break;
            }
            case "openOutputStream": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, OUTPUT_STREAM_CLS, returnType);
                break;
            }
            case "ofArgb": 
            case "ofFloat": 
            case "ofPropertyValuesHolder": 
            case "ofInt": 
            case "ofObject": {
                String string2 = containingClass.getQualifiedName();
                if (string2 == null) {
                    return;
                }
                String type = string2;
                String[] stringArray = new String[]{START};
                this.checkRecycled(context, node, type, stringArray);
            }
        }
    }

    private final void checkRecycled(JavaContext context, UCallExpression node, String recycleType, String ... recycleNames) {
        String string;
        Object[] objectArray;
        String string2;
        PsiElement psi = node.getSourcePsi();
        if (psi != null && Lint.isJava((PsiElement)psi) && PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) != null) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        Ref.BooleanRef recycled = new Ref.BooleanRef();
        Ref.BooleanRef escapes = new Ref.BooleanRef();
        Set set = SetsKt.setOf((Object)node);
        List list = CollectionsKt.emptyList();
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(recycled, recycleNames, recycleType, context, escapes, set, list){
            final /* synthetic */ Ref.BooleanRef $recycled;
            final /* synthetic */ String[] $recycleNames;
            final /* synthetic */ String $recycleType;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Ref.BooleanRef $escapes;
            {
                this.$recycled = $recycled;
                this.$recycleNames = $recycleNames;
                this.$recycleType = $recycleType;
                this.$context = $context;
                this.$escapes = $escapes;
                super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                if (CleanupDetector.access$checkRecycled$isCleanup(this.$recycleNames, this.$recycleType, this.$context, call)) {
                    this.$recycled.element = true;
                }
            }

            public void field(@NotNull UElement field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.$escapes.element = true;
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                PsiMethod resolved;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                if (Intrinsics.areEqual((Object)this.$recycleType, (Object)"android.graphics.SurfaceTexture") && UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && (resolved = call.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.Surface")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)"obtain", (Object)Lint.getMethodName((UCallExpression)call))) {
                    resolved = call.resolve();
                    if (this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.MotionEvent")) {
                        return;
                    }
                }
                this.$escapes.element = true;
            }

            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.$escapes.element = true;
            }
        };
        method.accept((UastVisitor)visitor2);
        if (recycled.element || escapes.element) {
            return;
        }
        if (visitor2.getFailedResolve() && DataFlowAnalyzerKt.anyCall(method, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>(recycleNames, recycleType, context){
            final /* synthetic */ String[] $recycleNames;
            final /* synthetic */ String $recycleType;
            final /* synthetic */ JavaContext $context;
            {
                this.$recycleNames = $recycleNames;
                this.$recycleType = $recycleType;
                this.$context = $context;
                super(1, Intrinsics.Kotlin.class, "isCleanup", "checkRecycled$isCleanup([Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;)Z", 0);
            }

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CleanupDetector.access$checkRecycled$isCleanup(this.$recycleNames, this.$recycleType, this.$context, p0);
            }
        }))) {
            return;
        }
        String string3 = recycleType.substring(StringsKt.lastIndexOf$default((CharSequence)recycleType, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String className = string3;
        String recycleName = (String)ArraysKt.first((Object[])recycleNames);
        if (Intrinsics.areEqual((Object)recycleName, (Object)RECYCLE)) {
            string2 = "This `%1$s` should be recycled after use with `#recycle()`";
            objectArray = new Object[]{className};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        } else if (Intrinsics.areEqual((Object)recycleName, (Object)START)) {
            string = "This animation should be started with `#start()`";
        } else {
            string2 = "This `%1$s` should be freed up after use with `#%2$s()`";
            objectArray = new Object[]{className, recycleName};
            String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        }
        String message2 = string;
        UElement locationNode = (UElement)node.getMethodIdentifier();
        if (locationNode == null) {
            locationNode = (UElement)node;
        }
        Location location = context.getLocation(locationNode);
        JavaContext.report$default((JavaContext)context, (Issue)RECYCLE_RESOURCE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
    }

    private final void checkTransactionCommits(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context, calledMethod)) {
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Ref.BooleanRef committed = new Ref.BooleanRef();
            Ref.BooleanRef escaped = new Ref.BooleanRef();
            Set set = SetsKt.setOf((Object)node);
            List list = CollectionsKt.emptyList();
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(committed, this, context, escaped, set, list){
                final /* synthetic */ Ref.BooleanRef $committed;
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.BooleanRef $escaped;
                {
                    this.$committed = $committed;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$escaped = $escaped;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public void receiver(@NotNull UCallExpression call) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    if (CleanupDetector.access$checkTransactionCommits$isCleanupCall(this.this$0, this.$context, call)) {
                        this.$committed.element = true;
                    }
                }

                public void field(@NotNull UElement field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    this.$escaped.element = true;
                }

                public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    this.$escaped.element = true;
                }

                public void returns(@NotNull UReturnExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$escaped.element = true;
                }
            };
            method.accept((UastVisitor)visitor2);
            if (!(committed.element || escaped.element || visitor2.getFailedResolve() && DataFlowAnalyzerKt.anyCall(method, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>(this, context){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1, Intrinsics.Kotlin.class, "isCleanupCall", "checkTransactionCommits$isCleanupCall(Lcom/android/tools/lint/checks/CleanupDetector;Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;)Z", 0);
                }

                @NotNull
                public final Boolean invoke(@NotNull UCallExpression p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CleanupDetector.access$checkTransactionCommits$isCleanupCall(this.this$0, this.$context, p0);
                }
            })))) {
                String message2 = "This transaction should be completed with a `commit()` call";
                JavaContext.report$default((JavaContext)context, (Issue)COMMIT_FRAGMENT, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }
    }

    private final boolean isTransactionCommitMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        return (Intrinsics.areEqual((Object)COMMIT, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW, (Object)methodName)) && this.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_ANDROIDX_CLS, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private final boolean isShowFragmentMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        return Intrinsics.areEqual((Object)SHOW, (Object)methodName) && this.isMethodOnFragmentClass(context, call, DIALOG_ANDROIDX_FRAGMENT, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private final boolean isMethodOnFragmentClass(JavaContext context, UCallExpression call, String fragmentClass, String platformFragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return returnForUnresolved;
        }
        PsiMethod method = psiMethod;
        PsiClass containingClass = method.getContainingClass();
        JavaEvaluator evaluator = context.getEvaluator();
        return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, platformFragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
    }

    private final boolean isSuperConstructorCall(UCallExpression node) {
        return node.getSourcePsi() instanceof KtSuperTypeCallEntry || Intrinsics.areEqual((Object)node.getMethodName(), (Object)"super");
    }

    private final void checkEditorApplied(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isSharedEditorCreation(context, calledMethod)) {
            if (!((Collection)node.getValueArguments()).isEmpty()) {
                return;
            }
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Ref.BooleanRef applied = new Ref.BooleanRef();
            Ref.BooleanRef escaped = new Ref.BooleanRef();
            Set set = SetsKt.setOf((Object)node);
            List list = CollectionsKt.emptyList();
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(applied, this, context, escaped, set, list){
                final /* synthetic */ Ref.BooleanRef $applied;
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.BooleanRef $escaped;
                {
                    this.$applied = $applied;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$escaped = $escaped;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public void receiver(@NotNull UCallExpression call) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    if (CleanupDetector.access$checkEditorApplied$isSharedPrefsCleanup(this.this$0, this.$context, call)) {
                        this.$applied.element = true;
                    }
                }

                public void field(@NotNull UElement field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    this.$escaped.element = true;
                }

                public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    this.$escaped.element = true;
                }

                public void returns(@NotNull UReturnExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$escaped.element = true;
                }
            };
            method.accept((UastVisitor)visitor2);
            if (!(applied.element || escaped.element || visitor2.getFailedResolve() && DataFlowAnalyzerKt.anyCall(method, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>(this, context){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1, Intrinsics.Kotlin.class, "isSharedPrefsCleanup", "checkEditorApplied$isSharedPrefsCleanup(Lcom/android/tools/lint/checks/CleanupDetector;Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;)Z", 0);
                }

                @NotNull
                public final Boolean invoke(@NotNull UCallExpression p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return CleanupDetector.access$checkEditorApplied$isSharedPrefsCleanup(this.this$0, this.$context, p0);
                }
            })))) {
                String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
                JavaContext.report$default((JavaContext)context, (Issue)SHARED_PREF, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }
    }

    private final boolean isSharedEditorCreation(JavaContext context, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)EDIT, (Object)methodName)) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return false;
            }
            PsiType type = psiType;
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches(type, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private final boolean isEditorCommitMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        if (Intrinsics.areEqual((Object)COMMIT, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context.getEvaluator();
                if (evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false)) {
                    this.suggestApplyIfApplicable(context, call);
                    return true;
                }
            } else if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean isEditorApplyMethodCall(JavaContext context, UCallExpression call) {
        String methodName = Lint.getMethodName((UCallExpression)call);
        if (Intrinsics.areEqual((Object)APPLY, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context.getEvaluator();
                return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false);
            }
            if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final void suggestApplyIfApplicable(JavaContext context, UCallExpression node) {
        UExpression condition;
        UElement prev = (UElement)node;
        UElement parent = node.getUastParent();
        while (parent instanceof UReferenceExpression || parent instanceof UParenthesizedExpression) {
            prev = parent;
            parent = parent.getUastParent();
        }
        boolean returnValueIgnored = true;
        UElement uElement = parent;
        if ((((uElement instanceof UCallExpression ? true : uElement instanceof UVariable) ? true : uElement instanceof UPolyadicExpression) ? true : uElement instanceof UUnaryExpression) ? true : uElement instanceof UReturnExpression) {
            returnValueIgnored = false;
        } else if (uElement instanceof UIfExpression) {
            condition = ((UIfExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UWhileExpression) {
            condition = ((UWhileExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UDoWhileExpression) {
            condition = ((UDoWhileExpression)parent).getCondition();
            boolean bl = returnValueIgnored = condition != prev;
        }
        if (returnValueIgnored) {
            String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
            Location location = context.getCallLocation(node, false, true);
            LintFix fix = LintFix.Companion.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
            context.report(APPLY_SHARED_PREF, (UElement)node, location, message2, fix);
        }
    }

    private final boolean isBeginTransaction(JavaContext context, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_ANDROIDX_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    private static final boolean checkRecycled$isCleanup(String[] $recycleNames, String $recycleType, JavaContext $context, UCallExpression call) {
        PsiType argumentType;
        String methodName = Lint.getMethodName((UCallExpression)call);
        if (Intrinsics.areEqual((Object)"use", (Object)methodName) && call.getValueArgumentCount() == 1 && (argumentType = ((UExpression)CollectionsKt.first((List)call.getValueArguments())).getExpressionType()) != null && LambdaUtil.isFunctionalType((PsiType)argumentType)) {
            return true;
        }
        if (!ArraysKt.contains((Object[])$recycleNames, (Object)methodName)) {
            return false;
        }
        PsiMethod resolved = call.resolve();
        if (resolved != null) {
            PsiClass containingClass = resolved.getContainingClass();
            Object object = containingClass;
            if (object == null || (object = object.getQualifiedName()) == null) {
                return true;
            }
            Object targetName = object;
            if (Intrinsics.areEqual((Object)targetName, (Object)$recycleType)) {
                return true;
            }
            PsiClass psiClass = $context.getEvaluator().findClass($recycleType);
            if (psiClass == null) {
                return true;
            }
            PsiClass recycleClass = psiClass;
            return $context.getEvaluator().extendsClass(recycleClass, (String)targetName, false);
        }
        return true;
    }

    private static final boolean checkTransactionCommits$isCleanupCall(CleanupDetector this$0, JavaContext $context, UCallExpression call) {
        return this$0.isTransactionCommitMethodCall($context, call) || this$0.isShowFragmentMethodCall($context, call);
    }

    private static final boolean checkEditorApplied$isSharedPrefsCleanup(CleanupDetector this$0, JavaContext $context, UCallExpression call) {
        return this$0.isEditorApplyMethodCall($context, call) || this$0.isEditorCommitMethodCall($context, call);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
        return Companion.getVariableElement(rhs, allowChainedCalls);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
        return Companion.getVariableElement(rhs);
    }

    public static final /* synthetic */ boolean access$checkRecycled$isCleanup(String[] $recycleNames, String $recycleType, JavaContext $context, UCallExpression call) {
        return CleanupDetector.checkRecycled$isCleanup($recycleNames, $recycleType, $context, call);
    }

    public static final /* synthetic */ boolean access$checkTransactionCommits$isCleanupCall(CleanupDetector this$0, JavaContext $context, UCallExpression call) {
        return CleanupDetector.checkTransactionCommits$isCleanupCall(this$0, $context, call);
    }

    public static final /* synthetic */ boolean access$checkEditorApplied$isSharedPrefsCleanup(CleanupDetector this$0, JavaContext $context, UCallExpression call) {
        return CleanupDetector.checkEditorApplied$isSharedPrefsCleanup(this$0, $context, call);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        RECYCLE_RESOURCE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Recycle", (String)"Missing `recycle()` calls", (String)"\n                Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled \\\n                (with a `recycle()` call) after use. This lint check looks for missing \\\n                `recycle()` calls.", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        COMMIT_FRAGMENT = Issue.Companion.create$default((Issue.Companion)companion, (String)"CommitTransaction", (String)"Missing `commit()` calls", (String)"\n                After creating a `FragmentTransaction`, you typically need to commit it as well\n                ", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        SHARED_PREF = Issue.Companion.create$default((Issue.Companion)companion, (String)"CommitPrefEdits", (String)"Missing `commit()` on `SharedPreference` editor", (String)"\n                After calling `edit()` on a `SharedPreference`, you must call `commit()` or \\\n                `apply()` on the editor to save the results.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        APPLY_SHARED_PREF = Issue.Companion.create$default((Issue.Companion)companion, (String)"ApplySharedPref", (String)"Use `apply()` on `SharedPreferences`", (String)"\n                Consider using `apply()` instead of `commit` on shared preferences. Whereas \\\n                `commit` blocks and writes its data to persistent storage immediately, `apply` \\\n                will handle it in the background.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020N2\b\b\u0002\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020PH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$Companion;", "", "()V", "ACQUIRE_CPC", "", "ACQUIRE_UNSTABLE_CPC", "ANDROID_CONTENT_SHARED_PREFERENCES", "ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR", "ANIMATOR_SET_CLS", "APPLY", "APPLY_SHARED_PREF", "Lcom/android/tools/lint/detector/api/Issue;", "ASSET_FILE_DESCRIPTOR_CLS", "BEGIN_TRANSACTION", "CLOSE", "CLOSE_WITH_ERROR", "COMMIT", "COMMIT_ALLOWING_LOSS", "COMMIT_FRAGMENT", "COMMIT_NOW", "COMMIT_NOW_ALLOWING_LOSS", "CONTENT_PROVIDER_CLIENT_CLS", "CONTENT_RESOLVER_CLS", "CURSOR_CLS", "DIALOG_ANDROIDX_FRAGMENT", "DIALOG_FRAGMENT", "DIALOG_V4_FRAGMENT", "EDIT", "FRAGMENT_MANAGER_ANDROIDX_CLS", "FRAGMENT_MANAGER_CLS", "FRAGMENT_MANAGER_V4_CLS", "FRAGMENT_TRANSACTION_ANDROIDX_CLS", "FRAGMENT_TRANSACTION_CLS", "FRAGMENT_TRANSACTION_V4_CLS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INPUT_STREAM_CLS", "MOTION_EVENT_CLS", "OBJECT_ANIMATOR_CLS", "OBTAIN", "OBTAIN_ATTRIBUTES", "OBTAIN_NO_HISTORY", "OBTAIN_STYLED_ATTRIBUTES", "OBTAIN_TYPED_ARRAY", "OF_ARGB", "OF_FLOAT", "OF_INT", "OF_OBJECT", "OF_PROPERTY_VALUES_HOLDER", "OPEN_ASSET_FILE", "OPEN_ASSET_FILE_DESCRIPTOR", "OPEN_FILE", "OPEN_FILE_DESCRIPTOR", "OPEN_INPUT_STREAM", "OPEN_OUTPUT_STREAM", "OPEN_TYPED_ASSET_FILE", "OPEN_TYPED_ASSET_FILE_DESCRIPTOR", "OUTPUT_STREAM_CLS", "PARCEL_CLS", "PARCEL_FILE_DESCRIPTOR_CLS", "QUERY", "QUERY_WITH_FACTORY", "RAW_QUERY", "RAW_QUERY_WITH_FACTORY", "RECYCLE", "RECYCLE_RESOURCE", "RELEASE", "SHARED_PREF", "SHOW", "SQLITE_DATABASE_CLS", "START", "SURFACE_CLS", "SURFACE_TEXTURE_CLS", "VALUE_ANIMATOR_CLS", "VELOCITY_TRACKER_CLS", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
        }

        public static /* synthetic */ PsiVariable getVariableElement$default(Companion companion, UCallExpression uCallExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.getVariableElement(uCallExpression, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, allowChainedCalls, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

