/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/IgnoreWithoutReasonDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "applicableAnnotations", "", "", "hasComment", "", "element", "Lcom/intellij/psi/PsiElement;", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "lint-checks"})
public final class IgnoreWithoutReasonDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanOption ALLOW_COMMENT = new BooleanOption("allow-comments", "Whether to allow a comment next to the @Ignore tag to be considered providing a reason", true, "\n                Normally you have to specify an annotation argument to the `@Ignore` \\\n                annotation, but with this option you can configure whether it should \\\n                also allow ignore reasons to specified by a comment adjacent to \\\n                the ignore tag.\n                ");
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)"org.junit.Ignore");
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type == AnnotationUsageType.DEFINITION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation node = annotationInfo.getAnnotation();
        UElement uElement = node.getUastParent();
        if (uElement == null) {
            return;
        }
        UElement parent = uElement;
        PsiElement source = parent.getSourcePsi();
        if (source instanceof KtObjectDeclaration && ((KtObjectDeclaration)source).isCompanion()) {
            return;
        }
        UExpression attribute = node.findAttributeValue("value");
        if (attribute != null) {
            String value;
            IgnoreWithoutReasonDetector $this$visitAnnotationUsage_u24lambda_u2d0 = this;
            boolean bl = false;
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)attribute));
            String string = value = object instanceof String ? (String)object : null;
            if (value != null && !StringsKt.isBlank((CharSequence)value) && !Intrinsics.areEqual((Object)value, (Object)"TODO")) {
                return;
            }
            boolean bl2 = false;
            if (bl2) {
                return;
            }
        }
        boolean bl = false;
        boolean hasDescription = bl;
        if (hasDescription) return;
        if (ALLOW_COMMENT.getValue(context.getConfiguration()).booleanValue() && this.hasComment(node.getSourcePsi())) {
            return;
        }
        LintFix fix = attribute == null || node.getAttributeValues().isEmpty() ? this.fix().name("Give reason").replace().end().with("(\"TODO\")").select("TODO").build() : (LintFix)null;
        context.report(ISSUE, parent, context.getLocation((UElement)node), "Test is ignored without giving any explanation", fix);
    }

    private final boolean hasComment(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement curr = element.getNextSibling();
        while (curr instanceof PsiWhiteSpace) {
            String string = ((PsiWhiteSpace)curr).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"curr.text");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null) || ((PsiWhiteSpace)curr).getNextSibling() == null) break;
        }
        if (curr instanceof PsiComment) {
            return true;
        }
        curr = element.getPrevSibling();
        if (curr == null) {
            curr = element.getParent().getPrevSibling();
        }
        while (curr instanceof PsiWhiteSpace) {
            String string = ((PsiWhiteSpace)curr).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"curr.text");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n\n", (boolean)false, (int)2, null) || ((PsiWhiteSpace)curr).getPrevSibling() == null) break;
        }
        return curr instanceof PsiComment;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        ISSUE = Issue.Companion.create("IgnoreWithoutReason", "@Ignore without Reason", "\n            Ignoring a test without a reason makes it difficult to figure out the problem later. \\\n            Please define an explicit reason why it is ignored, and when it can be resolved.", Category.TESTING, 2, Severity.WARNING, new Implementation(IgnoreWithoutReasonDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), enumSetArray)).setOptions(CollectionsKt.listOf((Object)ALLOW_COMMENT));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/IgnoreWithoutReasonDetector$Companion;", "", "()V", "ALLOW_COMMENT", "Lcom/android/tools/lint/detector/api/BooleanOption;", "getALLOW_COMMENT", "()Lcom/android/tools/lint/detector/api/BooleanOption;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanOption getALLOW_COMMENT() {
            return ALLOW_COMMENT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

