/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005H\u0002J2\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JX\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0005H\u0002J(\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010+\u001a\u0004\u0018\u00010\u0013*\u00020\u000eH\u0002\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkTypeDefConstant", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "errorNode", "flag", "", "value", "", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "createQuickFix", "Lcom/android/tools/lint/detector/api/LintFix;", "node", "values", "Lorg/jetbrains/uast/UExpression;", "getResolvedValue", "expression", "getResolvedValues", "", "allowed", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "listAllowedValues", "allowedValues", "reportTypeDef", "unmatched", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "getLiteralValue", "Companion", "lint-checks"})
public final class TypedefDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TypedefDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String COMPAT_SUFFIX = "Compat";
    @NotNull
    public static final String ATTR_OPEN = "open";
    @JvmField
    @NotNull
    public static final Issue TYPE_DEF;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AndroidXConstants.INT_DEF_ANNOTATION.oldName(), AndroidXConstants.INT_DEF_ANNOTATION.newName(), AndroidXConstants.LONG_DEF_ANNOTATION.oldName(), AndroidXConstants.LONG_DEF_ANNOTATION.newName(), AndroidXConstants.STRING_DEF_ANNOTATION.oldName(), AndroidXConstants.STRING_DEF_ANNOTATION.newName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type != AnnotationUsageType.BINARY && type != AnnotationUsageType.DEFINITION;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String string = annotationInfo.getQualifiedName();
        if (((Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.newName())) {
            Boolean flagAttribute = UastLintUtils.Companion.getAnnotationBooleanValue(annotation, "flag");
            boolean flag = flagAttribute != null && flagAttribute != false;
            this.checkTypeDefConstant(context, annotation, element, null, flag, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.STRING_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.STRING_DEF_ANNOTATION.newName())) {
            this.checkTypeDefConstant(context, annotation, element, null, false, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, AnnotationUsageInfo usageInfo) {
        if (argument == null) {
            return;
        }
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            if (value == null) {
                return;
            }
            if (value instanceof String) {
                this.checkTypeDefConstant(context, annotation, argument, errorNode, false, value, usageInfo);
            } else if (value instanceof Number) {
                long v = ((Number)value).longValue();
                if (flag && v == 0L) {
                    return;
                }
                this.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, usageInfo);
            }
        } else if (UastLintUtils.Companion.isMinusOne(argument)) {
            if (!flag) {
                this.reportTypeDef(context, annotation, argument, errorNode, usageInfo);
            }
        } else if (argument instanceof UPrefixExpression) {
            if (flag) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UPrefixExpression)argument).getOperand(), errorNode, true, usageInfo);
            } else {
                UastPrefixOperator operator = ((UPrefixExpression)argument).getOperator();
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    this.reportTypeDef(context, annotation, argument, errorNode, usageInfo);
                }
            }
        } else if (argument instanceof UParenthesizedExpression) {
            UExpression expression = ((UParenthesizedExpression)argument).getExpression();
            this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, usageInfo);
        } else if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getThenExpression(), errorNode, flag, usageInfo);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getElseExpression(), errorNode, flag, usageInfo);
            }
        } else if (argument instanceof UPolyadicExpression) {
            if (flag) {
                if (((UPolyadicExpression)argument).getOperator() == UastBinaryOperator.BITWISE_AND) {
                    for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                        String resolvedName;
                        if (!(operand instanceof UReferenceExpression) || (resolvedName = ((UReferenceExpression)operand).getResolvedName()) == null || !StringsKt.contains((CharSequence)resolvedName, (CharSequence)"mask", (boolean)true)) continue;
                        return;
                    }
                }
                for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                    this.checkTypeDefConstant(context, annotation, (UElement)operand, errorNode, true, usageInfo);
                }
            } else {
                UastBinaryOperator operator = ((UPolyadicExpression)argument).getOperator();
                if (operator == UastBinaryOperator.BITWISE_AND || operator == UastBinaryOperator.BITWISE_OR || operator == UastBinaryOperator.BITWISE_XOR) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                }
            }
        } else if (argument instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)argument).resolve();
            if (resolved instanceof PsiVariable) {
                if (((PsiVariable)resolved).getType() instanceof PsiArrayType) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                    return;
                }
                if (((PsiVariable)resolved).hasModifierProperty("static") && ((PsiVariable)resolved).hasModifierProperty("final")) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                } else {
                    UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, argument);
                    if (lastAssignment != null) {
                        UElement uElement = (UElement)lastAssignment;
                        UElement uElement2 = errorNode;
                        if (uElement2 == null) {
                            uElement2 = argument;
                        }
                        this.checkTypeDefConstant(context, annotation, uElement, uElement2, flag, usageInfo);
                    }
                }
            } else if (resolved instanceof PsiMethod) {
                UElement uElement = errorNode;
                if (uElement == null) {
                    uElement = argument;
                }
                this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
            }
        } else if (argument instanceof UCallExpression) {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument) || UastExpressionUtils.isArrayInitializer((UElement)argument)) {
                PsiType type = ((UCallExpression)argument).getExpressionType();
                if (type != null) {
                    type = type.getDeepComponentType();
                }
                if (Intrinsics.areEqual((Object)PsiType.INT, (Object)type) || Intrinsics.areEqual((Object)PsiType.LONG, (Object)type)) {
                    for (UExpression expression : ((UCallExpression)argument).getValueArguments()) {
                        this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, usageInfo);
                    }
                }
            } else {
                PsiMethod resolved = ((UCallExpression)argument).resolve();
                if (resolved != null) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                }
            }
        }
    }

    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, Object value, AnnotationUsageInfo usageInfo) {
        AnnotationInfo rangeAnnotation2 = usageInfo.findSameScope((Function1)checkTypeDefConstant.rangeAnnotation.1.INSTANCE);
        if (rangeAnnotation2 != null && !(value instanceof PsiField) && RangeDetector.Companion.getIntRangeError(context, rangeAnnotation2.getAnnotation(), argument, usageInfo) == null) {
            return;
        }
        UExpression uExpression = UastLintUtils.Companion.getAnnotationValue(annotation);
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return;
        }
        UExpression allowed = uExpression;
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            Object annotations;
            UElement uElement = argument;
            PsiElement resolvedArgument = uElement instanceof UReferenceExpression ? ((UReferenceExpression)argument).resolve() : (uElement instanceof UCallExpression ? (PsiElement)((UCallExpression)argument).resolve() : null);
            UExpression unmatched = null;
            if (resolvedArgument instanceof PsiModifierListOwner) {
                UElement uMethod;
                UExpression provided;
                JavaEvaluator evaluator = context.getEvaluator();
                annotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)resolvedArgument), (boolean)true, null, (int)4, null);
                boolean hadTypeDef = false;
                for (UAnnotation a : JavaEvaluator.filterRelevantAnnotations$default((JavaEvaluator)evaluator, (List)annotations, (UElement)argument, null, (int)4, null)) {
                    UBinaryExpression condition;
                    String qualifiedName = a.getQualifiedName();
                    if (!AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) && !AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName) && !AndroidXConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) continue;
                    hadTypeDef = true;
                    UExpression uExpression2 = UastLintUtils.Companion.getAnnotationValue(a);
                    Object paramValues = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
                    if (paramValues == null) continue;
                    if (Intrinsics.areEqual((Object)paramValues, (Object)allowed)) {
                        return;
                    }
                    provided = this.getResolvedValues((UExpression)paramValues, argument);
                    List<Object> allowedValues = this.getResolvedValues(allowed, argument);
                    for (Object allowedValue : allowedValues) {
                        String fieldName;
                        Object object;
                        if (provided.remove(allowedValue) || !(allowedValue instanceof PsiField) || (object = ((PsiField)allowedValue).getContainingClass()) == null || (object = object.getName()) == null) continue;
                        Object containingClass = object;
                        String equivalentName = StringsKt.endsWith$default((String)containingClass, (String)COMPAT_SUFFIX, (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)containingClass, (CharSequence)COMPAT_SUFFIX) : (String)containingClass + COMPAT_SUFFIX;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiField)allowedValue).getName(), (String)"allowedValue.name");
                        provided.removeIf(new Predicate(fieldName, equivalentName, allowedValue){
                            final /* synthetic */ String $fieldName;
                            final /* synthetic */ String $equivalentName;
                            final /* synthetic */ Object $allowedValue;
                            {
                                this.$fieldName = $fieldName;
                                this.$equivalentName = $equivalentName;
                                this.$allowedValue = $allowedValue;
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean test(@NotNull Object it) {
                                Object object;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (!(it instanceof PsiField)) return false;
                                if (!Intrinsics.areEqual((Object)((PsiField)it).getName(), (Object)this.$fieldName)) return false;
                                PsiClass psiClass = ((PsiField)it).getContainingClass();
                                if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getName() : null), (Object)this.$equivalentName)) return false;
                                Object object2 = ((PsiField)it).getContainingClass();
                                if (Intrinsics.areEqual((Object)(object2 != null && (object2 = object2.getQualifiedName()) != null ? Boolean.valueOf(StringsKt.startsWith$default((String)object2, (String)"androidx.", (boolean)false, (int)2, null)) : null), (object = ((PsiField)this.$allowedValue).getContainingClass()) != null && (object = object.getQualifiedName()) != null ? Boolean.valueOf(StringsKt.startsWith$default((String)object, (String)"androidx.", (boolean)false, (int)2, null)) : null)) return false;
                                return true;
                            }
                        });
                    }
                    if (provided.isEmpty()) {
                        return;
                    }
                    if (allowedValues.size() <= provided.size()) continue;
                    unmatched = provided;
                    if (provided.size() != 1) continue;
                    UElement $this$getParentOfType$iv = argument;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    UIfExpression uIfExpression = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv);
                    UExpression uExpression3 = uIfExpression != null && (uIfExpression = uIfExpression.getCondition()) != null ? UastUtils.skipParenthesizedExprDown((UExpression)uIfExpression) : null;
                    UBinaryExpression uBinaryExpression = condition = uExpression3 instanceof UBinaryExpression ? (UBinaryExpression)uExpression3 : null;
                    if (!Intrinsics.areEqual((Object)(uBinaryExpression != null ? uBinaryExpression.getOperator() : null), (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                        UBinaryExpression uBinaryExpression2 = condition;
                        if (!Intrinsics.areEqual((Object)(uBinaryExpression2 != null ? uBinaryExpression2.getOperator() : null), (Object)UastBinaryOperator.NOT_EQUALS)) continue;
                    }
                    if (!Intrinsics.areEqual(provided.get(0), (Object)this.getResolvedValue(condition.getRightOperand(), argument))) continue;
                    if (Intrinsics.areEqual((Object)condition.getLeftOperand().asSourceString(), (Object)argument.asSourceString())) {
                        return;
                    }
                    PsiElement psiElement = condition.getLeftOperand().getSourcePsi();
                    PsiElement psiElement2 = argument.getSourcePsi();
                    if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)(psiElement2 != null ? psiElement2.getText() : null))) {
                        return;
                    }
                    if (!Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)condition.getLeftOperand())), (Object)value)) continue;
                    return;
                }
                if (!hadTypeDef && resolvedArgument instanceof PsiMethod && (uMethod = UastContextKt.toUElement((PsiElement)resolvedArgument)) instanceof UMethod) {
                    UExpression retValue;
                    Object object;
                    UExpression body = ((UMethod)uMethod).getUastBody();
                    if (body instanceof UBlockExpression) {
                        if (((UBlockExpression)body).getExpressions().size() == 1) {
                            provided = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)((UBlockExpression)body).getExpressions().get(0)));
                            UReturnExpression uReturnExpression = provided instanceof UReturnExpression ? (UReturnExpression)provided : null;
                            object = uReturnExpression != null ? uReturnExpression.getReturnExpression() : null;
                        } else {
                            object = null;
                        }
                    } else {
                        object = retValue = body;
                    }
                    if (retValue instanceof UReferenceExpression) {
                        PsiElement psiElement = ((UReferenceExpression)retValue).resolve();
                        if (psiElement == null) {
                            return;
                        }
                        PsiElement psiElement3 = psiElement;
                        if (psiElement3 instanceof PsiField) {
                            this.checkTypeDefConstant(context, annotation, (UElement)retValue, errorNode, flag, psiElement3, usageInfo);
                        }
                        return;
                    }
                    if (!(retValue instanceof ULiteralExpression)) {
                        return;
                    }
                }
            }
            ULiteralExpression uLiteralExpression = argument instanceof ULiteralExpression ? (ULiteralExpression)argument : null;
            annotations = UastUtils.skipParenthesizedExprUp((UElement)(uLiteralExpression != null ? uLiteralExpression.getUastParent() : null));
            UField fieldInitialization = annotations instanceof UField ? (UField)annotations : null;
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            PsiElement psiValue = null;
            if (value instanceof PsiElement) {
                psiValue = (PsiElement)value;
            }
            for (UExpression initializer : initializers) {
                PsiElement resolved;
                UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                if (fieldInitialization != null && expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo((PsiElement)fieldInitialization)) {
                    return;
                }
                if (!(expression instanceof ULiteralExpression ? Intrinsics.areEqual((Object)value, (Object)((ULiteralExpression)expression).getValue()) : psiValue != null && expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo(psiValue))) continue;
                return;
            }
            if (value instanceof PsiField && rangeAnnotation2 == null) {
                UExpression initializer;
                UExpression uExpression4 = UastFacade.INSTANCE.getInitializerBody((PsiVariable)value);
                Object object = initializer = uExpression4 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression4) : null;
                if (initializer != null && !(initializer instanceof ULiteralExpression) && !(initializer.getSourcePsi() instanceof PsiLiteralExpression)) {
                    this.checkTypeDefConstant(context, annotation, (UElement)initializer, errorNode, flag, usageInfo);
                    return;
                }
            }
            if (allowed instanceof PsiCompiledElement || annotation.getPsi() instanceof PsiCompiledElement) {
                return;
            }
            this.reportTypeDef(context, argument, errorNode, flag, initializers, usageInfo, annotation, (List<? extends Object>)unmatched);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> getResolvedValues(UExpression allowed, UElement context) {
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNull((Object)allowed, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            Iterable $this$mapNotNull$iv = initializers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UExpression it = (UExpression)element$iv$iv;
                boolean bl2 = false;
                if (this.getResolvedValue(it, context) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        return new ArrayList();
    }

    private final Object getResolvedValue(UExpression expression, UElement context) {
        UExpression uExpression = expression;
        return uExpression instanceof ULiteralExpression ? ((ULiteralExpression)expression).getValue() : (uExpression instanceof UReferenceExpression ? ((UReferenceExpression)expression).resolve() : (uExpression instanceof UParenthesizedExpression ? this.getResolvedValue(((UParenthesizedExpression)expression).getExpression(), context) : null));
    }

    private final Object getLiteralValue(UElement $this$getLiteralValue) {
        if ($this$getLiteralValue instanceof ULiteralExpression || $this$getLiteralValue instanceof UPrefixExpression && ((UPrefixExpression)$this$getLiteralValue).getOperand() instanceof ULiteralExpression) {
            return ((UExpression)$this$getLiteralValue).evaluate();
        }
        return null;
    }

    private final void reportTypeDef(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, AnnotationUsageInfo usageInfo) {
        UExpression allowed;
        UExpression uExpression = UastLintUtils.Companion.getAnnotationValue(annotation);
        Object object = allowed = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        if (allowed != null && UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            Object value = this.getLiteralValue(argument);
            if (value instanceof Number) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = initializers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)value, (Object)this.getLiteralValue((UElement)it))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
            }
            this.reportTypeDef(context, argument, errorNode, false, initializers, usageInfo, annotation, null);
        }
    }

    private final void reportTypeDef(JavaContext context, UElement node, UElement errorNode, boolean flag, List<? extends UExpression> allowedValues, AnnotationUsageInfo usageInfo, UAnnotation annotation, List<? extends Object> unmatched) {
        UElement uElement;
        String rangeError;
        PsiElement psiElement;
        PsiField psiField;
        String message2;
        UVariable declaration;
        if (UastLintUtils.Companion.isZero(node) && (declaration = (UVariable)UastUtils.getParentOfType((UElement)node, UVariable.class, (boolean)true)) != null) {
            UExpression uExpression = declaration.getUastInitializer();
            if (Intrinsics.areEqual((Object)node, (Object)(uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null))) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)UastLintUtils.Companion.getAnnotationBooleanValue(annotation, ATTR_OPEN), (Object)true)) {
            return;
        }
        String values = this.listAllowedValues(node, allowedValues);
        String string = message2 = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        if (Intrinsics.areEqual((Object)values, (Object)"RecyclerView.HORIZONTAL, RecyclerView.VERTICAL") && errorNode instanceof UResolvable && Intrinsics.areEqual((Object)((psiField = (psiElement = ((UResolvable)errorNode).resolve()) instanceof PsiField ? (PsiField)psiElement : null) != null && (psiField = psiField.getContainingClass()) != null ? psiField.getName() : null), (Object)"LinearLayoutManager")) {
            return;
        }
        if (StringsKt.startsWith$default((String)values, (String)"MediaMetadataCompat.METADATA_KEY_", (boolean)false, (int)2, null)) {
            return;
        }
        AnnotationInfo rangeAnnotation2 = usageInfo.findSameScope((Function1)reportTypeDef.rangeAnnotation.1.INSTANCE);
        if (rangeAnnotation2 != null && (rangeError = RangeDetector.Companion.getIntRangeError(context, rangeAnnotation2.getAnnotation(), node, usageInfo)) != null && ((CharSequence)rangeError).length() > 0) {
            char c = Character.toLowerCase(rangeError.charAt(0));
            String string2 = rangeError.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            message2 = message2 + " or " + c + string2;
        }
        if (unmatched != null && !((Collection)unmatched).isEmpty()) {
            message2 = message2 + ", but could be " + this.listAllowedValues(node, unmatched);
        }
        if ((uElement = errorNode) == null) {
            uElement = node;
        }
        UElement locationNode = uElement;
        LintFix fix = this.createQuickFix(locationNode, allowedValues, node);
        this.report(context, TYPE_DEF, locationNode, context.getLocation(locationNode), message2, fix);
    }

    private final LintFix createQuickFix(UElement node, List<? extends UExpression> values, UElement context) {
        Object object;
        Object currentValue = null;
        if (node instanceof ULiteralExpression) {
            currentValue = ((ULiteralExpression)node).getValue();
        } else if (node instanceof UReferenceExpression) {
            object = ((UReferenceExpression)node).resolve();
            PsiField psiField = object instanceof PsiField ? (PsiField)object : null;
            if (psiField == null) {
                return null;
            }
            PsiField field = psiField;
            if (field.hasModifierProperty("final") && field.hasModifierProperty("static")) {
                currentValue = field.computeConstantValue();
            } else {
                return null;
            }
        }
        List fixes = new ArrayList();
        boolean foundCurrent = false;
        for (UExpression uExpression : values) {
            String qualifiedName;
            String containingClassName;
            PsiClass containingClass;
            PsiElement resolved = null;
            if (uExpression instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)uExpression).resolve();
            }
            if (!(resolved instanceof PsiField) || ((PsiField)resolved).getContainingClass() == null || containingClass.getName() == null || containingClass.getQualifiedName() == null) continue;
            String shortName = containingClassName + "." + ((PsiField)resolved).getName();
            String fullName = qualifiedName + "." + ((PsiField)resolved).getName();
            boolean current = !foundCurrent && Intrinsics.areEqual((Object)uExpression.evaluate(), (Object)currentValue);
            LintFix fix = this.fix().name("Change to " + shortName + (String)(current ? " (" + currentValue + ")" : "")).replace().all().with(fullName).shortenNames().build();
            if (current) {
                fixes.add(0, fix);
                foundCurrent = true;
                continue;
            }
            if (values.size() > 8) continue;
            fixes.add(fix);
        }
        if (!((Collection)fixes).isEmpty()) {
            LintFix.Builder builder = this.fix();
            Collection collection = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = collection;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            Intrinsics.checkNotNull((Object)lintFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            object = lintFixArray;
            return builder.alternatives((LintFix[])Arrays.copyOf(object, ((Object)object).length));
        }
        return null;
    }

    private final String listAllowedValues(UElement context, List<? extends Object> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (Object object : allowedValues) {
            Object s = null;
            PsiElement resolved = null;
            Object object2 = object;
            if (object2 instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)object).resolve();
            } else if (object2 instanceof PsiField) {
                resolved = (PsiElement)object;
            }
            if (resolved instanceof PsiField) {
                Object object3 = ((PsiField)resolved).getContainingClass();
                if (object3 == null || (object3 = object3.getName()) == null) continue;
                Object containingClassName = object3;
                s = (String)containingClassName + "." + ((PsiField)resolved).getName();
            }
            if (s == null) {
                Object object4;
                object2 = object;
                if (object2 instanceof UElement) {
                    object4 = ((UElement)object).asSourceString();
                } else if (object2 instanceof String) {
                    char c = '\"';
                    String string = (String)object;
                    object4 = c + string + "\"";
                } else {
                    object4 = s = object.toString();
                }
            }
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append((String)s);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        TYPE_DEF = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongConstant", (String)"Incorrect constant", (String)"\n                Ensures that when parameter in a method only allows a specific set of \\\n                constants, calls obey those rules.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector$Companion;", "", "()V", "ATTR_OPEN", "", "COMPAT_SUFFIX", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TYPE_DEF", "Lcom/android/tools/lint/detector/api/Issue;", "findIntDef", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "", "isTypeDef", "", "qualifiedName", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTypeDef(@Nullable String qualifiedName) {
            if (qualifiedName == null) {
                return false;
            }
            if (AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName)) {
                return true;
            }
            if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(qualifiedName)) {
                return this.isTypeDef(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(qualifiedName));
            }
            return false;
        }

        @Nullable
        public final UAnnotation findIntDef(@NotNull List<? extends UAnnotation> annotations) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            for (UAnnotation uAnnotation : annotations) {
                if (!this.isTypeDef(uAnnotation.getQualifiedName())) continue;
                return uAnnotation;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

