/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.BuildScriptUtil;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010!\u001a\u00020\u001fH\u0002J\u0017\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010+\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\r\u001a\u00020/H\u0016J\u0014\u00100\u001a\u0004\u0018\u00010(*\b\u0012\u0004\u0012\u0002010\u001eH\u0002\u00a8\u00063"}, d2={"Lcom/android/tools/lint/checks/NotificationPermissionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "()V", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkCall", "Lcom/android/tools/lint/detector/api/ClassContext;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "method", "Lorg/objectweb/asm/tree/MethodNode;", "call", "Lorg/objectweb/asm/tree/MethodInsnNode;", "checkClassReference", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "createFix", "Lcom/android/tools/lint/detector/api/LintFix;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "getApplicableCallNames", "", "", "getApplicableMethodNames", "getWarningMessage", "isHoldingPostNotifications", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/detector/api/Project;)Ljava/lang/Boolean;", "isHoldingPostNotificationsViaAnnotations", "requirement", "Lcom/android/tools/lint/checks/PermissionRequirement;", "scope", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "Lcom/intellij/psi/PsiMethod;", "getPermissionRequirement", "Lorg/objectweb/asm/tree/AnnotationNode;", "Issues", "lint-checks"})
public final class NotificationPermissionDetector
extends Detector
implements SourceCodeScanner,
ClassScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String KEY_SOURCE = "source";
    @NotNull
    private static final String KEY_CLASS = "class";
    @NotNull
    private static final String KEY_CLASS_NAME = "className";
    @NotNull
    private static final String POST_NOTIFICATIONS_PERMISSION = "android.permission.POST_NOTIFICATIONS";
    private static final int MIN_TARGET = 33;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"notify");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, "android.app.NotificationManager") && !evaluator.isMemberInClass((PsiMember)method, "androidx.core.app.NotificationCompat")) {
            return;
        }
        if (context.isGlobalAnalysis()) {
            if (context.getMainProject().getTargetSdk() < 33 || this.isHoldingPostNotificationsViaAnnotations((UElement)node) || !Intrinsics.areEqual((Object)this.isHoldingPostNotifications(context.getMainProject()), (Object)false) || context.getMainProject().isLibrary()) {
                return;
            }
        } else {
            if (this.isHoldingPostNotificationsViaAnnotations((UElement)node)) {
                return;
            }
            LintMap map = context.getPartialResults(ISSUE).map();
            if (!map.containsKey(KEY_SOURCE)) {
                map.put(KEY_SOURCE, true);
            }
        }
        Incident incident = new Incident(ISSUE, (Object)node, context.getLocation((UElement)node), this.getWarningMessage(), this.createFix());
        if (context.isGlobalAnalysis()) {
            context.report(incident);
            if (context.getDriver().getScope().contains(Scope.JAVA_LIBRARIES)) {
                context.getPartialResults(ISSUE).map().put(KEY_SOURCE, true);
            }
        } else {
            context.report(incident, this.map());
        }
    }

    private final String getWarningMessage() {
        return "When targeting Android 13 or higher, posting a permission requires holding the `POST_NOTIFICATIONS` permission";
    }

    @NotNull
    public List<String> getApplicableCallNames() {
        return CollectionsKt.listOf((Object)"notify");
    }

    public void checkCall(@NotNull ClassContext context, @NotNull ClassNode classNode, @NotNull MethodNode method, @NotNull MethodInsnNode call) {
        LintMap map;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String owner = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)owner, (String)"owner");
        if (StringsKt.startsWith$default((String)owner, (String)"android/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"androidx/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"com/google/android/gms/", (boolean)false, (int)2, null)) {
            return;
        }
        if ((Intrinsics.areEqual((Object)call.owner, (Object)"android/app/NotificationManager") || Intrinsics.areEqual((Object)call.owner, (Object)"androidx/core/app/NotificationCompat")) && !(map = context.getPartialResults(ISSUE).map()).containsKey(KEY_CLASS)) {
            if (this.isHoldingPostNotificationsViaAnnotations(classNode, method)) {
                return;
            }
            map.put(KEY_CLASS, context.getLocation((AbstractInsnNode)call));
            map.put(KEY_CLASS_NAME, owner);
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis() && context.getDriver().getScope().contains(Scope.JAVA_LIBRARIES) && !context.getMainProject().isLibrary()) {
            this.checkClassReference(context.getPartialResults(ISSUE).map(), context);
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        boolean bl2 = bl = !context.isGlobalAnalysis();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (context.getProject() == context.getMainProject() && !context.getMainProject().isLibrary()) {
            LintMap map = partialResults.map();
            this.checkClassReference(map, context);
        }
    }

    private final void checkClassReference(LintMap map, Context context) {
        Location location;
        Element mergedManifest;
        if (context.getMainProject().getTargetSdk() < 33) {
            return;
        }
        if (Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)map, (String)KEY_SOURCE, null, (int)2, null), (Object)true)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.isHoldingPostNotifications(context.getMainProject()), (Object)false)) {
            return;
        }
        Document document = context.getMainProject().getMergedManifest();
        Element element = mergedManifest = document != null ? document.getDocumentElement() : null;
        if (mergedManifest != null && context.getDriver().isSuppressed(null, ISSUE, (Node)mergedManifest)) {
            return;
        }
        List list = context.getMainProject().getManifestFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.mainProject.manifestFiles");
        File manifest = (File)CollectionsKt.firstOrNull((List)list);
        File file = context.getMainProject().getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.mainProject.dir");
        File gradleFile = BuildScriptUtil.findGradleBuildFile((File)file);
        File file2 = manifest;
        if (file2 != null) {
            location = Location.Companion.create(file2);
        } else if (gradleFile.isFile()) {
            location = Location.Companion.create(gradleFile);
        } else {
            location = map.getLocation(KEY_CLASS);
            if (location == null) {
                return;
            }
        }
        Location location2 = location;
        String string = map.get(KEY_CLASS_NAME);
        if (string == null) {
            return;
        }
        String owner = string;
        String message2 = this.getWarningMessage() + " (usage from " + ClassContext.Companion.getFqcn(owner) + ")";
        context.report(ISSUE, location2, message2, this.createFix());
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(UElement scope) {
        for (UElement currentScope = scope; currentScope != null; currentScope = currentScope.getUastParent()) {
            if (currentScope instanceof UAnnotated) {
                List annotations = ((UAnnotated)currentScope).getUAnnotations();
                for (UAnnotation annotation : annotations) {
                    PermissionRequirement requirement;
                    String fqcn = annotation.getQualifiedName();
                    if (!AnnotationDetectorKt.PERMISSION_ANNOTATION.isEquals(fqcn)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PermissionRequirement.create(annotation), (String)"create(annotation)");
                    if (!this.isHoldingPostNotificationsViaAnnotations(requirement)) continue;
                    return true;
                }
            }
            if (!(currentScope instanceof UFile)) continue;
            return false;
        }
        return false;
    }

    private final PermissionRequirement getPermissionRequirement(List<? extends AnnotationNode> $this$getPermissionRequirement) {
        for (AnnotationNode annotationNode : $this$getPermissionRequirement) {
            if (!Intrinsics.areEqual((Object)annotationNode.desc, (Object)"Landroidx/annotation/RequiresPermission;")) continue;
            return PermissionRequirement.create(annotationNode);
        }
        return null;
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(ClassNode classNode, MethodNode method) {
        Object object = method.invisibleAnnotations;
        if (object == null || (object = this.getPermissionRequirement((List<? extends AnnotationNode>)object)) == null) {
            List list = classNode.invisibleAnnotations;
            object = list != null ? this.getPermissionRequirement(list) : null;
            if (object == null) {
                return false;
            }
        }
        Object requirement = object;
        return this.isHoldingPostNotificationsViaAnnotations((PermissionRequirement)requirement);
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(PermissionRequirement requirement) {
        return requirement.getMissingPermissions(PermissionHolder.NONE).contains(POST_NOTIFICATIONS_PERMISSION);
    }

    private final Boolean isHoldingPostNotifications(Project project) {
        Document document = project.getMergedManifest();
        if (document == null) {
            return null;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        Node node = element != null ? element.getFirstChild() : null;
        if (node == null) {
            return null;
        }
        Node curr = node;
        Element element2;
        String permission;
        while (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)"uses-permission") || !Intrinsics.areEqual((Object)(permission = (element2 = (Element)curr).getAttributeNS("http://schemas.android.com/apk/res/android", "name")), (Object)POST_NOTIFICATIONS_PERMISSION)) {
            if (curr.getNextSibling() != null) continue;
            return false;
        }
        return true;
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Project project = context.getMainProject();
        if (project.getTargetSdk() >= 33 && !project.isLibrary() && Intrinsics.areEqual((Object)this.isHoldingPostNotifications(project), (Object)false)) {
            map.put(KEY_SOURCE, true);
            return true;
        }
        return false;
    }

    private final LintFix createFix() {
        Object[] objectArray = new Object[]{"missing", CollectionsKt.listOf((Object)POST_NOTIFICATIONS_PERMISSION)};
        return this.fix().data(objectArray);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(NotificationPermissionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.JAVA_LIBRARIES), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"NotificationPermission", (String)"Notifications Without Permission", (String)"\n                When targeting Android 13 and higher, posting permissions requires holding the runtime permission \\\n                `android.permission.POST_NOTIFICATIONS`.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/NotificationPermissionDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_CLASS", "", "KEY_CLASS_NAME", "KEY_SOURCE", "MIN_TARGET", "", "POST_NOTIFICATIONS_PERMISSION", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

