/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\u0018\u00010\u0015H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/SamDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkCalls", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "variable", "Lcom/intellij/psi/PsiLocalVariable;", "checkLambda", "Lorg/jetbrains/uast/UExpression;", "call", "Lorg/jetbrains/uast/UCallExpression;", "argument", "Lorg/jetbrains/uast/UReferenceExpression;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "reportError", "type", "", "storesLambda", "", "method", "Lorg/jetbrains/uast/UMethod;", "parameter", "Lcom/intellij/psi/PsiParameter;", "Issues", "lint-checks"})
public final class SamDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String HANDLER_CLASS = "android.os.Handler";
    @NotNull
    private static final String DRAWABLE_CALLBACK_CLASS = "android.graphics.drawable.Drawable.Callback";
    @NotNull
    private static final String RUNNABLE_CLASS = "java.lang.Runnable";

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{ULambdaExpression.class, UCallableReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UFile uFile = context.getUastFile();
        if (uFile == null || (uFile = uFile.getSourcePsi()) == null) {
            return null;
        }
        UFile psi = uFile;
        if (Lint.isJava((PsiElement)((PsiElement)psi))) {
            return null;
        }
        return new UElementHandler(this, context){
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitLambdaExpression(@NotNull ULambdaExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement uElement = node.getUastParent();
                if (uElement == null) {
                    return;
                }
                UElement parent = uElement;
                if (parent instanceof ULocalVariable) {
                    PsiElement psiElement = parent.getSourcePsi();
                    PsiLocalVariable psiLocalVariable = psiElement instanceof PsiLocalVariable ? (PsiLocalVariable)psiElement : null;
                    if (psiLocalVariable == null && (psiLocalVariable = ((ULocalVariable)parent).getPsi()) == null) {
                        return;
                    }
                    PsiLocalVariable psiVar = psiLocalVariable;
                    SamDetector.access$checkCalls(this.this$0, this.$context, node, psiVar);
                } else if (UastExpressionUtils.isAssignment((UElement)parent)) {
                    PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)parent).getLeftOperand()));
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement v = psiElement;
                    PsiLocalVariable psiLocalVariable = v instanceof PsiLocalVariable ? (PsiLocalVariable)v : null;
                    if (psiLocalVariable == null) {
                        return;
                    }
                    PsiLocalVariable psiVar = psiLocalVariable;
                    SamDetector.access$checkCalls(this.this$0, this.$context, node, psiVar);
                }
            }

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement uElement = node.getUastParent();
                UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression call = uCallExpression;
                SamDetector.access$checkLambda(this.this$0, this.$context, (UExpression)node, call, (UReferenceExpression)node);
            }
        };
    }

    private final void checkCalls(JavaContext context, ULambdaExpression lambda, PsiLocalVariable variable) {
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)lambda));
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)new AbstractUastVisitor(variable, this, context, lambda){
            final /* synthetic */ PsiLocalVariable $variable;
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ ULambdaExpression $lambda;
            {
                this.$variable = $variable;
                this.this$0 = $receiver;
                this.$context = $context;
                this.$lambda = $lambda;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UExpression argument : node.getValueArguments()) {
                    if (!(argument instanceof UReferenceExpression) || !Intrinsics.areEqual((Object)((UReferenceExpression)argument).resolve(), (Object)this.$variable)) continue;
                    SamDetector.access$checkLambda(this.this$0, this.$context, (UExpression)this.$lambda, node, (UReferenceExpression)argument);
                }
                return super.visitCallExpression(node);
            }
        });
    }

    private final void checkLambda(JavaContext context, UExpression lambda, UCallExpression call, UReferenceExpression argument) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        JavaEvaluator evaluator = context.getEvaluator();
        if (psiMethod2 instanceof PsiCompiledElement) {
            PsiClass containingClass = psiMethod2.getContainingClass();
            if (evaluator.isMemberInClass((PsiMember)psiMethod2, HANDLER_CLASS) || evaluator.inheritsFrom(containingClass, "android.view.View", false) || evaluator.inheritsFrom(containingClass, "android.view.ViewTreeObserver", false) || evaluator.inheritsFrom(containingClass, DRAWABLE_CALLBACK_CLASS, false)) {
                Map map = evaluator.computeArgumentMapping(call, psiMethod2);
                PsiParameter psiParameter = (PsiParameter)map.get(lambda);
                if (psiParameter == null) {
                    return;
                }
                PsiParameter psiParameter2 = psiParameter;
                String string = psiParameter2.getType().getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiParameter.type.canonicalText");
                String typeString = string;
                if (Intrinsics.areEqual((Object)typeString, (Object)RUNNABLE_CLASS)) {
                    this.reportError(context, lambda, typeString, argument);
                }
            }
            return;
        }
        if (!Lint.isJava((PsiElement)((PsiElement)psiMethod2))) {
            return;
        }
        Map map = evaluator.computeArgumentMapping(call, psiMethod2);
        PsiParameter psiParameter = (PsiParameter)map.get(argument);
        if (psiParameter == null) {
            return;
        }
        PsiParameter psiParameter3 = psiParameter;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2), UMethod.class);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        if (this.storesLambda(method, psiParameter3) && !context.getDriver().isSuppressed(context, ISSUE, (UElement)method)) {
            String string = psiParameter3.getType().getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiParameter.type.canonicalText");
            String typeString = string;
            this.reportError(context, lambda, typeString, argument);
        }
    }

    private final void reportError(JavaContext context, UExpression lambda, String type, UReferenceExpression argument) {
        Location location = context.getLocation((UElement)argument);
        String string = type.substring(StringsKt.lastIndexOf$default((CharSequence)type, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String simpleType = string;
        Location range = context.getLocation((UElement)lambda);
        LintFix fix = lambda instanceof ULambdaExpression ? this.fix().name("Explicitly create " + simpleType + " instance").replace().beginning().with(simpleType + " ").range(range).build() : (LintFix)null;
        context.report(ISSUE, (UElement)argument, location, "Implicit new `" + simpleType + "` instance being passed to method which ends up checking instance equality; this can lead to subtle bugs", fix);
    }

    private final boolean storesLambda(UMethod method, PsiParameter parameter) {
        Ref.BooleanRef storesLambda2 = new Ref.BooleanRef();
        method.accept((UastVisitor)new AbstractUastVisitor(parameter, storesLambda2){
            final /* synthetic */ PsiParameter $parameter;
            final /* synthetic */ Ref.BooleanRef $storesLambda;
            {
                this.$parameter = $parameter;
                this.$storesLambda = $storesLambda;
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement resolved = node.resolve();
                if (Intrinsics.areEqual((Object)resolved, (Object)this.$parameter)) {
                    UElement parent = node.getUastParent();
                    if (parent instanceof UCallExpression) {
                        String methodName = ((UCallExpression)parent).getMethodName();
                        if (methodName != null && (StringsKt.startsWith$default((String)methodName, (String)"add", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"put", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null))) {
                            this.$storesLambda.element = true;
                        }
                    } else if (parent instanceof UBinaryExpression) {
                        PsiElement lhs;
                        UastBinaryOperator kind = ((UBinaryExpression)parent).getOperator();
                        if ((Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.IDENTITY_EQUALS) || Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) && !UastLiteralUtils.isNullLiteral((UElement)((UElement)((UBinaryExpression)parent).getRightOperand()))) {
                            this.$storesLambda.element = true;
                        } else if (Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.ASSIGN) && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getRightOperand(), (Object)node) && (lhs = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)parent).getLeftOperand()))) instanceof PsiField) {
                            this.$storesLambda.element = true;
                        }
                    }
                }
                return super.visitSimpleNameReferenceExpression(node);
            }
        });
        return storesLambda2.element;
    }

    public static final /* synthetic */ void access$checkCalls(SamDetector $this, JavaContext context, ULambdaExpression lambda, PsiLocalVariable variable) {
        $this.checkCalls(context, lambda, variable);
    }

    public static final /* synthetic */ void access$checkLambda(SamDetector $this, JavaContext context, UExpression lambda, UCallExpression call, UReferenceExpression argument) {
        $this.checkLambda(context, lambda, call, argument);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SamDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ImplicitSamInstance", (String)"Implicit SAM Instances", (String)"\n                Kotlin's support for SAM (single accessor method) interfaces lets you pass \\\n                a lambda to the interface. This will create a new instance on the fly even \\\n                though there is no explicit constructor call. If you pass one of these \\\n                lambdas or method references into a method which (for example) stores or \\\n                compares the object identity, unexpected results may happen.\n            ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3088, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/SamDetector$Issues;", "", "()V", "DRAWABLE_CALLBACK_CLASS", "", "HANDLER_CLASS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "RUNNABLE_CLASS", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

