/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.UseKtxDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0017\u001a\u00020\u0016*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/TrimDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "createRemovalFix", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/LintFix;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isDefaultLambda", "", "isLambdaParameterReference", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nTrimDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrimDetector.kt\ncom/android/tools/lint/checks/TrimDetector\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,198:1\n29#2,2:199\n29#2,2:214\n35#3,13:201\n35#3,13:216\n*S KotlinDebug\n*F\n+ 1 TrimDetector.kt\ncom/android/tools/lint/checks/TrimDetector\n*L\n142#1:199,2\n180#1:214,2\n142#1:201,13\n180#1:216,13\n*E\n"})
public final class TrimDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TrimDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("TrimLambda", "Unnecessary lambda with `trim()`", "\n          The Kotlin standard library `trim()` call takes an optional lambda \\\n          to specify which characters are considered whitespace.\n\n          When converting Java code to Kotlin code, the converter will convert \\\n          calls for Java's `s.trim()` into `s.trim() { it <= ' ' }`. This \\\n          preserves the exact semantics of the Java code, but is likely not \\\n          what you want: the default in Kotlin uses a better definition of what \\\n          constitutes a whitespace character (`Char::isWhitespace`) and also \\\n          results in less bytecode at the call-site.\n          ", Category.CORRECTNESS, 6, Severity.INFORMATIONAL, IMPLEMENTATION);
    @NotNull
    private static final String STRING_TRIM_OWNER = "kotlin.text.StringsKt__StringsKt";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"trim");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (node.getValueArgumentCount() == 1) {
            PsiClass psiClass = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)STRING_TRIM_OWNER)) {
                Object object = node.getValueArguments().get(0);
                ULambdaExpression uLambdaExpression = object instanceof ULambdaExpression ? (ULambdaExpression)object : null;
                if (uLambdaExpression == null) {
                    return;
                }
                ULambdaExpression argument = uLambdaExpression;
                PsiElement psiElement = argument.getSourcePsi();
                KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
                if (ktLambdaExpression == null) {
                    return;
                }
                KtLambdaExpression lambda = ktLambdaExpression;
                if (!this.isDefaultLambda(lambda)) {
                    return;
                }
                object = this.createRemovalFix(lambda, context, node);
                LintFix fix = (LintFix)object.component1();
                String message2 = (String)object.component2();
                context.report(ISSUE, (UElement)node, context.getLocation((PsiElement)lambda), message2, fix);
            }
        }
    }

    private final Pair<LintFix, String> createRemovalFix(KtLambdaExpression lambda, JavaContext context, UCallExpression node) {
        PsiElement psiElement = node.getSourcePsi();
        KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        String replacement = (ktCallExpression != null && (ktCallExpression = ktCallExpression.getValueArgumentList()) != null ? ktCallExpression.getRightParenthesis() : null) == null ? "()" : "";
        LintFix fix = this.fix().name("Remove lambda").replace().pattern("(\\s*\\Q" + lambda.getText() + "\\E)").with(replacement).range(context.getLocation((UElement)node)).autoFix().build();
        String message2 = "The lambda argument (`" + lambda.getText() + "`) is unnecessary";
        return new Pair((Object)fix, (Object)message2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isDefaultLambda(KtLambdaExpression lambda) {
        KtBlockExpression ktBlockExpression = lambda.getBodyExpression();
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression body = ktBlockExpression;
        List list = body.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
        List statements = list;
        if (statements.size() != 1) {
            return false;
        }
        KtExpression expression = (KtExpression)statements.get(0);
        Intrinsics.checkNotNull((Object)expression);
        KtExpression statement = UseKtxDetectorKt.skipParenthesizedExprDown(expression);
        if (statement instanceof KtDotQualifiedExpression) {
            KtExpression selector = ((KtDotQualifiedExpression)statement).getSelectorExpression();
            if (selector instanceof KtCallExpression && ((KtCallExpression)selector).getValueArguments().isEmpty() && this.isLambdaParameterReference(lambda, (KtElement)UseKtxDetectorKt.skipParenthesizedExprDown(((KtDotQualifiedExpression)statement).getReceiverExpression()))) {
                void this_$iv$iv;
                KtElement useSiteElement$iv = (KtElement)selector;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        block17: {
                            KaFunctionSymbol symbol;
                            boolean bl = false;
                            KaSession $this$isDefaultLambda_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            KaCallInfo kaCallInfo = $this$isDefaultLambda_u24lambda_u240.resolveToCall((KtElement)selector);
                            KaFunctionSymbol kaFunctionSymbol = kaCallInfo != null && (kaCallInfo = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaCallInfo)) != null ? (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)kaCallInfo)) : (symbol = null);
                            if (!(symbol instanceof KaNamedFunctionSymbol) || !Intrinsics.areEqual((Object)((KaNamedFunctionSymbol)symbol).getName().getIdentifier(), (Object)"isWhitespace") || $this$isDefaultLambda_u24lambda_u240.getContainingFile((KaSymbol)symbol) != null) break block17;
                            boolean bl3 = true;
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 4, 15] lbl38 : MonitorExitStatement: MONITOREXIT : var13_16
                            boolean bl4 = bl3;
                            return bl4;
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                }
            }
            return false;
        }
        if (statement instanceof KtBinaryExpression) {
            KtExpression binary = statement;
            if (!Intrinsics.areEqual((Object)((KtBinaryExpression)binary).getOperationToken(), (Object)KtTokens.LTEQ)) {
                return false;
            }
            KtExpression left = ((KtBinaryExpression)binary).getLeft();
            KtExpression right = ((KtBinaryExpression)binary).getRight();
            if (!(right instanceof KtConstantExpression) || !Intrinsics.areEqual((Object)((KtConstantExpression)right).getText(), (Object)"' '")) {
                return false;
            }
            if (!(left instanceof KtNameReferenceExpression)) {
                return false;
            }
            if (this.isLambdaParameterReference(lambda, (KtElement)left)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isLambdaParameterReference(KtLambdaExpression $this$isLambdaParameterReference, KtElement element) {
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(element);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, element);
        try {
            Unit unit;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                block10: {
                    KaVariableSymbol symbol;
                    block11: {
                        boolean bl = false;
                        KaSession $this$isLambdaParameterReference_u24lambda_u241 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        KaCallInfo kaCallInfo = $this$isLambdaParameterReference_u24lambda_u241.resolveToCall(element);
                        KaVariableSymbol kaVariableSymbol = kaCallInfo != null && (kaCallInfo = KaCallInfoKt.singleVariableAccessCall((KaCallInfo)kaCallInfo)) != null ? (KaVariableSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)kaCallInfo)) : (symbol = null);
                        if (!(symbol instanceof KaValueParameterSymbol)) break block10;
                        if (!((KaValueParameterSymbol)symbol).isImplicitLambdaParameter()) break block11;
                        boolean bl3 = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var8_8
                        boolean bl4 = bl3;
                        return bl4;
                    }
                    PsiElement psi = ((KaValueParameterSymbol)symbol).getPsi();
                    List list = $this$isLambdaParameterReference.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
                    if (!Intrinsics.areEqual((Object)psi, (Object)CollectionsKt.firstOrNull((List)list))) break block10;
                    boolean bl = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl32 : MonitorExitStatement: MONITOREXIT : var8_8
                    boolean bl5 = bl;
                    return bl5;
                }
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, element);
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/TrimDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "STRING_TRIM_OWNER", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

