/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/WearSplashScreenDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "hasSplashScreenLibrary", "", "getApplicableElements", "", "", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Issues", "lint-checks"})
public final class WearSplashScreenDetector
extends WearDetector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    private boolean hasSplashScreenLibrary;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String MAIN_ACTION = "android.intent.action.MAIN";
    @NotNull
    private static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getProject().isGradleProject()) ** GOTO lbl-1000
        v0 = context.getProject().dependsOn("androidx.core:core-splashscreen");
        if (v0 != null ? v0 : false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        this.hasSplashScreenLibrary = v1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.isWearProject()) {
            return;
        }
        if (this.hasSplashScreenLibrary) {
            return;
        }
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeNS(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Splash", (boolean)false, (int)2, null)) {
            return;
        }
        Element element2 = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter");
        if (element2 == null) {
            return;
        }
        Element intentFilterTag = element2;
        Element element3 = DomExtensions.subtag((Element)intentFilterTag, (String)"action");
        if (element3 == null) return;
        String string2 = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2 == null) return;
        if (!string2.equals(MAIN_ACTION)) return;
        boolean bl = true;
        if (!bl) return;
        element3 = DomExtensions.subtag((Element)intentFilterTag, (String)"category");
        if (element3 == null) return;
        string2 = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2 == null) return;
        if (!string2.equals(CATEGORY_LAUNCHER)) return;
        boolean bl2 = true;
        if (!bl2) return;
        boolean bl3 = true;
        boolean isLauncherActivity = bl3;
        if (!isLauncherActivity) return;
        context.report(new Incident(ISSUE, context.getLocation((Node)element), "Applications using splash screens are strongly recommended to use the 'androidx.core:core-splashscreen' library"), Constraints.minSdkLessThan((int)31));
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.GRADLE_SCOPE};
        IMPLEMENTATION = new Implementation(WearSplashScreenDetector.class, Scope.MANIFEST_SCOPE, enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"WearSplashScreen", (String)"Wear: Use `SplashScreen` library", (String)"\n              If your app implements a custom splash screen or uses a launcher theme, migrate your app to the `SplashScreen` library, \\\n              available in Jetpack, to ensure it displays correctly on all Wear OS versions. \\\n              Starting in Android 12, the system always applies the new Android system default splash screen on cold and warm starts \\\n              for all apps. By default, this system default splash screen is constructed using your app\u2019s launcher icon element and \\\n              the `windowBackground` of your theme (if it's a single color). \\\n              If you do not migrate your app, your app launch experience on Android 12 and higher will be either degraded or may have \\\n              unintended results.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)true, (Boolean)true, null, null, (int)3152, null).addMoreInfo("https://developer.android.com/training/wearables/apps/splash-screen");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/WearSplashScreenDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAIN_ACTION", "", "CATEGORY_LAUNCHER", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

