/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u001e\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/AppLinksAutoVerifyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "mFutures", "", "", "Ljava/util/concurrent/Future;", "Lcom/android/tools/lint/checks/AppLinksAutoVerifyDetector$HttpResult;", "mJsonHost", "Lorg/w3c/dom/Attr;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "reportWarning", "node", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "reportError", "getJsonFileAsync", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "HttpResult", "Companion", "lint-checks"})
public final class AppLinksAutoVerifyDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Future<HttpResult>> mFutures;
    @NotNull
    private final Map<String, Attr> mJsonHost;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksAutoVerifyDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ATTRIBUTE_AUTO_VERIFY = "autoVerify";
    @NotNull
    private static final String JSON_RELATIVE_PATH = "/.well-known/assetlinks.json";
    private static final int STATUS_HTTP_CONNECT_FAIL;
    private static final int STATUS_MALFORMED_URL;
    private static final int STATUS_UNKNOWN_HOST;
    private static final int STATUS_NOT_FOUND;
    private static final int STATUS_WRONG_JSON_SYNTAX;
    private static final int STATUS_JSON_PARSE_FAIL;

    public AppLinksAutoVerifyDetector() {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.mFutures = hashMap;
        HashMap hashMap2 = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap2, (String)"newHashMap(...)");
        this.mJsonHost = hashMap2;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!context.getScope().contains(Scope.ALL_JAVA_FILES)) {
            return;
        }
        if (document.getDocumentElement() != null) {
            Element element = document.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
            List intents = AppLinksAutoVerifyDetector.Companion.getTags(element, "intent-filter");
            if (!AppLinksAutoVerifyDetector.Companion.needAutoVerification(intents)) {
                return;
            }
            for (Element intent : intents) {
                boolean actionView = AppLinksAutoVerifyDetector.Companion.hasNamedSubTag(intent, "action", "android.intent.action.VIEW");
                boolean browsableCategory = AppLinksAutoVerifyDetector.Companion.hasNamedSubTag(intent, "category", "android.intent.category.BROWSABLE");
                if (!actionView || !browsableCategory) continue;
                this.mJsonHost.putAll(AppLinksAutoVerifyDetector.Companion.getJsonUrl(context, intent));
            }
        }
        Map<String, HttpResult> results = this.getJsonFileAsync(context.getClient());
        String packageName = context.getProject().getPackage();
        for (Map.Entry<String, HttpResult> entry : results.entrySet()) {
            String string;
            Object object;
            Attr host;
            String key = entry.getKey();
            HttpResult value = entry.getValue();
            if (value == null || this.mJsonHost.get(key) == null) continue;
            String jsonPath = key + JSON_RELATIVE_PATH;
            int n = value.getMStatus();
            if (n == 200) {
                List packageNames = AppLinksAutoVerifyDetector.Companion.getPackageNameFromJson(value.getMJsonFile());
                if (packageNames.contains(packageName)) continue;
                Node node = host;
                Location location = context.getLocation((Node)host);
                object = "This host does not support app links to your app. Checks the Digital Asset Links JSON file: %s";
                Object[] objectArray = new Object[]{jsonPath};
                String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                this.reportError(context, node, location, string2);
                continue;
            }
            if (n == STATUS_HTTP_CONNECT_FAIL) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "Connection to Digital Asset Links JSON file %s fails";
                object = new Object[]{jsonPath};
                String string3 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                this.reportWarning(context, node, location, string3);
                continue;
            }
            if (n == STATUS_MALFORMED_URL) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "Malformed URL of Digital Asset Links JSON file: %s. An unknown protocol is specified";
                object = new Object[]{jsonPath};
                String string4 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                this.reportError(context, node, location, string4);
                continue;
            }
            if (n == STATUS_UNKNOWN_HOST) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "Unknown host: %s. Check if the host exists, and check your network connection";
                object = new Object[]{key};
                String string5 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                this.reportWarning(context, node, location, string5);
                continue;
            }
            if (n == STATUS_NOT_FOUND) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "Digital Asset Links JSON file %s is not found on the host";
                object = new Object[]{jsonPath};
                String string6 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                this.reportError(context, node, location, string6);
                continue;
            }
            if (n == STATUS_WRONG_JSON_SYNTAX) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "%s has incorrect JSON syntax";
                object = new Object[]{jsonPath};
                String string7 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
                this.reportError(context, node, location, string7);
                continue;
            }
            if (n == STATUS_JSON_PARSE_FAIL) {
                Node node = host;
                Location location = context.getLocation((Node)host);
                string = "Parsing JSON file %s fails";
                object = new Object[]{jsonPath};
                String string8 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
                this.reportError(context, node, location, string8);
                continue;
            }
            if (n == 301 || n == 302) continue;
            Node node = host;
            Location location = context.getLocation((Node)host);
            string = "HTTP request for Digital Asset Links JSON file %1$s fails. HTTP response code: %2$s";
            object = new Object[]{jsonPath, value.getMStatus()};
            String string9 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
            this.reportWarning(context, node, location, string9);
        }
    }

    private final void reportWarning(XmlContext context, Node node, Location location, String message2) {
        Incident incident = new Incident(ISSUE, (Object)node, location, message2);
        incident.overrideSeverity(Severity.WARNING);
        context.report(incident);
    }

    private final void reportError(XmlContext context, Node node, Location location, String message2) {
        Incident incident = new Incident(ISSUE, (Object)node, location, message2);
        incident.overrideSeverity(Severity.ERROR);
        context.report(incident);
    }

    private final Map<String, HttpResult> getJsonFileAsync(LintClient client) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Iterator<Map.Entry<String, Attr>> iterator = this.mJsonHost.entrySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().getKey();
            Future future2 = executorService.submit(new Callable(client, key){
                final /* synthetic */ LintClient $client;
                final /* synthetic */ String $key;
                {
                    this.$client = $client;
                    this.$key = $key;
                }

                public final HttpResult call() {
                    return com.android.tools.lint.checks.AppLinksAutoVerifyDetector$Companion.access$getJson(AppLinksAutoVerifyDetector.Companion, this.$client, this.$key + "/.well-known/assetlinks.json", 0);
                }
            });
            this.mFutures.put(key, future2);
        }
        executorService.shutdown();
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        Map jsons = hashMap;
        for (Map.Entry<String, Future<HttpResult>> entry : this.mFutures.entrySet()) {
            String key = entry.getKey();
            Future<HttpResult> value = entry.getValue();
            try {
                jsons.put(key, value.get());
            }
            catch (Exception e) {
                if (LintClient.Companion.isUnitTest()) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IllegalArgumentException("Network failure", cause);
                }
                jsons.put(key, null);
            }
        }
        return jsons;
    }

    static {
        Object[] objectArray = new String[]{"AppLinksAutoVerifyError", "AppLinksAutoVerifyWarning"};
        ISSUE = Issue.Companion.create("AppLinksAutoVerify", "App Links Auto Verification Failure", "Ensures that app links are correctly set and associated with website.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://g.co/appindexing/applinks").setAliases(CollectionsKt.mutableListOf((Object[])objectArray)).setEnabledByDefault(false);
        STATUS_HTTP_CONNECT_FAIL = -1;
        STATUS_MALFORMED_URL = -2;
        STATUS_UNKNOWN_HOST = -3;
        STATUS_NOT_FOUND = -4;
        STATUS_WRONG_JSON_SYNTAX = -5;
        STATUS_JSON_PARSE_FAIL = -6;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\tH\u0002J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J \u0010'\u001a\u00020%2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J$\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!H\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\tH\u0002J \u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\fH\u0002J\u001a\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0 2\b\u0010\"\u001a\u0004\u0018\u000108H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u000fR\u001c\u0010\u0016\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u000fR\u001c\u0010\u0019\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u000fR\u001c\u0010\u001c\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0003\u001a\u0004\b\u001e\u0010\u000f\u00a8\u00069"}, d2={"Lcom/android/tools/lint/checks/AppLinksAutoVerifyDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ATTRIBUTE_AUTO_VERIFY", "", "JSON_RELATIVE_PATH", "STATUS_HTTP_CONNECT_FAIL", "", "getSTATUS_HTTP_CONNECT_FAIL$annotations", "getSTATUS_HTTP_CONNECT_FAIL", "()I", "STATUS_MALFORMED_URL", "getSTATUS_MALFORMED_URL$annotations", "getSTATUS_MALFORMED_URL", "STATUS_UNKNOWN_HOST", "getSTATUS_UNKNOWN_HOST$annotations", "getSTATUS_UNKNOWN_HOST", "STATUS_NOT_FOUND", "getSTATUS_NOT_FOUND$annotations", "getSTATUS_NOT_FOUND", "STATUS_WRONG_JSON_SYNTAX", "getSTATUS_WRONG_JSON_SYNTAX$annotations", "getSTATUS_WRONG_JSON_SYNTAX", "STATUS_JSON_PARSE_FAIL", "getSTATUS_JSON_PARSE_FAIL$annotations", "getSTATUS_JSON_PARSE_FAIL", "getTags", "", "Lorg/w3c/dom/Element;", "element", "tagName", "needAutoVerification", "", "intents", "hasNamedSubTag", "nameAttrValue", "getJsonUrl", "", "Lorg/w3c/dom/Attr;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "intent", "resolvePlaceHolder", "hostname", "getJson", "Lcom/android/tools/lint/checks/AppLinksAutoVerifyDetector$HttpResult;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "url", "redirectsCount", "getPackageNameFromJson", "Lcom/google/gson/JsonElement;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSTATUS_HTTP_CONNECT_FAIL() {
            return STATUS_HTTP_CONNECT_FAIL;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_HTTP_CONNECT_FAIL$annotations() {
        }

        public final int getSTATUS_MALFORMED_URL() {
            return STATUS_MALFORMED_URL;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_MALFORMED_URL$annotations() {
        }

        public final int getSTATUS_UNKNOWN_HOST() {
            return STATUS_UNKNOWN_HOST;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_UNKNOWN_HOST$annotations() {
        }

        public final int getSTATUS_NOT_FOUND() {
            return STATUS_NOT_FOUND;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_NOT_FOUND$annotations() {
        }

        public final int getSTATUS_WRONG_JSON_SYNTAX() {
            return STATUS_WRONG_JSON_SYNTAX;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_WRONG_JSON_SYNTAX$annotations() {
        }

        public final int getSTATUS_JSON_PARSE_FAIL() {
            return STATUS_JSON_PARSE_FAIL;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSTATUS_JSON_PARSE_FAIL$annotations() {
        }

        private final List<Element> getTags(Element element, String tagName) {
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            List tagList = arrayList;
            if (StringsKt.equals((String)element.getTagName(), (String)tagName, (boolean)true)) {
                tagList.add(element);
            } else {
                NodeList children = element.getChildNodes();
                int n = children.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element)) continue;
                    tagList.addAll((Collection)this.getTags((Element)child, tagName));
                }
            }
            return tagList;
        }

        private final boolean needAutoVerification(List<? extends Element> intents) {
            for (Element element : intents) {
                if (!Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", AppLinksAutoVerifyDetector.ATTRIBUTE_AUTO_VERIFY), (Object)"true")) continue;
                return true;
            }
            return false;
        }

        private final boolean hasNamedSubTag(Element element, String tagName, String nameAttrValue) {
            NodeList children = element.getElementsByTagName(tagName);
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = children.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element e = (Element)node;
                if (!Intrinsics.areEqual((Object)e.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)nameAttrValue)) continue;
                return true;
            }
            return false;
        }

        private final Map<String, Attr> getJsonUrl(XmlContext context, Element intent) {
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            List schemes2 = arrayList;
            ArrayList arrayList2 = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"newArrayList(...)");
            List hosts = arrayList2;
            NodeList dataTags = intent.getElementsByTagName("data");
            int n = dataTags.getLength();
            for (int k = 0; k < n; ++k) {
                Node node = dataTags.item(k);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element dataTag = (Element)node;
                String scheme = dataTag.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme");
                if (Intrinsics.areEqual((Object)scheme, (Object)"http") || Intrinsics.areEqual((Object)scheme, (Object)"https")) {
                    schemes2.add(scheme);
                }
                if (!dataTag.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) continue;
                Attr host = dataTag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "host");
                Intrinsics.checkNotNull((Object)host);
                hosts.add(host);
            }
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
            Map urls = hashMap;
            for (String scheme : schemes2) {
                for (Attr host : hosts) {
                    String hostname;
                    String string = hostname = host.getValue();
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.startsWith$default((String)string, (String)"${", (boolean)false, (int)2, null) && (hostname = this.resolvePlaceHolder(context, hostname)) == null) continue;
                    urls.put(scheme + "://" + hostname, host);
                }
            }
            return urls;
        }

        private final String resolvePlaceHolder(XmlContext context, String hostname) {
            boolean bl = StringsKt.startsWith$default((String)hostname, (String)"${", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            LintModelVariant variant = context.getProject().getBuildVariant();
            if (variant != null) {
                Map placeHolders = variant.getManifestPlaceholders();
                String string = hostname.substring(2, hostname.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String name = string;
                return (String)placeHolders.get(name);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private final HttpResult getJson(LintClient client, String url, int redirectsCount) {
            try {
                HttpURLConnection urlConnection;
                URL urlObj = new URL(url);
                URLConnection uRLConnection = client.openConnection(urlObj, 3000);
                HttpURLConnection httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
                if (httpURLConnection == null) {
                    return new HttpResult(this.getSTATUS_HTTP_CONNECT_FAIL(), null);
                }
                HttpURLConnection connection = urlConnection = httpURLConnection;
                try {
                    InputStream inputStream2;
                    int status = connection.getResponseCode();
                    switch (status) {
                        case 301: 
                        case 302: {
                            Object newUrl;
                            if (redirectsCount < 3 && (newUrl = connection.getHeaderField("Location")) != null && !Intrinsics.areEqual((Object)newUrl, (Object)url)) {
                                HttpResult httpResult = this.getJson(client, (String)newUrl, redirectsCount + 1);
                                return httpResult;
                            }
                            newUrl = new HttpResult(status, null);
                            return newUrl;
                        }
                    }
                    if (connection.getInputStream() == null) {
                        HttpResult httpResult = new HttpResult(status, null);
                        return httpResult;
                    }
                    InputStream inputStream3 = inputStream2;
                    byte[] byArray = inputStream3.readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    byte[] byArray2 = byArray;
                    Object object = Charsets.UTF_8;
                    String response = new String(byArray2, (Charset)object);
                    inputStream3.close();
                    try {
                        JsonElement jsonFile = new JsonParser().parse(response);
                        object = new HttpResult(status, jsonFile);
                        return object;
                    }
                    catch (JsonSyntaxException e) {
                        HttpResult httpResult = new HttpResult(this.getSTATUS_WRONG_JSON_SYNTAX(), null);
                        connection.disconnect();
                        return httpResult;
                    }
                    catch (RuntimeException e) {
                        HttpResult httpResult = new HttpResult(this.getSTATUS_JSON_PARSE_FAIL(), null);
                        connection.disconnect();
                        return httpResult;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (MalformedURLException e) {
                return new HttpResult(this.getSTATUS_MALFORMED_URL(), null);
            }
            catch (UnknownHostException e) {
                return new HttpResult(this.getSTATUS_UNKNOWN_HOST(), null);
            }
            catch (FileNotFoundException e) {
                return new HttpResult(this.getSTATUS_NOT_FOUND(), null);
            }
            catch (IOException e) {
                return new HttpResult(this.getSTATUS_HTTP_CONNECT_FAIL(), null);
            }
        }

        private final List<String> getPackageNameFromJson(JsonElement element) {
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            List packageNames = arrayList;
            if (element instanceof JsonArray) {
                JsonElement jsonArray = element;
                int n = ((JsonArray)jsonArray).size();
                for (int i = 0; i < n; ++i) {
                    JsonObject target2;
                    JsonElement app = ((JsonArray)jsonArray).get(i);
                    if (!(app instanceof JsonObject) || (target2 = ((JsonObject)app).getAsJsonObject("target")) == null) continue;
                    JsonElement namespace = target2.get("namespace");
                    JsonElement packageName = target2.get("package_name");
                    if (namespace == null || !Intrinsics.areEqual((Object)namespace.getAsString(), (Object)"android_app") || packageName == null) continue;
                    packageNames.add(packageName.getAsString());
                }
            }
            return packageNames;
        }

        public static final /* synthetic */ HttpResult access$getJson(Companion $this, LintClient client, String url, int redirectsCount) {
            return $this.getJson(client, url, redirectsCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/AppLinksAutoVerifyDetector$HttpResult;", "", "mStatus", "", "mJsonFile", "Lcom/google/gson/JsonElement;", "<init>", "(ILcom/google/gson/JsonElement;)V", "getMStatus", "()I", "getMJsonFile", "()Lcom/google/gson/JsonElement;", "lint-checks"})
    public static final class HttpResult {
        private final int mStatus;
        @Nullable
        private final JsonElement mJsonFile;

        @VisibleForTesting
        public HttpResult(int mStatus, @Nullable JsonElement mJsonFile) {
            this.mStatus = mStatus;
            this.mJsonFile = mJsonFile;
        }

        public final int getMStatus() {
            return this.mStatus;
        }

        @Nullable
        public final JsonElement getMJsonFile() {
            return this.mJsonFile;
        }
    }
}

