/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/ChromeOsSourceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UMethod;", "getApplicableMethodNames", "", "visitMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "reportRearCameraOnlySystemFeatureViolations", "reportUnsupportedOrientationViolations", "reportFinishInOnConfigurationChanged", "determinePropertyString", "Companion", "lint-checks"})
public final class ChromeOsSourceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ChromeOsSourceDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CHROMEOS_ON_CONFIGURATION_CHANGED;
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED_LOCKED_ORIENTATION;
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED_CAMERA_FEATURE;
    @NotNull
    private static final Set<String> UNSUPPORTED_ORIENTATIONS;
    @NotNull
    public static final String UNSPECIFIED_ORIENTATION_VALUE = "SCREEN_ORIENTATION_UNSPECIFIED";
    @NotNull
    public static final String FEATURE_CAMERA_ANY_STRING = "FEATURE_CAMERA_ANY";
    @NotNull
    public static final String FEATURE_CAMERA_STRING = "FEATURE_CAMERA";

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ ChromeOsSourceDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitMethod(UMethod node) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!Intrinsics.areEqual((Object)node.getName(), (Object)"onConfigurationChanged")) break block1;
                    UExpression uExpression = node.getUastBody();
                    if (uExpression != null) {
                        uExpression.accept((UastVisitor)new AbstractUastVisitor(this.this$0, this.$context){
                            final /* synthetic */ ChromeOsSourceDetector this$0;
                            final /* synthetic */ JavaContext $context;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                            }

                            public boolean visitCallExpression(UCallExpression node) {
                                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"finish") && node.getValueArgumentCount() == 0) {
                                    ChromeOsSourceDetector.access$reportFinishInOnConfigurationChanged(this.this$0, node, this.$context);
                                }
                                return super.visitCallExpression(node);
                            }
                        });
                    }
                }
            }
        };
    }

    @NotNull
    public List<Class<UMethod>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setRequestedOrientation", "hasSystemFeature"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (Intrinsics.areEqual((Object)"setRequestedOrientation", (Object)name)) {
            this.reportUnsupportedOrientationViolations(node, context);
        } else if (Intrinsics.areEqual((Object)"hasSystemFeature", (Object)name)) {
            this.reportRearCameraOnlySystemFeatureViolations(node, context);
        }
    }

    private final void reportRearCameraOnlySystemFeatureViolations(UCallExpression node, JavaContext context) {
        String cameraFeatureRequested = this.determinePropertyString(node);
        if (Intrinsics.areEqual((Object)FEATURE_CAMERA_STRING, (Object)cameraFeatureRequested)) {
            String message2 = "You should look for any camera available on the device, not just the rear";
            LintFix fix = this.fix().name("Switch to look for FEATURE_CAMERA_ANY").replace().text(cameraFeatureRequested).with(FEATURE_CAMERA_ANY_STRING).build();
            context.report(UNSUPPORTED_CAMERA_FEATURE, (UElement)node, context.getLocation((UElement)node), message2, fix);
        }
    }

    private final void reportUnsupportedOrientationViolations(UCallExpression node, JavaContext context) {
        String string = this.determinePropertyString(node);
        if (string == null) {
            return;
        }
        String orientationValue = string;
        if (UNSUPPORTED_ORIENTATIONS.contains(orientationValue)) {
            String message2 = "You should not lock orientation of your activities, so that you can support a good user experience for any device or orientation";
            LintFix fix = this.fix().name("Set the orientation to SCREEN_ORIENTATION_UNSPECIFIED").replace().text(orientationValue).with(UNSPECIFIED_ORIENTATION_VALUE).build();
            context.report(UNSUPPORTED_LOCKED_ORIENTATION, (UElement)node, context.getLocation((UElement)node), message2, fix);
        }
    }

    private final void reportFinishInOnConfigurationChanged(UCallExpression node, JavaContext context) {
        String message2 = "Calling `finish()` within `onConfigurationChanged()` can lead to redraws";
        JavaContext.report$default((JavaContext)context, (Issue)CHROMEOS_ON_CONFIGURATION_CHANGED, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)message2, null, (int)16, null);
    }

    private final String determinePropertyString(UCallExpression node) {
        UExpression firstArgument = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        UReferenceExpression uReferenceExpression = firstArgument instanceof UReferenceExpression ? (UReferenceExpression)firstArgument : null;
        if (uReferenceExpression == null) {
            return null;
        }
        UReferenceExpression reference = uReferenceExpression;
        return reference.getResolvedName();
    }

    public static final /* synthetic */ void access$reportFinishInOnConfigurationChanged(ChromeOsSourceDetector $this, UCallExpression node, JavaContext context) {
        $this.reportFinishInOnConfigurationChanged(node, context);
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.CHROME_OS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CHROMEOS_ON_CONFIGURATION_CHANGED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ChromeOsOnConfigurationChanged", (String)"Poor performance with APIs inside `onConfigurationChanged()`", (String)"\n                When users resize the Android emulator in Android 13 and Chrome OS, an \\\n                `onConfigurationChanged()` API call occurs. If your `onConfigurationChanged()` \\\n                method contains any code that can cause a redraw, your app might take a performance \\\n                hit on large screens. To fix the issue, ensure your `onConfigurationChanged()` method \\\n                does not contain any calls to UI redraw logic for specific elements.\n            ", (Implementation)implementation, null, (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null).setEnabledByDefault(true);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        UNSUPPORTED_LOCKED_ORIENTATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"SourceLockedOrientationActivity", (String)"Incompatible setRequestedOrientation value", (String)"\n                The `Activity` should not be locked to a portrait orientation so that users \\\n                can take advantage of the multi-window environments and larger landscape-first \\\n                screens that Android runs on such as ChromeOS, tablets, and foldables. To fix \\\n                the issue, consider calling `setRequestedOrientation` with the \\\n                `ActivityInfo.SCREEN_ORIENTATION_FULL_SENSOR` or \\\n                `ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED` options or removing the \\\n                call all together.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/large-screens/large-screen-cookbook#restricted_app_orientation", (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null).setEnabledByDefault(true);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        UNSUPPORTED_CAMERA_FEATURE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UnsupportedChromeOsCameraSystemFeature", (String)"Looking for Rear Camera only feature", (String)"\n                You should look for the `FEATURE_CAMERA_ANY` features to include all possible \\\n                cameras that may be on the device. Looking for `FEATURE_CAMERA` only looks \\\n                for a rear facing camera, which certain large screen devices don't have, \\\n                as well as newer device configurations and modes may place the device \\\n                in a state where the rear camera is not available. To fix the issue, \\\n                look for `FEATURE_CAMERA_ANY` instead.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/large-screens/large-screen-cookbook#chromebook_camera_support", (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null).setEnabledByDefault(true);
        objectArray = new String[]{"SCREEN_ORIENTATION_PORTRAIT", "SCREEN_ORIENTATION_REVERSE_PORTRAIT", "SCREEN_ORIENTATION_SENSOR_PORTRAIT", "SCREEN_ORIENTATION_USER_PORTRAIT"};
        UNSUPPORTED_ORIENTATIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ChromeOsSourceDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "CHROMEOS_ON_CONFIGURATION_CHANGED", "Lcom/android/tools/lint/detector/api/Issue;", "UNSUPPORTED_LOCKED_ORIENTATION", "UNSUPPORTED_CAMERA_FEATURE", "UNSUPPORTED_ORIENTATIONS", "", "", "getUNSUPPORTED_ORIENTATIONS", "()Ljava/util/Set;", "UNSPECIFIED_ORIENTATION_VALUE", "FEATURE_CAMERA_ANY_STRING", "FEATURE_CAMERA_STRING", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getUNSUPPORTED_ORIENTATIONS() {
            return UNSUPPORTED_ORIENTATIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

